/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.upgrade;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.date.DateUtil;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.LicenseKeys;
import java.util.LinkedHashMap;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
@LoginAs(user="admin")
public class TestUpgradeHistory
extends BaseJiraFuncTest {
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testUpgradeHistory3Versions() throws Exception {
        LinkedHashMap<String, String> replacements = new LinkedHashMap<String, String>();
        replacements.put("@@TIMESTAMP1@@", DateUtil.dateAsTimestamp(2009, 9, 11, 9, 45));
        replacements.put("@@TIMESTAMP2@@", DateUtil.dateAsTimestamp(2009, 9, 23, 12, 30));
        this.administration.restoreDataWithReplacedTokens("TestUpgradeHistory3Versions.xml", replacements);
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), "Last Upgrade", "v7.7.0-SNAPSHOT#77001", "Get more upgrade history details.");
        this.tester.clickLink("view_upgrade_history");
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), "7.7.0-SNAPSHOT", "77001", "23/Oct/09 12:30 PM", "4.0", "466", "11/Oct/09 9:45 AM", "3.7.3", "187", "(inferred)", "Unknown");
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testUpgradeHistory2VersionsInferred() throws Exception {
        LinkedHashMap<String, String> replacements = new LinkedHashMap<String, String>();
        replacements.put("@@TIMESTAMP1@@", DateUtil.dateAsTimestamp(2009, 9, 23, 12, 30));
        this.administration.restoreDataWithReplacedTokens("TestUpgradeHistory2VersionsInferred.xml", replacements);
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), "Last Upgrade", "v7.7.0-SNAPSHOT#77001", "Get more upgrade history details.");
        this.tester.clickLink("view_upgrade_history");
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), "7.7.0-SNAPSHOT", "77001", "23/Oct/09 12:30 PM", "3.8", "209", "(inferred from 207)", "Unknown");
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testUpgradeHistoryAfterSetUp() throws Exception {
        this.resetupJira();
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        TableCellLocator locator = new TableCellLocator(this.tester, "jirainfo", 8, 0);
        this.assertions.getTextAssertions().assertTextPresent(locator, "Last Upgrade");
        locator = new TableCellLocator(this.tester, "jirainfo", 9, 1);
        this.assertions.getTextAssertions().assertTextNotPresent(locator, "(v");
        this.assertions.getTextAssertions().assertTextNotPresent(locator, "#");
        this.assertions.getTextAssertions().assertTextNotPresent(locator, ")");
        this.tester.clickLink("view_upgrade_history");
        Assert.assertEquals((String)"Found more than 2 rows in the upgrade history table", (long)2L, (long)this.tester.getDialog().getWebTableBySummaryOrId("upgradehistory").getRowCount());
    }

    private void resetupJira() {
        this.administration.restoreNotSetupInstance();
        this.tester.gotoPage("secure/SetupApplicationProperties!default.jspa");
        this.tester.assertTextPresent("Set up application properties");
        this.tester.setWorkingForm("jira-setupwizard");
        this.tester.setFormElement("title", "My Jira");
        this.tester.submit();
        this.tester.setWorkingForm("setupLicenseForm");
        this.tester.setFormElement("setupLicenseKey", LicenseKeys.COMMERCIAL_DC.getLicenseString());
        this.tester.submit();
        this.tester.assertTextPresent("Set up administrator account");
        this.tester.setFormElement("username", "admin");
        this.tester.setFormElement("password", "admin");
        this.tester.setFormElement("confirm", "admin");
        this.tester.setFormElement("fullname", "Mary Magdelene");
        this.tester.setFormElement("email", "admin@example.com");
        this.tester.submit();
        this.tester.assertTextPresent("Set up email notifications");
        this.logger.log((Object)"Noemail");
        this.tester.submit("finish");
        this.logger.log((Object)"Noemail");
        this.tester.assertLinkPresent("header-details-user-fullname");
    }
}

