/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.navigation.issue.AttachmentsBlock;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.webtests.ztests.attachment.AbstractTestAttachmentsBlockSortingOnViewIssue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS})
public class TestAttachmentViewMode
extends AbstractTestAttachmentsBlockSortingOnViewIssue
implements FunctTestConstants {
    @Before
    public void addBrowseProjectPermissions() {
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS);
    }

    @After
    public void revokeBrowseProjectPermissions() {
        this.backdoor.permissionSchemes().removeEveryonePermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS);
    }

    @Test
    public void testViewModeRetainedForSession() {
        AttachmentsBlock attachments = this.navigation.issue().attachments("HSP-1");
        Assert.assertEquals((String)"Gallery is default view mode", (Object)AttachmentsBlock.ViewMode.GALLERY, (Object)attachments.getViewMode());
        attachments.setViewMode(AttachmentsBlock.ViewMode.LIST);
        attachments = this.navigation.issue().attachments("HSP-1");
        Assert.assertEquals((String)"List view mode retained after reload", (Object)AttachmentsBlock.ViewMode.LIST, (Object)attachments.getViewMode());
    }

    @Test
    @LoginAs(user="admin")
    public void testViewModeRetainedForLoggedIn() {
        AttachmentsBlock attachments = this.navigation.issue().attachments("HSP-1");
        Assert.assertEquals((String)"Gallery is default view mode", (Object)AttachmentsBlock.ViewMode.GALLERY, (Object)attachments.getViewMode());
        attachments.setViewMode(AttachmentsBlock.ViewMode.LIST);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        attachments = this.navigation.issue().attachments("HSP-1");
        Assert.assertEquals((String)"List view mode restored after login", (Object)AttachmentsBlock.ViewMode.LIST, (Object)attachments.getViewMode());
    }

    @Test
    @LoginAs(user="admin")
    public void testViewModeResetAfterLogout() {
        AttachmentsBlock attachments = this.navigation.issue().attachments("HSP-1", AttachmentsBlock.ViewMode.LIST);
        Assert.assertEquals((String)"Attachments are in list view mode", (Object)AttachmentsBlock.ViewMode.LIST, (Object)attachments.getViewMode());
        this.navigation.logout();
        attachments = this.navigation.issue().attachments("HSP-1");
        Assert.assertEquals((String)"View mode was reset to gallery after logout", (Object)AttachmentsBlock.ViewMode.GALLERY, (Object)attachments.getViewMode());
    }
}

