/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.Rules;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS})
@LoginAs(user="admin")
@RestoreOnce(value="TestAttachmentZipServlet/TestAttachmentZipServlet.xml")
public class TestAttachmentZipServlet
extends BaseJiraFuncTest {
    public static final int ID_OF_ISSUE_WITH_MANY_ATTACHMENTS = 10001;
    public static final int ID_OF_ISSUE_WITH_ZIP_ARCHIVE_ATTACHMENT = 10000;
    public static final int XML_ATTACHMENT_ID = 10000;
    public static final int ZIP_ATTACHMENT_ID = 10001;
    public static final int PNG_ATTACHMENT_ID = 10002;
    public static final int JPEG_ATTACHMENT_ID = 10100;
    private final HttpClient client = new HttpClient();
    @Rule
    public TestRule copyAttachmentsRule = Rules.prepareAttachments(this::getEnvironmentData, this::getBackdoor, "TestAttachmentZipServlet/attachments");

    @Before
    public void setUpTest() {
        this.client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        this.client.getParams().setAuthenticationPreemptive(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDownloadAllAttachmentsOfIssueAsZip() throws Exception {
        String uri = this.zipAllAttachmentsUri().toString();
        GetMethod request = this.makeRequestToAttachmentServlet(uri);
        InputStream is = request.getResponseBodyAsStream();
        try {
            this.assertResponseZipContainsEntries(is, "test1.xml", "test3.png", "test1.xml.zip", "test.jpeg");
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @Test
    public void testCanDownloadOneEntryFromZip() throws Exception {
        GetMethod request = this.makeRequestToAttachmentServlet(this.unzipFileUri(0).toString());
        InputStream is = request.getResponseBodyAsStream();
        try {
            this.assertResponseBodyEqualsTo(is, " <someXmlContent>here</someXmlContent>");
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @Test
    public void testShouldHaveAppropriateHeaderAccordingToFileType() throws IOException, URISyntaxException {
        this.verifyAttachmentWithIdProvidedWithAppropriateContentType("text/xml", 10000);
        this.verifyAttachmentWithIdProvidedWithAppropriateContentType("application/zip", 10001);
        this.verifyAttachmentWithIdProvidedWithAppropriateContentType("image/png", 10002);
        this.verifyAttachmentWithIdProvidedWithAppropriateContentType("image/jpeg", 10100);
    }

    @Test
    public void testShouldHaveContentSecurityPolicySandbox() throws IOException, URISyntaxException {
        this.verifyAttachmentWithIdProvidedWithSandboxPolicy(10000);
        this.verifyAttachmentWithIdProvidedWithSandboxPolicy(10001);
        this.verifyAttachmentWithIdProvidedWithSandboxPolicy(10002);
        this.verifyAttachmentWithIdProvidedWithSandboxPolicy(10100);
    }

    @Test
    public void testShouldNotAllowToUnzipFileBiggerThanMaxAttachmentProperty() throws Exception {
        this.backdoor.applicationProperties().setString("webwork.multipart.maxSize", Long.toString(10L));
        GetMethod request = new GetMethod(this.unzipFileUri(0).toString());
        int status = this.client.executeMethod((HttpMethod)request);
        try {
            Assert.assertNotEquals((long)200L, (long)status);
        }
        finally {
            this.backdoor.applicationProperties().setString("webwork.multipart.maxSize", Long.toString(10000000L));
        }
    }

    private void verifyAttachmentWithIdProvidedWithAppropriateContentType(String expectedContentType, int attachmentId) throws IOException, URISyntaxException {
        GetMethod request = this.makeRequestToAttachmentServlet(this.getAttachmentURI(attachmentId).toString());
        Header responseHeader = request.getResponseHeader("Content-Type");
        MatcherAssert.assertThat((Object)responseHeader.getValue(), (Matcher)CoreMatchers.startsWith((String)expectedContentType));
    }

    private void verifyAttachmentWithIdProvidedWithSandboxPolicy(int attachmentId) throws IOException, URISyntaxException {
        GetMethod request = this.makeRequestToAttachmentServlet(this.getAttachmentURI(attachmentId).toString());
        Header responseHeader = request.getResponseHeader("Content-Security-Policy");
        Assert.assertEquals((Object)"sandbox", (Object)responseHeader.getValue());
    }

    private void assertResponseBodyEqualsTo(InputStream resultStream, String expectedStreamContent) throws IOException {
        String resultStreamContent = IOUtils.toString((InputStream)resultStream, (String)"UTF-8");
        MatcherAssert.assertThat((Object)resultStreamContent, (Matcher)IsEqual.equalTo((Object)expectedStreamContent));
    }

    private void assertResponseZipContainsEntries(InputStream is, String ... expectedEntries) throws Exception {
        ZipEntry entry;
        ZipInputStream zipInputStream = new ZipInputStream(is);
        HashSet<String> entries = new HashSet<String>();
        while ((entry = zipInputStream.getNextEntry()) != null) {
            entries.add(entry.getName());
        }
        MatcherAssert.assertThat(entries, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])expectedEntries));
    }

    private GetMethod makeRequestToAttachmentServlet(String uri) throws IOException {
        GetMethod request = new GetMethod(uri);
        request.setRequestHeader("User-Agent", "Mozilla/5.0 (compatible; MSIE 7.01; Windows NT 5.0)");
        int status = this.client.executeMethod((HttpMethod)request);
        Assert.assertEquals((long)200L, (long)status);
        return request;
    }

    private URI getAttachmentURI(int attachmentId) throws URISyntaxException {
        return this.getUriBuilder().path("secure/attachment/" + attachmentId + "/").build(new Object[0]);
    }

    private URI unzipFileUri(int entryId) throws URISyntaxException {
        return this.getUriBuilder().path("secure/attachmentzip/unzip/10000/10003%5B" + entryId + "%5D/").build(new Object[0]);
    }

    private URI zipAllAttachmentsUri() throws URISyntaxException {
        return this.getUriBuilder().path("secure/attachmentzip/10001.zip").build(new Object[0]);
    }

    private UriBuilder getUriBuilder() throws URISyntaxException {
        return UriBuilder.fromUri((URI)this.environmentData.getBaseUrl().toURI());
    }
}

