/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.navigation.issue.AttachmentsBlock;
import com.atlassian.jira.functest.framework.navigation.issue.FileAttachmentsList;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.webtests.ztests.attachment.AbstractTestAttachmentsBlockSortingOnViewIssue;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
@LoginAs(user="admin")
public class TestAttachmentsListSorting
extends AbstractTestAttachmentsBlockSortingOnViewIssue {
    @Test
    public void testAttachmentsDefaultToSortingByNameInDescendingOrder() throws Exception {
        List<FileAttachmentsList.FileAttachmentItem> expectedFileAttachmentsList = CollectionBuilder.newBuilder(FileAttachmentsList.Items.file("_fil\u00e5e", "0.0 kB", "Administrator", "06/May/10 12:13 PM"), FileAttachmentsList.Items.file("[#JRA-18780] Test Issue 123 - Atlassian.pdf", "193 kB", "Administrator", "06/May/10 11:27 AM"), FileAttachmentsList.Items.file("[#JRA-18780] Test Issue 123 - Printable.pdf", "98 kB", "Administrator", "06/May/10 12:02 PM"), FileAttachmentsList.Items.file("200px-FCB.svg.png", "16 kB", "Administrator", "06/May/10 11:26 AM"), FileAttachmentsList.Items.file("235px-Floppy_disk_2009_G1.jpg", "8 kB", "Administrator", "06/May/10 11:36 AM"), FileAttachmentsList.Items.file("235px-Floppy_disk_2009_G1.jpg", "8 kB", "Administrator", "06/May/10 11:25 AM"), FileAttachmentsList.Items.file("a", "0.0 kB", "Administrator", "06/May/10 12:12 PM"), FileAttachmentsList.Items.file("a1k4BJwT.jpg.part", "22 kB", "Administrator", "06/May/10 12:01 PM"), FileAttachmentsList.Items.file("\u00e1 file", "0.0 kB", "Administrator", "06/May/10 12:14 PM"), FileAttachmentsList.Items.file("build.xml", "1 kB", "Administrator", "06/May/10 12:00 PM"), FileAttachmentsList.Items.file("catalina.sh", "12 kB", "Administrator", "06/May/10 12:15 PM"), FileAttachmentsList.Items.file("license.txt", "1 kB", "Administrator", "06/May/10 11:26 AM"), FileAttachmentsList.Items.file("license.txt", "1 kB", "Administrator", "06/May/10 11:24 AM"), FileAttachmentsList.Items.file("pom.xml", "5 kB", "Administrator", "06/May/10 11:29 AM"), FileAttachmentsList.Items.file("pom.xml", "2 kB", "Administrator", "06/May/10 11:25 AM"), FileAttachmentsList.Items.file("Tickspot", "0.1 kB", "Administrator", "06/May/10 12:03 PM"), FileAttachmentsList.Items.file("tropical-desktop-wallpaper-1280x1024.jpg", "115 kB", "Administrator", "06/May/10 11:26 AM")).asList();
        List<FileAttachmentsList.FileAttachmentItem> actualFileAttachmentsList = this.navigation.issue().attachments("HSP-1", AttachmentsBlock.ViewMode.LIST).list().get();
        Assert.assertEquals(expectedFileAttachmentsList, actualFileAttachmentsList);
    }

    @Test
    public void testCanSortAttachmentsByFileNameInAscendingOrder() throws Exception {
        List<FileAttachmentsList.FileAttachmentItem> expectedFileAttachmentsList = CollectionBuilder.newBuilder(FileAttachmentsList.Items.file("_fil\u00e5e", "0.0 kB", "Administrator", "06/May/10 12:13 PM"), FileAttachmentsList.Items.file("[#JRA-18780] Test Issue 123 - Atlassian.pdf", "193 kB", "Administrator", "06/May/10 11:27 AM"), FileAttachmentsList.Items.file("[#JRA-18780] Test Issue 123 - Printable.pdf", "98 kB", "Administrator", "06/May/10 12:02 PM"), FileAttachmentsList.Items.file("200px-FCB.svg.png", "16 kB", "Administrator", "06/May/10 11:26 AM"), FileAttachmentsList.Items.file("235px-Floppy_disk_2009_G1.jpg", "8 kB", "Administrator", "06/May/10 11:36 AM"), FileAttachmentsList.Items.file("235px-Floppy_disk_2009_G1.jpg", "8 kB", "Administrator", "06/May/10 11:25 AM"), FileAttachmentsList.Items.file("a", "0.0 kB", "Administrator", "06/May/10 12:12 PM"), FileAttachmentsList.Items.file("a1k4BJwT.jpg.part", "22 kB", "Administrator", "06/May/10 12:01 PM"), FileAttachmentsList.Items.file("\u00e1 file", "0.0 kB", "Administrator", "06/May/10 12:14 PM"), FileAttachmentsList.Items.file("build.xml", "1 kB", "Administrator", "06/May/10 12:00 PM"), FileAttachmentsList.Items.file("catalina.sh", "12 kB", "Administrator", "06/May/10 12:15 PM"), FileAttachmentsList.Items.file("license.txt", "1 kB", "Administrator", "06/May/10 11:26 AM"), FileAttachmentsList.Items.file("license.txt", "1 kB", "Administrator", "06/May/10 11:24 AM"), FileAttachmentsList.Items.file("pom.xml", "5 kB", "Administrator", "06/May/10 11:29 AM"), FileAttachmentsList.Items.file("pom.xml", "2 kB", "Administrator", "06/May/10 11:25 AM"), FileAttachmentsList.Items.file("Tickspot", "0.1 kB", "Administrator", "06/May/10 12:03 PM"), FileAttachmentsList.Items.file("tropical-desktop-wallpaper-1280x1024.jpg", "115 kB", "Administrator", "06/May/10 11:26 AM")).asList();
        AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1", AttachmentsBlock.ViewMode.LIST);
        attachmentsBlock.sort(AttachmentsBlock.Sort.Key.NAME, AttachmentsBlock.Sort.Direction.ASCENDING);
        List<FileAttachmentsList.FileAttachmentItem> actualFileAttachmentsList = attachmentsBlock.list().get();
        Assert.assertEquals(expectedFileAttachmentsList, actualFileAttachmentsList);
        this.verifySortingSettingIsStickyDuringTheSession(expectedFileAttachmentsList);
    }

    @Test
    public void testCanSortAttachmentsByFileNameInDescendingOrder() throws Exception {
        List<FileAttachmentsList.FileAttachmentItem> expectedFileAttachmentsList = CollectionBuilder.newBuilder(FileAttachmentsList.Items.file("tropical-desktop-wallpaper-1280x1024.jpg", "115 kB", "Administrator", "06/May/10 11:26 AM"), FileAttachmentsList.Items.file("Tickspot", "0.1 kB", "Administrator", "06/May/10 12:03 PM"), FileAttachmentsList.Items.file("pom.xml", "2 kB", "Administrator", "06/May/10 11:25 AM"), FileAttachmentsList.Items.file("pom.xml", "5 kB", "Administrator", "06/May/10 11:29 AM"), FileAttachmentsList.Items.file("license.txt", "1 kB", "Administrator", "06/May/10 11:24 AM"), FileAttachmentsList.Items.file("license.txt", "1 kB", "Administrator", "06/May/10 11:26 AM"), FileAttachmentsList.Items.file("catalina.sh", "12 kB", "Administrator", "06/May/10 12:15 PM"), FileAttachmentsList.Items.file("build.xml", "1 kB", "Administrator", "06/May/10 12:00 PM"), FileAttachmentsList.Items.file("\u00e1 file", "0.0 kB", "Administrator", "06/May/10 12:14 PM"), FileAttachmentsList.Items.file("a1k4BJwT.jpg.part", "22 kB", "Administrator", "06/May/10 12:01 PM"), FileAttachmentsList.Items.file("a", "0.0 kB", "Administrator", "06/May/10 12:12 PM"), FileAttachmentsList.Items.file("235px-Floppy_disk_2009_G1.jpg", "8 kB", "Administrator", "06/May/10 11:25 AM"), FileAttachmentsList.Items.file("235px-Floppy_disk_2009_G1.jpg", "8 kB", "Administrator", "06/May/10 11:36 AM"), FileAttachmentsList.Items.file("200px-FCB.svg.png", "16 kB", "Administrator", "06/May/10 11:26 AM"), FileAttachmentsList.Items.file("[#JRA-18780] Test Issue 123 - Printable.pdf", "98 kB", "Administrator", "06/May/10 12:02 PM"), FileAttachmentsList.Items.file("[#JRA-18780] Test Issue 123 - Atlassian.pdf", "193 kB", "Administrator", "06/May/10 11:27 AM"), FileAttachmentsList.Items.file("_fil\u00e5e", "0.0 kB", "Administrator", "06/May/10 12:13 PM")).asList();
        AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1", AttachmentsBlock.ViewMode.LIST);
        attachmentsBlock.sort(AttachmentsBlock.Sort.Key.NAME, AttachmentsBlock.Sort.Direction.DESCENDING);
        List<FileAttachmentsList.FileAttachmentItem> actualFileAttachmentsList = attachmentsBlock.list().get();
        Assert.assertEquals(expectedFileAttachmentsList, actualFileAttachmentsList);
        this.verifySortingSettingIsStickyDuringTheSession(expectedFileAttachmentsList);
    }

    @Test
    public void testCanSortAttachmentsByDateInAscendingOrder() throws Exception {
        List<FileAttachmentsList.FileAttachmentItem> expectedFileAttachmentsList = CollectionBuilder.newBuilder(FileAttachmentsList.Items.file("license.txt", "1 kB", "Administrator", "06/May/10 11:24 AM"), FileAttachmentsList.Items.file("pom.xml", "2 kB", "Administrator", "06/May/10 11:25 AM"), FileAttachmentsList.Items.file("235px-Floppy_disk_2009_G1.jpg", "8 kB", "Administrator", "06/May/10 11:25 AM"), FileAttachmentsList.Items.file("license.txt", "1 kB", "Administrator", "06/May/10 11:26 AM"), FileAttachmentsList.Items.file("200px-FCB.svg.png", "16 kB", "Administrator", "06/May/10 11:26 AM"), FileAttachmentsList.Items.file("tropical-desktop-wallpaper-1280x1024.jpg", "115 kB", "Administrator", "06/May/10 11:26 AM"), FileAttachmentsList.Items.file("[#JRA-18780] Test Issue 123 - Atlassian.pdf", "193 kB", "Administrator", "06/May/10 11:27 AM"), FileAttachmentsList.Items.file("pom.xml", "5 kB", "Administrator", "06/May/10 11:29 AM"), FileAttachmentsList.Items.file("235px-Floppy_disk_2009_G1.jpg", "8 kB", "Administrator", "06/May/10 11:36 AM"), FileAttachmentsList.Items.file("build.xml", "1 kB", "Administrator", "06/May/10 12:00 PM"), FileAttachmentsList.Items.file("a1k4BJwT.jpg.part", "22 kB", "Administrator", "06/May/10 12:01 PM"), FileAttachmentsList.Items.file("[#JRA-18780] Test Issue 123 - Printable.pdf", "98 kB", "Administrator", "06/May/10 12:02 PM"), FileAttachmentsList.Items.file("Tickspot", "0.1 kB", "Administrator", "06/May/10 12:03 PM"), FileAttachmentsList.Items.file("a", "0.0 kB", "Administrator", "06/May/10 12:12 PM"), FileAttachmentsList.Items.file("_fil\u00e5e", "0.0 kB", "Administrator", "06/May/10 12:13 PM"), FileAttachmentsList.Items.file("\u00e1 file", "0.0 kB", "Administrator", "06/May/10 12:14 PM"), FileAttachmentsList.Items.file("catalina.sh", "12 kB", "Administrator", "06/May/10 12:15 PM")).asList();
        AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1", AttachmentsBlock.ViewMode.LIST);
        attachmentsBlock.sort(AttachmentsBlock.Sort.Key.DATE, AttachmentsBlock.Sort.Direction.ASCENDING);
        List<FileAttachmentsList.FileAttachmentItem> actualFileAttachmentsList = attachmentsBlock.list().get();
        Assert.assertEquals(expectedFileAttachmentsList, actualFileAttachmentsList);
        this.verifySortingSettingIsStickyDuringTheSession(expectedFileAttachmentsList);
    }

    @Test
    public void testCanSortAttachmentsByDateInDescendingOrder() throws Exception {
        List<FileAttachmentsList.FileAttachmentItem> expectedFileAttachmentsList = CollectionBuilder.newBuilder(FileAttachmentsList.Items.file("catalina.sh", "12 kB", "Administrator", "06/May/10 12:15 PM"), FileAttachmentsList.Items.file("\u00e1 file", "0.0 kB", "Administrator", "06/May/10 12:14 PM"), FileAttachmentsList.Items.file("_fil\u00e5e", "0.0 kB", "Administrator", "06/May/10 12:13 PM"), FileAttachmentsList.Items.file("a", "0.0 kB", "Administrator", "06/May/10 12:12 PM"), FileAttachmentsList.Items.file("Tickspot", "0.1 kB", "Administrator", "06/May/10 12:03 PM"), FileAttachmentsList.Items.file("[#JRA-18780] Test Issue 123 - Printable.pdf", "98 kB", "Administrator", "06/May/10 12:02 PM"), FileAttachmentsList.Items.file("a1k4BJwT.jpg.part", "22 kB", "Administrator", "06/May/10 12:01 PM"), FileAttachmentsList.Items.file("build.xml", "1 kB", "Administrator", "06/May/10 12:00 PM"), FileAttachmentsList.Items.file("235px-Floppy_disk_2009_G1.jpg", "8 kB", "Administrator", "06/May/10 11:36 AM"), FileAttachmentsList.Items.file("pom.xml", "5 kB", "Administrator", "06/May/10 11:29 AM"), FileAttachmentsList.Items.file("[#JRA-18780] Test Issue 123 - Atlassian.pdf", "193 kB", "Administrator", "06/May/10 11:27 AM"), FileAttachmentsList.Items.file("tropical-desktop-wallpaper-1280x1024.jpg", "115 kB", "Administrator", "06/May/10 11:26 AM"), FileAttachmentsList.Items.file("200px-FCB.svg.png", "16 kB", "Administrator", "06/May/10 11:26 AM"), FileAttachmentsList.Items.file("license.txt", "1 kB", "Administrator", "06/May/10 11:26 AM"), FileAttachmentsList.Items.file("235px-Floppy_disk_2009_G1.jpg", "8 kB", "Administrator", "06/May/10 11:25 AM"), FileAttachmentsList.Items.file("pom.xml", "2 kB", "Administrator", "06/May/10 11:25 AM"), FileAttachmentsList.Items.file("license.txt", "1 kB", "Administrator", "06/May/10 11:24 AM")).asList();
        AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1", AttachmentsBlock.ViewMode.LIST);
        attachmentsBlock.sort(AttachmentsBlock.Sort.Key.DATE, AttachmentsBlock.Sort.Direction.DESCENDING);
        List<FileAttachmentsList.FileAttachmentItem> actualFileAttachmentsList = attachmentsBlock.list().get();
        Assert.assertEquals(expectedFileAttachmentsList, actualFileAttachmentsList);
        this.verifySortingSettingIsStickyDuringTheSession(expectedFileAttachmentsList);
    }

    private void verifySortingSettingIsStickyDuringTheSession(List<FileAttachmentsList.FileAttachmentItem> expectedFileAttachmentsList) {
        this.navigation.gotoDashboard();
        AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1", AttachmentsBlock.ViewMode.LIST);
        List<FileAttachmentsList.FileAttachmentItem> actualAttachmentsList = attachmentsBlock.list().get();
        Assert.assertEquals(expectedFileAttachmentsList, actualAttachmentsList);
    }
}

