/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.util.IOUtil;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS})
@Restore(value="TestFullAnonymousPermissions.xml")
public class TestTemporaryAttachmentsAccess
extends BaseJiraFuncTest {
    private static final String SECURITY_BREACH_TEXT = "It seems that you have tried to perform an operation which you are not permitted to perform.";
    private static final String LOGIN_TEXT = "You must log in to access this page.";

    @Before
    public void setUpTest() {
        this.backdoor.attachments().enable();
    }

    @Test
    public void testAccessAsAdminWhenAttachmentCreatePermissionForEveryoneIsEnabled() throws IOException {
        String attachmentUrl = this.uploadTemporaryAttachment();
        this.navigation.login("admin");
        this.tester.gotoPage(attachmentUrl);
        this.tester.assertTextNotPresent(SECURITY_BREACH_TEXT);
    }

    @Test
    public void testAccessAsAdminWhenAttachmentCreatePermissionForEveryoneIsDisabled() throws IOException {
        String attachmentUrl = this.uploadTemporaryAttachment();
        this.disallowAnonymousAttachmentCreation();
        this.navigation.login("admin");
        this.tester.gotoPage(attachmentUrl);
        this.tester.assertTextNotPresent(SECURITY_BREACH_TEXT);
    }

    @Test
    public void testAccessAsAdminWhenAttachmentCreatePermissionIsRestricted() throws IOException {
        String attachmentUrl = this.uploadTemporaryAttachment();
        this.disallowAnyoneAttachmentCreation();
        this.navigation.login("admin");
        this.tester.gotoPage(attachmentUrl);
        this.tester.assertTextPresent(SECURITY_BREACH_TEXT);
    }

    @Test
    public void testAccessAsAdminWhenAttachmentCreateIsDisabled() throws IOException {
        String attachmentUrl = this.uploadTemporaryAttachment();
        this.backdoor.attachments().disable();
        this.navigation.login("admin");
        this.tester.gotoPage(attachmentUrl);
        this.tester.assertTextPresent(SECURITY_BREACH_TEXT);
    }

    @Test
    public void testAccessAsNormalUserWhenAttachmentCreatePermissionForEveryoneIsEnabled() throws IOException {
        String attachmentUrl = this.uploadTemporaryAttachment();
        this.navigation.login("fred");
        this.tester.gotoPage(attachmentUrl);
        this.tester.assertTextNotPresent(SECURITY_BREACH_TEXT);
    }

    @Test
    public void testAccessAsNormalUserWhenAttachmentCreatePermissionForEveryoneIsDisabled() throws IOException {
        String attachmentUrl = this.uploadTemporaryAttachment();
        this.disallowAnonymousAttachmentCreation();
        this.navigation.login("fred");
        this.tester.gotoPage(attachmentUrl);
        this.tester.assertTextNotPresent(SECURITY_BREACH_TEXT);
    }

    @Test
    public void testAccessAsNormalUserWhenAttachmentCreatePermissionIsRestricted() throws IOException {
        String attachmentUrl = this.uploadTemporaryAttachment();
        this.disallowAnyoneAttachmentCreation();
        this.navigation.login("fred");
        this.tester.gotoPage(attachmentUrl);
        this.tester.assertTextPresent(SECURITY_BREACH_TEXT);
    }

    @Test
    public void testAccessAsNormalUserWhenAttachmentCreateIsDisabled() throws IOException {
        String attachmentUrl = this.uploadTemporaryAttachment();
        this.backdoor.attachments().disable();
        this.navigation.login("fred");
        this.tester.gotoPage(attachmentUrl);
        this.tester.assertTextPresent(SECURITY_BREACH_TEXT);
    }

    @Test
    public void testAccessAsAnonymousWhenAttachmentCreatePermissionForEveryoneIsEnabled() throws IOException {
        String attachmentUrl = this.uploadTemporaryAttachment();
        this.navigation.logout();
        this.tester.gotoPage(attachmentUrl);
        this.tester.assertTextNotPresent(LOGIN_TEXT);
    }

    @Test
    public void testAccessAsAnonymousWhenAttachmentCreatePermissionForEveryoneIsDisabled() throws IOException {
        String attachmentUrl = this.uploadTemporaryAttachment();
        this.disallowAnonymousAttachmentCreation();
        this.navigation.logout();
        this.tester.gotoPage(attachmentUrl);
        this.tester.assertTextPresent(LOGIN_TEXT);
    }

    @Test
    public void testAccessAsAnonymousWhenAttachmentCreatePermissionIsRestricted() throws IOException {
        String attachmentUrl = this.uploadTemporaryAttachment();
        this.disallowAnyoneAttachmentCreation();
        this.navigation.logout();
        this.tester.gotoPage(attachmentUrl);
        this.tester.assertTextPresent(LOGIN_TEXT);
    }

    @Test
    public void testAccessAsAnonymousWhenAttachmentCreateIsDisabled() throws IOException {
        String attachmentUrl = this.uploadTemporaryAttachment();
        this.backdoor.attachments().disable();
        this.navigation.logout();
        this.tester.gotoPage(attachmentUrl);
        this.tester.assertTextPresent(LOGIN_TEXT);
    }

    @Test
    public void testContentSecurityPolicyHeader() throws IOException {
        String attachmentUrl = this.uploadTemporaryAttachment();
        this.navigation.login("admin");
        this.tester.gotoPage(attachmentUrl);
        this.tester.assertTextNotPresent(SECURITY_BREACH_TEXT);
        Assert.assertEquals((Object)"sandbox", (Object)this.tester.getDialog().getResponse().getHeaderField("Content-Security-Policy"));
    }

    private String uploadTemporaryAttachment() throws IOException {
        Throwable throwable = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            Throwable throwable2;
            CloseableHttpResponse response;
            block27: {
                String string;
                block28: {
                    block29: {
                        byte[] fileContent = "{\"test\": true}".getBytes(StandardCharsets.UTF_8);
                        HttpPost httpPost = new HttpPost(this.getEnvironmentData().getBaseUrl().toString() + "/rest/internal/2/AttachTemporaryFile?filename=test.json&size=" + fileContent.length + "&formToken=formId&projectId=10001");
                        httpPost.setEntity(EntityBuilder.create().setBinary(fileContent).setContentType(ContentType.APPLICATION_JSON).setContentEncoding(StandardCharsets.UTF_8.displayName()).build());
                        String encoding = Base64.getEncoder().encodeToString("admin:admin".getBytes());
                        httpPost.addHeader("Authorization", "Basic " + encoding);
                        httpPost.addHeader("X-Atlassian-Token", "no-check");
                        response = httpClient.execute((HttpUriRequest)httpPost);
                        throwable2 = null;
                        if (response.getStatusLine().getStatusCode() != 201) break block27;
                        String content = this.getResponseContentAsString(response);
                        if (content.isEmpty()) {
                            throw new IllegalStateException("Response cannot be empty");
                        }
                        AttachTemporaryFileBean resultBean = (AttachTemporaryFileBean)new Gson().fromJson(content, AttachTemporaryFileBean.class);
                        string = resultBean.attachmentUrl;
                        if (response == null) break block28;
                        if (throwable2 == null) break block29;
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block28;
                    }
                    response.close();
                }
                return string;
            }
            try {
                try {
                    try {
                        if (response.getEntity().getContentLength() <= 0L) {
                            throw new IllegalStateException("Failed to create new temporary attachment. No error in content. Response code:  `" + response.getStatusLine().toString() + "`");
                        }
                        throw new IllegalStateException("Failed to create new temporary attachment with error `" + this.getResponseContentAsString(response) + "`");
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (response != null) {
                        if (throwable2 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            response.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    private String getResponseContentAsString(CloseableHttpResponse response) throws IOException {
        byte[] bytes = IOUtil.toByteArray((InputStream)response.getEntity().getContent());
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private void disallowAnonymousAttachmentCreation() {
        this.backdoor.getTestkit().permissionSchemes().removeEveryonePermission(Long.valueOf(0L), ProjectPermissions.CREATE_ATTACHMENTS);
    }

    private void disallowUsersAttachmentCreation() {
        this.backdoor.getTestkit().permissionSchemes().removeGroupPermission(0L, ProjectPermissions.CREATE_ATTACHMENTS, "jira-users");
    }

    private void disallowAnyoneAttachmentCreation() {
        this.disallowAnonymousAttachmentCreation();
        this.disallowUsersAttachmentCreation();
    }

    static class AttachTemporaryFileBean {
        public String name;
        public String id;
        public String attachmentUrl;

        AttachTemporaryFileBean() {
        }
    }
}

