/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperationProgress;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.REFERENCE_PLUGIN})
@LoginAs(user="admin")
public class TestBulkEditCustomFieldWithNoValidation
extends BaseJiraFuncTest {
    private static final int LIMIT = 255;
    private static final String SOME_LONG_TEXT = StringUtils.repeat((String)"yaddi yaddi yadda ", (int)15);
    private static final String CUSTOM_FIELD_WITHOUT_LENGTH_VALIDATION_ID = "customfield_10100";
    @Inject
    private BulkOperationProgress bulkOperationProgress;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestCreateIssueWithDegeneratedCustomFieldType.xml");
        this.backdoor.advancedSettings().setTextFieldCharacterLengthLimit(255L);
    }

    @Test
    public void testBulkEditReportsAnErrorWhenFieldIsTooLong() throws Exception {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.tester.assertTextPresent("Step 1 of 4: Choose Issues");
        this.tester.checkCheckbox("bulkedit_10300", "on");
        this.tester.checkCheckbox("bulkedit_10200", "on");
        this.tester.checkCheckbox("bulkedit_10100", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.tester.checkCheckbox("actions", CUSTOM_FIELD_WITHOUT_LENGTH_VALIDATION_ID);
        this.tester.setFormElement(CUSTOM_FIELD_WITHOUT_LENGTH_VALIDATION_ID, SOME_LONG_TEXT);
        this.tester.submit("Next");
        this.tester.submit("Confirm");
        this.bulkOperationProgress.waitForOperationProgressPage(this.tester);
        this.assertions.getJiraFormAssertions().assertFormErrMsg("Error while performing bulk operation on issues");
        this.tester.submit("Acknowledge");
    }
}

