/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS})
public class TestBulkEditDataLeaks
extends BaseJiraFuncTest {
    private static final Long TEST_PROJECT_ID = 10010L;

    @Test
    @LoginAs(user="admin")
    @Restore(value="TestIssueNavigatorCsvViewEmptyProject.xml")
    public void whenUserHasNotBrowsePermissionThenHeShouldNotBeAbleToSelectIssues() throws Exception {
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.SET_ISSUE_SECURITY);
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS);
        IssueCreateResponse newIssue = this.backdoor.issues().createIssue(TEST_PROJECT_ID.longValue(), "This is a new issue");
        Long issueSchemeId = this.backdoor.issueSecuritySchemesControl().createScheme("Some scheme", "description");
        Long levelId = this.backdoor.issueSecuritySchemesControl().addSecurityLevel(issueSchemeId.longValue(), "Nobody", "Nobody can access it");
        this.backdoor.project().setIssueSecurityScheme(TEST_PROJECT_ID, issueSchemeId);
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.gotoPage("/issue/bulkedit/BulkEdit1!default.jspa?reset=true");
        this.tester.setWorkingForm("bulkedit");
        this.tester.getDialog().getForm().setParameter(String.format("bulkedit_%s", newIssue.id), "on");
        this.backdoor.issues().setIssueFields(newIssue.key, new IssueFields().securityLevel(ResourceRef.withId((String)String.valueOf(levelId))));
        this.tester.submit("Next");
        this.tester.assertTextPresent("You are trying to perform an unavailable operation for the selected  issues.");
        this.tester.gotoPage("/secure/views/bulkedit/BulkDeleteDetailsValidation.jspa");
        this.tester.assertTextNotPresent(newIssue.key);
        this.tester.gotoPage("/secure/views/bulkedit/BulkArchiveDetailsValidation.jspa");
        this.tester.assertTextNotPresent(newIssue.key);
    }
}

