/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperationProgress;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS})
@LoginAs(user="admin")
public class TestBulkEditTimeTrackingLegacy
extends BaseJiraFuncTest {
    private static final String COW_15 = "COW-15";
    private static final String COW_16 = "COW-16";
    private static final String COW_17 = "COW-17";
    private static final String INIT_ESTIMATE = "50h";
    private static final String UPDATED_ESTIMATE = "2d";
    private static final String NOT_SPECIFIED = "Not Specified";
    private static final String PAGE_HEADER_SELECTOR = ".aui-page-header-main";
    private static final String COW_15_CHECKBOX = "bulkedit_10020";
    private static final String COW_16_CHECKBOX = "bulkedit_10021";
    private static final String COW_17_CHECKBOX = "bulkedit_10030";
    @Inject
    private BulkOperationProgress bulkOperationProgress;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestBulkEditEnvironment.xml");
    }

    @Test
    public void testUpdateEstimate() {
        this.navigation.issue().setOriginalEstimate(COW_15, INIT_ESTIMATE);
        this.navigation.issue().setOriginalEstimate(COW_16, INIT_ESTIMATE);
        this.navigation.issue().logWork(COW_16, "1d");
        this.navigation.issue().setOriginalEstimate(COW_17, INIT_ESTIMATE);
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.tester.assertTextPresent("Step 1 of 4: Choose Issues");
        this.tester.checkCheckbox(COW_15_CHECKBOX, "on");
        this.tester.checkCheckbox(COW_16_CHECKBOX, "on");
        this.tester.checkCheckbox(COW_17_CHECKBOX, "on");
        this.tester.submit("Next");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, PAGE_HEADER_SELECTOR), "Step 2 of 4: Choose Operation");
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, PAGE_HEADER_SELECTOR), "Step 3 of 4: Operation Details");
        this.tester.assertTextPresent("Change Time Tracking");
        this.tester.checkCheckbox("actions", "timetracking");
        this.tester.setFormElement("timetracking", UPDATED_ESTIMATE);
        this.tester.submit("Next");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, PAGE_HEADER_SELECTOR), "Step 4 of 4: Confirmation");
        this.tester.assertTextPresent("Updated Fields");
        WebTable updatedfields = this.tester.getDialog().getWebTableBySummaryOrId("updatedfields");
        Assert.assertEquals((String)"Cell (1, 0) in table 'updatedfields' should be 'Time Tracking'.", (Object)"Time Tracking", (Object)updatedfields.getCellAsText(1, 0).trim());
        Assert.assertEquals((String)"Cell (1, 1) in table 'updatedfields' should be 'Change to'.", (Object)"Change to", (Object)updatedfields.getCellAsText(1, 1).trim());
        Assert.assertEquals((String)"Cell (1, 2) in table 'updatedfields' should match '2d'.", (Object)UPDATED_ESTIMATE, (Object)updatedfields.getCellAsText(1, 2).trim());
        this.tester.submit("Confirm");
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().viewIssue(COW_15);
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo(UPDATED_ESTIMATE, UPDATED_ESTIMATE, NOT_SPECIFIED);
        this.navigation.issue().viewIssue(COW_16);
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("1w 1d 2h", UPDATED_ESTIMATE, "1d");
        this.navigation.issue().viewIssue(COW_17);
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo(UPDATED_ESTIMATE, UPDATED_ESTIMATE, NOT_SPECIFIED);
    }
}

