/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperations;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.assertions.ViewIssueAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.ISSUES})
@LoginAs(user="admin")
public class TestBulkMoveMappingVersionsAndComponents
extends BaseJiraFuncTest {
    private static final String BULK_EDIT_KEY = "10000_1_";
    private static final String UNKNOWN = "Unknown";
    private static final String TARGET_PROJECT_ID = "10000_1_pid";
    @Inject
    private BulkOperations bulkOperations;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.backdoor.darkFeatures().enableForSite("jira.no.frother.userpicker.field");
    }

    @After
    public void tearDown() {
        this.backdoor.darkFeatures().disableForSite("jira.no.frother.userpicker.field");
    }

    @Test
    @Restore(value="TestBulkMoveMappingVersionsAndComponents.xml")
    public void testBulkMoveDistinctValuesMapped() throws Exception {
        String hsp1 = this.navigation.issue().createIssue("homosapien", "Bug", "first issue");
        this.navigation.issue().setAffectsVersions(hsp1, "New Version 1", "New Version 2");
        this.navigation.issue().setFixVersions(hsp1, "New Version 1", "New Version 3");
        this.navigation.issue().setComponents(hsp1, "New Component 1", "New Component 2");
        this.navigation.issue().setIssueMultiSelectField(hsp1, "customfield_10003", "New Version 1", "New Version 5");
        String hsp2 = this.navigation.issue().createIssue("homosapien", "Bug", "second issue");
        this.navigation.issue().setAffectsVersions(hsp2, "New Version 1", "New Version 3");
        this.navigation.issue().setFixVersions(hsp2, "New Version 1", "New Version 4");
        this.navigation.issue().setComponents(hsp2, "New Component 1", "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(hsp2, "customfield_10003", "New Version 2");
        String mky1 = this.navigation.issue().createIssue("monkey", "Bug", "third issue");
        this.navigation.issue().setAffectsVersions(mky1, "New Version 3");
        this.navigation.issue().setFixVersions(mky1, "New Version 5");
        this.navigation.issue().setComponents(mky1, "New Component 4");
        this.navigation.issue().setIssueMultiSelectField(mky1, "customfield_10003", "New Version 6");
        this.bulkMoveAllIssuesToProject("monkey");
        this.assertDefaultOption("fixVersions", "10000", UNKNOWN);
        this.assertDefaultOption("fixVersions", "10003", "New Version 3");
        this.assertDefaultOption("fixVersions", "10004", UNKNOWN);
        this.assertDefaultOption("versions", "10000", UNKNOWN);
        this.assertDefaultOption("versions", "10001", UNKNOWN);
        this.assertDefaultOption("versions", "10003", "New Version 3");
        this.assertDefaultOption("components", "10000", UNKNOWN);
        this.assertDefaultOption("components", "10001", UNKNOWN);
        this.assertDefaultOption("components", "10002", "New Component 3");
        this.assertDefaultOption("customfield_10003", "10000", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10001", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10005", "New Version 5");
        this.tester.selectOption("fixVersions_10000", "New Version 5");
        this.tester.selectOption("fixVersions_10004", "New Version 6");
        this.tester.selectOption("versions_10000", "New Version 5");
        this.tester.selectOption("versions_10001", "New Version 6");
        this.tester.selectOption("components_10000", "New Component 4");
        this.tester.selectOption("components_10001", "New Component 4");
        this.tester.selectOption("customfield_10003_10000", "New Version 5");
        this.tester.selectOption("customfield_10003_10001", "New Version 6");
        this.completeBulkMoveWizard();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.assertIssueValuesAfterMove("MKY-1", "New Version 3", "New Version 5", "New Component 4", "New Version 6");
        String firstIssueKey = this.getIssueKeyWithSummary("first issue", "MKY");
        this.assertIssueValuesAfterMove(firstIssueKey, "New Version 5, New Version 6", "New Version 3, New Version 5", "New Component 4", "New Version 5");
        String secondIssueKey = this.getIssueKeyWithSummary("second issue", "MKY");
        this.assertIssueValuesAfterMove(secondIssueKey, "New Version 3, New Version 5", "New Version 5, New Version 6", "New Component 3, New Component 4", "New Version 6");
    }

    @Test
    @Restore(value="TestBulkMoveMappingVersionsAndComponentsAndUsers.xml")
    public void testBulkMoveWithUserCFType() throws Exception {
        String hsp1 = this.navigation.issue().createIssue("homosapien", "Bug", "first issue");
        this.navigation.issue().setAffectsVersions(hsp1, "New Version 1", "New Version 2");
        this.navigation.issue().setFixVersions(hsp1, "New Version 1", "New Version 3");
        this.navigation.issue().setComponents(hsp1, "New Component 1", "New Component 2");
        this.navigation.issue().setIssueMultiSelectField(hsp1, "customfield_10003", "New Version 1", "New Version 5");
        this.navigation.issue().setFreeTextCustomField(hsp1, "customfield_10010", "admin");
        String hsp2 = this.navigation.issue().createIssue("homosapien", "Bug", "second issue");
        this.navigation.issue().setAffectsVersions(hsp2, "New Version 1", "New Version 3");
        this.navigation.issue().setFixVersions(hsp2, "New Version 1", "New Version 4");
        this.navigation.issue().setComponents(hsp2, "New Component 1", "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(hsp2, "customfield_10003", "New Version 2");
        this.bulkMoveAllIssuesToProject("monkey");
        this.assertDefaultOption("fixVersions", "10000", UNKNOWN);
        this.assertDefaultOption("fixVersions", "10003", "New Version 3");
        this.assertDefaultOption("fixVersions", "10004", UNKNOWN);
        this.assertDefaultOption("versions", "10000", UNKNOWN);
        this.assertDefaultOption("versions", "10001", UNKNOWN);
        this.assertDefaultOption("versions", "10003", "New Version 3");
        this.assertDefaultOption("components", "10000", UNKNOWN);
        this.assertDefaultOption("components", "10001", UNKNOWN);
        this.assertDefaultOption("components", "10002", "New Component 3");
        this.assertDefaultOption("customfield_10003", "10000", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10001", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10005", "New Version 5");
        this.tester.selectOption("fixVersions_10000", "New Version 5");
        this.tester.selectOption("fixVersions_10004", "New Version 6");
        this.tester.selectOption("versions_10000", "New Version 5");
        this.tester.selectOption("versions_10001", "New Version 6");
        this.tester.selectOption("components_10000", "New Component 4");
        this.tester.selectOption("components_10001", "New Component 4");
        this.tester.selectOption("customfield_10003_10000", "New Version 5");
        this.tester.selectOption("customfield_10003_10001", "New Version 6");
        this.tester.setFormElement("customfield_10010", "admin");
        this.completeBulkMoveWizard();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        String firstIssueKey = this.getIssueKeyWithSummary("first issue", "MKY");
        this.assertIssueValuesAfterMoveWithUserPicker(firstIssueKey, "New Version 5, New Version 6", "New Version 3, New Version 5", "New Component 4", "Administrator", "New Version 5");
        String secondIssueKey = this.getIssueKeyWithSummary("second issue", "MKY");
        this.assertIssueValuesAfterMoveWithUserPicker(secondIssueKey, "New Version 3, New Version 5", "New Version 5, New Version 6", "New Component 3, New Component 4", "Administrator", "New Version 6");
    }

    @Test
    @Restore(value="TestBulkMoveMappingVersionsAndComponents.xml")
    public void testBulkMoveTwoContextsDifferentMappings() throws Exception {
        String hsp1 = this.navigation.issue().createIssue("homosapien", "Bug", "first issue");
        this.navigation.issue().setAffectsVersions(hsp1, "New Version 1", "New Version 2", "New Version 3");
        this.navigation.issue().setFixVersions(hsp1, "New Version 1", "New Version 2", "New Version 3");
        this.navigation.issue().setComponents(hsp1, "New Component 1", "New Component 2", "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(hsp1, "customfield_10003", "New Version 1", "New Version 2", "New Version 5");
        String hsp2 = this.navigation.issue().createIssue("homosapien", "New Feature", "second issue");
        this.navigation.issue().setAffectsVersions(hsp2, "New Version 1", "New Version 2", "New Version 3");
        this.navigation.issue().setFixVersions(hsp2, "New Version 1", "New Version 2", "New Version 3");
        this.navigation.issue().setComponents(hsp2, "New Component 1", "New Component 2", "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(hsp2, "customfield_10003", "New Version 1", "New Version 2", "New Version 5");
        this.navigation.issueNavigator().createSearch("project = HSP");
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeChooseIssuesAll();
        this.bulkOperations.chooseOperationBulkMove();
        this.isStepSelectProjectIssueType();
        this.navigation.issue().selectProject("monkey", TARGET_PROJECT_ID);
        this.navigation.issue().selectProject("monkey", "10000_2_pid");
        this.tester.submit("Next");
        this.isStepSetFields();
        this.assertDefaultOption("fixVersions", "10000", UNKNOWN);
        this.assertDefaultOption("fixVersions", "10001", UNKNOWN);
        this.assertDefaultOption("fixVersions", "10003", "New Version 3");
        this.assertDefaultOption("versions", "10000", UNKNOWN);
        this.assertDefaultOption("versions", "10001", UNKNOWN);
        this.assertDefaultOption("versions", "10003", "New Version 3");
        this.assertDefaultOption("components", "10000", UNKNOWN);
        this.assertDefaultOption("components", "10001", UNKNOWN);
        this.assertDefaultOption("components", "10002", "New Component 3");
        this.assertDefaultOption("customfield_10003", "10000", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10001", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10005", "New Version 5");
        this.tester.selectOption("fixVersions_10000", "New Version 5");
        this.tester.selectOption("fixVersions_10001", "New Version 5");
        this.tester.selectOption("fixVersions_10003", "New Version 6");
        this.tester.selectOption("versions_10000", "New Version 5");
        this.tester.selectOption("versions_10001", "New Version 6");
        this.tester.selectOption("versions_10003", UNKNOWN);
        this.tester.selectOption("components_10001", "New Component 4");
        this.tester.selectOption("customfield_10003_10000", "New Version 5");
        this.tester.selectOption("customfield_10003_10001", "New Version 5");
        this.tester.selectOption("customfield_10003_10005", "New Version 6");
        this.tester.submit("Next");
        this.assertDefaultOption("fixVersions", "10000", "New Version 5");
        this.assertDefaultOption("fixVersions", "10001", "New Version 5");
        this.assertDefaultOption("fixVersions", "10003", "New Version 6");
        this.assertDefaultOption("versions", "10000", "New Version 5");
        this.assertDefaultOption("versions", "10001", "New Version 6");
        this.assertDefaultOption("versions", "10003", UNKNOWN);
        this.assertDefaultOption("components", "10000", UNKNOWN);
        this.assertDefaultOption("components", "10001", "New Component 4");
        this.assertDefaultOption("components", "10002", "New Component 3");
        this.assertDefaultOption("customfield_10003", "10000", "New Version 5");
        this.assertDefaultOption("customfield_10003", "10001", "New Version 5");
        this.assertDefaultOption("customfield_10003", "10005", "New Version 6");
        this.tester.selectOption("fixVersions_10000", UNKNOWN);
        this.tester.selectOption("versions_10000", UNKNOWN);
        this.tester.selectOption("customfield_10003_10001", "New Version 3");
        this.tester.submit("Next");
        this.bulkOperations.isStepConfirmation();
        this.assertConfirmationMapping(BULK_EDIT_KEY, "fixVersions", "New Version 1", "New Version 5", "New Version 2", "New Version 5", "New Version 3", "New Version 6");
        this.assertConfirmationMapping(BULK_EDIT_KEY, "versions", "New Version 1", "New Version 5", "New Version 2", "New Version 6", "New Version 3", UNKNOWN);
        this.assertConfirmationMapping(BULK_EDIT_KEY, "components", "New Component 1", UNKNOWN, "New Component 2", "New Component 4", "New Component 3", "New Component 3");
        this.assertConfirmationMapping(BULK_EDIT_KEY, "customfield_10003", "New Version 1", "New Version 5", "New Version 2", "New Version 5", "New Version 5", "New Version 6");
        this.assertConfirmationMapping("10000_2_", "fixVersions", "New Version 1", UNKNOWN, "New Version 2", "New Version 5", "New Version 3", "New Version 6");
        this.assertConfirmationMapping("10000_2_", "versions", "New Version 1", UNKNOWN, "New Version 2", "New Version 6", "New Version 3", UNKNOWN);
        this.assertConfirmationMapping("10000_2_", "components", "New Component 1", UNKNOWN, "New Component 2", "New Component 4", "New Component 3", "New Component 3");
        this.assertConfirmationMapping("10000_2_", "customfield_10003", "New Version 1", "New Version 5", "New Version 2", "New Version 3", "New Version 5", "New Version 6");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        String firstIssueKey = this.getIssueKeyWithSummary("first issue", "MKY");
        this.assertIssueValuesAfterMove(firstIssueKey, "New Version 5, New Version 6", "New Version 5, New Version 6", "New Component 3, New Component 4", "New Version 5", "New Version 6");
        String secondIssueKey = this.getIssueKeyWithSummary("second issue", "MKY");
        this.assertIssueValuesAfterMove(secondIssueKey, "New Version 6", "New Version 5, New Version 6", "New Component 3, New Component 4", "New Version 5", "New Version 3", "New Version 6");
    }

    @Test
    @Restore(value="TestBulkMoveMappingVersionsAndComponents.xml")
    public void testBulkMoveThreeContextsDifferentMappings() throws Exception {
        String hsp1 = this.navigation.issue().createIssue("homosapien", "Bug", "first issue");
        this.navigation.issue().setAffectsVersions(hsp1, "New Version 1", "New Version 2", "New Version 3");
        this.navigation.issue().setFixVersions(hsp1, "New Version 1", "New Version 2", "New Version 3");
        this.navigation.issue().setComponents(hsp1, "New Component 1", "New Component 2", "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(hsp1, "customfield_10003", "New Version 1", "New Version 2", "New Version 5");
        String hsp2 = this.navigation.issue().createIssue("homosapien", "New Feature", "second issue");
        this.navigation.issue().setAffectsVersions(hsp2, "New Version 1");
        this.navigation.issue().setFixVersions(hsp2, "New Version 1");
        this.navigation.issue().setComponents(hsp2, "New Component 1");
        this.navigation.issue().setIssueMultiSelectField(hsp2, "customfield_10003", "New Version 1");
        String hsp3 = this.navigation.issue().createIssue("homosapien", "Task", "third issue");
        this.navigation.issue().setAffectsVersions(hsp3, "New Version 1", "New Version 2", "New Version 3");
        this.navigation.issue().setFixVersions(hsp3, "New Version 1", "New Version 2", "New Version 3");
        this.navigation.issue().setComponents(hsp3, "New Component 1", "New Component 2", "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(hsp3, "customfield_10003", "New Version 1", "New Version 2", "New Version 5");
        this.navigation.issueNavigator().createSearch("project = HSP");
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeChooseIssuesAll();
        this.bulkOperations.chooseOperationBulkMove();
        this.isStepSelectProjectIssueType();
        this.navigation.issue().selectProject("monkey", TARGET_PROJECT_ID);
        this.navigation.issue().selectProject("monkey", "10000_2_pid");
        this.navigation.issue().selectProject("monkey", "10000_3_pid");
        this.tester.submit("Next");
        this.isStepSetFields();
        this.assertDefaultOption("fixVersions", "10000", UNKNOWN);
        this.assertDefaultOption("fixVersions", "10001", UNKNOWN);
        this.assertDefaultOption("fixVersions", "10003", "New Version 3");
        this.assertDefaultOption("versions", "10000", UNKNOWN);
        this.assertDefaultOption("versions", "10001", UNKNOWN);
        this.assertDefaultOption("versions", "10003", "New Version 3");
        this.assertDefaultOption("components", "10000", UNKNOWN);
        this.assertDefaultOption("components", "10001", UNKNOWN);
        this.assertDefaultOption("components", "10002", "New Component 3");
        this.assertDefaultOption("customfield_10003", "10000", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10001", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10005", "New Version 5");
        this.tester.selectOption("fixVersions_10000", "New Version 5");
        this.tester.selectOption("fixVersions_10001", "New Version 6");
        this.tester.selectOption("versions_10000", "New Version 5");
        this.tester.selectOption("versions_10001", "New Version 6");
        this.tester.selectOption("versions_10003", UNKNOWN);
        this.tester.selectOption("components_10001", "New Component 4");
        this.tester.selectOption("customfield_10003_10000", "New Version 5");
        this.tester.selectOption("customfield_10003_10001", "New Version 6");
        this.tester.submit("Next");
        this.assertDefaultOption("fixVersions", "10000", "New Version 5");
        this.assertDefaultOption("versions", "10000", "New Version 5");
        this.assertDefaultOption("components", "10000", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10000", "New Version 5");
        this.tester.selectOption("fixVersions_10000", UNKNOWN);
        this.tester.submit("Next");
        this.assertDefaultOption("fixVersions", "10000", UNKNOWN);
        this.assertDefaultOption("fixVersions", "10001", "New Version 6");
        this.assertDefaultOption("fixVersions", "10003", "New Version 3");
        this.assertDefaultOption("versions", "10000", "New Version 5");
        this.assertDefaultOption("versions", "10001", "New Version 6");
        this.assertDefaultOption("versions", "10003", UNKNOWN);
        this.assertDefaultOption("components", "10000", UNKNOWN);
        this.assertDefaultOption("components", "10001", "New Component 4");
        this.assertDefaultOption("components", "10002", "New Component 3");
        this.assertDefaultOption("customfield_10003", "10000", "New Version 5");
        this.assertDefaultOption("customfield_10003", "10001", "New Version 6");
        this.assertDefaultOption("customfield_10003", "10005", "New Version 5");
    }

    private void assertConfirmationMapping(String uniqueContextId, String fieldId, String ... mappingValues) {
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, uniqueContextId + fieldId), mappingValues);
    }

    @Test
    @Restore(value="TestBulkMoveMappingVersionsAndComponents.xml")
    public void testBulkMoveIssuesFromTwoProjects() throws Exception {
        this.administration.project().addVersion("NDT", "XYZ", null, null);
        this.administration.project().addComponent("NDT", "ABC", null, null);
        String hsp1 = this.navigation.issue().createIssue("homosapien", "Bug", "first issue");
        this.navigation.issue().setAffectsVersions(hsp1, "New Version 3");
        this.navigation.issue().setFixVersions(hsp1, "New Version 3");
        this.navigation.issue().setComponents(hsp1, "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(hsp1, "customfield_10003", "New Version 3");
        String mky1 = this.navigation.issue().createIssue("monkey", "Bug", "second issue");
        this.navigation.issue().setAffectsVersions(mky1, "New Version 3");
        this.navigation.issue().setFixVersions(mky1, "New Version 3");
        this.navigation.issue().setComponents(mky1, "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(mky1, "customfield_10003", "New Version 3");
        this.bulkMoveAllIssuesToProject("neanderthal");
        this.assertDefaultOption("fixVersions", "10002", "New Version 3", "monkey", UNKNOWN);
        this.assertDefaultOption("fixVersions", "10003", "New Version 3", "homosapien", UNKNOWN);
        this.assertDefaultOption("versions", "10002", "New Version 3", "monkey", UNKNOWN);
        this.assertDefaultOption("versions", "10003", "New Version 3", "homosapien", UNKNOWN);
        this.assertDefaultOption("components", "10010", "New Component 3", "monkey", UNKNOWN);
        this.assertDefaultOption("components", "10002", "New Component 3", "homosapien", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10002", "New Version 3", "monkey", UNKNOWN);
        this.assertDefaultOption("customfield_10003", "10003", "New Version 3", "homosapien", UNKNOWN);
        this.tester.selectOption("fixVersions_10002", "XYZ");
        this.tester.selectOption("versions_10002", "XYZ");
        this.tester.selectOption("components_10010", "ABC");
        this.tester.selectOption("customfield_10003_10002", "XYZ");
        this.completeBulkMoveWizard();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        String firstIssueKey = this.getIssueKeyWithSummary("first issue", "NDT");
        this.assertIssueValuesAfterMove(firstIssueKey, "None", "None", "None", null);
        String secondIssueKey = this.getIssueKeyWithSummary("second issue", "NDT");
        this.assertIssueValuesAfterMove(secondIssueKey, "XYZ", "XYZ", "ABC", "XYZ");
    }

    @Test
    @Restore(value="TestBulkMoveMappingVersionsAndComponents.xml")
    public void testBulkMoveIssuesFromTwoProjectsDestinationRequired() throws Exception {
        this.administration.project().addVersion("NDT", "XYZ", null, null);
        this.administration.project().addVersion("NDT", "XYZ1", null, null);
        this.administration.project().addComponent("NDT", "ABC", null, null);
        this.administration.project().addComponent("NDT", "ABC1", null, null);
        this.navigation.issue().createIssue("homosapien", "Bug", "first issue");
        String mky1 = this.navigation.issue().createIssue("monkey", "Bug", "second issue");
        this.navigation.issue().setAffectsVersions(mky1, "New Version 3");
        this.navigation.issue().setFixVersions(mky1, "New Version 3");
        this.navigation.issue().setComponents(mky1, "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(mky1, "customfield_10003", "New Version 3");
        this.setFieldsToBeRequired();
        this.bulkMoveAllIssuesToProject("neanderthal");
        this.assertDefaultOption("fixVersions", "10002", "New Version 3", "monkey", "XYZ", true);
        this.assertDefaultOption("fixVersions", "-1", "No Version", null, "XYZ", true);
        this.assertDefaultOption("versions", "10002", "New Version 3", "monkey", "XYZ", true);
        this.assertDefaultOption("versions", "-1", "No Version", null, "XYZ", true);
        this.assertDefaultOption("components", "10010", "New Component 3", "monkey", "ABC", true);
        this.assertDefaultOption("components", "-1", "No Component", null, "ABC", true);
        this.assertDefaultOption("customfield_10003", "10002", "New Version 3", "monkey", "XYZ", true);
        this.assertDefaultOption("customfield_10003", "-1", "No Version", null, "XYZ", true);
        this.tester.selectOption("fixVersions_10002", "XYZ1");
        this.tester.selectOption("versions_10002", "XYZ1");
        this.tester.selectOption("components_10010", "ABC1");
        this.tester.selectOption("customfield_10003_10002", "XYZ1");
        this.completeBulkMoveWizard();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        String firstIssueKey = this.getIssueKeyWithSummary("first issue", "NDT");
        this.assertIssueValuesAfterMove(firstIssueKey, "XYZ", "XYZ", "ABC", "XYZ");
        String secondIssueKey = this.getIssueKeyWithSummary("second issue", "NDT");
        this.assertIssueValuesAfterMove(secondIssueKey, "XYZ1", "XYZ1", "ABC1", "XYZ1");
    }

    @Test
    @Restore(value="TestBulkMoveMappingVersionsAndComponents.xml")
    public void testBulkMoveIssuesWithNoDestinationValues() throws Exception {
        String hsp1 = this.navigation.issue().createIssue("homosapien", "Bug", "first issue");
        this.navigation.issue().setAffectsVersions(hsp1, "New Version 3");
        this.navigation.issue().setFixVersions(hsp1, "New Version 3");
        this.navigation.issue().setComponents(hsp1, "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(hsp1, "customfield_10003", "New Version 3");
        this.bulkMoveAllIssuesToProject("neanderthal");
        this.assertNoOption("fixVersions");
        this.assertNoOption("versions");
        this.assertNoOption("components");
        this.assertNoOption("customfield_10003");
        this.completeBulkMoveWizard();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        String firstIssueKey = this.getIssueKeyWithSummary("first issue", "NDT");
        ViewIssueAssertions viewIssueAssertions = this.assertions.getViewIssueAssertions();
        this.navigation.issue().viewIssue(firstIssueKey);
        viewIssueAssertions.assertComponentsAbsent();
        viewIssueAssertions.assertAffectsVersionAbsent();
        viewIssueAssertions.assertFixVersionAbsent();
    }

    @Test
    @Restore(value="TestBulkMoveMappingVersionsAndComponents.xml")
    public void testBulkMoveIssuesWithNoDestinationValuesButRequired() throws Exception {
        String hsp1 = this.navigation.issue().createIssue("homosapien", "Bug", "first issue");
        this.navigation.issue().setAffectsVersions(hsp1, "New Version 3");
        this.navigation.issue().setFixVersions(hsp1, "New Version 3");
        this.navigation.issue().setComponents(hsp1, "New Component 3");
        this.navigation.issue().setIssueMultiSelectField(hsp1, "customfield_10003", "New Version 3");
        this.setFieldsToBeRequired();
        this.bulkMoveAllIssuesToProject("neanderthal");
        this.assertNoOption("fixVersions");
        this.assertNoOption("versions");
        this.assertNoOption("components");
        this.assertNoOption("customfield_10003");
        this.tester.submit("Next");
        String versionErrorMsg = "\"%s\" field is required and the project \"neanderthal\" does not have any versions.";
        String componentErrorMsg = "\"%s\" field is required and the project \"neanderthal\" does not have any components.";
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), String.format("\"%s\" field is required and the project \"neanderthal\" does not have any versions.", "Affects Version/s"));
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), String.format("\"%s\" field is required and the project \"neanderthal\" does not have any versions.", "Fix Version/s"));
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), String.format("\"%s\" field is required and the project \"neanderthal\" does not have any components.", "Component/s"));
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "Multi VP is required.");
        String firstIssueKey = this.getIssueKeyWithSummary("first issue", "HSP");
        this.assertIssueValuesAfterMove(firstIssueKey, "New Version 3", "New Version 3", "New Component 3", "New Version 3");
    }

    private void setFieldsToBeRequired() {
        this.administration.fieldConfigurations().defaultFieldConfiguration().requireField("Affects Version/s");
        this.administration.fieldConfigurations().defaultFieldConfiguration().requireField("Fix Version/s");
        this.administration.fieldConfigurations().defaultFieldConfiguration().requireField("Component/s");
        this.administration.fieldConfigurations().defaultFieldConfiguration().requireField("Multi VP");
    }

    private void assertIssueValuesAfterMove(String issueKey, String affectsVersions, String fixVersions, String components, String ... multiVersionCFValues) {
        this.navigation.issue().viewIssue(issueKey);
        this.assertions.getViewIssueAssertions().assertAffectsVersions(affectsVersions);
        this.assertions.getViewIssueAssertions().assertFixVersions(fixVersions);
        this.assertions.getViewIssueAssertions().assertComponents(components);
        if (multiVersionCFValues == null) {
            this.textAssertions.assertTextNotPresent(new WebPageLocator(this.tester), "Multi VP");
        } else {
            for (String multiVersionCFValue : multiVersionCFValues) {
                this.assertions.getViewIssueAssertions().assertCustomFieldValue("customfield_10003", multiVersionCFValue);
            }
        }
    }

    private void assertIssueValuesAfterMoveWithUserPicker(String issueKey, String affectsVersions, String fixVersions, String components, String userPickerValues, String ... multiVersionCFValues) {
        this.navigation.issue().viewIssue(issueKey);
        this.assertions.getViewIssueAssertions().assertAffectsVersions(affectsVersions);
        this.assertions.getViewIssueAssertions().assertFixVersions(fixVersions);
        this.assertions.getViewIssueAssertions().assertComponents(components);
        this.assertions.getViewIssueAssertions().assertCustomFieldValue("customfield_10010", userPickerValues);
        if (multiVersionCFValues == null) {
            this.textAssertions.assertTextNotPresent(new WebPageLocator(this.tester), "Multi VP");
        } else {
            for (String multiVersionCFValue : multiVersionCFValues) {
                this.assertions.getViewIssueAssertions().assertCustomFieldValue("customfield_10003", multiVersionCFValue);
            }
        }
    }

    private void bulkMoveAllIssuesToProject(String projectName) {
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeChooseIssuesAll();
        this.bulkOperations.chooseOperationBulkMove();
        this.isStepSelectProjectIssueType();
        this.tester.checkCheckbox("sameAsBulkEditBean", BULK_EDIT_KEY);
        this.navigation.issue().selectProject(projectName, TARGET_PROJECT_ID);
        this.tester.submit("Next");
        this.isStepSetFields();
    }

    private void completeBulkMoveWizard() {
        this.tester.submit("Next");
        this.bulkOperations.isStepConfirmation();
        this.tester.submit("Next");
    }

    private void isStepSelectProjectIssueType() {
        this.tester.assertTextPresent("Select Projects and Issue Types");
    }

    private void isStepSetFields() {
        this.tester.assertTextPresent("Update Fields for Target Project");
        this.logger.log((Object)"Step Set Fields");
    }

    private void assertDefaultOption(String fieldId, String originalId, String expected) {
        this.assertDefaultOption(fieldId, originalId, null, null, expected);
    }

    private void assertNoOption(String fieldId) {
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, fieldId + "_container"), "None");
    }

    private void assertDefaultOption(String fieldId, String originalId, String originalName, String originalProject, String expected) {
        this.assertDefaultOption(fieldId, originalId, originalName, originalProject, expected, false);
    }

    private void assertDefaultOption(String fieldId, String originalId, String originalName, String originalProject, String expected, boolean isUnknownDisallowed) {
        String uniqueId = fieldId + "_" + originalId;
        if (originalName != null && originalProject != null) {
            this.textAssertions.assertTextSequence(new IdLocator(this.tester, "rowFor_" + uniqueId), originalName, "[", "Project:", originalProject);
        } else if (originalName != null) {
            this.textAssertions.assertTextPresent(new IdLocator(this.tester, "rowFor_" + uniqueId), originalName);
        }
        Assert.assertEquals((Object)expected, (Object)this.tester.getDialog().getSelectedOption(uniqueId));
        String[] options = this.tester.getDialog().getOptionsFor(uniqueId);
        boolean unknownFound = false;
        for (String option : options) {
            if (!UNKNOWN.equals(option.trim())) continue;
            if (isUnknownDisallowed) {
                Assert.fail((String)("Found Unknown option when it shouldn't have been present for input '" + uniqueId + "'"));
                continue;
            }
            unknownFound = true;
        }
        if (!isUnknownDisallowed && !unknownFound) {
            Assert.fail((String)("Did not find Unknown option when it should have been present for input '" + uniqueId + "'"));
        }
    }

    private String getIssueKeyWithSummary(String summary, String projectKey) {
        return this.backdoor.issueNavControl().getIssueKeyForSummary(summary);
    }
}

