/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectWorkflowSchemeClient
extends RestApiClient<ProjectWorkflowSchemeClient> {
    private static final Logger log = LoggerFactory.getLogger(ProjectWorkflowSchemeClient.class);

    protected ProjectWorkflowSchemeClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Response getWorkflowSchemeForProject(String projectKeyOrId) {
        log.info("Requesting for project-workflowScheme from projectKeyOrId={}", (Object)projectKeyOrId);
        Response workflowSchemeResponse = (Response)this.workflowSchemeResource(projectKeyOrId).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(Response.class);
        log.info("Response statusInfo={}  ", (Object)workflowSchemeResponse.getStatusInfo());
        return workflowSchemeResponse;
    }

    protected WebTarget createResource() {
        return super.createResource();
    }

    private WebTarget workflowSchemeResource(String projectKey) {
        return this.createResource().path("project").path(projectKey).path("workflowscheme");
    }
}

