/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Attachment;
import com.atlassian.jira.testkit.client.restclient.AttachmentClient;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import java.util.Map;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@Restore(value="TestIssueResourceAttachments.xml")
@LoginAs(user="admin")
public class TestAttachmentResource
extends BaseJiraRestTest {
    private AttachmentClient attachmentClient;
    private IssueClient issueClient;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
        this.attachmentClient = new AttachmentClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testViewAttachment() throws Exception {
        Issue mky1 = this.issueClient.get("MKY-1", new Issue.Expand[0]);
        Assert.assertThat((Object)mky1.fields.attachment.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        Attachment attachment1 = this.attachmentClient.get("10000");
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/attachment/10000"), (Object)attachment1.self);
        Assert.assertEquals((Object)"attachment.txt", (Object)attachment1.filename);
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/user?username=admin"), (Object)attachment1.author.self);
        Assert.assertEquals((Object)"admin", (Object)attachment1.author.name);
        Assert.assertEquals((Object)"Administrator", (Object)attachment1.author.displayName);
        this.textAssertions.assertEqualDateStrings("2010-06-09T15:59:34.602+1000", attachment1.created);
        Assert.assertEquals((long)19L, (long)attachment1.size);
        Assert.assertEquals((Object)"text/plain", (Object)attachment1.mimeType);
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/secure/attachment/10000/attachment.txt"), (Object)attachment1.content);
        Assert.assertTrue((boolean)((Boolean)attachment1.properties.get("magickey1")));
        Assert.assertEquals((Object)11, attachment1.properties.get("magickey2"));
        Assert.assertEquals((Object)1212121, attachment1.properties.get("magickey3"));
        Assert.assertEquals((Object)3.14, attachment1.properties.get("magickey4"));
        Assert.assertEquals((Object)"Picture of an elephant", attachment1.properties.get("magickey5"));
        Assert.assertEquals((Object)"Picture of an big long elephant", attachment1.properties.get("magickey6"));
        Assert.assertEquals((Object)"2011-07-28T08:31:58.487+1000", attachment1.properties.get("magickey7"));
    }

    @Test
    public void testViewAttachmentNotFound() throws Exception {
        ParsedResponse response123 = this.attachmentClient.getResponse("123");
        Assert.assertEquals((long)404L, (long)response123.statusCode);
        Assert.assertEquals((long)1L, (long)response123.entity.errorMessages.size());
        Assert.assertTrue((boolean)response123.entity.errorMessages.contains("The attachment with id '123' does not exist"));
        ParsedResponse responseAbc = this.attachmentClient.getResponse("abc");
        Assert.assertEquals((long)404L, (long)responseAbc.statusCode);
        Assert.assertEquals((long)1L, (long)responseAbc.entity.errorMessages.size());
        Assert.assertTrue((boolean)responseAbc.entity.errorMessages.contains("The attachment with id 'abc' does not exist"));
    }

    @Test
    public void testViewAttachmentNotAuthorised() throws Exception {
        ParsedResponse response = ((AttachmentClient)this.attachmentClient.anonymous()).getResponse("10000");
        Assert.assertEquals((long)403L, (long)response.statusCode);
        Assert.assertEquals((long)1L, (long)response.entity.errorMessages.size());
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("You do not have permission to view attachment with id: 10000"));
    }

    @Test
    public void testRemoveAttachment() throws Exception {
        Issue mky1 = this.issueClient.get("MKY-1", new Issue.Expand[0]);
        Assert.assertThat((Object)mky1.fields.attachment.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        Attachment attachment1 = this.attachmentClient.get("10000");
        Assert.assertEquals((Object)"attachment.txt", (Object)attachment1.filename);
        ParsedResponse response = this.attachmentClient.deleteResponse("10000");
        Assert.assertEquals((long)204L, (long)response.statusCode);
        response = this.attachmentClient.getResponse("10000");
        Assert.assertEquals((long)404L, (long)response.statusCode);
        mky1 = this.issueClient.get("MKY-1", new Issue.Expand[0]);
        Assert.assertThat((Object)mky1.fields.attachment.size(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void testDeleteAttachmentNotFound() throws Exception {
        ParsedResponse response123 = this.attachmentClient.deleteResponse("123");
        Assert.assertEquals((long)404L, (long)response123.statusCode);
        Assert.assertEquals((long)1L, (long)response123.entity.errorMessages.size());
        Assert.assertTrue((boolean)response123.entity.errorMessages.contains("The attachment with id '123' does not exist"));
        ParsedResponse responseAbc = this.attachmentClient.deleteResponse("abc");
        Assert.assertEquals((long)404L, (long)responseAbc.statusCode);
        Assert.assertEquals((long)1L, (long)responseAbc.entity.errorMessages.size());
        Assert.assertTrue((boolean)responseAbc.entity.errorMessages.contains("The attachment with id 'abc' does not exist"));
    }

    @Test
    public void testGetMeta() throws Exception {
        Map responseMeta = this.attachmentClient.getMeta();
        Assert.assertEquals((Object)true, responseMeta.get("enabled"));
        Assert.assertEquals((Object)0xA00000, responseMeta.get("uploadLimit"));
    }
}

