/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.AvatarSystemClient;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestAvatarResource
extends BaseJiraFuncTest {
    private static final String PROJECT_TYPE = "project";
    private static final String SYSTEM_GROUP = "system";
    private AvatarSystemClient avatarSystemClient;

    @Before
    public void setUp() {
        this.avatarSystemClient = new AvatarSystemClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testAvatarResource() {
        Map response = this.avatarSystemClient.getSystemAvatars(PROJECT_TYPE);
        Assert.assertEquals((long)1L, (long)response.size());
        MatcherAssert.assertThat((Object)((List)response.get(SYSTEM_GROUP)).size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(27)));
    }

    @Test
    public void testAvatarResourceAsAnonymous() {
        Response response = ((AvatarSystemClient)this.avatarSystemClient.anonymous()).getSystemAvatarsResponse(PROJECT_TYPE);
        Assert.assertEquals((long)401L, (long)response.getStatus());
    }
}

