/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.backdoor.EventClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.CommentClient;
import com.atlassian.jira.testkit.client.restclient.CommentsWithPaginationBean;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.LIMITS})
public class TestCommentResourceSafeguards
extends EmailBaseFuncTestCase {
    private static final FeatureFlag COMMENTS_PER_ISSUE_FLAG = FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.SAFEGUARDS.featureKey());
    private static final String TEST_EDIT_COMMENT_XML_RESOURCE = "TestEditComment.xml";
    private static final String ISSUE_KEY_HSP_2 = "HSP-2";
    private static final String JIRA_SAFEGUARDS_BOT_GROUPS = "jira.safeguards.config.restricted.groups";
    private static final String BOT_GROUP_1 = "bot-group-1";
    private static final String BOT_GROUP_2 = "bot-group-2";
    private static final String BOT_GROUPS = "bot-group-1,bot-group-2";
    private static final String BOT_USER_1 = "bot-1";
    private static final String BOT_USER_2 = "bot-2";
    private static final String RON_USER = "ron";
    private static final String ADMIN_USER = "admin";
    private static final String LIMIT_BREACHING_ATTEMPT_MAIL = "We found that the total number of comments on issue HSP-2 attempted to exceed the configured limit.";
    private static final String LIMIT_BREACHED_MAIL = "We found that the total number of comments on issue HSP-2 exceeded the configured limit.";
    private static final String LIMIT_REACHED_MAIL = "We found that the total number of comments on issue HSP-2 reached the configured limit.";
    private static final String LIMIT_APPROACHED_MAIL = "We found that the total number of comments on issue HSP-2 reached the 90% warning threshold.";
    private static final String DOCUMENTATION_LINK = "\"https://docs.atlassian.com/jira/jadm-docs-0900/Configuring+Safeguards\"";
    private static final String COMMENTS_COUNT = "Number of comments on issue";
    private static final String EVENT = "com.atlassian.jira.event.safeguards.SafeguardsValidatorExecutionEvent";
    private CommentClient commentClient;
    private EventClient.EventPoller poller;

    @Before
    public void setUpTest() {
        this.commentClient = new CommentClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testAddCommentBelowLimitIsAllowedForUsersNotPartOfBotGroup() {
        this.backdoor.restoreDataCenterInstance(TEST_EDIT_COMMENT_XML_RESOURCE);
        this.backdoor.applicationProperties().setString("jira.safeguards.issue.comments", "1");
        this.commentClient.loginAs(ADMIN_USER);
        this.assertAddingCommentIsAllowed();
        this.assertNumberOfCommentForIssue(1);
    }

    @Test
    public void testAddCommentAboveLimitIsAllowedForUsersNotPartOfBotGroup() {
        this.backdoor.restoreDataCenterInstance(TEST_EDIT_COMMENT_XML_RESOURCE);
        this.backdoor.applicationProperties().setString("jira.safeguards.issue.comments", "0");
        this.commentClient.loginAs(ADMIN_USER);
        this.assertAddingCommentIsAllowed();
        this.assertNumberOfCommentForIssue(1);
    }

    @Test
    public void testAddCommentBelowLimitIsAllowedForUsersPartOfBotGroup() {
        this.backdoor.restoreDataCenterInstance(TEST_EDIT_COMMENT_XML_RESOURCE);
        this.createBotUsers();
        this.backdoor.applicationProperties().setString(JIRA_SAFEGUARDS_BOT_GROUPS, BOT_GROUP_1);
        this.backdoor.applicationProperties().setString("jira.safeguards.issue.comments", "1");
        this.commentClient.loginAs(BOT_USER_1);
        this.assertAddingCommentIsAllowed();
        this.assertNumberOfCommentForIssue(1);
    }

    @Test
    public void testAddCommentAboveLimitIsForbiddenForUsersPartOfBotGroup() {
        this.backdoor.restoreDataCenterInstance(TEST_EDIT_COMMENT_XML_RESOURCE);
        this.createBotUsers();
        this.backdoor.applicationProperties().setString(JIRA_SAFEGUARDS_BOT_GROUPS, BOT_GROUP_1);
        this.backdoor.applicationProperties().setString("jira.safeguards.issue.comments", "0");
        this.commentClient.loginAs(BOT_USER_1);
        this.assertAddingCommentIsForbidden();
        this.assertNumberOfCommentForIssue(0);
    }

    @Test
    public void testAddCommentAboveLimitIsForbiddenForAnyUserPartOfBotGroups() {
        this.backdoor.restoreDataCenterInstance(TEST_EDIT_COMMENT_XML_RESOURCE);
        this.createBotUsers();
        this.backdoor.applicationProperties().setString(JIRA_SAFEGUARDS_BOT_GROUPS, BOT_GROUPS);
        this.backdoor.applicationProperties().setString("jira.safeguards.issue.comments", "0");
        this.commentClient.loginAs(BOT_USER_1);
        this.assertAddingCommentIsForbidden();
        this.assertNumberOfCommentForIssue(0);
        this.commentClient.loginAs(BOT_USER_2);
        this.assertAddingCommentIsForbidden();
        this.assertNumberOfCommentForIssue(0);
        this.commentClient.loginAs(ADMIN_USER);
        this.assertAddingCommentIsAllowed();
        this.assertNumberOfCommentForIssue(1);
        this.commentClient.loginAs(BOT_USER_1);
        this.assertAddingCommentIsForbidden();
        this.assertNumberOfCommentForIssue(1);
        this.commentClient.loginAs(BOT_USER_2);
        this.assertAddingCommentIsForbidden();
        this.assertNumberOfCommentForIssue(1);
    }

    @Test
    public void testAddCommentAboveLimitIsAllowedIfFeatureDisabled() {
        this.backdoor.restoreDataCenterInstance(TEST_EDIT_COMMENT_XML_RESOURCE);
        this.createBotUsers();
        this.backdoor.applicationProperties().setString(JIRA_SAFEGUARDS_BOT_GROUPS, BOT_GROUP_1);
        this.disableSafeguardsFeature();
        this.backdoor.applicationProperties().setString("jira.safeguards.issue.comments", "0");
        this.commentClient.loginAs(BOT_USER_1);
        this.assertAddingCommentIsAllowed();
        this.assertNumberOfCommentForIssue(1);
        this.enableSafeguardsFeature();
    }

    @Test
    public void testEmailNotificationsForBotWhenLimitingEnabled() throws Exception {
        this.backdoor.restoreDataCenterInstance(TEST_EDIT_COMMENT_XML_RESOURCE);
        this.initPoller();
        this.configureAndStartSmtpServer();
        this.createBotUsers();
        this.backdoor.applicationProperties().setString(JIRA_SAFEGUARDS_BOT_GROUPS, BOT_GROUP_1);
        this.testCommonNotifyingScenario(BOT_USER_1);
        this.assertAddingCommentIsForbidden();
        this.flushMailAndAssert(3, LIMIT_BREACHING_ATTEMPT_MAIL, 20);
        this.assertAnalyticEventTriggered();
        this.assertAddingCommentIsForbidden();
        this.flushMailAndAssert(4, LIMIT_BREACHING_ATTEMPT_MAIL, 20);
        this.assertAnalyticEventTriggered();
        this.commentClient.loginAs(ADMIN_USER);
        this.assertAddingCommentIsAllowed();
        this.flushMailAndAssert(4, LIMIT_BREACHING_ATTEMPT_MAIL, 20);
        this.assertAnalyticEventTriggered();
        this.stopPollers();
    }

    @Test
    public void testEmailNotificationsForRealUserWhenLimitingEnabled() throws Exception {
        this.backdoor.restoreDataCenterInstance(TEST_EDIT_COMMENT_XML_RESOURCE);
        this.initPoller();
        this.configureAndStartSmtpServer();
        this.createRealUser();
        this.backdoor.applicationProperties().setString(JIRA_SAFEGUARDS_BOT_GROUPS, BOT_GROUP_1);
        this.testCommonNotifyingScenario(RON_USER);
        this.assertAddingCommentIsAllowed();
        this.flushMailAndAssert(2, LIMIT_REACHED_MAIL, 20);
        this.assertAnalyticEventTriggered();
        this.assertAddingCommentIsAllowed();
        this.flushMailAndAssert(3, LIMIT_BREACHED_MAIL, 22);
        this.assertAnalyticEventTriggered();
        this.createBotUsers();
        this.commentClient.loginAs(BOT_USER_1);
        this.assertAddingCommentIsForbidden();
        this.flushMailAndAssert(4, LIMIT_BREACHING_ATTEMPT_MAIL, 22);
        this.assertAnalyticEventTriggered();
        this.stopPollers();
    }

    private void testCommonNotifyingScenario(String executor) throws Exception {
        this.backdoor.applicationProperties().setString("jira.safeguards.issue.comments", "20");
        this.commentClient.loginAs(executor);
        this.createComments(17);
        this.flushMailQueueAndWait(0);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)0L, (long)mimeMessages.length);
        this.assertNoAnalyticEventTriggered();
        this.assertAddingCommentIsAllowed();
        this.flushMailAndAssert(1, LIMIT_APPROACHED_MAIL, 18);
        this.assertAnalyticEventTriggered();
        this.assertAddingCommentIsAllowed();
        this.flushMailQueueAndWait(0);
        mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)1L, (long)mimeMessages.length);
        this.assertNoAnalyticEventTriggered();
        this.assertAddingCommentIsAllowed();
        this.flushMailAndAssert(2, LIMIT_REACHED_MAIL, 20);
        this.assertAnalyticEventTriggered();
    }

    private void createComments(int commentsCount) {
        for (int i = 0; i < commentsCount; ++i) {
            this.assertAddingCommentIsAllowed();
        }
    }

    private void createBotUsers() {
        this.backdoor.usersAndGroups().addUser(BOT_USER_1, BOT_USER_1, BOT_USER_1, "jiratest@atlassian.com");
        this.backdoor.usersAndGroups().addUser(BOT_USER_2, BOT_USER_2, BOT_USER_2, "jiratest@atlassian.com");
        this.backdoor.usersAndGroups().addGroup(BOT_GROUP_1);
        this.backdoor.usersAndGroups().addGroup(BOT_GROUP_2);
        this.backdoor.usersAndGroups().addUserToGroup(BOT_USER_1, BOT_GROUP_1);
        this.backdoor.usersAndGroups().addUserToGroup(BOT_USER_2, BOT_GROUP_2);
    }

    private void createRealUser() {
        this.backdoor.usersAndGroups().addUser(RON_USER, RON_USER, RON_USER, "jiratest@atlassian.com");
    }

    private void enableSafeguardsFeature() {
        this.backdoor.darkFeatures().enableForSite(COMMENTS_PER_ISSUE_FLAG);
    }

    private void disableSafeguardsFeature() {
        this.backdoor.darkFeatures().disableForSite(COMMENTS_PER_ISSUE_FLAG);
        this.backdoor.applicationProperties().setString("jira.safeguards.issue.comments", "-1");
    }

    private Comment createNewComment() {
        Comment comment = new Comment();
        comment.body = "comment";
        return comment;
    }

    private void assertAddingCommentIsAllowed() {
        ParsedResponse post = this.commentClient.post(ISSUE_KEY_HSP_2, this.createNewComment());
        Assert.assertEquals((long)201L, (long)post.statusCode);
    }

    private void assertAddingCommentIsForbidden() {
        ParsedResponse post = this.commentClient.post(ISSUE_KEY_HSP_2, this.createNewComment());
        Assert.assertEquals((long)400L, (long)post.statusCode);
        Assert.assertEquals((long)1L, (long)post.entity.errors.size());
        Assert.assertEquals((Object)"This issue already reached maximum number of allowed comments and you can't add more.", post.entity.errors.get("comment"));
    }

    private void assertNumberOfCommentForIssue(int i) {
        ParsedResponse comments = this.commentClient.getComments(ISSUE_KEY_HSP_2);
        Assert.assertEquals((long)i, (long)((CommentsWithPaginationBean)comments.body).getTotal().intValue());
    }

    private void flushMailAndAssert(int expectedAllMailsCount, String expectedLastMailContent, int commentsCount) throws Exception {
        this.flushMailQueueAndWait(1);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)expectedAllMailsCount, (long)mimeMessages.length);
        int lastMailIndex = expectedAllMailsCount - 1;
        this.assertEmailBodyContains(mimeMessages[lastMailIndex], expectedLastMailContent);
        this.assertEmailBodyContains(mimeMessages[lastMailIndex], DOCUMENTATION_LINK);
        this.assertEmailBodyContains(mimeMessages[lastMailIndex], String.format("%s: %d", COMMENTS_COUNT, commentsCount));
    }

    private void assertNoAnalyticEventTriggered() {
        MatcherAssert.assertThat(this.poller.events(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)EVENT)));
    }

    private void assertAnalyticEventTriggered() {
        MatcherAssert.assertThat(this.poller.events(), (Matcher)Matchers.hasItem((Object)EVENT));
    }

    private void initPoller() {
        this.poller = this.backdoor.events().createPoller();
    }

    private void stopPollers() {
        this.backdoor.events().stopAllPollers();
    }
}

