/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.backdoor.PermissionControlExt;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.GroupAndUserPickerClient;
import com.atlassian.jira.testkit.client.restclient.GroupAndUserSuggestions;
import com.atlassian.jira.testkit.client.restclient.UserSuggestion;
import javax.ws.rs.WebApplicationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@Restore(value="TestGroupPickerResource.xml")
public class TestGroupAndUserPickerResource
extends BaseJiraRestTest {
    private static final String RESULTFUL_QUERY = "z";
    private GroupAndUserPickerClient groupAndUserPickerClient;
    private PermissionControlExt permissionsControl;

    @Before
    public void setUpTest() {
        this.groupAndUserPickerClient = new GroupAndUserPickerClient((JIRAEnvironmentData)this.environmentData);
        this.permissionsControl = new PermissionControlExt(this.environmentData);
    }

    @Test
    public void testMatches() {
        GroupAndUserSuggestions suggestions = this.groupAndUserPickerClient.get(RESULTFUL_QUERY);
        Assert.assertEquals((long)20L, (long)suggestions.groups.groups.size());
        Assert.assertEquals((Object)"Showing 20 of 21 matching groups", (Object)suggestions.groups.header);
        Assert.assertEquals((long)0L, (long)suggestions.users.users.size());
        Assert.assertEquals((Object)"Showing 0 of 0 matching users", (Object)suggestions.users.header);
        suggestions = this.groupAndUserPickerClient.get("a");
        Assert.assertEquals((long)3L, (long)suggestions.groups.groups.size());
        Assert.assertEquals((Object)"Showing 3 of 3 matching groups", (Object)suggestions.groups.header);
        Assert.assertEquals((long)1L, (long)suggestions.users.users.size());
        Assert.assertEquals((Object)"Showing 1 of 1 matching users", (Object)suggestions.users.header);
        Assert.assertEquals((Object)"admin", (Object)((UserSuggestion)suggestions.users.users.get((int)0)).name);
        Assert.assertEquals((Object)"admin", (Object)((UserSuggestion)suggestions.users.users.get((int)0)).key);
    }

    @Test
    public void testFindUsersAndGroupsWhenAnonymousWithoutGlobalUserPickerPermissionShouldReturnForbidden() {
        this.permissionsControl.removeAnyoneGlobalPermissionByKey(GlobalPermissionKey.USER_PICKER.getKey());
        try {
            ((GroupAndUserPickerClient)this.groupAndUserPickerClient.anonymous()).get(RESULTFUL_QUERY);
            Assert.fail((String)"Should throw WebApplicationException with 403 status code");
        }
        catch (WebApplicationException e) {
            Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
        }
    }

    @Test
    public void testFindUsersAndGroupsWhenAnonymousWithGlobalUserPickerPermissionShouldReturnSuggestions() {
        this.permissionsControl.addAnyoneGlobalPermissionByKey(GlobalPermissionKey.USER_PICKER.getKey());
        GroupAndUserSuggestions suggestions = ((GroupAndUserPickerClient)this.groupAndUserPickerClient.anonymous()).get(RESULTFUL_QUERY);
        Assert.assertEquals((long)20L, (long)suggestions.groups.groups.size());
    }

    @Test
    public void testFindUsersAndGroupsWhenLoggedInWithoutGlobalUserPickerPermissionShouldReturnSuggestions() {
        this.permissionsControl.removeAnyoneGlobalPermissionByKey(GlobalPermissionKey.USER_PICKER.getKey());
        this.assertSuggestionsReturnedForLoggedIn();
    }

    @Test
    public void testFindUsersAndGroupsWhenLoggedInWithGlobalUserPickerPermissionShouldReturnSuggestions() {
        this.permissionsControl.addAnyoneGlobalPermissionByKey(GlobalPermissionKey.USER_PICKER.getKey());
        this.assertSuggestionsReturnedForLoggedIn();
    }

    private void assertSuggestionsReturnedForLoggedIn() {
        GroupAndUserSuggestions suggestions = this.groupAndUserPickerClient.get(RESULTFUL_QUERY);
        Assert.assertEquals((long)20L, (long)suggestions.groups.groups.size());
    }
}

