/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestUrlHelper;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.navigation.issue.FileAttachmentsList;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.Attachment;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestIssueAttachmentsResource
extends BaseJiraFuncTest {
    private HttpClient client;
    private FuncTestUrlHelper funcTestUrlHelper;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.attachments().enable();
        this.client = new HttpClient();
        this.funcTestUrlHelper = new FuncTestUrlHelper(this.environmentData);
    }

    @Test
    public void testAttachSingleAttachment() throws Exception {
        String key = this.navigation.issue().createIssue("monkey", "Bug", "Issue with attachment");
        PostMethod method = this.addAttachments(key, true, true, new MyAttachment("testfile.txt", "text/plain", "Hello world!!"));
        Assert.assertEquals((long)200L, (long)method.getStatusCode());
        InputStream jsonStream = method.getResponseBodyAsStream();
        ObjectMapper mapper = new ObjectMapper();
        List attachmentList = (List)mapper.readValue(jsonStream, (TypeReference)new TypeReference<List<Attachment>>(){});
        Assert.assertEquals((long)1L, (long)attachmentList.size());
        Attachment attachment = (Attachment)attachmentList.get(0);
        Assert.assertEquals((Object)"10000", (Object)attachment.id);
        Assert.assertEquals((Object)"testfile.txt", (Object)attachment.filename);
        Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/attachment/10000"), (Object)attachment.self);
        Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/user?username=admin"), (Object)attachment.author.self);
        Assert.assertEquals((Object)"admin", (Object)attachment.author.name);
        Assert.assertEquals((Object)"Administrator", (Object)attachment.author.displayName);
        List<FileAttachmentsList.FileAttachmentItem> attachments = this.navigation.issue().attachments(key).list().get();
        Assert.assertEquals((long)1L, (long)attachments.size());
        FileAttachmentsList.FileAttachmentItem item = attachments.get(0);
        Assert.assertEquals((Object)"testfile.txt", (Object)item.getName());
        Assert.assertEquals((Object)"Hello world!!", (Object)this.navigation.issue().attachments(key).manage().downloadAttachmentAsString(item.getId(), item.getName()));
    }

    @Test
    public void testAttachMultipleAttachments() throws Exception {
        String key = this.navigation.issue().createIssue("monkey", "Bug", "Issue with attachment");
        PostMethod method = this.addAttachments(key, true, true, new MyAttachment("testfile1.txt", "text/plain", "Hello first world!!"), new MyAttachment("testfile2.txt", "text/plain", "Hello second world!!"));
        Assert.assertEquals((long)200L, (long)method.getStatusCode());
        InputStream jsonStream = method.getResponseBodyAsStream();
        ObjectMapper mapper = new ObjectMapper();
        List attachmentList = (List)mapper.readValue(jsonStream, (TypeReference)new TypeReference<List<Attachment>>(){});
        Assert.assertEquals((long)2L, (long)attachmentList.size());
        Attachment attachment = (Attachment)attachmentList.get(0);
        Assert.assertEquals((Object)"10000", (Object)attachment.id);
        Assert.assertEquals((Object)"testfile1.txt", (Object)attachment.filename);
        Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/attachment/10000"), (Object)attachment.self);
        Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/user?username=admin"), (Object)attachment.author.self);
        Assert.assertEquals((Object)"admin", (Object)attachment.author.name);
        Assert.assertEquals((Object)"Administrator", (Object)attachment.author.displayName);
        attachment = (Attachment)attachmentList.get(1);
        Assert.assertEquals((Object)"10001", (Object)attachment.id);
        Assert.assertEquals((Object)"testfile2.txt", (Object)attachment.filename);
        Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/attachment/10001"), (Object)attachment.self);
        Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/user?username=admin"), (Object)attachment.author.self);
        Assert.assertEquals((Object)"admin", (Object)attachment.author.name);
        Assert.assertEquals((Object)"Administrator", (Object)attachment.author.displayName);
        List<FileAttachmentsList.FileAttachmentItem> attachments = this.navigation.issue().attachments(key).list().get();
        Assert.assertEquals((long)2L, (long)attachments.size());
        FileAttachmentsList.FileAttachmentItem item1 = attachments.get(0);
        Assert.assertEquals((Object)"testfile1.txt", (Object)item1.getName());
        Assert.assertEquals((Object)"Hello first world!!", (Object)this.navigation.issue().attachments(key).manage().downloadAttachmentAsString(item1.getId(), item1.getName()));
        FileAttachmentsList.FileAttachmentItem item2 = attachments.get(1);
        Assert.assertEquals((Object)"testfile2.txt", (Object)item2.getName());
        Assert.assertEquals((Object)"Hello second world!!", (Object)this.navigation.issue().attachments(key).manage().downloadAttachmentAsString(item2.getId(), item2.getName()));
    }

    @Test
    public void testAttachTooBig() throws Exception {
        this.administration.attachments().enable("500");
        byte[] toobig = new byte[1000];
        for (int i = 0; i < 1000; ++i) {
            toobig[i] = 97;
        }
        String key = this.navigation.issue().createIssue("monkey", "Bug", "Issue with attachment");
        PostMethod method = this.addAttachments(key, true, true, new MyAttachment("toobig.txt", "text/plain", toobig));
        Assert.assertEquals((long)413L, (long)method.getStatusCode());
        List<FileAttachmentsList.FileAttachmentItem> attachments = this.navigation.issue().attachments(key).list().get();
        Assert.assertEquals((long)0L, (long)attachments.size());
    }

    @Test
    public void testAttachmentsDisabled() throws Exception {
        this.administration.attachments().disable();
        String key = this.navigation.issue().createIssue("monkey", "Bug", "Issue with attachment");
        PostMethod method = this.addAttachments(key, true, true, new MyAttachment("testfile.txt", "text/plain", "Hello world!!"));
        Assert.assertEquals((long)403L, (long)method.getStatusCode());
        List<FileAttachmentsList.FileAttachmentItem> attachments = this.navigation.issue().attachments(key).list().get();
        Assert.assertEquals((long)0L, (long)attachments.size());
    }

    @Test
    public void testXsrf() throws Exception {
        String key = this.navigation.issue().createIssue("monkey", "Bug", "Issue with attachment");
        PostMethod method = this.addAttachments(key, false, true, new MyAttachment("testfile.txt", "text/plain", "Hello world!!"));
        Assert.assertEquals((long)403L, (long)method.getStatusCode());
        List<FileAttachmentsList.FileAttachmentItem> attachments = this.navigation.issue().attachments(key).list().get();
        Assert.assertEquals((long)0L, (long)attachments.size());
    }

    @Test
    public void testNoIssue() throws Exception {
        PostMethod method = this.addAttachments("BLAH-123", true, false, new MyAttachment("testfile.txt", "text/plain", "Hello world!!"));
        Assert.assertEquals((long)404L, (long)method.getStatusCode());
    }

    @Test
    public void testNoPermission() throws Exception {
        String key = this.navigation.issue().createIssue("monkey", "Bug", "Issue with attachment");
        PostMethod method = this.addAttachments(key, true, false, new MyAttachment("testfile.txt", "text/ plain", "Hello world!!"));
        Assert.assertEquals((long)401L, (long)method.getStatusCode());
        List<FileAttachmentsList.FileAttachmentItem> attachments = this.navigation.issue().attachments(key).list().get();
        Assert.assertEquals((long)0L, (long)attachments.size());
    }

    private PostMethod addAttachments(String issueKey, boolean addXsrf, boolean authorized, MyAttachment ... attachments) throws Exception {
        String url = this.funcTestUrlHelper.getBaseUrlPlus("rest/api/2/issue", issueKey, "attachments");
        PostMethod method = new PostMethod(url);
        ArrayList<FilePart> fileParts = new ArrayList<FilePart>();
        for (MyAttachment attachment : attachments) {
            ByteArrayPartSource partSource = new ByteArrayPartSource(attachment.filename, attachment.contents);
            FilePart filePart = new FilePart("file", (PartSource)partSource, attachment.contentType, "UTF-8");
            fileParts.add(filePart);
        }
        MultipartRequestEntity entity = new MultipartRequestEntity((Part[])fileParts.toArray(new FilePart[fileParts.size()]), new HttpMethodParams());
        method.setRequestEntity((RequestEntity)entity);
        if (addXsrf) {
            method.addRequestHeader("X-Atlassian-Token", "no-check");
        }
        if (authorized) {
            String encoding = Base64.getEncoder().encodeToString("admin:admin".getBytes());
            method.addRequestHeader("Authorization", "Basic " + encoding);
        }
        if (StringUtils.isNotBlank((CharSequence)this.environmentData.getTenant())) {
            method.addRequestHeader("X-Atlassian-Tenant", this.environmentData.getTenant());
        }
        this.client.executeMethod((HttpMethod)method);
        return method;
    }

    private static class MyAttachment {
        public String filename;
        public String contentType;
        public byte[] contents;

        private MyAttachment(String filename, String contentType, byte[] contents) {
            this.filename = filename;
            this.contentType = contentType;
            this.contents = contents;
        }

        private MyAttachment(String filename, String contentType, String contents) {
            this.filename = filename;
            this.contentType = contentType;
            this.contents = contents.getBytes();
        }
    }
}

