/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.backdoor.JqlAutoCompleteControl;
import com.atlassian.jira.functest.framework.backdoor.PluginIndexConfigurationControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.ReferencePluginReloadHelper;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyClient;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.atlassian.jira.util.SearchResultMatcher;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operator.Operator;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsCollectionContaining;
import org.joda.time.format.ISODateTimeFormat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ENTITY_PROPERTIES, Category.REST, Category.REFERENCE_PLUGIN})
public class TestIssuePropertyAliasing
extends BaseJiraRestTest {
    private static final Label TEST_LABEL = new Label("propertyAliasing", "description of the label", "2014-10-30", 10L);
    private EntityPropertyClient client;
    private PluginIndexConfigurationControl configurationControl;
    private JqlAutoCompleteControl autoCompleteControl;

    @Before
    public void setUpTest() {
        this.client = new EntityPropertyClient((JIRAEnvironmentData)this.environmentData, "issue");
        this.configurationControl = new PluginIndexConfigurationControl(this.environmentData);
        this.autoCompleteControl = new JqlAutoCompleteControl(this.environmentData);
        this.backdoor.restoreBlankInstance();
    }

    @Test
    public void testJqlAliasSearchingForStrings() throws IOException {
        this.setLabelDocumentConfiguration();
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Issue with aliases issue property");
        this.setLabelProperty(issue, TEST_LABEL);
        this.assertSearchResultsForAlias("label", Operator.EQUALS, TEST_LABEL.getValue(), issue);
        this.assertSearchResultsForAlias("label", Operator.IN, "('" + TEST_LABEL.getValue() + "')", issue);
    }

    @Test
    public void testJqlAliasingForRelativeDateQueries() throws Exception {
        this.setLabelDocumentConfiguration();
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Issue with aliases issue property");
        this.setLabelProperty(issue, TEST_LABEL);
        this.assertSearchResultsForAlias("labelDate", Operator.GREATER_THAN_EQUALS, "'2014-10-29'", issue);
        this.assertSearchResultsForAlias("labelDate", Operator.LESS_THAN, "'2014-11-01'", issue);
        this.assertSearchResultsForAlias("labelDate", Operator.LESS_THAN, "'2014-11-01'", issue);
    }

    @Test
    public void testJqlAliasingForJqlFunctionDateQueries() throws Exception {
        this.setLabelDocumentConfiguration();
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Issue with aliases issue property");
        String date = ISODateTimeFormat.dateTimeNoMillis().print(System.currentTimeMillis());
        Label label = new Label("val", "description", date, 1L);
        this.setLabelProperty(issue, label);
        this.assertSearchResultsForAlias("labelDate", Operator.GREATER_THAN_EQUALS, "'-2d'", issue);
        this.assertSearchResultsForAlias("labelDate", Operator.GREATER_THAN, "startOfDay()", issue);
        this.assertSearchResultsForAlias("labelDate", Operator.LESS_THAN, "endOfDay()", issue);
        this.assertSearchResultsForAlias("labelDate", Operator.LESS_THAN_EQUALS, "'2d'", issue);
    }

    @Test
    public void testJqlAliasingForTextValues() throws Exception {
        this.setLabelDocumentConfiguration();
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Issue with aliases issue property");
        this.setLabelProperty(issue, TEST_LABEL);
        this.assertSearchResultsForAlias("labelDescription", Operator.LIKE, "description", issue);
        this.assertSearchResultsForAlias("labelDescription", Operator.LIKE, "label", issue);
    }

    @Test
    public void testJqlAliasSearchingForMultipleIssues() throws Exception {
        this.setLabelDocumentConfiguration();
        IssueCreateResponse firstIssue = this.backdoor.issues().createIssue("HSP", "First issue");
        IssueCreateResponse secondIssue = this.backdoor.issues().createIssue("HSP", "Second issue");
        IssueCreateResponse thirdIssue = this.backdoor.issues().createIssue("HSP", "Third issue");
        String date = ISODateTimeFormat.dateTimeNoMillis().print(System.currentTimeMillis());
        Label firstLabel = new Label("first value", "first description", date, 1L);
        Label secondLabel = new Label("second value", "second description", date, 1L);
        Label thirdLabel = new Label("third value", "third description", date, 1L);
        this.setLabelProperty(firstIssue, firstLabel);
        this.setLabelProperty(secondIssue, secondLabel);
        this.setLabelProperty(thirdIssue, thirdLabel);
        this.assertSearchResultsForAlias("label", Operator.EQUALS, "'" + firstLabel.value + "'", firstIssue);
        this.assertSearchResultsForAlias("labelDescription", Operator.LIKE, "description", firstIssue, secondIssue, thirdIssue);
        this.assertSearchResult(new SearchRequest().jql("label = 'second value' AND labelDescription ~ 'description'"), secondIssue);
        this.assertSearchResult(new SearchRequest().jql("labelDate > '-1d' AND labelDescription ~ 'description'"), firstIssue, secondIssue, thirdIssue);
        this.assertSearchResult(new SearchRequest().jql("labelId = 1"), firstIssue, secondIssue, thirdIssue);
    }

    @Test
    public void testConflictingJqlAliases() throws Exception {
        ReferencePluginReloadHelper.updatePluginIndexConfiguration(this.backdoor, "first plugin", "conflict_indexconf1.xml", this.configurationControl);
        ReferencePluginReloadHelper.updatePluginIndexConfiguration(this.backdoor, "second plugin", "conflict_indexconf2.xml", this.configurationControl);
        IssueCreateResponse firstIssue = this.backdoor.issues().createIssue("HSP", "Some issue");
        IssueCreateResponse secondIssue = this.backdoor.issues().createIssue("HSP", "Some issue");
        String date = ISODateTimeFormat.dateTimeNoMillis().print(System.currentTimeMillis());
        this.client.put(firstIssue.key, "label", new Label("label", "description", date, 1L).toJson());
        this.client.put(secondIssue.key, "conflicting_alias", new Label("conflict", "description", date, 1L).toJson());
        this.assertSearchResultsForAlias("conflict", Operator.EQUALS, "'label'", firstIssue);
        this.assertSearchResultsForAlias("conflict", Operator.EQUALS, "'conflict'", secondIssue);
        this.assertSearchResultsForAlias("issue.property[conflicting_alias].value", Operator.EQUALS, "'conflict'", secondIssue);
        this.assertSearchResultsForAlias("issue.property[label].value", Operator.EQUALS, "'label'", firstIssue);
    }

    @Test
    public void testAliasAutoCompletionWithoutConflict() throws Exception {
        String[] values;
        this.setLabelDocumentConfiguration();
        String date = ISODateTimeFormat.dateTimeNoMillis().print(System.currentTimeMillis());
        for (String value : values = new String[]{"value1", "value2", "value3", "value4", "value5", "value6"}) {
            IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "new issue with label value " + value);
            this.setLabelProperty(issue, new Label(value, "some description", date, 1L));
        }
        this.assertAutoCompletionResult("label", "val", values);
        this.assertAutoCompletionResult("label", "value", values);
        this.assertAutoCompletionResult("label", "value1", "value1");
        this.assertAutoCompletionResult("label", "value2", "value2");
    }

    @Test
    public void testAliasWithMoreThen15Matches() throws Exception {
        this.setLabelDocumentConfiguration();
        String date = ISODateTimeFormat.dateTimeNoMillis().print(System.currentTimeMillis());
        for (int i = 0; i < 20; ++i) {
            IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "new issue " + i);
            this.setLabelProperty(issue, new Label("value" + i, "some description", date, 1L));
        }
        JqlAutoCompleteControl.Results autoCompleteResults = this.autoCompleteControl.getAutoCompleteResults("label", "val");
        Assert.assertThat(autoCompleteResults.getResults(), (Matcher)Matchers.hasSize((Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(15))));
    }

    @Test
    public void testAutoCompletionWorksForConflictingProperties() throws Exception {
        ReferencePluginReloadHelper.updatePluginIndexConfiguration(this.backdoor, "first plugin", "conflict_indexconf1.xml", this.configurationControl);
        ReferencePluginReloadHelper.updatePluginIndexConfiguration(this.backdoor, "second plugin", "conflict_indexconf2.xml", this.configurationControl);
        IssueCreateResponse firstIssue = this.backdoor.issues().createIssue("HSP", "Some issue");
        IssueCreateResponse secondIssue = this.backdoor.issues().createIssue("HSP", "Some issue");
        String date = ISODateTimeFormat.dateTimeNoMillis().print(System.currentTimeMillis());
        this.client.put(firstIssue.key, "label", new Label("some label value", "description", date, 1L).toJson());
        this.client.put(secondIssue.key, "conflicting_alias", new Label("conflict", "description", date, 1L).toJson());
        this.assertAutoCompletionResult("issue.property[label].value", "som", "\"some label value\"");
        this.assertAutoCompletionResult("issue.property[conflicting_alias].value", "conf", "conflict");
        Assert.assertThat(this.autoCompleteControl.getAutoCompleteResults("label", "lab").getResults(), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void testAutoCompletionReturnsOnlyDistrinctResults() {
        this.setLabelDocumentConfiguration();
        String date = ISODateTimeFormat.dateTimeNoMillis().print(System.currentTimeMillis());
        for (int i = 0; i < 20; ++i) {
            IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "new issue " + i);
            this.setLabelProperty(issue, new Label("value", "some description", date, 1L));
        }
        Assert.assertThat(this.autoCompleteControl.getAutoCompleteResults("label", "val").getResults(), (Matcher)Matchers.hasSize((Matcher)Matchers.equalTo((Object)1)));
    }

    @Test
    public void orderByAliasedIdSortsDescendingByDefault() {
        this.setLabelDocumentConfiguration();
        Label[] labels = new Label[]{this.withId(1L), this.withId(2L), this.withId(3L), this.withId(4L), this.withId(5L), this.withId(6L)};
        List expected = Lists.reverse(this.createIssuesWithLabel(labels));
        this.assertSearchResultsWithOrderBy("labelId", expected);
        this.assertSearchResultsWithOrderBy("labelId DESC", expected);
        this.assertSearchResultsWithOrderBy("labelId ASC", Lists.reverse((List)expected));
    }

    @Test
    public void orderBySystemFieldIdSortsAscendingByDefault() {
        this.setLabelDocumentConfiguration();
        Label[] labels = new Label[]{this.withId(1L), this.withId(1L), this.withId(1L), this.withId(1L), this.withId(1L), this.withId(1L)};
        List<IssueCreateResponse> expected = this.createIssuesWithLabel(labels);
        this.assertSearchResultsWithOrderBy("id", expected);
        this.assertSearchResultsWithOrderBy("id ASC", expected);
        this.assertSearchResultsWithOrderBy("id DESC", Lists.reverse(expected));
    }

    @Test
    public void orderByStringAliasSortsDescendingByDefault() throws Exception {
        this.setLabelDocumentConfiguration();
        Label[] labels = new Label[]{this.withValue("a"), this.withValue("b"), this.withValue("c"), this.withValue("d"), this.withValue("e"), this.withValue("f")};
        List expected = Lists.reverse(this.createIssuesWithLabel(labels));
        this.assertSearchResultsWithOrderBy("label", expected);
        this.assertSearchResultsWithOrderBy("label DESC", expected);
        this.assertSearchResultsWithOrderBy("label ASC", Lists.reverse((List)expected));
    }

    @Test
    public void orderByStringFQNSortsDescendingByDefault() throws Exception {
        this.setLabelDocumentConfiguration();
        Label[] labels = new Label[]{this.withValue("a"), this.withValue("b"), this.withValue("c"), this.withValue("d"), this.withValue("e"), this.withValue("f")};
        List expected = Lists.reverse(this.createIssuesWithLabel(labels));
        this.assertSearchResultsWithOrderBy("issue.property[label].value", expected);
        this.assertSearchResultsWithOrderBy("issue.property[label].value DESC", expected);
        this.assertSearchResultsWithOrderBy("issue.property[label].value ASC", Lists.reverse((List)expected));
    }

    @Test
    public void orderByIssueWithoutLabelWhenOrderingByLabelIsLast() {
        this.setLabelDocumentConfiguration();
        Label[] labels = new Label[]{this.withId(1L), this.withId(2L), this.withId(3L), this.withId(4L), this.withId(5L), this.withId(6L)};
        List expected = Lists.reverse(this.createIssuesWithLabel(labels));
        IssueCreateResponse issueWithoutLabel = this.backdoor.issues().createIssue("HSP", "new issue with no label value.");
        expected.add(issueWithoutLabel);
        this.assertSearchResultsWithOrderBy("labelId", expected);
        this.assertSearchResultsWithOrderBy("labelId DESC", expected);
        this.assertSearchResultsWithOrderBy("labelId ASC", Lists.reverse((List)expected));
    }

    @Test
    public void orderByAliasDateDescendingByDefault() {
        this.testOrderByDateIsDescendingByDefault("labelDate");
    }

    @Test
    public void orderByFQNDateDescendingByDefault() {
        this.testOrderByDateIsDescendingByDefault("issue.property[label].date");
    }

    @Test
    public void orderByCreatedWorks() throws InterruptedException {
        IssueCreateResponse first = this.backdoor.issues().createIssue("HSP", "first");
        Thread.sleep(2000L);
        IssueCreateResponse second = this.backdoor.issues().createIssue("HSP", "second");
        Thread.sleep(2000L);
        IssueCreateResponse third = this.backdoor.issues().createIssue("HSP", "third");
        this.assertSearchResultsWithOrderBy("created", Arrays.asList(third, second, first));
        this.assertSearchResultsWithOrderBy("created DESC", Arrays.asList(third, second, first));
        this.assertSearchResultsWithOrderBy("created ASC", Arrays.asList(first, second, third));
    }

    @Test
    public void testConflictingAliasWithSystemFieldSortsBySystemField() throws Exception {
        ReferencePluginReloadHelper.updatePluginIndexConfiguration(this.backdoor, "first plugin", "conflict_with_system_field.xml", this.configurationControl);
        IssueCreateResponse firstIssue = this.backdoor.issues().createIssue("HSP", "Some issue");
        IssueCreateResponse secondIssue = this.backdoor.issues().createIssue("HSP", "Some issue2");
        this.addLabelToIssue(firstIssue, this.withValue("2"));
        this.addLabelToIssue(secondIssue, this.withValue("1"));
        this.assertSearchResultsWithOrderBy("summary", Arrays.asList(firstIssue, secondIssue));
        this.addLabelToIssue(firstIssue, this.withValue("1"));
        this.addLabelToIssue(secondIssue, this.withValue("2"));
        this.assertSearchResultsWithOrderBy("summary", Arrays.asList(firstIssue, secondIssue));
    }

    @Test
    public void testConflictingAliasWithSystemFieldSortsByAliasSecond() throws Exception {
        ReferencePluginReloadHelper.updatePluginIndexConfiguration(this.backdoor, "first plugin", "conflict_with_system_field.xml", this.configurationControl);
        IssueCreateResponse firstIssue = this.backdoor.issues().createIssue("HSP", "Some issue");
        IssueCreateResponse secondIssue = this.backdoor.issues().createIssue("HSP", "Some issue");
        this.addLabelToIssue(firstIssue, this.withValue("a"));
        this.addLabelToIssue(secondIssue, this.withValue("b"));
        this.assertSearchResultsWithOrderBy("summary", Arrays.asList(secondIssue, firstIssue));
        this.addLabelToIssue(firstIssue, this.withValue("b"));
        this.addLabelToIssue(secondIssue, this.withValue("a"));
        this.assertSearchResultsWithOrderBy("summary", Arrays.asList(firstIssue, secondIssue));
    }

    @Test
    public void testMissingPropertyValueIsHandledCorrectlyByOperators() throws IOException {
        this.setLabelDocumentConfiguration();
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Issue with aliases issue property");
        IssueCreateResponse issueWithoutProperty = this.backdoor.issues().createIssue("HSP", "Issue without property");
        this.setLabelProperty(issue, TEST_LABEL);
        this.assertSearchResultsForAlias("label", Operator.EQUALS, TEST_LABEL.getValue(), issue);
        this.assertSearchResultsForAlias("label", Operator.IN, "('" + TEST_LABEL.getValue() + "')", issue);
        this.assertSearchResultsForAlias("label", Operator.IS, EmptyOperand.EMPTY.getName(), issueWithoutProperty);
        this.assertSearchResultsForAlias("label", Operator.IS_NOT, EmptyOperand.EMPTY.getName(), issue);
        this.assertSearchResultsForAlias("issue.property[\"label\"].value", Operator.IS_NOT, EmptyOperand.EMPTY.getName(), issue);
    }

    @Test
    public void testNumericOperatorsDontReturnIssuesWithMissingValues() throws IOException {
        this.setLabelDocumentConfiguration();
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Issue with aliases issue property");
        IssueCreateResponse issueWithoutProperty = this.backdoor.issues().createIssue("HSP", "Issue without property");
        this.setLabelProperty(issue, TEST_LABEL);
        this.assertSearchResultsForAlias("labelId", Operator.LESS_THAN, String.valueOf(TEST_LABEL.getId() + 1L), issue);
        this.assertSearchResultsForAlias("labelId", Operator.GREATER_THAN, String.valueOf(TEST_LABEL.getId() - 1L), issue);
        this.assertSearchResultsForAlias("labelId", Operator.LESS_THAN_EQUALS, String.valueOf(TEST_LABEL.getId()), issue);
        this.assertSearchResultsForAlias("labelId", Operator.GREATER_THAN_EQUALS, String.valueOf(TEST_LABEL.getId()), issue);
    }

    @Test
    public void testEmptyOrNonEmptyQueryReturnsAll() throws IOException {
        this.setLabelDocumentConfiguration();
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Issue with aliases issue property");
        IssueCreateResponse issueWithoutProperty = this.backdoor.issues().createIssue("HSP", "Issue without property");
        this.setLabelProperty(issue, TEST_LABEL);
        SearchRequest searchRequest = new SearchRequest().jql(String.format("%s is empty OR %s is not empty", "label", "label"));
        this.assertSearchResult(searchRequest, issue, issueWithoutProperty);
    }

    @Test
    public void testJsonValueIsIgnored() throws IOException, JSONException {
        this.setLabelDocumentConfiguration();
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Issue with aliases issue property");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Map<String, Object>)ImmutableMap.of((Object)"jsonthing", (Object)"jsonthingvalue"));
        this.client.put(issue.key, "label", jsonObject);
        this.assertSearchResultsForAlias("label", Operator.IS, EmptyOperand.EMPTY.getName(), issue);
    }

    @Test
    public void testNullValueIsIgnored() throws IOException, JSONException {
        this.setLabelDocumentConfiguration();
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Issue with aliases issue property");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("value", (Object)null);
        this.client.put(issue.key, "label", jsonObject);
        this.assertSearchResultsForAlias("label", Operator.IS, EmptyOperand.EMPTY.getName(), issue);
    }

    private void addLabelToIssue(IssueCreateResponse issue, Label label) {
        this.client.put(issue.key, "label", label.toJson());
    }

    private void testOrderByDateIsDescendingByDefault(String property) {
        this.setLabelDocumentConfiguration();
        Label[] labels = new Label[]{this.withDate("2014-10-30"), this.withDate("2014-10-31"), this.withDate("2014-11-1")};
        List<IssueCreateResponse> responses = this.createIssuesWithLabel(labels);
        List expected = Lists.reverse(responses);
        this.assertSearchResultsWithOrderBy(property, expected);
        this.assertSearchResultsWithOrderBy(property + " DESC", expected);
        this.assertSearchResultsWithOrderBy(property + " ASC", Lists.reverse((List)expected));
    }

    private Label withId(Long id) {
        return Label.from(TEST_LABEL).id(id).build();
    }

    private Label withValue(String value) {
        return Label.from(TEST_LABEL).value(value).build();
    }

    private Label withDate(String date) {
        return Label.from(TEST_LABEL).date(date).build();
    }

    private List<IssueCreateResponse> createIssuesWithLabel(Label[] values) {
        ArrayList<IssueCreateResponse> responses = new ArrayList<IssueCreateResponse>();
        for (Label value : values) {
            IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "new issue with label value " + value.value);
            this.setLabelProperty(issue, value);
            responses.add(issue);
        }
        return responses;
    }

    private void assertAutoCompletionResult(String fieldName, String fieldValue, final String ... values) {
        JqlAutoCompleteControl.Results results = this.autoCompleteControl.getAutoCompleteResults(fieldName, fieldValue);
        Assert.assertThat(results.getResults(), (Matcher)new TypeSafeMatcher<List<JqlAutoCompleteControl.AutoCompleteResult>>(){

            protected boolean matchesSafely(List<JqlAutoCompleteControl.AutoCompleteResult> autoCompleteResults) {
                return IsCollectionContaining.hasItems((Object[])values).matches((Object)Lists.transform(autoCompleteResults, (Function)new Function<JqlAutoCompleteControl.AutoCompleteResult, String>(){

                    public String apply(JqlAutoCompleteControl.AutoCompleteResult result) {
                        return result.getValue();
                    }
                }));
            }

            public void describeTo(Description description) {
                description.appendText("Auto complete result does not contain").appendValue((Object)values);
            }
        });
    }

    private void assertSearchResultsForAlias(String alias, Operator operator, String value, IssueCreateResponse ... issues) {
        SearchRequest searchRequest = new SearchRequest().jql(String.format("%s %s %s", alias, operator.getDisplayString(), value));
        this.assertSearchResult(searchRequest, issues);
    }

    private void assertSearchResultsWithOrderBy(String orderByClause, List<IssueCreateResponse> issues) {
        SearchRequest searchRequest = new SearchRequest().jql(String.format("%s order by %s", "project = HSP", orderByClause));
        SearchResult search = this.backdoor.search().getSearch(searchRequest);
        List resultIssueIds = search.issues.stream().map(issue -> issue.id).collect(Collectors.toList());
        List expected = issues.stream().map(issue -> issue.id).collect(Collectors.toList());
        Assert.assertThat(resultIssueIds, (Matcher)Matchers.contains((Object[])expected.toArray()));
    }

    private void assertSearchResult(SearchRequest searchRequest, IssueCreateResponse ... issues) {
        SearchResult searchResult = this.backdoor.search().getSearch(searchRequest);
        Assert.assertThat((Object)searchResult, SearchResultMatcher.issues(Lists.transform((List)Lists.newArrayList((Object[])issues), (Function)new Function<IssueCreateResponse, String>(){

            public String apply(IssueCreateResponse issueCreateResponse) {
                return issueCreateResponse.key();
            }
        })));
    }

    private void setLabelDocumentConfiguration() {
        ReferencePluginReloadHelper.updatePluginIndexConfiguration(this.backdoor, "com.atlassian.jira.dev.reference-plugin", "pluginindexconfiguration1.xml", this.configurationControl);
    }

    private void setLabelProperty(IssueCreateResponse issue, Label label) {
        this.client.put(issue.key, "label", label.toJson());
    }

    private static class Label {
        private final String value;
        private final String description;
        private final String date;
        private final Long id;

        private Label(String value, String description, String date, Long id) {
            this.value = value;
            this.description = description;
            this.date = date;
            this.id = id;
        }

        public JSONObject toJson() {
            return new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"value", (Object)this.value, (Object)"description", (Object)this.description, (Object)"date", (Object)this.date, (Object)"id", (Object)this.id));
        }

        public String getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDate() {
            return this.date;
        }

        public Long getId() {
            return this.id;
        }

        public static Builder from(Label label) {
            return new Builder(label);
        }

        private static class Builder {
            private String value;
            private String description;
            private String date;
            private Long id;

            public Builder(Label label) {
                this.value = label.value;
                this.description = label.description;
                this.date = label.date;
                this.id = label.id;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder date(String date) {
                this.date = date;
                return this;
            }

            public Builder id(Long id) {
                this.id = id;
                return this;
            }

            public Label build() {
                return new Label(this.value, this.description, this.date, this.id);
            }
        }
    }
}

