/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Errors;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.User;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestAssignIssue.xml")
public class TestIssueResourceAssign
extends BaseJiraRestTest {
    private static final String ADMIN = "admin";
    private static final String FRY = "fry";
    private static final String FARNSWORTH = "farnsworth";
    private IssueClient issueClient;

    @Test
    public void testAssignPermission() throws Exception {
        ParsedResponse response = ((IssueClient)this.issueClient.loginAs("joe", "joe")).assign("TST-1", new User().name(FRY));
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)response.statusCode);
        Assert.assertThat((Object)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.assignee.name, (Matcher)CoreMatchers.equalTo((Object)FRY));
        response = ((IssueClient)this.issueClient.loginAs("bill", "bill")).assign("TST-1", new User().name(FRY));
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testAssign() throws Exception {
        ParsedResponse response = this.issueClient.assign("TST-1", new User().name(ADMIN));
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)response.statusCode);
        Assert.assertThat((Object)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.assignee.name, (Matcher)CoreMatchers.equalTo((Object)ADMIN));
        this.issueClient.assign("TST-1", new User().name(FRY));
        Assert.assertThat((Object)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.assignee.name, (Matcher)CoreMatchers.equalTo((Object)FRY));
        this.issueClient.assign("TST-1", new User().name(FARNSWORTH));
        Assert.assertThat((Object)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.assignee.name, (Matcher)CoreMatchers.equalTo((Object)FARNSWORTH));
        this.issueClient.assign("TST-1", new User().name(null));
        Assert.assertThat((Object)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.assignee, (Matcher)CoreMatchers.equalTo(null));
        this.issueClient.assign("TST-1", new User().name("-1"));
        Assert.assertThat((Object)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.assignee.name, (Matcher)CoreMatchers.equalTo((Object)ADMIN));
    }

    @Test
    public void testAssignErrors() throws Exception {
        ParsedResponse response = this.issueClient.assign("TST-19", new User().name(ADMIN));
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = this.issueClient.assign("TST-1", new User().name("joe"));
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((Object)new Errors().addError("assignee", "User 'joe' cannot be assigned issues."), (Object)response.entity);
    }

    @Before
    public void setUpTest() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
    }
}

