/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestUrlHelper;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Attachment;
import com.atlassian.jira.testkit.client.restclient.AttachmentRendered;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestIssueResourceAttachments.xml")
public class TestIssueResourceAttachments
extends BaseJiraFuncTest {
    private static final String ISSUE_KEY = "MKY-1";
    private IssueClient issueClient;
    @Inject
    private FuncTestUrlHelper funcTestUrlHelper;
    @Inject
    TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testAttachmentsExpanded() throws Exception {
        Issue issue = this.issueClient.get(ISSUE_KEY, new Issue.Expand[0]);
        Assert.assertEquals((Object)ISSUE_KEY, (Object)issue.key);
        Assert.assertEquals((long)3L, (long)issue.fields.attachment.size());
        for (Attachment attachment1 : issue.fields.attachment) {
            if (!attachment1.self.endsWith("/10000")) continue;
            Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/attachment/10000"), (Object)attachment1.self);
            Assert.assertEquals((Object)"attachment.txt", (Object)attachment1.filename);
            Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/user?username=admin"), (Object)attachment1.author.self);
            Assert.assertEquals((Object)"admin", (Object)attachment1.author.name);
            Assert.assertEquals((Object)"Administrator", (Object)attachment1.author.displayName);
            this.textAssertions.assertEqualDateStrings("2010-06-09T15:59:34.602+1000", attachment1.created);
            Assert.assertEquals((long)19L, (long)attachment1.size);
            Assert.assertEquals((Object)"text/plain", (Object)attachment1.mimeType);
            Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/secure/attachment/10000/attachment.txt"), (Object)attachment1.content);
            return;
        }
        Assert.fail((String)"attachment 10000 is missing");
    }

    @Test
    public void testAttachmentsRendered() {
        Issue issue = this.issueClient.get(ISSUE_KEY, new Issue.Expand[]{Issue.Expand.renderedFields});
        Assert.assertEquals((Object)ISSUE_KEY, (Object)issue.key);
        Assert.assertEquals((long)3L, (long)issue.fields.attachment.size());
        int attachCount = 0;
        for (AttachmentRendered attachment1 : issue.renderedFields.attachment) {
            if (attachment1.self.endsWith("/10000")) {
                Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/attachment/10000"), (Object)attachment1.self);
                Assert.assertEquals((Object)"attachment.txt", (Object)attachment1.filename);
                Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/user?username=admin"), (Object)attachment1.author.self);
                Assert.assertEquals((Object)"admin", (Object)attachment1.author.name);
                Assert.assertEquals((Object)"Administrator", (Object)attachment1.author.displayName);
                this.textAssertions.assertEqualDateStrings("09/Jun/10 3:59 PM", attachment1.created);
                Assert.assertEquals((Object)"0.0 kB", (Object)attachment1.size);
                Assert.assertEquals((Object)"text/plain", (Object)attachment1.mimeType);
                Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/secure/attachment/10000/attachment.txt"), (Object)attachment1.content);
                ++attachCount;
                continue;
            }
            if (attachment1.self.endsWith("/10010")) {
                Assert.assertEquals((Object)"123 kB", (Object)attachment1.size);
                this.textAssertions.assertEqualDateStrings("28/Jul/11 12:12 PM", attachment1.created);
                ++attachCount;
                continue;
            }
            if (!attachment1.self.endsWith("/10001")) continue;
            Assert.assertEquals((Object)"0.0 kB", (Object)attachment1.size);
            this.textAssertions.assertEqualDateStrings("09/Jun/10 3:59 PM", attachment1.created);
            ++attachCount;
        }
        Assert.assertEquals((String)"attachments collection didn't match", (long)3L, (long)attachCount);
    }
}

