/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.testkit.client.restclient.FieldMetaData;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssueCreateMeta;
import com.atlassian.jira.testkit.client.restclient.PageBean;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@Restore(value="TestIssueResourceCreateMeta.xml")
public class TestIssueResourceCreateMetaFields
extends BaseJiraFuncTest {
    private IssueClient issueClient;
    private static final String BUG_TYPE_ID = "1";
    private static final String NEW_FEATURE_TYPE_ID = "2";
    private static final String TASK_TYPE_ID = "3";
    private static final String IMPROVEMENT_TYPE_ID = "4";
    private static final String SUBTASK_TYPE_ID = "5";
    private static final FeatureFlag PRIORITIES_PER_PROJECT = FeatureFlag.featureFlag((String)"jira.priorities.per.project");
    private static final Set<String> defaultRequiredFields = ImmutableSet.builder().add((Object)"project").add((Object)"versions").add((Object)"components").add((Object)"description").add((Object)"duedate").add((Object)"environment").add((Object)"fixVersions").add((Object)"issuetype").add((Object)"labels").add((Object)"worklog").add((Object)"priority").add((Object)"reporter").add((Object)"security").add((Object)"summary").add((Object)"timetracking").build();
    private static final Set<String> subTaskRequiredFields = ImmutableSet.builder().addAll(defaultRequiredFields).add((Object)"parent").build();
    private static final Set<String> testBugRequiredFields = ImmutableSet.builder().add((Object)"project").add((Object)"versions").add((Object)"description").add((Object)"issuetype").add((Object)"priority").add((Object)"reporter").add((Object)"summary").add((Object)"customfield_10000").build();
    private static final Map<String, IssueCreateMeta.JsonType> sharedFieldTypes = ImmutableMap.builder().put((Object)"project", (Object)IssueCreateMeta.JsonType.system((String)"project", (String)"project")).put((Object)"versions", (Object)IssueCreateMeta.JsonType.systemArray((String)"version", (String)"versions")).put((Object)"assignee", (Object)IssueCreateMeta.JsonType.system((String)"user", (String)"assignee")).put((Object)"attachment", (Object)IssueCreateMeta.JsonType.systemArray((String)"attachment", (String)"attachment")).put((Object)"description", (Object)IssueCreateMeta.JsonType.system((String)"string", (String)"description")).put((Object)"environment", (Object)IssueCreateMeta.JsonType.system((String)"string", (String)"environment")).put((Object)"fixVersions", (Object)IssueCreateMeta.JsonType.systemArray((String)"version", (String)"fixVersions")).put((Object)"issuetype", (Object)IssueCreateMeta.JsonType.system((String)"issuetype", (String)"issuetype")).put((Object)"issuelinks", (Object)IssueCreateMeta.JsonType.systemArray((String)"issuelinks", (String)"issuelinks")).put((Object)"worklog", (Object)IssueCreateMeta.JsonType.systemArray((String)"worklog", (String)"worklog")).put((Object)"priority", (Object)IssueCreateMeta.JsonType.system((String)"priority", (String)"priority")).put((Object)"reporter", (Object)IssueCreateMeta.JsonType.system((String)"user", (String)"reporter")).put((Object)"resolution", (Object)IssueCreateMeta.JsonType.system((String)"resolution", (String)"resolution")).put((Object)"security", (Object)IssueCreateMeta.JsonType.system((String)"securitylevel", (String)"security")).put((Object)"summary", (Object)IssueCreateMeta.JsonType.system((String)"string", (String)"summary")).put((Object)"customfield_10000", (Object)IssueCreateMeta.JsonType.custom((String)"date", (String)"com.atlassian.jira.plugin.system.customfieldtypes:datepicker", (Long)10000L)).put((Object)"customfield_10001", (Object)IssueCreateMeta.JsonType.custom((String)"datetime", (String)"com.atlassian.jira.plugin.system.customfieldtypes:datetime", (Long)10001L)).build();
    private static final Map<String, IssueCreateMeta.JsonType> defaultFieldTypes = ImmutableMap.builder().putAll(sharedFieldTypes).put((Object)"duedate", (Object)IssueCreateMeta.JsonType.system((String)"date", (String)"duedate")).put((Object)"components", (Object)IssueCreateMeta.JsonType.systemArray((String)"component", (String)"components")).put((Object)"labels", (Object)IssueCreateMeta.JsonType.systemArray((String)"string", (String)"labels")).put((Object)"timetracking", (Object)IssueCreateMeta.JsonType.system((String)"timetracking", (String)"timetracking")).build();
    private static final Map<String, IssueCreateMeta.JsonType> subTaskFieldTypes = ImmutableMap.builder().putAll(defaultFieldTypes).put((Object)"parent", (Object)IssueCreateMeta.JsonType.system((String)"issuelink", (String)"parent")).build();
    private static final Map<String, String> fieldsNamesValues = ImmutableMap.builder().put((Object)"assignee", (Object)"Assignee").put((Object)"attachment", (Object)"Attachment").put((Object)"components", (Object)"Component/s").put((Object)"customfield_10000", (Object)"datePickerCF").put((Object)"customfield_10001", (Object)"dateTimeCF").put((Object)"description", (Object)"Description").put((Object)"duedate", (Object)"Due Date").put((Object)"environment", (Object)"Environment").put((Object)"fixVersions", (Object)"Fix Version/s").put((Object)"issuelinks", (Object)"Linked Issues").put((Object)"issuetype", (Object)"Issue Type").put((Object)"labels", (Object)"Labels").put((Object)"parent", (Object)"Parent").put((Object)"priority", (Object)"Priority").put((Object)"project", (Object)"Project").put((Object)"reporter", (Object)"Reporter").put((Object)"resolution", (Object)"Resolution").put((Object)"security", (Object)"Security Level").put((Object)"summary", (Object)"Summary").put((Object)"timetracking", (Object)"Time Tracking").put((Object)"versions", (Object)"Affects Version/s").put((Object)"worklog", (Object)"Log Work").build();

    @Test
    public void testRequiredFieldsWithProjectKeys() {
        this.testRequiredFields("PEXPRESS", "TST");
    }

    @Test
    public void testRequiredFieldsWithProjectIds() {
        this.testRequiredFields("10001", "10000");
    }

    private void testRequiredFields(String projectExpressIdOrKey, String projectTestIdOrKey) {
        this.getAndAssertRequiredFields(projectExpressIdOrKey, BUG_TYPE_ID, defaultRequiredFields, defaultFieldTypes);
        this.getAndAssertRequiredFields(projectExpressIdOrKey, NEW_FEATURE_TYPE_ID, defaultRequiredFields, defaultFieldTypes);
        this.getAndAssertRequiredFields(projectExpressIdOrKey, TASK_TYPE_ID, defaultRequiredFields, defaultFieldTypes);
        this.getAndAssertRequiredFields(projectExpressIdOrKey, IMPROVEMENT_TYPE_ID, defaultRequiredFields, defaultFieldTypes);
        this.getAndAssertRequiredFields(projectExpressIdOrKey, SUBTASK_TYPE_ID, subTaskRequiredFields, subTaskFieldTypes);
        this.getAndAssertRequiredFields(projectTestIdOrKey, BUG_TYPE_ID, testBugRequiredFields, sharedFieldTypes);
        this.getAndAssertRequiredFields(projectTestIdOrKey, IMPROVEMENT_TYPE_ID, defaultRequiredFields, defaultFieldTypes);
        this.getAndAssertRequiredFields(projectTestIdOrKey, NEW_FEATURE_TYPE_ID, defaultRequiredFields, defaultFieldTypes);
    }

    private void getAndAssertRequiredFields(String projectIdOrKey, String bugTypeId, Set<String> requiredFields, Map<String, IssueCreateMeta.JsonType> fieldTypes) {
        PageBean projectExpressBugFields = this.issueClient.getCreateIssueMetaFields(projectIdOrKey, bugTypeId, Long.valueOf(0L), Integer.valueOf(50));
        this.assertRequiredFields(projectExpressBugFields.getValues(), requiredFields);
        this.assertFieldNamesAndTypes(projectExpressBugFields.getValues(), fieldTypes);
    }

    @Test
    public void testAllowedValuesForFields() {
        String cfProjectName = this.backdoor.customFields().createCustomField("Project Custom Field", null, "com.atlassian.jira.plugin.system.customfieldtypes:project", null);
        this.backdoor.screens().addFieldToScreen("Default Screen", "Project Custom Field");
        String cfVersionName = this.backdoor.customFields().createCustomField("Version Custom Field", null, "com.atlassian.jira.plugin.system.customfieldtypes:version", null);
        this.backdoor.screens().addFieldToScreen("Default Screen", "Version Custom Field");
        List projectTestBugFields = this.issueClient.getCreateIssueMetaFields("TST", BUG_TYPE_ID, Long.valueOf(0L), Integer.valueOf(50)).getValues();
        this.assertRequiredFields(projectTestBugFields, testBugRequiredFields);
        HashSet expectedFieldKeys = Sets.newHashSet((Object[])new String[]{cfProjectName, cfVersionName, "issuetype", "security", "fixVersions", "resolution", "project", "versions", "priority"});
        Set actualFoundFieldKeys = projectTestBugFields.stream().filter(field -> expectedFieldKeys.contains(this.getFieldKey((FieldMetaData)field))).map(this::getFieldKey).collect(Collectors.toSet());
        Assert.assertEquals((Object)expectedFieldKeys, actualFoundFieldKeys);
        this.assertFieldsHaveNonIterableAllowedValuesItems(projectTestBugFields, expectedFieldKeys);
    }

    @Test
    public void testWithPrioritySchemes() {
        this.backdoor.darkFeatures().enableForSite(PRIORITIES_PER_PROJECT);
        long schemeId = this.backdoor.prioritySchemes().createPriorityScheme("test scheme", "", (List<String>)ImmutableList.of((Object)SUBTASK_TYPE_ID, (Object)TASK_TYPE_ID, (Object)BUG_TYPE_ID));
        this.backdoor.prioritySchemes().assignProject(schemeId, 10000L);
        this.getAndAssertFieldMetaDataAllowedValueIds(this.getFieldMetadata("10000", BUG_TYPE_ID, "priority"), Lists.newArrayList((Object[])new String[]{SUBTASK_TYPE_ID, TASK_TYPE_ID, BUG_TYPE_ID}));
        this.backdoor.darkFeatures().disableForSite(PRIORITIES_PER_PROJECT);
        this.getAndAssertFieldMetaDataAllowedValueIds(this.getFieldMetadata("10000", BUG_TYPE_ID, "priority"), Lists.newArrayList((Object[])new String[]{BUG_TYPE_ID, NEW_FEATURE_TYPE_ID, TASK_TYPE_ID, IMPROVEMENT_TYPE_ID, SUBTASK_TYPE_ID}));
    }

    @Test
    public void testWithDefaultPriorityScheme() {
        this.backdoor.darkFeatures().disableForSite(PRIORITIES_PER_PROJECT);
        this.getAndAssertFieldMetaDataAllowedValueIds(this.getFieldMetadata("10000", BUG_TYPE_ID, "priority"), Lists.newArrayList((Object[])new String[]{BUG_TYPE_ID, NEW_FEATURE_TYPE_ID, TASK_TYPE_ID, IMPROVEMENT_TYPE_ID, SUBTASK_TYPE_ID}));
        this.backdoor.darkFeatures().enableForSite(PRIORITIES_PER_PROJECT);
        this.getAndAssertFieldMetaDataAllowedValueIds(this.getFieldMetadata("10000", BUG_TYPE_ID, "priority"), Lists.newArrayList((Object[])new String[]{BUG_TYPE_ID, NEW_FEATURE_TYPE_ID, TASK_TYPE_ID, IMPROVEMENT_TYPE_ID, SUBTASK_TYPE_ID}));
    }

    private void getAndAssertFieldMetaDataAllowedValueIds(FieldMetaData fieldMetaData, List<String> expectedAllowedValueIds) {
        List actualAllowedValueIds = fieldMetaData.allowedValues.stream().map(o -> (String)((HashMap)o).get("id")).collect(Collectors.toList());
        Assert.assertEquals(expectedAllowedValueIds, actualAllowedValueIds);
    }

    private FieldMetaData getFieldMetadata(String projectId, String typeId, String systemFieldKey) {
        PageBean projectTestBugFields = this.issueClient.getCreateIssueMetaFields(projectId, typeId, Long.valueOf(0L), Integer.valueOf(50));
        return projectTestBugFields.getValues().stream().filter(field -> systemFieldKey.equals(field.schema.system)).findFirst().get();
    }

    @Test
    public void testOrderingWithPaging() {
        ArrayList orderedDefaultFieldKeys = Lists.newArrayList((Object[])new String[]{"summary", "issuetype", "security", "priority", "duedate", "components", "versions", "fixVersions", "reporter", "environment", "description", "timetracking", "attachment", "labels", "worklog", "resolution", "customfield_10000", "customfield_10001", "issuelinks", "assignee", "project"});
        ArrayList<String> orderedSubtaskFieldKeys = new ArrayList<String>(orderedDefaultFieldKeys);
        orderedSubtaskFieldKeys.add("parent");
        ArrayList orderedTestProjectBugFieldKeys = Lists.newArrayList((Object[])new String[]{"summary", "issuetype", "security", "priority", "versions", "fixVersions", "reporter", "environment", "description", "attachment", "worklog", "resolution", "customfield_10000", "customfield_10001", "issuelinks", "assignee", "project"});
        Assert.assertEquals((Object)orderedDefaultFieldKeys, this.getKeys(this.getIssueTypesWithPaging("PEXPRESS", BUG_TYPE_ID)));
        Assert.assertEquals((Object)orderedDefaultFieldKeys, this.getKeys(this.getIssueTypesWithPaging("PEXPRESS", NEW_FEATURE_TYPE_ID)));
        Assert.assertEquals((Object)orderedDefaultFieldKeys, this.getKeys(this.getIssueTypesWithPaging("PEXPRESS", TASK_TYPE_ID)));
        Assert.assertEquals((Object)orderedDefaultFieldKeys, this.getKeys(this.getIssueTypesWithPaging("PEXPRESS", IMPROVEMENT_TYPE_ID)));
        Assert.assertEquals(orderedSubtaskFieldKeys, this.getKeys(this.getIssueTypesWithPaging("PEXPRESS", SUBTASK_TYPE_ID)));
        Assert.assertEquals((Object)orderedDefaultFieldKeys, this.getKeys(this.getIssueTypesWithPaging("TST", IMPROVEMENT_TYPE_ID)));
        Assert.assertEquals((Object)orderedDefaultFieldKeys, this.getKeys(this.getIssueTypesWithPaging("TST", NEW_FEATURE_TYPE_ID)));
        Assert.assertEquals((Object)orderedTestProjectBugFieldKeys, this.getKeys(this.getIssueTypesWithPaging("TST", BUG_TYPE_ID)));
    }

    private List<String> getKeys(List<FieldMetaData> fields) {
        return fields.stream().map(this::getFieldKey).collect(Collectors.toList());
    }

    private void assertRequiredFields(List<FieldMetaData> fields, Set<String> requiredFieldNames) {
        for (FieldMetaData field : fields) {
            String key = this.getFieldKey(field);
            if (field.required.booleanValue()) {
                Assert.assertTrue((String)("Field \"" + key + "\" should be required"), (boolean)requiredFieldNames.contains(key));
                continue;
            }
            Assert.assertFalse((String)("Field \"" + key + "\" should not be required"), (boolean)requiredFieldNames.contains(key));
        }
        Set fieldKeys = fields.stream().map(this::getFieldKey).collect(Collectors.toSet());
        for (String expectedKey : requiredFieldNames) {
            Assert.assertTrue((String)("Could not find required key " + expectedKey), (boolean)fieldKeys.contains(expectedKey));
        }
    }

    private void assertFieldNamesAndTypes(List<FieldMetaData> fields, Map<String, IssueCreateMeta.JsonType> fieldNamesToTypes) {
        HashSet<String> fieldKeys = new HashSet<String>();
        for (FieldMetaData field : fields) {
            String key = this.getFieldKey(field);
            fieldKeys.add(key);
            Assert.assertTrue((String)("Contains field that should not be visible: " + key), (boolean)fieldNamesToTypes.containsKey(key));
            Assert.assertEquals((String)("Incorrect field type for field: " + key), (Object)fieldNamesToTypes.get(key), (Object)field.schema);
            Assert.assertEquals((String)("Incorrect name for field: " + key), (Object)fieldsNamesValues.get(key), (Object)field.name);
        }
        for (String expectedKey : fieldNamesToTypes.keySet()) {
            Assert.assertTrue((String)("Could not find required key " + expectedKey), (boolean)fieldKeys.contains(expectedKey));
        }
    }

    private String getFieldKey(FieldMetaData field) {
        return field.schema.system != null ? field.schema.system : "customfield_" + field.schema.customId;
    }

    private void assertFieldsHaveNonIterableAllowedValuesItems(List<FieldMetaData> fields, Set<String> fieldKeysToTest) {
        for (FieldMetaData field : fields) {
            if (!fieldKeysToTest.contains(this.getFieldKey(field))) continue;
            List allowedValues = field.allowedValues;
            Assert.assertNotNull((String)String.format("Field '%s' has null allowedValues!", field.name), (Object)allowedValues);
            Assert.assertFalse((String)String.format("Field '%s' has empty allowedValues!", field.name), (boolean)allowedValues.isEmpty());
            for (Object value : allowedValues) {
                Assert.assertFalse((String)String.format("Field '%s' has value that is an instance of Iterable! Value: %s", field.name, value), (boolean)(value instanceof Iterable));
            }
        }
    }

    private List<FieldMetaData> getIssueTypesWithPaging(String projectIdOrKey, String typeId) {
        LinkedList<FieldMetaData> firstProjectIssueTypes = new LinkedList<FieldMetaData>();
        long startAt = 0L;
        boolean maxResults = true;
        while (true) {
            PageBean firstProjectIssueTypesPaged = this.issueClient.getCreateIssueMetaFields(projectIdOrKey, typeId, Long.valueOf(startAt), Integer.valueOf(1));
            firstProjectIssueTypes.addAll(firstProjectIssueTypesPaged.getValues());
            if (firstProjectIssueTypesPaged.getIsLast().booleanValue()) break;
            ++startAt;
        }
        return firstProjectIssueTypes;
    }

    @Before
    public void setup() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
    }
}

