/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
public class TestIssueResourceNames
extends BaseJiraFuncTest {
    private IssueClient issueClient;
    @Inject
    private Administration administration;

    @Test
    public void testIssueRepresentationShouldContainExpandableNamesField() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue minimal = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        Assert.assertThat((String)"names should not be expanded by default", (Object)minimal.names, (Matcher)CoreMatchers.equalTo(null));
        Assert.assertThat((Object)minimal.expand, (Matcher)Matchers.containsString((String)Issue.Expand.names.name()));
        Issue expanded = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.names});
        HashSet fields = Sets.newHashSet((Iterable)Iterables.filter((Iterable)expanded.fields.idSet(), (Predicate)new NonNullFields(expanded)));
        Set names = expanded.names.keySet();
        Assert.assertTrue((String)("Found in 'fields' but not in 'names': " + Sets.difference((Set)fields, names)), (boolean)Sets.difference((Set)fields, names).isEmpty());
    }

    @Before
    public void setUpTest() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    private static class NonNullFields
    implements Predicate<String> {
        private final Issue expanded;

        public NonNullFields(Issue expanded) {
            this.expanded = expanded;
        }

        public boolean apply(@Nullable String fieldId) {
            return this.expanded.fields.get(fieldId) != null;
        }
    }
}

