/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.IssueKeyMatcher;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.SearchClient;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@Restore(value="TestIssueResourceCustomFields.xml")
@LoginAs(user="admin")
public class TestIssueResourceUpdateHistory
extends BaseJiraFuncTest {
    private static final String ISSUE_KEY = "HSP-1";
    private static final int PROJECT_ID = 10000;
    private IssueClient issueClient;
    private SearchClient searchClient;

    @Before
    public void setUpTest() {
        com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData = this.getEnvironmentData();
        this.issueClient = new IssueClient((JIRAEnvironmentData)environmentData);
        this.searchClient = new SearchClient((JIRAEnvironmentData)environmentData);
    }

    @Test
    public void testIssueShouldUpdateHistory() {
        this.getIssue(ISSUE_KEY, true);
        SearchResult results = this.getIssueHistory();
        MatcherAssert.assertThat((Object)results.issues, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)results.issues, (Matcher)IssueKeyMatcher.containsIssueWithKey(ISSUE_KEY));
    }

    @Test
    public void testIssueShouldNotUpdateHistory() {
        this.getIssue(ISSUE_KEY, false);
        SearchResult results = this.getIssueHistory();
        MatcherAssert.assertThat((Object)results.issues, (Matcher)IssueKeyMatcher.notContainsIssueWithKey(ISSUE_KEY));
    }

    @Test
    public void testIssueShouldNotUpdateHistoryIfPropertyNotThere() {
        this.issueClient.get(ISSUE_KEY, new Issue.Expand[0]);
        SearchResult results = this.getIssueHistory();
        MatcherAssert.assertThat((Object)results.issues, (Matcher)IssueKeyMatcher.notContainsIssueWithKey(ISSUE_KEY));
    }

    @Test
    public void testIssueWithHistoryAndAnonymousUserShouldWork() {
        this.makeProjectVisibleByAnonymousUsers();
        Issue issue = (Issue)((IssueClient)this.issueClient.anonymous()).issueResource(ISSUE_KEY, new Issue.Expand[]{Issue.Expand.renderedFields}).queryParam("updateHistory", new Object[]{"true"}).request().get(Issue.class);
        MatcherAssert.assertThat((Object)issue, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    private void makeProjectVisibleByAnonymousUsers() {
        Long schemeId = this.backdoor.permissionSchemes().createScheme("new scheme", "new scheme description");
        this.backdoor.permissionSchemes().addEveryonePermission(schemeId, ProjectPermissions.BROWSE_PROJECTS);
        this.backdoor.project().setPermissionScheme(10000L, schemeId);
    }

    private Issue getIssue(String issueKey, boolean updateHistory) {
        Issue issue = (Issue)this.issueClient.issueResource(issueKey, new Issue.Expand[]{Issue.Expand.renderedFields}).queryParam("updateHistory", new Object[]{String.valueOf(updateHistory)}).request().get(Issue.class);
        MatcherAssert.assertThat((Object)issue, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        return issue;
    }

    private SearchResult getIssueHistory() {
        return ((SearchClient)this.searchClient.loginAs("admin")).getSearch(new SearchRequest().jql(" issuekey in issueHistory() ORDER BY lastViewed DESC"));
    }
}

