/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.FieldOperation;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.CurrentUserPreferencesClient;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.UserJson;
import com.atlassian.jira.testkit.client.restclient.Visibility;
import com.atlassian.jira.testkit.client.restclient.Worklog;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.inject.Inject;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestWorklogAndTimeTracking.xml")
public class TestIssueResourceWorklog
extends BaseJiraRestTest {
    public static final String TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private IssueClient issueClient;
    private CurrentUserPreferencesClient userClient;
    @Inject
    TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
        this.userClient = new CurrentUserPreferencesClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testView() throws Exception {
        Issue json = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        List worklogs = json.fields.worklog.worklogs;
        Assert.assertEquals((long)1L, (long)worklogs.size());
        Worklog log = (Worklog)worklogs.get(0);
        Assert.assertNotNull((Object)log.self);
        Assert.assertEquals((Object)"I'm finished finally!", (Object)log.comment);
        Assert.assertEquals((Object)"2h", (Object)log.timeSpent);
        this.textAssertions.assertEqualDateStrings("2010-05-24T09:52:41.092+1000", log.created);
        this.textAssertions.assertEqualDateStrings("2010-05-24T09:52:41.092+1000", log.updated);
        this.textAssertions.assertEqualDateStrings("2010-05-24T09:52:00.000+1000", log.started);
        UserJson author = log.author;
        Assert.assertNotNull((Object)author.self);
        Assert.assertEquals((Object)"admin", (Object)author.name);
        Assert.assertEquals((Object)"Administrator", (Object)author.displayName);
        UserJson updateAuthor = log.updateAuthor;
        Assert.assertNotNull((Object)updateAuthor.self);
        Assert.assertEquals((Object)"admin", (Object)updateAuthor.name);
        Assert.assertEquals((Object)"Administrator", (Object)updateAuthor.displayName);
    }

    @Test
    public void testViewTimeZone() {
        IssueUpdateRequest request = this.getSystemFieldsByNameAndId(new Date());
        IssueCreateResponse created = this.issueClient.create(request);
        String timezone1 = "Etc/GMT-12";
        this.userClient.setPreference("jira.user.timezone", "Etc/GMT-12");
        UserJson author1 = this.getAuthorOfFirstIssueWorklog(created.key);
        TimeZone author1TimeZone = TimeZone.getTimeZone(author1.timeZone);
        Assert.assertThat((Object)author1.timeZone, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)author1TimeZone, (Matcher)Matchers.is((Object)TimeZone.getTimeZone("Etc/GMT-12")));
        String timezone2 = "Antarctica/McMurdo";
        this.userClient.setPreference("jira.user.timezone", "Antarctica/McMurdo");
        UserJson author2 = this.getAuthorOfFirstIssueWorklog(created.key);
        TimeZone author2TimeZone = TimeZone.getTimeZone(author2.timeZone);
        Assert.assertThat((Object)author2.timeZone, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)author2TimeZone, (Matcher)Matchers.is((Object)TimeZone.getTimeZone("Antarctica/McMurdo")));
    }

    @Test
    public void testRenderedView() {
        Issue expandedHsp = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.renderedFields});
        List worklogs = expandedHsp.renderedFields.worklog.worklogs;
        Assert.assertEquals((long)1L, (long)worklogs.size());
        Worklog log = (Worklog)worklogs.get(0);
        Assert.assertNotNull((Object)log.self);
        Assert.assertEquals((Object)"I&#39;m finished finally!", (Object)log.comment);
        Assert.assertEquals((Object)"2 hours", (Object)log.timeSpent);
        this.textAssertions.assertEqualDateStrings("24/May/10 9:52 AM", log.created);
        this.textAssertions.assertEqualDateStrings("24/May/10 9:52 AM", log.updated);
        this.textAssertions.assertEqualDateStrings("24/May/10 9:52 AM", log.started);
    }

    @Test
    public void testViewLoggedByDeletedUser() throws Exception {
        Issue json = this.issueClient.get("HSP-3", new Issue.Expand[0]);
        List worklogs = json.fields.worklog.worklogs;
        Assert.assertEquals((long)1L, (long)worklogs.size());
        Worklog log = (Worklog)worklogs.get(0);
        Assert.assertNotNull((Object)log.self);
        Assert.assertEquals((Object)"spent a whole minute on this", (Object)log.comment);
        Assert.assertEquals((Object)"1m", (Object)log.timeSpent);
        this.textAssertions.assertEqualDateStrings("2010-07-12T12:47:39.198+1000", log.created);
        this.textAssertions.assertEqualDateStrings("2010-07-12T12:47:39.198+1000", log.updated);
        this.textAssertions.assertEqualDateStrings("2010-07-12T12:47:00.000+1000", log.started);
        UserJson author = log.author;
        Assert.assertEquals((Object)"deleted", (Object)author.name);
        UserJson updateAuthor = log.updateAuthor;
        Assert.assertEquals((Object)"deleted", (Object)updateAuthor.name);
    }

    @Test
    public void testAddLogDuringCreate() {
        Date date = new Date();
        IssueUpdateRequest request = this.getSystemFieldsByNameAndId(date);
        this.issueClient.loginAs("admin");
        IssueCreateResponse created = this.issueClient.create(request);
        Issue newIssue = this.issueClient.get(created.key(), new Issue.Expand[0]);
        Assert.assertEquals((long)1L, (long)newIssue.fields.worklog.worklogs.size());
        Worklog worklog = (Worklog)newIssue.fields.worklog.worklogs.get(0);
        Assert.assertEquals((Object)"hello", (Object)worklog.comment);
        Assert.assertEquals((Object)"50m", (Object)worklog.timeSpent);
        Assert.assertEquals((Object)"group", (Object)worklog.visibility.type);
        Assert.assertEquals((Object)"jira-administrators", (Object)worklog.visibility.value);
        Assert.assertEquals((Object)"4h", (Object)newIssue.fields.timetracking.remainingEstimate);
    }

    @Test
    public void testAddDuringEdit() {
        Date date = new Date();
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        HashMap<String, List<FieldOperation>> operations = new HashMap<String, List<FieldOperation>>();
        operations.put("worklog", this.addWorkLog(TestIssueResourceWorklog.asTimeString(date), "50m"));
        issueUpdateRequest.update(operations);
        this.issueClient.edit("HSP-1", issueUpdateRequest);
        Issue newIssue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        Assert.assertEquals((long)2L, (long)newIssue.fields.worklog.worklogs.size());
        Worklog worklog = (Worklog)newIssue.fields.worklog.worklogs.get(1);
        Assert.assertEquals((Object)"hello", (Object)worklog.comment);
        Assert.assertEquals((Object)"50m", (Object)worklog.timeSpent);
        Assert.assertEquals((Object)"group", (Object)worklog.visibility.type);
        Assert.assertEquals((Object)"jira-administrators", (Object)worklog.visibility.value);
        Assert.assertEquals((Object)"4h", (Object)newIssue.fields.timetracking.remainingEstimate);
    }

    private UserJson getAuthorOfFirstIssueWorklog(String key) {
        Issue newIssue = this.issueClient.get(key, new Issue.Expand[0]);
        List worklogs = newIssue.fields.worklog.worklogs;
        Worklog log = (Worklog)worklogs.get(0);
        return log.author;
    }

    private IssueUpdateRequest getSystemFieldsByNameAndId(Date date) {
        IssueFields fields = new IssueFields();
        LinkedHashMap<String, List<FieldOperation>> updates = new LinkedHashMap<String, List<FieldOperation>>();
        fields.project(ResourceRef.withId((String)"10000"));
        fields.issueType(ResourceRef.withId((String)"1"));
        fields.reporter(ResourceRef.withName((String)"admin"));
        fields.summary("my first fields");
        updates.put("worklog", this.addWorkLog(TestIssueResourceWorklog.asTimeString(date), "50m"));
        return new IssueUpdateRequest().fields(fields).update(updates);
    }

    private List<FieldOperation> addWorkLog(String started, String timeSpent) {
        Visibility visibility = new Visibility();
        visibility.type = "group";
        visibility.value = "jira-administrators";
        Map<String, String> worklog = MapBuilder.newBuilder().add("started", started).add("timeSpent", timeSpent).add("adjustEstimate", "new").add("newEstimate", "4h").add("comment", "hello").add("visibility", (String)visibility).toMap();
        return Arrays.asList(new FieldOperation().operation("add").value(worklog));
    }

    private static String asTimeString(@Nullable Date date) {
        return date != null ? new SimpleDateFormat(TIME_FORMAT).format(date) : null;
    }
}

