/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.FuncTestUrlHelper;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.IssueSecurityType;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.IssueSecurityTypeClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.google.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestIssueSecurityTypeResource.xml")
public class TestIssueSecurityTypeResource
extends BaseJiraRestTest {
    private static final String SECURITY_TYPE_ID = "10000";
    private IssueSecurityTypeClient securityTypeClient;
    @Inject
    FuncTestUrlHelper funcTestUrlHelper;

    @Before
    public void setUpTest() {
        this.securityTypeClient = new IssueSecurityTypeClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testSecurityTypeVisible() throws Exception {
        IssueSecurityType securityType = this.securityTypeClient.get(SECURITY_TYPE_ID);
        Assert.assertEquals((Object)(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/securitylevel/" + SECURITY_TYPE_ID), (Object)securityType.self);
        Assert.assertEquals((Object)"Only the good guys can see this", (Object)securityType.description);
        Assert.assertEquals((Object)"Secure", (Object)securityType.name);
        Assert.assertEquals((Object)SECURITY_TYPE_ID, (Object)securityType.id);
    }

    @Test
    public void testSecurityTypeNotFound() throws Exception {
        ParsedResponse response = ((IssueSecurityTypeClient)this.securityTypeClient.loginAs("fred")).getResponse("zzz");
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertTrue((boolean)response.entity.errorMessages.contains("The security level with id 'zzz' does not exist."));
    }
}

