/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueRefJsonBean;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueSubTaskClient;
import java.util.List;
import javax.ws.rs.core.Response;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestIssueSubTaskResource
extends BaseJiraFuncTest {
    private IssueSubTaskClient issueClient;
    private Long projectId;
    private IssueCreateResponse parentIssue;

    @Before
    public void createIssueClient() {
        this.issueClient = new IssueSubTaskClient(this.environmentData);
        this.backdoor.subtask().enable();
        this.projectId = this.backdoor.project().getProjectId("HSP");
        this.parentIssue = this.backdoor.issues().createIssue("HSP", "summary");
    }

    @Test
    public void getWorks() throws Exception {
        IssueCreateResponse expected = this.createSubtask("subtask summary");
        List<IssueRefJsonBean> result = this.getSubtasks();
        Assert.assertThat(result, (Matcher)Matchers.contains(this.subtask(expected.id())));
    }

    @Test
    public void testGetNonExistingIssue() throws Exception {
        ParsedResponse response = this.issueClient.getResponse("NTEXST-1");
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void reorder() throws Exception {
        IssueCreateResponse sub1 = this.createSubtask("sub1");
        IssueCreateResponse sub2 = this.createSubtask("sub2");
        IssueCreateResponse sub3 = this.createSubtask("sub3");
        Assert.assertThat(this.getSubtasks(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{this.subtask(sub1), this.subtask(sub2), this.subtask(sub3)}));
        this.issueClient.reorder(this.parentIssue.key, 0L, 1L);
        Assert.assertThat(this.getSubtasks(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{this.subtask(sub2), this.subtask(sub1), this.subtask(sub3)}));
    }

    @Test
    public void testOutOfBounds() throws Exception {
        this.createSubtask("sub1");
        this.createSubtask("sub2");
        this.createSubtask("sub3");
        Assert.assertThat((Object)this.issueClient.reorder((String)this.parentIssue.key, (Long)Long.valueOf((long)-1L), (Long)Long.valueOf((long)1L)).statusCode, (Matcher)Matchers.is((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        Assert.assertThat((Object)this.issueClient.reorder((String)this.parentIssue.key, (Long)Long.valueOf((long)0L), (Long)Long.valueOf((long)-1L)).statusCode, (Matcher)Matchers.is((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        Assert.assertThat((Object)this.issueClient.reorder((String)this.parentIssue.key, (Long)Long.valueOf((long)0L), (Long)Long.valueOf((long)3L)).statusCode, (Matcher)Matchers.is((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        Assert.assertThat((Object)this.issueClient.reorder((String)this.parentIssue.key, (Long)Long.valueOf((long)3L), (Long)Long.valueOf((long)0L)).statusCode, (Matcher)Matchers.is((Object)Response.Status.BAD_REQUEST.getStatusCode()));
    }

    @Test
    public void testNotExistingIssueWhenReordering() throws Exception {
        this.createSubtask("sub1");
        this.createSubtask("sub2");
        ParsedResponse response = this.issueClient.reorder("i-dont-exist", 0L, 1L);
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)Response.Status.NOT_FOUND.getStatusCode()));
    }

    private List<IssueRefJsonBean> getSubtasks() {
        return this.issueClient.get(this.parentIssue.key());
    }

    private IssueCreateResponse createSubtask(String summary) {
        return this.backdoor.issues().createSubtask(this.projectId.toString(), this.parentIssue.key(), summary);
    }

    private Matcher<IssueRefJsonBean> subtask(final String id) {
        return new TypeSafeMatcher<IssueRefJsonBean>(){

            protected boolean matchesSafely(IssueRefJsonBean item) {
                return item.id().equals(id);
            }

            public void describeTo(Description description) {
                description.appendText("subtask with id ").appendValue((Object)id);
            }
        };
    }

    private Matcher<IssueRefJsonBean> subtask(IssueCreateResponse issue) {
        return this.subtask(issue.id);
    }
}

