/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.PrioritySchemeBean;
import com.atlassian.jira.testkit.client.restclient.PrioritySchemeClient;
import com.atlassian.jira.testkit.client.restclient.PrioritySchemeGetAllResponseBean;
import com.atlassian.jira.testkit.client.restclient.PrioritySchemeUpdateBean;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreBlankInstance
public class TestPrioritySchemeResource
extends BaseJiraFuncTest {
    public static final String NO_PROJECT_PERMISSIONS_ERROR = "You cannot edit the configuration of this project.";
    private PrioritySchemeClient prioritySchemeClient;
    private static final FeatureFlag PRIORITIES_PER_PROJECT = FeatureFlag.featureFlag((String)"jira.priorities.per.project");

    @Before
    public void setUpTest() {
        this.prioritySchemeClient = new PrioritySchemeClient((JIRAEnvironmentData)this.environmentData);
        this.backdoor.darkFeatures().enableForSite(PRIORITIES_PER_PROJECT);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=77000)
    public void testGetAllSchemes() throws Exception {
        ParsedResponse response = this.prioritySchemeClient.getAll(null, null, new PrioritySchemeGetAllResponseBean.Expand[]{PrioritySchemeGetAllResponseBean.Expand.projectKeys});
        Assert.assertEquals((long)200L, (long)response.statusCode);
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)response.body).getExpand(), (Matcher)Matchers.equalTo((Object)"schemes"));
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)response.body).getSchemes(), (Matcher)Matchers.contains(this.getDefaultPrioritySchemeMatcher("projectKeys", (ImmutableList<String>)ImmutableList.of((Object)"HSP", (Object)"MKY"))));
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)response.body).getStartAt(), (Matcher)Matchers.equalTo((Object)0L));
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)response.body).getMaxResults(), (Matcher)Matchers.equalTo((Object)100));
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)response.body).getTotal(), (Matcher)Matchers.equalTo((Object)1));
        response = this.prioritySchemeClient.getAll(null, null, new PrioritySchemeGetAllResponseBean.Expand[0]);
        Assert.assertEquals((long)200L, (long)response.statusCode);
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)response.body).getExpand(), (Matcher)Matchers.equalTo((Object)"schemes"));
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)response.body).getSchemes(), (Matcher)Matchers.contains(this.getDefaultPrioritySchemeMatcher(null, null)));
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)response.body).getStartAt(), (Matcher)Matchers.equalTo((Object)0L));
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)response.body).getMaxResults(), (Matcher)Matchers.equalTo((Object)100));
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)response.body).getTotal(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=77000)
    public void testGetAllSchemesWithPagination() throws Exception {
        IntStream.range(0, 100).forEach(i -> this.prioritySchemeClient.createWithDefaultMapping(new PrioritySchemeUpdateBean(null, String.format("%02d", i), null, null, (List)ImmutableList.of((Object)"1"))));
        ParsedResponse response = this.prioritySchemeClient.getAll(Long.valueOf(1L), Integer.valueOf(10), new PrioritySchemeGetAllResponseBean.Expand[]{PrioritySchemeGetAllResponseBean.Expand.projectKeys});
        Assert.assertEquals((long)200L, (long)response.statusCode);
        Assert.assertThat(((PrioritySchemeGetAllResponseBean)response.body).getSchemes().stream().map(PrioritySchemeBean::getName).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09"}));
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)response.body).getStartAt(), (Matcher)Matchers.equalTo((Object)1L));
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)response.body).getMaxResults(), (Matcher)Matchers.equalTo((Object)10));
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)response.body).getTotal(), (Matcher)Matchers.equalTo((Object)101));
        response = this.prioritySchemeClient.getAll(Long.valueOf(99L), Integer.valueOf(10), new PrioritySchemeGetAllResponseBean.Expand[]{PrioritySchemeGetAllResponseBean.Expand.projectKeys});
        Assert.assertEquals((long)200L, (long)response.statusCode);
        Assert.assertThat(((PrioritySchemeGetAllResponseBean)response.body).getSchemes().stream().map(PrioritySchemeBean::getName).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"98", "99"}));
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)response.body).getStartAt(), (Matcher)Matchers.equalTo((Object)99L));
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)response.body).getMaxResults(), (Matcher)Matchers.equalTo((Object)10));
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)response.body).getTotal(), (Matcher)Matchers.equalTo((Object)101));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=77000)
    public void testDeleteScheme() {
        ParsedResponse createResponse = this.prioritySchemeClient.createWithDefaultMapping(new PrioritySchemeUpdateBean(null, "New scheme", null, null, (List)ImmutableList.of((Object)"4", (Object)"1")));
        Assert.assertThat((Object)createResponse.statusCode, (Matcher)Matchers.equalTo((Object)201));
        ParsedResponse allSchemes = this.prioritySchemeClient.getAll(null, null, new PrioritySchemeGetAllResponseBean.Expand[]{PrioritySchemeGetAllResponseBean.Expand.projectKeys});
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)allSchemes.body).getSchemes(), (Matcher)Matchers.iterableWithSize((int)2));
        ParsedResponse deleteResponse = this.prioritySchemeClient.delete(((PrioritySchemeBean)createResponse.body).getId().longValue());
        Assert.assertThat((Object)deleteResponse.statusCode, (Matcher)Matchers.equalTo((Object)204));
        allSchemes = this.prioritySchemeClient.getAll(null, null, new PrioritySchemeGetAllResponseBean.Expand[]{PrioritySchemeGetAllResponseBean.Expand.projectKeys});
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)allSchemes.body).getSchemes(), (Matcher)Matchers.iterableWithSize((int)1));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=77000)
    public void testAssignAndUnassign() {
        Matcher<PrioritySchemeBean> assignedSchemeMatcher = this.prioritySchemeMatcher("projectKeys", this.createSelfLink(10110L), 10110L, "New scheme", null, null, (List<String>)ImmutableList.of((Object)"4", (Object)"1"), false, (List<String>)ImmutableList.of((Object)"MKY"));
        Matcher<PrioritySchemeBean> assignedSchemeMatcher2 = this.prioritySchemeMatcher("projectKeys", this.createSelfLink(10110L), 10110L, "New scheme", null, null, (List<String>)ImmutableList.of((Object)"4", (Object)"1"), false, (List<String>)ImmutableList.of((Object)"HSP", (Object)"MKY"));
        Matcher<PrioritySchemeBean> unassignedSchemeMatcher = this.prioritySchemeMatcher("projectKeys", this.createSelfLink(10110L), 10110L, "New scheme", null, null, (List<String>)ImmutableList.of((Object)"4", (Object)"1"), false, (List<String>)ImmutableList.of((Object)"MKY"));
        ParsedResponse createResponse = this.prioritySchemeClient.createWithDefaultMapping(new PrioritySchemeUpdateBean(null, "New scheme", null, null, (List)ImmutableList.of((Object)"4", (Object)"1")));
        Assert.assertThat((Object)createResponse.statusCode, (Matcher)Matchers.equalTo((Object)201));
        ParsedResponse assignResponse = this.prioritySchemeClient.assign(((PrioritySchemeBean)createResponse.body).getId().longValue(), "MKY", new PrioritySchemeBean.Expand[]{PrioritySchemeBean.Expand.projectKeys});
        Assert.assertThat((Object)assignResponse.body, assignedSchemeMatcher);
        ParsedResponse allSchemes = this.prioritySchemeClient.getAll(null, null, new PrioritySchemeGetAllResponseBean.Expand[]{PrioritySchemeGetAllResponseBean.Expand.projectKeys});
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)allSchemes.body).getSchemes(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{this.getDefaultPrioritySchemeMatcher("projectKeys", (ImmutableList<String>)ImmutableList.of((Object)"HSP")), assignedSchemeMatcher}));
        assignResponse = this.prioritySchemeClient.assign(((PrioritySchemeBean)createResponse.body).getId().longValue(), "HSP", new PrioritySchemeBean.Expand[]{PrioritySchemeBean.Expand.projectKeys});
        Assert.assertThat((Object)assignResponse.body, assignedSchemeMatcher2);
        allSchemes = this.prioritySchemeClient.getAll(null, null, new PrioritySchemeGetAllResponseBean.Expand[]{PrioritySchemeGetAllResponseBean.Expand.projectKeys});
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)allSchemes.body).getSchemes(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{this.getDefaultPrioritySchemeMatcher("projectKeys", (ImmutableList<String>)ImmutableList.of()), assignedSchemeMatcher2}));
        ParsedResponse unassignResponse = this.prioritySchemeClient.unassign(((PrioritySchemeBean)createResponse.body).getId().longValue(), "HSP", new PrioritySchemeBean.Expand[]{PrioritySchemeBean.Expand.projectKeys});
        Assert.assertThat((Object)unassignResponse.body, unassignedSchemeMatcher);
        ParsedResponse getResponse = this.prioritySchemeClient.get(((PrioritySchemeBean)createResponse.body).getId().longValue(), new PrioritySchemeBean.Expand[]{PrioritySchemeBean.Expand.projectKeys});
        Assert.assertThat((Object)getResponse.body, unassignedSchemeMatcher);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=77000)
    public void testSchemeCreate() {
        Matcher<PrioritySchemeBean> createdSchemeMatcher = this.prioritySchemeMatcher("projectKeys", this.createSelfLink(10110L), 10110L, "New scheme", "New description", "5", (List<String>)ImmutableList.of((Object)"5", (Object)"4", (Object)"2"), false, (List<String>)ImmutableList.of());
        ParsedResponse allSchemes = this.prioritySchemeClient.getAll(null, null, new PrioritySchemeGetAllResponseBean.Expand[]{PrioritySchemeGetAllResponseBean.Expand.projectKeys});
        Assert.assertThat((Object)allSchemes.statusCode, (Matcher)Matchers.equalTo((Object)200));
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)allSchemes.body).getSchemes(), (Matcher)Matchers.contains(this.getDefaultPrioritySchemeMatcher("projectKeys", (ImmutableList<String>)ImmutableList.of((Object)"HSP", (Object)"MKY"))));
        ParsedResponse createResponse = this.prioritySchemeClient.createWithDefaultMapping(new PrioritySchemeUpdateBean(null, "New scheme", "New description", "5", (List)ImmutableList.of((Object)"5", (Object)"4", (Object)"2")));
        Assert.assertThat((Object)createResponse.body, createdSchemeMatcher);
        ParsedResponse getResponse = this.prioritySchemeClient.get(((PrioritySchemeBean)createResponse.body).getId().longValue(), new PrioritySchemeBean.Expand[0]);
        Assert.assertThat((Object)getResponse.body, createdSchemeMatcher);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=77000)
    public void testSchemeEditing() {
        Matcher<PrioritySchemeBean> updatedSchemeMatcher = this.prioritySchemeMatcher("projectKeys", this.createSelfLink(10110L), 10110L, "Updated scheme", "Updated description", "4", (List<String>)ImmutableList.of((Object)"4", (Object)"1"), false, (List<String>)ImmutableList.of());
        Matcher<PrioritySchemeBean> updatedSchemeEmptyValuesMatcher = this.prioritySchemeMatcher("projectKeys", this.createSelfLink(10110L), 10110L, "Updated scheme", null, null, (List<String>)ImmutableList.of((Object)"4", (Object)"1"), false, (List<String>)ImmutableList.of());
        ParsedResponse createResponse = this.prioritySchemeClient.createWithDefaultMapping(new PrioritySchemeUpdateBean(null, "New scheme", "New description", "5", (List)ImmutableList.of((Object)"5", (Object)"4", (Object)"2")));
        Assert.assertThat((Object)createResponse.statusCode, (Matcher)Matchers.equalTo((Object)201));
        ParsedResponse updateResponse = this.prioritySchemeClient.updateWithDefaultMapping(new PrioritySchemeUpdateBean(((PrioritySchemeBean)createResponse.body).getId(), "Updated scheme", "Updated description", "4", (List)ImmutableList.of((Object)"4", (Object)"1")), new PrioritySchemeBean.Expand[]{PrioritySchemeBean.Expand.projectKeys});
        Assert.assertThat((Object)updateResponse.body, updatedSchemeMatcher);
        ParsedResponse getResponse = this.prioritySchemeClient.get(((PrioritySchemeBean)createResponse.body).getId().longValue(), new PrioritySchemeBean.Expand[]{PrioritySchemeBean.Expand.projectKeys});
        Assert.assertThat((Object)getResponse.body, updatedSchemeMatcher);
        updateResponse = this.prioritySchemeClient.updateWithDefaultMapping(new PrioritySchemeUpdateBean(((PrioritySchemeBean)createResponse.body).getId(), "Updated scheme", "", "", (List)ImmutableList.of((Object)"4", (Object)"1")), new PrioritySchemeBean.Expand[]{PrioritySchemeBean.Expand.projectKeys});
        Assert.assertThat((Object)updateResponse.body, updatedSchemeEmptyValuesMatcher);
        getResponse = this.prioritySchemeClient.get(((PrioritySchemeBean)createResponse.body).getId().longValue(), new PrioritySchemeBean.Expand[]{PrioritySchemeBean.Expand.projectKeys});
        Assert.assertThat((Object)getResponse.body, updatedSchemeEmptyValuesMatcher);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=77000)
    public void testSchemeEditingValidation() {
        ParsedResponse createResponse = this.prioritySchemeClient.createWithDefaultMapping(new PrioritySchemeUpdateBean(null, "New scheme", "New description", "5", (List)ImmutableList.of((Object)"5", (Object)"4", (Object)"2")));
        Assert.assertThat((Object)createResponse.statusCode, (Matcher)Matchers.equalTo((Object)201));
        createResponse = this.prioritySchemeClient.createWithDefaultMapping(new PrioritySchemeUpdateBean(null, "New scheme2", "New description", "5", (List)ImmutableList.of((Object)"5", (Object)"4", (Object)"2")));
        Assert.assertThat((Object)createResponse.statusCode, (Matcher)Matchers.equalTo((Object)201));
        ParsedResponse updateResponse = this.prioritySchemeClient.updateWithDefaultMapping(new PrioritySchemeUpdateBean(((PrioritySchemeBean)createResponse.body).getId(), "Updated scheme", "Updated description", null, (List)ImmutableList.of()), new PrioritySchemeBean.Expand[0]);
        Assert.assertThat((Object)updateResponse.statusCode, (Matcher)Matchers.equalTo((Object)400));
        Assert.assertThat((Object)updateResponse.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{"You must select at least one option"}));
        updateResponse = this.prioritySchemeClient.updateWithDefaultMapping(new PrioritySchemeUpdateBean(((PrioritySchemeBean)createResponse.body).getId(), "Updated scheme", "Updated description", "1", (List)ImmutableList.of((Object)"2")), new PrioritySchemeBean.Expand[0]);
        Assert.assertThat((Object)updateResponse.statusCode, (Matcher)Matchers.equalTo((Object)400));
        Assert.assertThat((Object)updateResponse.entity.errors, (Matcher)Matchers.hasEntry((Object)"defaultPriority", (Object)"Your default option must be in the selected options"));
        updateResponse = this.prioritySchemeClient.updateWithDefaultMapping(new PrioritySchemeUpdateBean(((PrioritySchemeBean)createResponse.body).getId(), "New scheme", "Updated description", "1", (List)ImmutableList.of((Object)"1")), new PrioritySchemeBean.Expand[0]);
        Assert.assertThat((Object)updateResponse.statusCode, (Matcher)Matchers.equalTo((Object)400));
        Assert.assertThat((Object)updateResponse.entity.errors, (Matcher)Matchers.hasEntry((Object)"name", (Object)"This name already exists please choose another one"));
        updateResponse = this.prioritySchemeClient.updateWithDefaultMapping(new PrioritySchemeUpdateBean(((PrioritySchemeBean)createResponse.body).getId(), "", "Updated description", "1", (List)ImmutableList.of((Object)"1")), new PrioritySchemeBean.Expand[0]);
        Assert.assertThat((Object)updateResponse.statusCode, (Matcher)Matchers.equalTo((Object)400));
        Assert.assertThat((Object)updateResponse.entity.errors, (Matcher)Matchers.hasEntry((Object)"name", (Object)"You must enter a valid name."));
        updateResponse = this.prioritySchemeClient.updateWithDefaultMapping(new PrioritySchemeUpdateBean(((PrioritySchemeBean)createResponse.body).getId(), "Another", "Updated description", null, (List)ImmutableList.of((Object)"666")), new PrioritySchemeBean.Expand[0]);
        Assert.assertThat((Object)updateResponse.statusCode, (Matcher)Matchers.equalTo((Object)400));
        Assert.assertThat((Object)updateResponse.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{"Option id 666 is not valid"}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=77000)
    public void getSchemeForProjectShouldNotWorkForNormalUsers() {
        String username = "normal";
        this.backdoor.usersAndGroups().addUser(username);
        ParsedResponse response = ((PrioritySchemeClient)this.prioritySchemeClient.loginAs(username, username)).getForProject("MKY", new PrioritySchemeBean.Expand[0]);
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)403));
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{NO_PROJECT_PERMISSIONS_ERROR}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=77000)
    public void getSchemeForProjectShouldWorkForProjectAdmins() {
        String username = "projectadmin";
        String browseProjectsGroup = "jira-users";
        String projectAdminGroup = "project-admin";
        this.backdoor.usersAndGroups().addUser(username);
        this.backdoor.usersAndGroups().addGroup(projectAdminGroup);
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.ADMINISTER_PROJECTS, projectAdminGroup);
        Long newPermissionSchemeId = this.backdoor.permissionSchemes().copyDefaultScheme("new permission scheme");
        Long hspId = this.backdoor.project().getProjectId("HSP");
        this.backdoor.project().setPermissionScheme(hspId, newPermissionSchemeId);
        ParsedResponse response = ((PrioritySchemeClient)this.prioritySchemeClient.loginAs(username, username)).getForProject("MKY", new PrioritySchemeBean.Expand[0]);
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)403));
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{NO_PROJECT_PERMISSIONS_ERROR}));
        this.backdoor.usersAndGroups().addUserToGroup(username, projectAdminGroup);
        response = ((PrioritySchemeClient)this.prioritySchemeClient.loginAs(username, username)).getForProject("MKY", new PrioritySchemeBean.Expand[]{PrioritySchemeBean.Expand.projectKeys});
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)200));
        Assert.assertThat((Object)response.body, this.getDefaultPrioritySchemeMatcher("projectKeys", (ImmutableList<String>)ImmutableList.of((Object)"HSP", (Object)"MKY")));
        this.backdoor.permissionSchemes().removeGroupPermission(newPermissionSchemeId.longValue(), ProjectPermissions.BROWSE_PROJECTS, browseProjectsGroup);
        response = ((PrioritySchemeClient)this.prioritySchemeClient.loginAs(username, username)).getForProject("MKY", new PrioritySchemeBean.Expand[]{PrioritySchemeBean.Expand.projectKeys});
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)200));
        Assert.assertThat((String)"Should not return associated project keys when user don't have browse projects permission", (Object)response.body, this.getDefaultPrioritySchemeMatcher("projectKeys", (ImmutableList<String>)ImmutableList.of((Object)"MKY")));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=77000)
    public void shouldNotAllowAssignWithMigration() {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("MKY", "Issue to migrate", null, "1", "Task");
        ParsedResponse createResponse = this.prioritySchemeClient.createWithDefaultMapping(new PrioritySchemeUpdateBean(null, "New scheme", "New description", null, (List)ImmutableList.of((Object)"2")));
        Assert.assertThat((Object)createResponse.statusCode, (Matcher)Matchers.equalTo((Object)201));
        ParsedResponse assignResponse = this.prioritySchemeClient.assign(((PrioritySchemeBean)createResponse.body).getId().longValue(), "MKY", new PrioritySchemeBean.Expand[0]);
        Assert.assertThat((Object)assignResponse.statusCode, (Matcher)Matchers.equalTo((Object)400));
        Assert.assertThat((Object)assignResponse.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{"We can't complete this operation, because it changes priorities that are currently used by some issues. Try doing this directly in Jira."}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=77000)
    public void shouldReturnProperResponseCodeWhenProjectIsNotFoundAndUserIsNotGlobalAdmin() {
        String username = "projectadmin";
        String projectAdminGroup = "project-admin";
        this.backdoor.usersAndGroups().addUser(username);
        this.backdoor.usersAndGroups().addGroup(projectAdminGroup);
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.ADMINISTER_PROJECTS, projectAdminGroup);
        String notExistingProject = "NOTEXISTS";
        ParsedResponse response = ((PrioritySchemeClient)this.prioritySchemeClient.loginAs(username, username)).getForProject("NOTEXISTS", new PrioritySchemeBean.Expand[0]);
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)404));
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{"No project could be found with key 'NOTEXISTS'."}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=77000)
    public void shouldReturnProperResponseCodeWhenProjectIsNotFoundAndUserDoesNotHaveViewProjectPermission() {
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.BROWSE_PROJECTS, "jira-users");
        String notExistingProject = "NOTEXISTS";
        ParsedResponse response = this.prioritySchemeClient.getForProject("NOTEXISTS", new PrioritySchemeBean.Expand[0]);
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)404));
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{"No project could be found with key 'NOTEXISTS'."}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=77000)
    public void shouldNotAllowEditWithMigration() {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("MKY", "Issue to migrate", null, "1", "Task");
        ParsedResponse createResponse = this.prioritySchemeClient.createWithDefaultMapping(new PrioritySchemeUpdateBean(null, "New scheme", "New description", null, (List)ImmutableList.of((Object)"1", (Object)"2")));
        Assert.assertThat((Object)createResponse.statusCode, (Matcher)Matchers.equalTo((Object)201));
        ParsedResponse assignResponse = this.prioritySchemeClient.assign(((PrioritySchemeBean)createResponse.body).getId().longValue(), "MKY", new PrioritySchemeBean.Expand[0]);
        Assert.assertThat((Object)assignResponse.statusCode, (Matcher)Matchers.equalTo((Object)200));
        ParsedResponse updateResponse = this.prioritySchemeClient.updateWithDefaultMapping(new PrioritySchemeUpdateBean(((PrioritySchemeBean)createResponse.body).getId(), "Updated scheme", "", "", (List)ImmutableList.of((Object)"2")), new PrioritySchemeBean.Expand[0]);
        Assert.assertThat((Object)updateResponse.statusCode, (Matcher)Matchers.equalTo((Object)400));
        Assert.assertThat((Object)updateResponse.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{"We can't complete this operation, because it changes priorities that are currently used by some issues. Try doing this directly in Jira."}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=77000)
    public void testGetAllWithProjectKeys() {
        ParsedResponse allSchemes = this.prioritySchemeClient.getAll(null, null, new PrioritySchemeGetAllResponseBean.Expand[]{PrioritySchemeGetAllResponseBean.Expand.projectKeys});
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)allSchemes.body).getSchemes(), (Matcher)Matchers.contains(this.getDefaultPrioritySchemeMatcher("projectKeys", (ImmutableList<String>)ImmutableList.of((Object)"HSP", (Object)"MKY"))));
        allSchemes = this.prioritySchemeClient.getAll(null, null, new PrioritySchemeGetAllResponseBean.Expand[0]);
        Assert.assertThat((Object)((PrioritySchemeGetAllResponseBean)allSchemes.body).getSchemes(), (Matcher)Matchers.contains(this.getDefaultPrioritySchemeMatcher(null, (ImmutableList<String>)ImmutableList.of())));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=77000)
    public void shouldReturnProperResponseCodeWhenSchemeIsNotFound() {
        Long notExistingSchemeId = 123L;
        ParsedResponse response = this.prioritySchemeClient.delete(notExistingSchemeId.longValue());
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)404));
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{"The priority scheme with ID [123] was not found."}));
        response = this.prioritySchemeClient.updateWithDefaultMapping(new PrioritySchemeUpdateBean(notExistingSchemeId, "Updated scheme", "", "", (List)ImmutableList.of((Object)"4", (Object)"1")), new PrioritySchemeBean.Expand[0]);
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)404));
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{"The priority scheme with ID [123] was not found."}));
        response = this.prioritySchemeClient.get(notExistingSchemeId.longValue(), new PrioritySchemeBean.Expand[0]);
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)404));
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{"The priority scheme with ID [123] was not found."}));
        response = this.prioritySchemeClient.assign(notExistingSchemeId.longValue(), "MKY", new PrioritySchemeBean.Expand[0]);
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)404));
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{"The priority scheme with ID [123] was not found."}));
        response = this.prioritySchemeClient.unassign(notExistingSchemeId.longValue(), "MKY", new PrioritySchemeBean.Expand[0]);
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)404));
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{"The priority scheme with ID [123] was not found."}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=77000)
    public void shouldReturnProperResponseCodeWhenProjectIsNotFound() {
        String notExistingProject = "NOTEXISTS";
        ParsedResponse response = this.prioritySchemeClient.getForProject("NOTEXISTS", new PrioritySchemeBean.Expand[0]);
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)404));
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{"No project could be found with key 'NOTEXISTS'."}));
    }

    private Matcher<PrioritySchemeBean> getDefaultPrioritySchemeMatcher(String expand, ImmutableList<String> projects) {
        return this.prioritySchemeMatcher(expand, this.createSelfLink(10010L), 10010L, "Default priority scheme", "This is default priority scheme used by all projects without any other scheme assigned", null, (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"), true, (List<String>)projects);
    }

    private Matcher<PrioritySchemeBean> prioritySchemeMatcher(String expand, URI self, Long id, String name, String description, String defaultOptionId, List<String> optionIds, boolean defaultScheme, List<String> projectKeys) {
        ImmutableList.Builder matchers = ImmutableList.builder();
        if (Objects.nonNull(expand)) {
            matchers.add((Object)Matchers.hasProperty((String)"expand", (Matcher)Matchers.equalTo((Object)expand)));
        }
        if (Objects.nonNull(projectKeys)) {
            Matchers.hasProperty((String)"projectKeys", (Matcher)Matchers.equalTo(projectKeys));
        }
        for (Matcher m : new Matcher[]{Matchers.hasProperty((String)"self", (Matcher)Matchers.equalTo((Object)self)), Matchers.hasProperty((String)"id", (Matcher)Matchers.equalTo((Object)id)), Matchers.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)name)), Matchers.hasProperty((String)"description", (Matcher)Matchers.equalTo((Object)description)), Matchers.hasProperty((String)"defaultOptionId", (Matcher)Matchers.equalTo((Object)defaultOptionId)), Matchers.hasProperty((String)"optionIds", (Matcher)Matchers.equalTo(optionIds)), Matchers.hasProperty((String)"defaultScheme", (Matcher)Matchers.equalTo((Object)defaultScheme))}) {
            matchers.add((Object)m);
        }
        return Matchers.allOf((Matcher[])((Matcher[])matchers.build().toArray((Object[])new Matcher[0])));
    }

    private URI createSelfLink(long id) {
        return URI.create(this.environmentData.getBaseUrl() + "/rest/api/2/priorityschemes/" + String.valueOf(id));
    }
}

