/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.beans.PermissionSchemeBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.GenericRestClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.PermissionSchemeRestClient;
import com.google.common.collect.ImmutableList;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreBlankInstance
@LoginAs(user="admin")
public final class TestProjectPermissionSchemeResource
extends BaseJiraRestTest {
    public static final String SCHEME_NAME = "scheme";
    public static final String SCHEME_DESC = "desc";
    public static final String PROJECT_KEY = "PR";
    public static final String PROJECT_NAME = "project";
    private PermissionSchemeRestClient client;
    private Long schemeId;
    private Long projectId;
    private GenericRestClient genericRestClient;

    @Before
    public void setUpRestClients() {
        this.client = (PermissionSchemeRestClient)new PermissionSchemeRestClient((JIRAEnvironmentData)this.getEnvironmentData()).loginAs("admin", "admin");
        this.genericRestClient = new GenericRestClient();
        this.genericRestClient.loginAs("admin", "admin");
    }

    @Before
    public void setUpJiraData() {
        this.schemeId = this.backdoor.permissionSchemes().createScheme(SCHEME_NAME, SCHEME_DESC);
        this.projectId = this.backdoor.project().addProject(PROJECT_NAME, PROJECT_KEY, "admin");
        this.backdoor.project().setPermissionScheme(this.projectId, this.schemeId);
    }

    @Test
    public void testAdminCanGetAssignedPermissionScheme() {
        this.assumeUserCanGetAssignedScheme("admin");
    }

    @Test
    public void testProjectAdministratorCanGetAssignedPermissionScheme() {
        this.assumeFredAdministersProject();
        this.assumeUserCanGetAssignedScheme("fred");
    }

    @Test
    public void testNotProjectAdministratorGets403WhenTryingToGetPermissionScheme() {
        this.assumeEveryoneCanSeeTheProject();
        Assert.assertThat((Object)((PermissionSchemeRestClient)this.client.loginAs((String)"fred")).getAssignedScheme((String)PROJECT_KEY).statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN.getStatusCode()));
    }

    @Test
    public void testAdminCanAssignPermissionScheme() {
        Long schemeId = this.backdoor.permissionSchemes().createScheme("newScheme", "newDesc");
        for (String projectKeyOrId : new String[]{PROJECT_KEY, this.projectId.toString()}) {
            ParsedResponse response = this.client.assignScheme(projectKeyOrId, schemeId);
            this.assertResponse((ParsedResponse<PermissionSchemeBean>)response, "newScheme", "newDesc");
            this.assumeUserCanGetAssignedScheme("admin", "newScheme", "newDesc");
        }
    }

    @Test
    public void testNonAdminGets403WhenTryingToUpdatePermissionScheme() {
        this.assumeEveryoneCanSeeTheProject();
        Assert.assertThat((Object)((PermissionSchemeRestClient)this.client.loginAs((String)"fred")).assignScheme((String)PROJECT_KEY, (Long)this.schemeId).statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN.getStatusCode()));
    }

    @Test
    public void testProjectAdministratorGets403WhenTryingToUpdatePermissionScheme() {
        this.assumeFredAdministersProject();
        Assert.assertThat((Object)((PermissionSchemeRestClient)this.client.loginAs((String)"fred")).assignScheme((String)PROJECT_KEY, (Long)this.schemeId).statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN.getStatusCode()));
    }

    @Test
    public void testUserThatDoesntHaveAccessToProjectGets404WhenTryingToViewOrAssignPermissionScheme() {
        Assert.assertThat((Object)((PermissionSchemeRestClient)this.client.loginAs((String)"fred")).assignScheme((String)PROJECT_KEY, (Long)this.schemeId).statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        Assert.assertThat((Object)((PermissionSchemeRestClient)this.client.loginAs((String)"fred")).getAssignedScheme((String)PROJECT_KEY).statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
    }

    @Test
    public void testAnonymousGets401WhenTryingToGetOrAssignPermissionScheme() {
        Assert.assertThat((Object)((PermissionSchemeRestClient)this.client.anonymous()).assignScheme((String)PROJECT_KEY, (Long)this.schemeId).statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.UNAUTHORIZED.getStatusCode()));
        Assert.assertThat((Object)((PermissionSchemeRestClient)this.client.anonymous()).getAssignedScheme((String)PROJECT_KEY).statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.UNAUTHORIZED.getStatusCode()));
    }

    @Test
    public void testAssigningNonExistentPermissionSchemeReturns404() {
        Assert.assertThat((Object)this.client.assignScheme((String)PROJECT_KEY, (Long)Long.valueOf((long)4444L)).statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
    }

    private void assumeUserCanGetAssignedScheme(String username) {
        this.assumeUserCanGetAssignedScheme(username, SCHEME_NAME, SCHEME_DESC);
    }

    private void assumeUserCanGetAssignedScheme(String username, String schemeName, String schemeDesc) {
        ParsedResponse responseByProjectKey = ((PermissionSchemeRestClient)this.client.loginAs(username)).getAssignedScheme(PROJECT_KEY);
        ParsedResponse responseByProjectId = ((PermissionSchemeRestClient)this.client.loginAs(username)).getAssignedScheme(this.projectId.toString());
        for (ParsedResponse response : ImmutableList.of((Object)responseByProjectKey, (Object)responseByProjectId)) {
            this.assertResponse((ParsedResponse<PermissionSchemeBean>)response, schemeName, schemeDesc);
        }
    }

    private void assertResponse(ParsedResponse<PermissionSchemeBean> response, String schemeName, String schemeDesc) {
        this.assertResponseWithoutCheckingSelf(response, schemeName, schemeDesc);
        this.assertResponseWithoutCheckingSelf((ParsedResponse<PermissionSchemeBean>)this.genericRestClient.get(((PermissionSchemeBean)response.body).getSelf(), PermissionSchemeBean.class), schemeName, schemeDesc);
    }

    private void assertResponseWithoutCheckingSelf(ParsedResponse<PermissionSchemeBean> response, String schemeName, String schemeDesc) {
        Assert.assertThat((Object)((PermissionSchemeBean)response.body).getName(), (Matcher)Matchers.equalTo((Object)schemeName));
        Assert.assertThat((Object)((PermissionSchemeBean)response.body).getDescription(), (Matcher)Matchers.equalTo((Object)schemeDesc));
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode()));
    }

    private void assumeEveryoneCanSeeTheProject() {
        this.backdoor.permissionSchemes().addEveryonePermission(this.schemeId, ProjectPermissions.BROWSE_PROJECTS);
    }

    private void assumeFredAdministersProject() {
        this.backdoor.permissionSchemes().addUserPermission(this.schemeId.longValue(), ProjectPermissions.ADMINISTER_PROJECTS, "fred");
    }
}

