/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.EntityProperty;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.util.PropertyAssertions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ENTITY_PROPERTIES, Category.REST})
@LoginAs(user="admin")
public class TestProjectPropertyResource
extends BaseJiraFuncTest {
    private static final String PROJECT_KEY = "HSP";
    private static final String PROPERTY_KEY = "project.admin";
    private EntityPropertyClient client;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.client = new EntityPropertyClient((JIRAEnvironmentData)this.environmentData, "project");
    }

    @Test
    public void testCreatingNewProjectProperty() {
        this.administration.restoreBlankInstance();
        MatcherAssert.assertThat((Object)this.client.getKeys((String)PROJECT_KEY).keys, (Matcher)Matchers.empty());
        JSONObject jsonObject = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"username", (Object)"filip", (Object)"userkey", (Object)"filip2"));
        this.client.put(PROJECT_KEY, PROPERTY_KEY, jsonObject);
        EntityProperty projectProperty = this.client.get(PROJECT_KEY, PROPERTY_KEY);
        MatcherAssert.assertThat((Object)projectProperty.key, (Matcher)Matchers.is((Object)PROPERTY_KEY));
        MatcherAssert.assertThat((Object)jsonObject, (Matcher)Matchers.is((Object)new JSONObject(projectProperty.value)));
        List keys = this.client.getKeys((String)PROJECT_KEY).keys;
        MatcherAssert.assertThat((Object)keys, (Matcher)Matchers.hasItem(PropertyAssertions.propertyKey(PROPERTY_KEY)));
        PropertyAssertions.assertWebApplicationException(() -> {
            ((EntityPropertyClient)this.client.anonymous()).getKeys(PROJECT_KEY);
            return null;
        }, Response.Status.UNAUTHORIZED);
        PropertyAssertions.assertWebApplicationException(() -> {
            ((EntityPropertyClient)this.client.anonymous()).get(PROJECT_KEY, PROPERTY_KEY);
            return null;
        }, Response.Status.UNAUTHORIZED);
    }

    @Test
    public void testDeletingProperties() {
        this.administration.restoreBlankInstance();
        MatcherAssert.assertThat((Object)this.client.getKeys((String)PROJECT_KEY).keys, (Matcher)Matchers.empty());
        JSONObject jsonObject = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"label", (Object)"todo", (Object)"color", (Object)"red"));
        this.client.put(PROJECT_KEY, PROPERTY_KEY, jsonObject);
        EntityProperty projectProperty = this.client.get(PROJECT_KEY, PROPERTY_KEY);
        MatcherAssert.assertThat((Object)projectProperty.key, (Matcher)Matchers.is((Object)PROPERTY_KEY));
        MatcherAssert.assertThat((Object)jsonObject, (Matcher)Matchers.is((Object)new JSONObject(projectProperty.value)));
        this.client.delete(PROJECT_KEY, PROPERTY_KEY);
        MatcherAssert.assertThat((Object)this.client.getKeys((String)PROJECT_KEY).keys, (Matcher)Matchers.empty());
        PropertyAssertions.assertWebApplicationException(() -> {
            this.client.get(PROJECT_KEY, PROPERTY_KEY);
            return null;
        }, Response.Status.NOT_FOUND);
    }

    @Test
    public void testForbiddenForUserWithoutPermissionsToProject() {
        this.backdoor.restoreBlankInstance();
        this.administration.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        ParsedResponse response = ((EntityPropertyClient)this.client.loginAs("bob", "bob")).put(PROJECT_KEY, PROPERTY_KEY, new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"status", (Object)"done")));
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testPropertiesAreRemovedWhenProjectIsRemoved() {
        this.backdoor.restoreBlankInstance();
        JSONObject jsonObject = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"status", (Object)"unresolved"));
        this.client.put(PROJECT_KEY, PROPERTY_KEY, jsonObject);
        EntityProperty property = this.client.get(PROJECT_KEY, PROPERTY_KEY);
        MatcherAssert.assertThat((Object)new JSONObject(property.value), (Matcher)Matchers.is((Object)jsonObject));
        this.backdoor.project().deleteProject(PROJECT_KEY);
        PropertyAssertions.assertWebApplicationException(() -> {
            this.client.get(PROJECT_KEY, PROPERTY_KEY);
            return null;
        }, Response.Status.NOT_FOUND);
    }
}

