/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.ProjectTypeBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.ProjectTypeClient;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
public class TestProjectTypeResource
extends BaseJiraRestTest {
    private ProjectTypeClient projectTypeClient;
    public static final String BUSINESS = "business";

    @Before
    public void setUp() {
        this.backdoor.restoreBlankInstance();
        this.projectTypeClient = new ProjectTypeClient((JIRAEnvironmentData)this.environmentData);
        this.projectTypeClient.anonymous();
    }

    @Test
    public void testGetAllProjectTypesReturnsAllTheExistingProjectTypes() throws Exception {
        ParsedResponse response = this.projectTypeClient.getAllProjectTypes();
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)200));
        List projectTypes = (List)response.body;
        MatcherAssert.assertThat((Object)projectTypes.size(), (Matcher)Is.is((Object)3));
        this.assertProjectTypeIsCorrect((ProjectTypeBean)projectTypes.get(0), "first-type", "first.type.desc", "first-type-icon", "#111111");
        this.assertProjectTypeIsCorrect((ProjectTypeBean)projectTypes.get(1), "second-type", "second.type.desc", "second-type-icon", "#222222");
        this.assertBusinessProjectTypeIsCorrect((ProjectTypeBean)projectTypes.get(2));
    }

    @Test
    public void testGetProjectTypeByKeyReturnsTheExpectedTypeWhenItExists() throws Exception {
        ParsedResponse response = this.projectTypeClient.getByKey(BUSINESS);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)200));
        this.assertBusinessProjectTypeIsCorrect((ProjectTypeBean)response.body);
    }

    @Test
    public void testGetProjectTypeByKeyReturns404WhenItDoesNotExist() throws Exception {
        ParsedResponse response = ((ProjectTypeClient)this.projectTypeClient.loginAs("admin")).getByKey("non-existent");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)404));
    }

    @Test
    public void testGetAccessibleProjectTypeReturnsTheTypeIfTheUserIsLoggedInAndHasAccessToIt() throws Exception {
        ParsedResponse response = ((ProjectTypeClient)this.projectTypeClient.loginAs("admin")).getAccessibleProjectTypeByKey(BUSINESS);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)200));
        this.assertBusinessProjectTypeIsCorrect((ProjectTypeBean)response.body);
    }

    @Test
    public void testGetAccessibleProjectTypeReturns404IfTheUserIsLoggedInAndDoesNotHaveAccessToIt() throws Exception {
        ParsedResponse response = ((ProjectTypeClient)this.projectTypeClient.loginAs("admin")).getAccessibleProjectTypeByKey("non-existent");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)404));
    }

    @Test
    public void testGetAccessibleProjectTypeReturns401IfTheUserIsNotLoggedIn() throws Exception {
        ParsedResponse response = this.projectTypeClient.getAccessibleProjectTypeByKey(BUSINESS);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Is.is((Object)401));
    }

    private void assertProjectTypeIsCorrect(ProjectTypeBean projectType, String expectedKey, String expectedDescription, String expectedIcon, String expectedColor) {
        MatcherAssert.assertThat((Object)projectType.getKey(), (Matcher)Is.is((Object)expectedKey));
        MatcherAssert.assertThat((Object)projectType.getDescriptionI18nKey(), (Matcher)Is.is((Object)expectedDescription));
        MatcherAssert.assertThat((Object)projectType.getIcon(), (Matcher)Is.is((Object)expectedIcon));
        MatcherAssert.assertThat((Object)projectType.getColor(), (Matcher)Is.is((Object)expectedColor));
    }

    private void assertBusinessProjectTypeIsCorrect(ProjectTypeBean projectType) {
        MatcherAssert.assertThat((Object)projectType.getKey(), (Matcher)Is.is((Object)BUSINESS));
        MatcherAssert.assertThat((Object)projectType.getDescriptionI18nKey(), (Matcher)Is.is((Object)"jira.project.type.business.description"));
        MatcherAssert.assertThat((Object)projectType.getColor(), (Matcher)Is.is((Object)"#0065FF"));
        MatcherAssert.assertThat((Object)projectType.getIcon().length(), (Matcher)Is.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }
}

