/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.project.ProjectRoleBean;
import com.atlassian.jira.testkit.beans.PermissionGrantBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.CommentClient;
import com.atlassian.jira.testkit.client.restclient.CommentsWithPaginationBean;
import com.atlassian.jira.testkit.client.restclient.GenericRestClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.PermissionSchemeRestClient;
import com.atlassian.jira.testkit.client.restclient.ProjectRole;
import com.atlassian.jira.testkit.client.restclient.ProjectRoleActorsBean;
import com.atlassian.jira.testkit.client.restclient.ProjectRoleClient;
import com.atlassian.jira.testkit.client.restclient.RoleClient;
import com.atlassian.jira.util.json.JSONException;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.annotation.Nonnull;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestRoleResource
extends BaseJiraFuncTest {
    private RoleClient roleClient;
    private PermissionSchemeRestClient permissionSchemeRestClient;
    private CommentClient commentClient;

    @Before
    public void setUpTest() {
        this.backdoor.restoreBlankInstance();
        this.roleClient = new RoleClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.permissionSchemeRestClient = new PermissionSchemeRestClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.commentClient = new CommentClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    @Test
    public void testGetAllRoles() {
        List projectRoles = this.roleClient.get();
        Matcher[] expectedProjectRoles = new Matcher[]{this.projectRole(10000L, "Users", "A project role that represents users in a project", "jira-users"), this.projectRole(10001L, "Developers", "A project role that represents developers in a project", "jira-developers"), this.projectRole(10002L, "Administrators", "A project role that represents administrators in a project", "jira-administrators")};
        Matcher values = CoreMatchers.hasItems((Matcher[])expectedProjectRoles);
        MatcherAssert.assertThat((Object)projectRoles, (Matcher)values);
    }

    @Test
    public void testAnonymousGet() {
        this.assertFailingStatusCode(() -> ((RoleClient)this.roleClient.anonymous()).get(), Response.Status.UNAUTHORIZED);
    }

    @Test
    public void testNormalUserGet() {
        this.assertFailingStatusCode(() -> {
            this.backdoor.usersAndGroups().addUser("user");
            ((RoleClient)this.roleClient.loginAs("user")).get();
        }, Response.Status.FORBIDDEN, () -> this.backdoor.usersAndGroups().deleteUser("user"));
    }

    @Test
    public void testGetSelfForEachRole() throws IOException, SAXException, JSONException {
        List projectRoles = this.roleClient.get();
        for (ProjectRole projectRole : projectRoles) {
            ProjectRole projectRoleFromGet = this.roleClient.get(projectRole.id.toString());
            Assert.assertNotNull((Object)projectRoleFromGet);
            Assert.assertEquals((Object)projectRole.description, (Object)projectRoleFromGet.description);
            Assert.assertEquals((Object)projectRole.name, (Object)projectRoleFromGet.name);
            Assert.assertEquals((Object)projectRole.self, (Object)projectRoleFromGet.self);
            Assert.assertEquals((Object)projectRole.id, (Object)projectRoleFromGet.id);
            ParsedResponse projectRoleBeanResponse = new GenericRestClient().get(URI.create(projectRole.self), ProjectRoleBean.class);
            MatcherAssert.assertThat((Object)projectRoleBeanResponse.statusCode, (Matcher)IsEqual.equalTo((Object)200));
            ProjectRoleBean bean = (ProjectRoleBean)projectRoleBeanResponse.body;
            Assert.assertEquals((Object)projectRole.description, (Object)bean.description);
            Assert.assertEquals((Object)projectRole.name, (Object)bean.name);
            Assert.assertEquals((Object)projectRole.self, (Object)bean.self.toString());
            Assert.assertEquals((Object)projectRole.id, (Object)bean.id);
        }
    }

    @Test
    public void testGetNonExistingRole() throws IOException, SAXException {
        this.assertFailingStatusCode(() -> this.roleClient.get("12312321312"), Response.Status.NOT_FOUND);
    }

    @Test
    public void testCreateRoleWorks() {
        ProjectRole expected = new ProjectRole().name("name").description("description");
        ProjectRole createResult = this.roleClient.create(expected.getName(), expected.getDescription());
        MatcherAssert.assertThat((Object)createResult, this.matchesByNameAndDescription(expected));
        ProjectRole getResult = this.roleClient.get(String.valueOf(createResult.id));
        MatcherAssert.assertThat((Object)getResult, this.matchesByNameAndDescription(expected));
        Assert.assertTrue((getResult.getActors() == null ? 1 : 0) != 0);
    }

    @Test
    public void testCreatingWithExistingNameYieldsConflict() {
        ProjectRole expected = new ProjectRole().name("name").description("description");
        this.roleClient.create(expected.getName(), expected.getDescription());
        this.assertFailingStatusCode(() -> this.roleClient.create(expected.getName(), expected.getDescription()), Response.Status.CONFLICT);
    }

    @Test
    public void testNoAccessForAnonymousForCreateRole() {
        this.assertFailingStatusCode(() -> ((RoleClient)this.roleClient.anonymous()).create("a", "b"), Response.Status.UNAUTHORIZED);
    }

    @Test
    public void testNoAccessForNormalUserForCreateRole() {
        this.assertFailingStatusCode(() -> {
            this.backdoor.usersAndGroups().addUser("user");
            ((RoleClient)this.roleClient.loginAs("user")).create("a", "b");
        }, Response.Status.FORBIDDEN, () -> this.backdoor.usersAndGroups().deleteUser("user"));
    }

    @Test
    public void testBadRequestForCreateRoleWithoutName() {
        this.assertFailingStatusCode(() -> this.roleClient.create(null, "b"), Response.Status.BAD_REQUEST);
    }

    @Test
    public void testRenameRoleWorks() {
        ProjectRole newRole = this.roleClient.create("role", "");
        String expectedName = "newName";
        ProjectRole newName = this.roleClient.updatePartial(newRole.id, expectedName, null);
        Assert.assertEquals((Object)expectedName, (Object)newName.getName());
    }

    @Test
    public void testPartialUpdateRoleNeedsNameOrDescription() {
        ProjectRole newRole = this.roleClient.create("role", "");
        this.assertFailingStatusCode(() -> this.roleClient.updatePartial(newRole.id, null, null), Response.Status.BAD_REQUEST);
    }

    @Test
    public void testFullUpdateRoleNeedsNameAndDescription() {
        ProjectRole newRole = this.roleClient.create("role", "");
        this.assertFailingStatusCode(() -> this.roleClient.updateFull(newRole.id, "a", null), Response.Status.BAD_REQUEST);
        this.assertFailingStatusCode(() -> this.roleClient.updateFull(newRole.id, null, "a"), Response.Status.BAD_REQUEST);
    }

    @Test
    public void testDeleteRoleWorks() {
        ProjectRole newRole = this.roleClient.create("to-be-deleted", "");
        this.roleClient.deleteProjectRole(newRole.getId());
        this.assertFailingStatusCode(() -> this.roleClient.get(String.valueOf(newRole.getId())), Response.Status.NOT_FOUND);
    }

    @Test
    public void testDeleteWorksWithLinkedSchemesAndSwapQueryParam() {
        ProjectRole newRole = this.roleClient.create("to-be-deleted", "");
        ProjectRole replacementRole = this.roleClient.create("replacement", "");
        Long schemeId = this.backdoor.permissionSchemes().createScheme("new-scheme", "");
        this.backdoor.permissionSchemes().addProjectRolePermission(schemeId.longValue(), ProjectPermissions.CLOSE_ISSUES, newRole.getId().longValue());
        this.roleClient.deleteProjectRole(newRole.getId(), replacementRole.getId());
        List permissions = ((PermissionSchemeRestClient.PermissionGrantListBean)this.permissionSchemeRestClient.getPermissions((Long)schemeId, (PermissionSchemeRestClient.Expand[])new PermissionSchemeRestClient.Expand[0]).body).permissions;
        MatcherAssert.assertThat((Object)permissions, (Matcher)IsIterableContainingInOrder.contains(this.projectRolePermissionGrantBean(replacementRole.getId())));
    }

    @Test
    public void testDeleteFailsWithLinkedSchemesWithoutSwapQueryParam() {
        ProjectRole role = this.roleClient.create(RandomStringUtils.randomAlphabetic((int)6), "");
        Long schemeId = this.backdoor.permissionSchemes().createScheme("new-scheme", "");
        this.backdoor.permissionSchemes().addProjectRolePermission(schemeId.longValue(), ProjectPermissions.CLOSE_ISSUES, role.getId().longValue());
        this.assertFailingStatusCode(() -> this.roleClient.deleteProjectRole(role.getId()), Response.Status.CONFLICT);
    }

    @Test
    public void testDeleteFailsWithProtectedCommentsWithoutSwapQueryParam() {
        ProjectRole role = this.roleClient.create(RandomStringUtils.randomAlphabetic((int)6), "");
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "summary");
        ProjectRoleClient projectRoleClient = new ProjectRoleClient((JIRAEnvironmentData)this.getEnvironmentData());
        projectRoleClient.addActors("HSP", role.getName(), new String[0], new String[]{"admin"});
        this.backdoor.issues().commentIssueWithVisibility(issue.key, "restricted-comment", "role", role.getName());
        this.assertFailingStatusCode(() -> this.roleClient.deleteProjectRole(role.getId()), Response.Status.CONFLICT);
    }

    @Test
    public void testDeleteWorksWithProtectedCommentsWithSwapQueryParam() {
        ProjectRole role = this.roleClient.create(RandomStringUtils.randomAlphabetic((int)6), "");
        ProjectRole roleReplacement = this.roleClient.create(RandomStringUtils.randomAlphabetic((int)6), "");
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "summary");
        ProjectRoleClient projectRoleClient = new ProjectRoleClient((JIRAEnvironmentData)this.getEnvironmentData());
        projectRoleClient.addActors("HSP", role.getName(), new String[0], new String[]{"admin"});
        projectRoleClient.addActors("HSP", roleReplacement.getName(), new String[0], new String[]{"fred"});
        this.backdoor.issues().commentIssueWithVisibility(issue.key, "restricted-comment", "role", role.getName());
        this.assertCannotSeeCommentsOnIssue("fred", issue.key);
        this.assertCanSeeCommentsOnIssue("admin", issue.key);
        this.roleClient.deleteProjectRole(role.getId(), roleReplacement.getId());
        this.assertCannotSeeCommentsOnIssue("admin", issue.key);
        this.assertCanSeeCommentsOnIssue("fred", issue.key);
    }

    @Test
    public void testDeleteWorksAndDoesNotModifyGroupRestrictions() {
        ProjectRole role = this.roleClient.create(RandomStringUtils.randomAlphabetic((int)6), "");
        ProjectRole roleReplacement = this.roleClient.create(RandomStringUtils.randomAlphabetic((int)6), "");
        String groupRestriction = "jira-administrators";
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "summary");
        ProjectRoleClient projectRoleClient = new ProjectRoleClient((JIRAEnvironmentData)this.getEnvironmentData());
        projectRoleClient.addActors("HSP", role.getName(), new String[0], new String[]{"admin"});
        this.backdoor.issues().commentIssueWithVisibility(issue.key, "restricted-comment", "role", role.getName());
        this.backdoor.issues().commentIssueWithVisibility(issue.key, "restricted-comment-to-group", "group", groupRestriction);
        this.roleClient.deleteProjectRole(role.getId(), roleReplacement.getId());
        projectRoleClient.addActors("HSP", roleReplacement.getName(), new String[0], new String[]{"admin"});
        this.assertCommentContainsGroupRestriction(issue.key, groupRestriction);
    }

    private void assertCommentContainsGroupRestriction(String key, String groupRestriction) {
        List comments = ((CommentsWithPaginationBean)this.commentClient.getComments((String)key).body).getComments();
        Assert.assertEquals((Object)"group", (Object)((Comment)comments.get((int)1)).visibility.type);
        Assert.assertEquals((Object)groupRestriction, (Object)((Comment)comments.get((int)1)).visibility.value);
    }

    @Test
    public void testDeleteFailsWhenRoleUsedInWorkflowWithoutSwapQueryParam() {
        Long roleId = 10610L;
        this.backdoor.restoreDataFromResource("xml/TestRoleResourceSwapRoleInWorkflows.xml");
        this.assertFailingStatusCode(() -> this.roleClient.deleteProjectRole(roleId), Response.Status.CONFLICT);
    }

    @Test
    public void testDeleteWorksWhenRoleUsedInWorkflowWithSwapQueryParam() {
        Long roleId = 10610L;
        this.backdoor.restoreDataFromResource("xml/TestRoleResourceSwapRoleInWorkflows.xml");
        ProjectRole roleReplacement = this.roleClient.create(RandomStringUtils.randomAlphabetic((int)6), "");
        this.roleClient.deleteProjectRole(roleId, roleReplacement.getId());
        this.verifyReplacementWorked(roleReplacement);
    }

    @Test
    public void getDefaultActorsOfNewRoleReturnsEmpty() {
        ProjectRole projectRole = this.roleClient.create(RandomStringUtils.randomAlphabetic((int)6), "");
        ProjectRoleActorsBean defaultActorsForRole = this.roleClient.getDefaultActorsForRole(projectRole.getId());
        MatcherAssert.assertThat((Object)defaultActorsForRole.getActors(), (Matcher)Matchers.empty());
    }

    @Test
    public void getDefaultActorsOfNonExistingRoleReturnsNotFound() {
        this.assertFailingStatusCode(() -> this.roleClient.getDefaultActorsForRole(Long.valueOf(999L)), Response.Status.NOT_FOUND);
    }

    @Test
    public void addDefaultActorsToNewRoleWorks() {
        ProjectRole projectRole = this.roleClient.create(RandomStringUtils.randomAlphabetic((int)6), "");
        ProjectRoleActorsBean result = this.roleClient.addDefaultActorsToRole(projectRole.getId(), new String[]{"admin"}, null);
        MatcherAssert.assertThat((Object)result.getActors(), (Matcher)Matchers.contains(this.actor("admin")));
    }

    @Test
    public void addDefaultActorsRequiresUserOrGroup() {
        ProjectRole projectRole = this.roleClient.create(RandomStringUtils.randomAlphabetic((int)6), "");
        this.assertFailingStatusCode(() -> this.roleClient.addDefaultActorsToRole(projectRole.getId(), null, null), Response.Status.BAD_REQUEST);
    }

    @Test
    public void addNonExistentActorFails() {
        ProjectRole projectRole = this.roleClient.create(RandomStringUtils.randomAlphabetic((int)6), "");
        this.assertFailingStatusCode(() -> this.roleClient.addDefaultActorsToRole(projectRole.getId(), new String[]{"nonexistent"}, null), Response.Status.BAD_REQUEST);
    }

    @Test
    public void addNonExistentActorFailsAndLeavesDefaultActorsAsIs() {
        ProjectRole projectRole = this.roleClient.create(RandomStringUtils.randomAlphabetic((int)6), "");
        this.assertFailingStatusCode(() -> this.roleClient.addDefaultActorsToRole(projectRole.getId(), new String[]{"nonexistent", "admin"}, new String[]{"jira-users"}), Response.Status.BAD_REQUEST);
        ProjectRoleActorsBean defaultActorsForRole = this.roleClient.getDefaultActorsForRole(projectRole.getId());
        MatcherAssert.assertThat((Object)defaultActorsForRole.getActors(), (Matcher)Matchers.empty());
    }

    @Test
    public void deleteDefaultActorsFromNewRoleWorks() {
        ProjectRole projectRole = this.roleClient.create(RandomStringUtils.randomAlphabetic((int)6), "");
        ProjectRoleActorsBean result = this.roleClient.addDefaultActorsToRole(projectRole.getId(), new String[]{"admin"}, null);
        MatcherAssert.assertThat((Object)result.getActors(), (Matcher)Matchers.contains(this.actor("admin")));
        ProjectRoleActorsBean updatedBean = this.roleClient.deleteDefaultActorsToRole(projectRole.getId(), "admin", null);
        MatcherAssert.assertThat((Object)updatedBean.getActors(), (Matcher)Matchers.empty());
    }

    @Test
    public void deleteDefaultActorsRequiresUserOrGroup() {
        ProjectRole projectRole = this.roleClient.create(RandomStringUtils.randomAlphabetic((int)6), "");
        this.assertFailingStatusCode(() -> this.roleClient.deleteDefaultActorsToRole(projectRole.getId(), null, null), Response.Status.BAD_REQUEST);
    }

    @Test
    public void deleteDefaultActorsFailsWhenGivenBothUserAndGroup() {
        ProjectRole projectRole = this.roleClient.create(RandomStringUtils.randomAlphabetic((int)6), "");
        this.assertFailingStatusCode(() -> this.roleClient.deleteDefaultActorsToRole(projectRole.getId(), "admin", "jira-users"), Response.Status.BAD_REQUEST);
    }

    private Matcher<? super ProjectRole.Actor> actor(final String name) {
        return new TypeSafeMatcher<ProjectRole.Actor>(){

            protected boolean matchesSafely(ProjectRole.Actor item) {
                return item.name.equals(name);
            }

            public void describeTo(Description description) {
                description.appendText("actor with name").appendValue((Object)name);
            }
        };
    }

    private int getNumberOfVisibleCommentsForUser(String username, String issueKey) {
        return ((CommentsWithPaginationBean)((CommentClient)this.commentClient.loginAs((String)username)).getComments((String)issueKey).body).getTotal();
    }

    private void assertCanSeeCommentsOnIssue(String username, String issueKey) {
        Assert.assertTrue((this.getNumberOfVisibleCommentsForUser(username, issueKey) != 0 ? 1 : 0) != 0);
    }

    private void assertCannotSeeCommentsOnIssue(String username, String issueKey) {
        Assert.assertTrue((this.getNumberOfVisibleCommentsForUser(username, issueKey) == 0 ? 1 : 0) != 0);
    }

    private void verifyReplacementWorked(ProjectRole roleReplacement) {
        this.assertFailingStatusCode(() -> this.roleClient.deleteProjectRole(roleReplacement.getId()), Response.Status.CONFLICT);
    }

    private Matcher<PermissionGrantBean> projectRolePermissionGrantBean(final Long roleId) {
        return new TypeSafeMatcher<PermissionGrantBean>(){

            protected boolean matchesSafely(PermissionGrantBean item) {
                return item.getHolder().getType().equals("projectRole") && item.getHolder().getParameter().equals(roleId.toString());
            }

            public void describeTo(Description description) {
                description.appendText("permission grant bean with role type and id equal to").appendValue((Object)roleId);
            }
        };
    }

    private void assertFailingStatusCode(Runnable function, Response.Status statusCode) {
        this.assertFailingStatusCode(function, statusCode, () -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertFailingStatusCode(Runnable function, Response.Status statusCode, Runnable finallyFunction) {
        try {
            function.run();
            Assert.fail((String)("Should result in " + statusCode.toString()));
        }
        catch (WebApplicationException e) {
            Assert.assertEquals((long)statusCode.getStatusCode(), (long)e.getResponse().getStatus());
        }
        finally {
            finallyFunction.run();
        }
    }

    private Matcher<ProjectRole> matchesByNameAndDescription(final ProjectRole expected) {
        return new TypeSafeMatcher<ProjectRole>(){

            public void describeTo(Description description) {
                description.appendText("name: ").appendValue((Object)expected.getName()).appendText("description: ").appendValue((Object)expected.getDescription());
            }

            protected boolean matchesSafely(ProjectRole projectRole) {
                return new EqualsBuilder().append((Object)projectRole.getName(), (Object)expected.getName()).append((Object)projectRole.getDescription(), (Object)expected.getDescription()).isEquals();
            }
        };
    }

    private BaseMatcher<ProjectRole> projectRole(final @Nonnull Long id, final @Nonnull String name, final @Nonnull String description, final @Nonnull String actorName) {
        return new BaseMatcher<ProjectRole>(){

            public boolean matches(Object o) {
                if (!(o instanceof ProjectRole)) {
                    return false;
                }
                ProjectRole changedValue = (ProjectRole)o;
                boolean result = name.equals(changedValue.name) && id.equals(changedValue.id) && description.equals(changedValue.description) && this.containsActor(changedValue.actors, actorName);
                return result;
            }

            public void describeTo(Description descr) {
                descr.appendText(new ProjectRole().name(name).id(id).description(description).toString());
            }

            private boolean containsActor(List<ProjectRole.Actor> actors, String actor) {
                for (ProjectRole.Actor roleActor : actors) {
                    if (!actor.equalsIgnoreCase(roleActor.name)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

