/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.IssueSecuritySchemesControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.IssueSecurityLevels;
import com.atlassian.jira.testkit.client.restclient.ProjectSecurityLevelClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.util.PropertyAssertions;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestSecurityLevelResource
extends BaseJiraRestTest {
    private static final String USER_NAME = "security_level_test_user";
    private String userKey;
    private ProjectSecurityLevelClient projectSecurityLevelClient;
    private IssueSecuritySchemesControl control;

    @Before
    public void setUpTest() {
        this.projectSecurityLevelClient = new ProjectSecurityLevelClient((JIRAEnvironmentData)this.environmentData);
        this.control = this.backdoor.getTestkit().issueSecuritySchemesControl();
        this.backdoor.usersAndGroups().addUser(USER_NAME);
        this.userKey = this.backdoor.usersAndGroups().getUserByName(USER_NAME).getKey();
        this.backdoor.project().addProject("TEST", "TEST", USER_NAME);
    }

    @Test
    public void testGetSecurityLevelsForNonExistingProject() {
        PropertyAssertions.assertWebApplicationException(() -> {
            this.projectSecurityLevelClient.get("NON_EXISTING");
            return null;
        }, Response.Status.NOT_FOUND);
    }

    @Test
    public void testGetSecurityLevelsForExistingProjectWithoutPermissionsForProject() {
        this.backdoor.project().addProject("HIDDEN", "HIDDEN", "admin");
        PropertyAssertions.assertWebApplicationException(() -> {
            ((ProjectSecurityLevelClient)this.projectSecurityLevelClient.anonymous()).get("HIDDEN");
            return null;
        }, Response.Status.NOT_FOUND);
    }

    @Test
    public void testGetNoSecurityLevelsWhenDoesNotHaveSetIssueSecurityPermission() {
        Long schemeId = this.control.createScheme("TestIssueSecurityLevelScheme", "Test");
        Long levelId = this.control.addSecurityLevel(schemeId.longValue(), "TestLevel", "desc");
        this.backdoor.project().setIssueSecurityScheme(this.backdoor.project().getProjectId("TEST"), schemeId);
        this.control.addUserToSecurityLevel(schemeId.longValue(), levelId.longValue(), this.userKey);
        this.projectSecurityLevelClient.loginAs(USER_NAME);
        IssueSecurityLevels levels = this.projectSecurityLevelClient.get("TEST");
        MatcherAssert.assertThat((Object)levels.getLevels(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testGetNoSecurityLevelsWhenNotInSecurityLevelGroup() {
        Long schemeId = this.control.createScheme("TestIssueSecurityLevelScheme", "Test");
        this.control.addSecurityLevel(schemeId.longValue(), "TestLevel", "desc");
        this.backdoor.project().setIssueSecurityScheme(this.backdoor.project().getProjectId("TEST"), schemeId);
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.SET_ISSUE_SECURITY, USER_NAME);
        this.projectSecurityLevelClient.loginAs(USER_NAME);
        IssueSecurityLevels levels = this.projectSecurityLevelClient.get("TEST");
        MatcherAssert.assertThat((Object)levels.getLevels(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testGetSecurityLevelWhenInSecurityLevelGroup() {
        Long schemeId = this.control.createScheme("TestIssueSecurityLevelScheme", "Test");
        Long levelId = this.control.addSecurityLevel(schemeId.longValue(), "TestLevel", "desc");
        this.control.addUserToSecurityLevel(schemeId.longValue(), levelId.longValue(), this.userKey);
        this.backdoor.project().setIssueSecurityScheme(this.backdoor.project().getProjectId("TEST"), schemeId);
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.SET_ISSUE_SECURITY, USER_NAME);
        this.projectSecurityLevelClient.loginAs(USER_NAME);
        IssueSecurityLevels levels = this.projectSecurityLevelClient.get("TEST");
        MatcherAssert.assertThat((Object)levels.getLevels(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testGetSecurityLevelWhenInTwoSecurityLevelGroups() {
        Long schemeId = this.control.createScheme("TestIssueSecurityLevelScheme", "Test");
        Long levelId = this.control.addSecurityLevel(schemeId.longValue(), "TestLevel", "desc");
        this.control.addUserToSecurityLevel(schemeId.longValue(), levelId.longValue(), this.userKey);
        Long levelId2 = this.control.addSecurityLevel(schemeId.longValue(), "TestLevel2", "desc2");
        this.control.addUserToSecurityLevel(schemeId.longValue(), levelId2.longValue(), this.userKey);
        this.backdoor.project().setIssueSecurityScheme(this.backdoor.project().getProjectId("TEST"), schemeId);
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.SET_ISSUE_SECURITY, USER_NAME);
        this.projectSecurityLevelClient.loginAs(USER_NAME);
        IssueSecurityLevels levels = this.projectSecurityLevelClient.get("TEST");
        MatcherAssert.assertThat((Object)levels.getLevels(), (Matcher)Matchers.hasSize((int)2));
    }
}

