/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.testkit.beans.UserDTO;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.UserPropertyClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.util.PropertyAssertions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestUserPropertyResource
extends BaseJiraFuncTest {
    private static AtomicInteger SEQ = new AtomicInteger(1);
    protected UserPropertyClient propertyClient;

    @Before
    public void setUp() {
        this.backdoor.restoreBlankInstance();
        this.backdoor.permissions().addGlobalPermission(27, "jira-developers");
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
        this.propertyClient = new UserPropertyClient(this.environmentData);
    }

    @Test
    public void propertyCanBeSetAndRead() {
        this.propertyClient.put("admin", "myProperty", this.value(5));
        MatcherAssert.assertThat((Object)this.propertyClient.get((String)"admin", (String)"myProperty").value, (Matcher)Matchers.equalTo(this.valueAsMap(5)));
    }

    @Test
    public void propertyCanBeRetrievedByUsernameAndByKeyAfterUsernameWasChanged() {
        this.propertyClient.put("fred", "myProperty", this.value(5));
        this.renameUser("fred", "fred2");
        MatcherAssert.assertThat((Object)this.propertyClient.identifyUserBy((UserPropertyClient.UserIdentificationMode)UserPropertyClient.UserIdentificationMode.username).get((String)"fred2", (String)"myProperty").value, (Matcher)Matchers.equalTo(this.valueAsMap(5)));
        MatcherAssert.assertThat((Object)this.propertyClient.identifyUserBy((UserPropertyClient.UserIdentificationMode)UserPropertyClient.UserIdentificationMode.userKey).get((String)"fred", (String)"myProperty").value, (Matcher)Matchers.equalTo(this.valueAsMap(5)));
    }

    @Test
    public void nonAdminUserIsNotAllowedToModifyOtherUsersProperties() {
        ParsedResponse response = ((EntityPropertyClient)this.propertyClient.loginAs("fred")).put("admin", "rogueProp", this.value(5));
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN.getStatusCode()));
        MatcherAssert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{"User 'fred' does not have permissions to edit properties of user 'admin'"}));
    }

    @Test
    public void regularAdminCanAccessAndModifyOtherUsersProperties() {
        this.createUserWithPermission("globalAdmin", GlobalPermissionKey.ADMINISTER);
        this.propertyClient.loginAs("globalAdmin");
        this.assertCanAccessAndEditPropertiesOf("fred");
    }

    @Test
    public void nonAdminUserCanAccessAndEditTheirOwnProperties() {
        this.propertyClient.loginAs("fred");
        this.assertCanAccessAndEditPropertiesOf("fred");
    }

    @Test
    public void notFoundResponseIsReturnedForNonExistingUsersWhenWeAreAdmin() {
        MatcherAssert.assertThat((Object)this.propertyClient.getKeys((String)"fred").keys, (Matcher)Matchers.hasSize((int)0));
        PropertyAssertions.assertWebApplicationException(() -> {
            ((EntityPropertyClient)this.propertyClient.loginAs("admin")).getKeys("nonExistentUser");
            return null;
        }, Response.Status.NOT_FOUND, "Specified user does not exist or you do not have required permissions");
    }

    @Test
    public void regularAdminIsNotAllowedToEditSystemAdminsProperties() {
        this.createUserWithPermission("regularAdmin", GlobalPermissionKey.ADMINISTER);
        ParsedResponse response = ((EntityPropertyClient)this.propertyClient.loginAs("regularAdmin")).put("admin", "rogueProp", this.value(42));
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN.getStatusCode()));
        MatcherAssert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{"User 'regularAdmin' does not have permissions to edit properties of user 'admin'"}));
    }

    @Test
    public void nonAdminUserIsNotAllowedToAccessOtherUsersProperties() {
        PropertyAssertions.assertWebApplicationException(() -> {
            ((EntityPropertyClient)this.propertyClient.loginAs("fred")).getKeys("admin");
            return null;
        }, Response.Status.FORBIDDEN, "User 'fred' does not have permissions to read properties of user 'admin'");
    }

    @Test
    public void regularAdminIsNotAllowedToReadSystemAdminsProperties() {
        this.createUserWithPermission("regularAdmin", GlobalPermissionKey.ADMINISTER);
        PropertyAssertions.assertWebApplicationException(() -> {
            ((EntityPropertyClient)this.propertyClient.loginAs("regularAdmin")).getKeys("admin");
            return null;
        }, Response.Status.FORBIDDEN);
    }

    @Test
    public void anonymousUserIsNotAllowedToAccessAnyProperties() {
        this.propertyClient.anonymous();
        PropertyAssertions.assertWebApplicationException(() -> {
            this.propertyClient.getKeys("fred");
            return null;
        }, Response.Status.UNAUTHORIZED);
    }

    @Test
    public void propertiesAreClearedAfterUserIsDeleted() {
        this.propertyClient.put("fred", "farewellProp", this.value(-1));
        this.backdoor.usersAndGroups().deleteUser("fred");
        PropertyAssertions.assertWebApplicationException(() -> {
            this.propertyClient.getKeys("fred");
            return null;
        }, Response.Status.NOT_FOUND);
        this.backdoor.usersAndGroups().addUser("fred");
        MatcherAssert.assertThat((Object)this.propertyClient.getKeys((String)"fred").keys, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void notFoundIsReturnedWhenAccessingNonExistentProperty() {
        PropertyAssertions.assertWebApplicationException(() -> {
            this.propertyClient.get("admin", "nonExistentProperty");
            return null;
        }, Response.Status.NOT_FOUND);
    }

    protected final void renameUser(String oldKeyName, String newName) {
        this.backdoor.usersAndGroups().updateUser(new UserDTO(true, 1L, oldKeyName, null, oldKeyName, oldKeyName, newName, Long.valueOf(0L)));
    }

    protected final void assertCanAccessAndEditPropertiesOf(String username) {
        this.propertyClient.put(username, "prop", this.value(42));
        MatcherAssert.assertThat((Object)this.propertyClient.getKeys((String)username).keys, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.propertyClient.get((String)username, (String)"prop").value, (Matcher)Matchers.equalTo(this.valueAsMap(42)));
    }

    protected final void createUserWithPermission(String username, GlobalPermissionKey permission) {
        this.backdoor.usersAndGroups().addUser(username);
        String groupName = "userGroup-" + SEQ.incrementAndGet();
        this.backdoor.usersAndGroups().addGroup(groupName);
        this.backdoor.usersAndGroups().addUserToGroup(username, groupName);
        this.backdoor.permissions().addGlobalPermission(((Integer)GlobalPermissionKey.GLOBAL_PERMISSION_ID_TRANSLATION.inverse().get((Object)permission)).intValue(), groupName);
    }

    protected final JSONObject value(int value) {
        return new JSONObject(this.valueAsMap(value));
    }

    protected final Map<String, Object> valueAsMap(int value) {
        return ImmutableMap.of((Object)"value", (Object)value);
    }
}

