/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.client.WorkflowSchemesControl;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.UserBean;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.WorkflowSchemeClient;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@RestoreOnce(value="TestWorkflowSchemeResource.xml")
public class TestWorkflowSchemeResource
extends BaseJiraRestTest {
    private static final String WF_ONE = "One";
    private static final String WF_TWO = "Two";
    private static final String WF_THREE = "Three";
    private static final String WF_FOUR = "Four";
    private static final String WF_FIVE = "Five";
    private static final String WF_BAD = "This Workflow Does not Exist";
    private static final List<String> WORKFLOWS = ImmutableList.of((Object)"One", (Object)"Two", (Object)"Three", (Object)"Four", (Object)"Five");
    private WorkflowSchemeClient client;

    @Test
    public void testGet() {
        WorkflowSchemeData scheme = new WorkflowSchemeData();
        scheme.setName("testGet").setDescription("testGet");
        scheme.setDefaultWorkflow(WF_ONE).setMapping(IssueType.BUG.name, WF_TWO);
        WorkflowSchemesControl schemesControl = this.backdoor.workflowSchemes();
        scheme = schemesControl.createScheme(scheme);
        SimpleWorkflowScheme expectedScheme = this.asSimpleScheme(scheme.getId());
        Assert.assertThat((Object)expectedScheme, this.equalsScheme(scheme.getId()));
        WorkflowSchemeData draft = schemesControl.createDraft(scheme);
        draft.setDefaultWorkflow(null).setMapping(IssueType.IMPROVMENT.id, WF_FIVE).setMapping(IssueType.NEW_FEATURE.id, WF_ONE);
        schemesControl.updateDraftScheme(scheme.getId().longValue(), draft);
        Assert.assertThat((Object)expectedScheme, this.equalsScheme(scheme.getId()));
        WorkflowSchemeClient.WorkflowScheme actualDraft = this.client.getWorkflowScheme(scheme.getId(), true);
        Assert.assertEquals((Object)"admin", (Object)actualDraft.getLastModifiedUser().name);
        Assert.assertNotNull((Object)actualDraft.getLastModified());
        SimpleWorkflowScheme expectedDraft = this.asSimpleScheme(scheme.getId());
        Assert.assertEquals((Object)expectedDraft, (Object)this.asSimpleScheme(actualDraft));
        schemesControl.discardDraftScheme(scheme.getId().longValue());
        Assert.assertThat((Object)expectedScheme, this.equalsScheme(scheme.getId()));
        Assert.assertThat((Object)expectedScheme, this.equalsDraftScheme(scheme.getId()));
        ParsedResponse<WorkflowSchemeClient.WorkflowScheme> response = this.client.getWorkflowSchemeResponse(2L);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertNull((Object)response.body);
    }

    private Matcher<Object> equalsScheme(Long schemeId) {
        return this.equalsIgnoringLastModified(this.client.getWorkflowScheme(schemeId, false));
    }

    private Matcher<Object> equalsDraftScheme(Long id) {
        return this.equalsIgnoringLastModified(this.client.getWorkflowScheme(id, true));
    }

    private Matcher<Object> equalsIgnoringLastModified(WorkflowSchemeClient.WorkflowScheme workflowScheme) {
        return new ReflectionEquals(this.asSimpleScheme(workflowScheme), "lastModified");
    }

    @Test
    public void testGetDraft() {
        this.client = this.client.asDraft();
        ParsedResponse<WorkflowSchemeClient.WorkflowScheme> response = this.client.getWorkflowSchemeResponse(2L);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        WorkflowSchemeData scheme = new WorkflowSchemeData();
        scheme.setName("testGetDraft");
        scheme.setDefaultWorkflow(WF_ONE).setMapping(IssueType.BUG.name, WF_TWO);
        WorkflowSchemesControl schemesControl = this.backdoor.workflowSchemes();
        scheme = schemesControl.createScheme(scheme);
        String pkey = "TGD";
        this.backdoor.project().addProject("TGD", "TGD", "admin");
        this.backdoor.project().setWorkflowScheme("TGD", scheme.getId());
        response = this.client.getWorkflowSchemeResponse(scheme.getId());
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        schemesControl.createDraft(scheme);
        SimpleWorkflowScheme expectedScheme = this.asSimpleScheme(scheme.getId(), true);
        Assert.assertThat((Object)expectedScheme, this.equalsIgnoringLastModified(this.client.getWorkflowScheme(scheme.getId())));
        schemesControl.discardDraftScheme(scheme.getId().longValue());
        response = this.client.getWorkflowSchemeResponse(scheme.getId());
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.anonymous()).getWorkflowSchemeResponse(scheme.getId());
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).getWorkflowSchemeResponse(scheme.getId());
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testGetNoPermission() {
        WorkflowSchemeData scheme = new WorkflowSchemeData();
        scheme.setName("testGetNoPermission").setDescription("testGetNoPermission");
        scheme.setDefaultWorkflow(WF_ONE).setMapping(IssueType.BUG.name, WF_TWO);
        WorkflowSchemesControl schemesControl = this.backdoor.workflowSchemes();
        scheme = schemesControl.createScheme(scheme);
        ParsedResponse<WorkflowSchemeClient.WorkflowScheme> response = ((WorkflowSchemeClient)this.client.anonymous()).getWorkflowSchemeResponse(scheme.getId());
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).getWorkflowSchemeResponse(scheme.getId());
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testCreateSchemeIssueTypes() {
        this.assertCreateScheme("IssueType", new Function<SimpleWorkflowScheme, WorkflowSchemeClient.WorkflowScheme>(){

            public WorkflowSchemeClient.WorkflowScheme apply(SimpleWorkflowScheme input) {
                return input.asRestBean();
            }
        });
    }

    private void assertCreateScheme(String prefix, Function<SimpleWorkflowScheme, WorkflowSchemeClient.WorkflowScheme> toRest) {
        SimpleWorkflowScheme scheme = new SimpleWorkflowScheme();
        scheme.setName(prefix + "testCreateScheme");
        scheme.setDescription("description");
        scheme.setDefaultWorkflow(WF_ONE);
        scheme.setMapping(IssueType.BUG, WF_TWO);
        scheme.setMapping(IssueType.IMPROVMENT, WF_TWO);
        scheme.setMapping(IssueType.NEW_FEATURE, WF_THREE);
        scheme.setMapping(IssueType.TASK, WF_FIVE);
        ParsedResponse<WorkflowSchemeClient.WorkflowScheme> actualSchemeResponse = this.client.createSchemeResponse((WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme));
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)actualSchemeResponse.statusCode);
        WorkflowSchemeClient.WorkflowScheme actualScheme = (WorkflowSchemeClient.WorkflowScheme)actualSchemeResponse.body;
        Assert.assertNotNull((Object)actualScheme.getId());
        scheme.setId(actualScheme.getId());
        scheme.setSelf(this.selfUri(actualScheme.getId(), false));
        Assert.assertEquals((Object)scheme, (Object)this.asSimpleScheme(actualScheme));
        ParsedResponse<WorkflowSchemeClient.WorkflowScheme> response = this.client.createSchemeResponse((WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme));
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = this.client.createSchemeResponse((WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme.copy().setName(null)));
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        scheme.setName(prefix + "testCreateScheme2");
        response = this.client.createSchemeResponse((WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme.copy().setDefaultWorkflow("badWorkflow")));
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = this.client.createSchemeResponse((WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme.copy().setMapping(IssueType.IMPROVMENT, "random")));
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = this.client.createSchemeResponse((WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme.copy().setMapping(IssueType.BAD, WF_FOUR)));
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.anonymous()).createSchemeResponse((WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme));
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).createSchemeResponse((WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme));
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testDeleteScheme() {
        SimpleWorkflowScheme scheme = new SimpleWorkflowScheme();
        scheme.setName("testDeleteScheme");
        scheme.setDescription("description");
        scheme.setDefaultWorkflow(WF_ONE);
        WorkflowSchemesControl control = this.backdoor.workflowSchemes();
        Long id = control.createScheme(scheme.asBackdoorBean()).getId();
        ParsedResponse<Void> response = this.client.deleteSchemeResponse(id);
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)response.statusCode);
        this.assertSchemeGone(id);
        response = this.client.deleteSchemeResponse(id);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        String pkey = "TDS";
        this.backdoor.project().addProject("testDeleteScheme", "TDS", "admin");
        id = control.createScheme(scheme.asBackdoorBean()).getId();
        this.backdoor.project().setWorkflowScheme("TDS", id);
        response = this.client.deleteSchemeResponse(id);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        this.backdoor.project().deleteProject("TDS");
        response = ((WorkflowSchemeClient)this.client.anonymous()).deleteSchemeResponse(id);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).deleteSchemeResponse(id);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("admin")).deleteSchemeResponse(id);
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)response.statusCode);
        this.assertSchemeGone(id);
    }

    @Test
    public void testDeleteDraftScheme() {
        this.client = this.client.asDraft();
        SimpleWorkflowScheme scheme = new SimpleWorkflowScheme();
        scheme.setName("testDeleteDrafScheme");
        scheme.setDescription("testDeleteDrafScheme");
        scheme.setDefaultWorkflow(WF_ONE);
        WorkflowSchemesControl control = this.backdoor.workflowSchemes();
        WorkflowSchemeData parentData = control.createScheme(scheme.asBackdoorBean());
        long parentId = parentData.getId();
        String pkey = "TDDS";
        this.backdoor.project().addProject("testDeleteDrafScheme", "TDDS", "admin");
        this.backdoor.project().setWorkflowScheme("TDDS", parentId);
        control.createDraft(parentData);
        ParsedResponse<Void> response = this.client.deleteSchemeResponse(parentId);
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)response.statusCode);
        this.assertDraftDoesNotExist(parentId);
        response = this.client.deleteSchemeResponse(parentId);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        control.createDraft(parentData);
        response = ((WorkflowSchemeClient)this.client.anonymous()).deleteSchemeResponse(parentId);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).deleteSchemeResponse(parentId);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("admin")).deleteSchemeResponse(parentId);
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)response.statusCode);
        this.assertDraftDoesNotExist(parentId);
    }

    @Test
    public void testCreateDraft() {
        SimpleWorkflowScheme scheme = new SimpleWorkflowScheme();
        scheme.setName("testCreateDraft");
        scheme.setDescription("testCreateDraft");
        scheme.setDefaultWorkflow(WF_ONE);
        WorkflowSchemesControl control = this.backdoor.workflowSchemes();
        WorkflowSchemeData parentData = control.createScheme(scheme.asBackdoorBean());
        long parentId = parentData.getId();
        String pkey = "TCD";
        this.backdoor.project().addProject("testCreateDraft", "TCD", "admin");
        this.backdoor.project().setWorkflowScheme("TCD", parentId);
        WorkflowSchemeClient.WorkflowScheme draft = this.client.createDraft(parentData.getId());
        scheme.setWorkflowMappings(Maps.newHashMap());
        SimpleWorkflowScheme expectedDraft = this.updateDraftInfo(scheme.copyAsDraft(), draft, parentId);
        Assert.assertEquals((Object)expectedDraft, (Object)this.asSimpleScheme(draft));
        ParsedResponse<WorkflowSchemeClient.WorkflowScheme> response = this.client.createDraftResponse(parentData.getId());
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        control.discardDraftScheme(parentId);
        response = ((WorkflowSchemeClient)this.client.anonymous()).createDraftResponse(parentId);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).createDraftResponse(parentId);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testUpdateIssueType() {
        this.assertUpdate("IssTp", (Function<SimpleWorkflowScheme, WorkflowSchemeClient.WorkflowScheme>)((Function)SimpleWorkflowScheme::asRestBean));
    }

    @Test
    public void testUpdateNoPermission() {
        SimpleWorkflowScheme scheme = new SimpleWorkflowScheme();
        scheme.setName("testUpdateNoPermission");
        scheme.setDescription("testUpdateNoPermission");
        scheme.setDefaultWorkflow(WF_ONE);
        WorkflowSchemesControl control = this.backdoor.workflowSchemes();
        Long id = control.createScheme(scheme.asBackdoorBean()).getId();
        scheme.setId(id);
        SimpleWorkflowScheme updateScheme = new SimpleWorkflowScheme(scheme);
        updateScheme.setName("NewName");
        ParsedResponse<WorkflowSchemeClient.WorkflowScheme> response = ((WorkflowSchemeClient)this.client.anonymous()).updateWorkflowSchemeResponse(updateScheme.asRestBean());
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).updateWorkflowSchemeResponse(updateScheme.asRestBean());
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testUpdateDraft() {
        this.client = this.client.asDraft();
        SimpleWorkflowScheme scheme = new SimpleWorkflowScheme();
        scheme.setName("testUpdateDraft");
        scheme.setDescription("testUpdateDraft");
        scheme.setDefaultWorkflow(WF_ONE).setMapping(IssueType.IMPROVMENT, WF_FIVE);
        WorkflowSchemesControl control = this.backdoor.workflowSchemes();
        Long id = control.createScheme(scheme.asBackdoorBean()).getId();
        scheme.setId(id);
        String pkey = "TUD";
        this.backdoor.project().addProject("TUD", "TUD", "admin");
        this.backdoor.project().setWorkflowScheme("TUD", id);
        SimpleWorkflowScheme draftScheme = new SimpleWorkflowScheme(scheme);
        draftScheme.setMapping(IssueType.NEW_FEATURE, WF_ONE).setDefaultWorkflow(WF_FIVE);
        draftScheme.setName(StringUtils.repeat((String)"&&", (int)255));
        ParsedResponse<WorkflowSchemeClient.WorkflowScheme> response = this.client.updateWorkflowSchemeResponse(draftScheme.asRestBean());
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        this.assertDraftDoesNotExist(id);
        draftScheme.setName("testUpdateDraft2");
        response = this.client.updateWorkflowSchemeResponse(draftScheme.asRestBean());
        SimpleWorkflowScheme expectedScheme = this.updateDraftInfo(scheme.copyAsDraft(), (WorkflowSchemeClient.WorkflowScheme)response.body, id);
        expectedScheme.setName("testUpdateDraft2");
        expectedScheme.setMapping(IssueType.NEW_FEATURE, WF_ONE).setDefaultWorkflow(WF_FIVE);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        Assert.assertNotNull((Object)((WorkflowSchemeClient.WorkflowScheme)response.body).getLastModified());
        Assert.assertThat((Object)expectedScheme, this.equalsIgnoringLastModified((WorkflowSchemeClient.WorkflowScheme)response.body));
        draftScheme.setName("testUpdateDraft4").setDefaultWorkflow(null).clearMappings().setMapping(IssueType.TASK, WF_TWO);
        response = this.client.updateWorkflowSchemeResponse(draftScheme.asRestBean());
        expectedScheme.setName(draftScheme.getName()).clearMappings().setMapping(IssueType.TASK, WF_TWO);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        this.updateDraftInfo(scheme, (WorkflowSchemeClient.WorkflowScheme)response.body, id);
        Assert.assertNotNull((Object)((WorkflowSchemeClient.WorkflowScheme)response.body).getLastModified());
        Assert.assertThat((Object)expectedScheme, this.equalsIgnoringLastModified((WorkflowSchemeClient.WorkflowScheme)response.body));
        draftScheme.setId(Long.MAX_VALUE);
        response = this.client.updateWorkflowSchemeResponse(draftScheme.asRestBean());
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        SimpleWorkflowScheme badScheme = new SimpleWorkflowScheme().setName("GoodName").setId(id);
        WorkflowSchemeData duplicate = control.createScheme(new WorkflowSchemeData().setName("testUpdateDraftDuplicate"));
        response = this.client.updateWorkflowSchemeResponse(badScheme.copy().setName(duplicate.getName()).asRestBean());
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = this.client.updateWorkflowSchemeResponse(badScheme.copy().setDefaultWorkflow(WF_BAD).asRestBean());
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = this.client.updateWorkflowSchemeResponse(badScheme.copy().setMapping(IssueType.IMPROVMENT, WF_BAD).asRestBean());
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = this.client.updateWorkflowSchemeResponse(badScheme.copy().setMapping(IssueType.BAD, WF_FOUR).asRestBean());
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.anonymous()).updateWorkflowSchemeResponse(expectedScheme.asRestBean());
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).updateWorkflowSchemeResponse(expectedScheme.asRestBean());
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    private void assertUpdate(String prefix, Function<SimpleWorkflowScheme, WorkflowSchemeClient.WorkflowScheme> toRest) {
        SimpleWorkflowScheme scheme = new SimpleWorkflowScheme();
        scheme.setName(prefix + "testUpdate");
        scheme.setDescription("testUpdate");
        scheme.setDefaultWorkflow(WF_ONE);
        WorkflowSchemesControl control = this.backdoor.workflowSchemes();
        Long schemId = control.createScheme(scheme.asBackdoorBean()).getId();
        SimpleWorkflowScheme expectedScheme = new SimpleWorkflowScheme(scheme);
        scheme = new SimpleWorkflowScheme().setId(schemId);
        scheme.setName(prefix + "testUpdate2").setDescription("testUpdate2");
        expectedScheme.setId(schemId);
        expectedScheme.setName(scheme.getName()).setDescription(scheme.getDescription());
        expectedScheme.setSelf(this.selfUri(schemId, false));
        expectedScheme.setWorkflowMappings(Maps.newHashMap());
        ParsedResponse<WorkflowSchemeClient.WorkflowScheme> response = this.client.updateWorkflowSchemeResponse((WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme));
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((Object)expectedScheme, (Object)this.asSimpleScheme((WorkflowSchemeClient.WorkflowScheme)response.body));
        scheme = new SimpleWorkflowScheme().setId(schemId);
        scheme.setMapping(IssueType.BUG, WF_ONE).setMapping(IssueType.TASK, WF_TWO);
        expectedScheme.setMapping(IssueType.BUG, WF_ONE).setMapping(IssueType.TASK, WF_TWO);
        response = this.client.updateWorkflowSchemeResponse((WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme));
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        Assert.assertThat((Object)expectedScheme.copyWithDefault(), this.equalsIgnoringLastModified((WorkflowSchemeClient.WorkflowScheme)response.body));
        String pkey = "TUS" + prefix.toUpperCase();
        this.backdoor.project().addProject(prefix + "testUpdate", pkey, "admin");
        this.backdoor.project().setWorkflowScheme(pkey, scheme.getId());
        scheme = new SimpleWorkflowScheme().setId(schemId);
        scheme.setName(prefix + "testUpdate3").setDescription("testUpdate3");
        expectedScheme.setName(scheme.getName()).setDescription(scheme.getDescription());
        response = this.client.updateWorkflowSchemeResponse((WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme));
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        Assert.assertThat((Object)expectedScheme.copyWithDefault(), this.equalsIgnoringLastModified((WorkflowSchemeClient.WorkflowScheme)response.body));
        scheme = new SimpleWorkflowScheme().setId(schemId);
        scheme.setDefaultWorkflow(WF_FOUR).setMapping(IssueType.IMPROVMENT, WF_TWO);
        response = this.client.updateWorkflowSchemeResponse((WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme));
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        Assert.assertThat((Object)expectedScheme.copyWithDefault(), (Matcher)new ReflectionEquals(this.asSimpleScheme(schemId), "lastModified"));
        WorkflowSchemeClient.WorkflowScheme restBean = (WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme);
        restBean.setUpdateDraftIfNeeded(true);
        expectedScheme.setDraft(true);
        expectedScheme.setSelf(this.selfUri(schemId, true));
        expectedScheme.clearMappings().setDefaultWorkflow(WF_FOUR).setMapping(IssueType.IMPROVMENT, WF_TWO);
        expectedScheme.setOriginalDefaultWorkflow(WF_ONE);
        expectedScheme.setOriginalMapping(IssueType.BUG, WF_ONE);
        expectedScheme.setOriginalMapping(IssueType.TASK, WF_TWO);
        response = this.client.updateWorkflowSchemeResponse(restBean);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        SimpleWorkflowScheme actualScheme = this.asSimpleScheme((WorkflowSchemeClient.WorkflowScheme)response.body);
        Assert.assertNotNull((Object)actualScheme.getLastModifiedUser());
        Assert.assertNotNull((Object)actualScheme.getLastModified());
        expectedScheme.setLastModified(actualScheme.getLastModified());
        expectedScheme.setLastModifiedUser(actualScheme.getLastModifiedUser());
        expectedScheme.setId(actualScheme.getId());
        Assert.assertEquals((Object)expectedScheme.copyWithDefault(), (Object)actualScheme);
        scheme.setMapping(IssueType.NEW_FEATURE, WF_FIVE).setDefaultWorkflow(WF_FIVE);
        scheme.setName(StringUtils.repeat((String)"&&", (int)255));
        restBean = (WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme);
        restBean.setUpdateDraftIfNeeded(true);
        response = this.client.updateWorkflowSchemeResponse(restBean);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        scheme.setName(prefix + "testUpdate4");
        restBean = (WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme);
        restBean.setUpdateDraftIfNeeded(true);
        expectedScheme.setName(scheme.getName()).setDefaultWorkflow(WF_FIVE).setMapping(IssueType.NEW_FEATURE, WF_FIVE);
        response = this.client.updateWorkflowSchemeResponse(restBean);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        actualScheme = this.asSimpleScheme((WorkflowSchemeClient.WorkflowScheme)response.body);
        Assert.assertNotNull((Object)actualScheme.getLastModifiedUser());
        Assert.assertNotNull((Object)actualScheme.getLastModified());
        expectedScheme.setLastModified(actualScheme.getLastModified());
        expectedScheme.setLastModifiedUser(actualScheme.getLastModifiedUser());
        Assert.assertEquals((Object)expectedScheme.copyWithDefault(), (Object)actualScheme);
        scheme = new SimpleWorkflowScheme().setId(schemId);
        scheme.setDefaultWorkflow(WF_THREE);
        response = this.client.updateWorkflowSchemeResponse((WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme));
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        Assert.assertThat((Object)expectedScheme.copyWithDefault(), (Matcher)new ReflectionEquals(this.asSimpleScheme(schemId), "lastModified"));
        control.discardDraftScheme(schemId.longValue());
        WorkflowSchemeData duplicate = control.createScheme(new WorkflowSchemeData().setName(prefix + "Duplicate"));
        response = this.client.updateWorkflowSchemeResponse((WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme.copy().setName(null)));
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = this.client.updateWorkflowSchemeResponse((WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme.copy().setName(duplicate.getName())));
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = this.client.updateWorkflowSchemeResponse((WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme.copy().setDefaultWorkflow(WF_BAD)));
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = this.client.updateWorkflowSchemeResponse((WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme.copy().setMapping(IssueType.IMPROVMENT, WF_BAD)));
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = this.client.updateWorkflowSchemeResponse((WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme.copy().setMapping(IssueType.BAD, WF_FOUR)));
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.anonymous()).updateWorkflowSchemeResponse((WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme));
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).updateWorkflowSchemeResponse((WorkflowSchemeClient.WorkflowScheme)toRest.apply((Object)scheme));
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testGetWorkflowMappings() {
        WorkflowSchemeData scheme = new WorkflowSchemeData();
        scheme.setName("testGetWorkflowMappings").setDescription("test Get Description");
        scheme.setDefaultWorkflow(WF_ONE).setMapping(IssueType.BUG.name, WF_TWO).setMapping(IssueType.TASK.name, WF_TWO).setMapping(IssueType.NEW_FEATURE.name, WF_THREE);
        WorkflowSchemesControl schemesControl = this.backdoor.workflowSchemes();
        scheme = schemesControl.createScheme(scheme);
        SimpleWorkflowScheme expectedScheme = this.asSimpleScheme(scheme.getId());
        Assert.assertEquals(expectedScheme.getWorkflowMappings(), this.asWorkflowMap(this.client.getWorkflowMappings(scheme.getId(), false)));
        this.assertGetWorkflowMapping(expectedScheme, scheme.getId(), false);
        this.assertGetWorkflowMapping(expectedScheme, scheme.getId(), true);
        String pkey = "TGWM";
        this.backdoor.project().addProject("TGWM", "TGWM", "admin");
        this.backdoor.project().setWorkflowScheme("TGWM", scheme.getId());
        WorkflowSchemeData draft = schemesControl.createDraft(scheme);
        draft.setDefaultWorkflow(null).setMapping(IssueType.IMPROVMENT.id, WF_FIVE).setMapping(IssueType.NEW_FEATURE.id, WF_ONE).setMapping(IssueType.BUG.id, WF_ONE);
        schemesControl.updateDraftScheme(scheme.getId().longValue(), draft);
        Assert.assertEquals(expectedScheme.getWorkflowMappings(), this.asWorkflowMap(this.client.getWorkflowMappings(scheme.getId(), false)));
        this.assertGetWorkflowMapping(expectedScheme, scheme.getId(), false);
        WorkflowSchemeClient.WorkflowScheme actualDraft = this.client.getWorkflowScheme(scheme.getId(), true);
        Assert.assertEquals((Object)"admin", (Object)actualDraft.getLastModifiedUser().name);
        Assert.assertNotNull((Object)actualDraft.getLastModified());
        SimpleWorkflowScheme expectedDraft = this.asSimpleScheme(scheme.getId());
        Assert.assertEquals(expectedDraft.getWorkflowMappings(), this.asWorkflowMap(this.client.getWorkflowMappings(scheme.getId(), true)));
        this.assertGetWorkflowMapping(expectedDraft, scheme.getId(), true);
        schemesControl.discardDraftScheme(scheme.getId().longValue());
        Assert.assertEquals(expectedScheme.getWorkflowMappings(), this.asWorkflowMap(this.client.getWorkflowMappings(scheme.getId(), false)));
        Assert.assertEquals(expectedScheme.getWorkflowMappings(), this.asWorkflowMap(this.client.getWorkflowMappings(scheme.getId(), true)));
        this.assertGetWorkflowMapping(expectedScheme, scheme.getId(), false);
        this.assertGetWorkflowMapping(expectedScheme, scheme.getId(), true);
        Object response = this.client.getWorkflowMappingsResponse(2L, true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertNull((Object)response.body);
        response = this.client.getWorkflowMappingResponse(scheme.getId(), WF_BAD, true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.anonymous()).getWorkflowMappingsResponse(scheme.getId(), false);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).getWorkflowMappingsResponse(scheme.getId(), false);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testGetDraftWorkflowMappings() {
        this.client = this.client.asDraft();
        WorkflowSchemeData scheme = new WorkflowSchemeData();
        scheme.setName("testGetDraftWorkflowMappings").setDescription("testGetDraftWorkflowMappings");
        scheme.setDefaultWorkflow(WF_ONE).setMapping(IssueType.BUG.name, WF_TWO).setMapping(IssueType.TASK.name, WF_TWO).setMapping(IssueType.NEW_FEATURE.name, WF_THREE);
        WorkflowSchemesControl schemesControl = this.backdoor.workflowSchemes();
        scheme = schemesControl.createScheme(scheme);
        String pkey = "TGDWM";
        this.backdoor.project().addProject("TGDWM", "TGDWM", "admin");
        this.backdoor.project().setWorkflowScheme("TGDWM", scheme.getId());
        schemesControl.createDraft(scheme);
        WorkflowSchemeData draftScheme = new WorkflowSchemeData().setDefaultWorkflow(WF_FIVE).setMapping(IssueType.BUG.name, WF_THREE).setMapping(IssueType.TASK.name, WF_FOUR).setMapping(IssueType.NEW_FEATURE.name, WF_THREE);
        schemesControl.updateDraftScheme(scheme.getId().longValue(), draftScheme);
        SimpleWorkflowScheme expectedScheme = this.asSimpleScheme(scheme.getId());
        Assert.assertEquals(expectedScheme.getWorkflowMappings(), this.asWorkflowMap(this.client.getWorkflowMappings(scheme.getId(), false)));
        this.assertGetWorkflowMapping(expectedScheme, scheme.getId(), false);
        schemesControl.discardDraftScheme(scheme.getId().longValue());
        Object response = this.client.getWorkflowMappingsResponse(scheme.getId(), false);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertNull((Object)response.body);
        response = this.client.getWorkflowMappingsResponse(2L, true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertNull((Object)response.body);
        response = this.client.getWorkflowMappingResponse(scheme.getId(), WF_BAD, true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.anonymous()).getWorkflowMappingsResponse(scheme.getId(), false);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).getWorkflowMappingsResponse(scheme.getId(), false);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testDeleteWorkflowMapping() {
        WorkflowSchemeData scheme = new WorkflowSchemeData();
        scheme.setName("testDeleteWorkflowMapping").setDescription("testDeleteWorkflowMapping");
        scheme.setDefaultWorkflow(WF_ONE).setMapping(IssueType.BUG.name, WF_TWO).setMapping(IssueType.TASK.name, WF_TWO).setMapping(IssueType.NEW_FEATURE.name, WF_THREE);
        WorkflowSchemesControl schemesControl = this.backdoor.workflowSchemes();
        scheme = schemesControl.createScheme(scheme);
        SimpleWorkflowScheme expectedScheme = this.asSimpleScheme(scheme.getId()).removeWorkflow(WF_TWO);
        Assert.assertEquals((Object)expectedScheme, (Object)this.asSimpleScheme(this.client.deleteWorkflowMapping(scheme.getId(), WF_TWO, false)));
        String pkey = "TDWM";
        this.backdoor.project().addProject("TDWM", "TDWM", "admin");
        this.backdoor.project().setWorkflowScheme("TDWM", scheme.getId());
        ParsedResponse<WorkflowSchemeClient.WorkflowScheme> response = this.client.deleteWorkflowMappingResponse(scheme.getId(), WF_THREE, false);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        SimpleWorkflowScheme draftScheme = expectedScheme.copyAsDraft();
        response = this.client.deleteWorkflowMappingResponse(scheme.getId(), WF_THREE, true);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        this.updateDraftInfo(draftScheme, (WorkflowSchemeClient.WorkflowScheme)response.body, scheme.getId());
        Assert.assertEquals((Object)draftScheme.removeWorkflow(WF_THREE), (Object)this.asSimpleScheme((WorkflowSchemeClient.WorkflowScheme)response.body));
        response = this.client.deleteWorkflowMappingResponse(scheme.getId(), WF_ONE, true);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        this.updateDraftInfo(draftScheme.removeWorkflow(WF_ONE), (WorkflowSchemeClient.WorkflowScheme)response.body, scheme.getId());
        Assert.assertEquals((Object)draftScheme.copyWithDefault(), (Object)this.asSimpleScheme((WorkflowSchemeClient.WorkflowScheme)response.body));
        response = this.client.deleteWorkflowMappingResponse(scheme.getId(), WF_FIVE, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        Assert.assertThat((Object)expectedScheme.copyWithDefault(), this.equalsIgnoringLastModified((WorkflowSchemeClient.WorkflowScheme)response.body));
        response = this.client.deleteWorkflowMappingResponse(2L, WF_THREE, true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertNull((Object)response.body);
        response = this.client.deleteWorkflowMappingResponse(scheme.getId(), WF_BAD, true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.anonymous()).deleteWorkflowMappingResponse(scheme.getId(), WF_TWO, false);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).deleteWorkflowMappingResponse(scheme.getId(), WF_TWO, false);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testDeleteDraftWorkflowMapping() {
        this.client = this.client.asDraft();
        WorkflowSchemeData scheme = new WorkflowSchemeData();
        scheme.setName("testDeleteDraftWorkflowMapping").setDescription("testDeleteDraftWorkflowMapping");
        scheme.setDefaultWorkflow(WF_ONE).setMapping(IssueType.BUG.name, WF_TWO).setMapping(IssueType.TASK.name, WF_TWO).setMapping(IssueType.NEW_FEATURE.name, WF_THREE);
        WorkflowSchemesControl schemesControl = this.backdoor.workflowSchemes();
        scheme = schemesControl.createScheme(scheme);
        String pkey = "TDDWM";
        this.backdoor.project().addProject("TDDWM", "TDDWM", "admin");
        this.backdoor.project().setWorkflowScheme("TDDWM", scheme.getId());
        schemesControl.createDraft(scheme);
        WorkflowSchemeData draftScheme = new WorkflowSchemeData().setDefaultWorkflow(WF_FIVE).setMapping(IssueType.BUG.name, WF_THREE).setMapping(IssueType.TASK.name, WF_FOUR).setMapping(IssueType.NEW_FEATURE.name, WF_THREE);
        schemesControl.updateDraftScheme(scheme.getId().longValue(), draftScheme);
        SimpleWorkflowScheme expectedScheme = this.asSimpleScheme(scheme.getId()).removeWorkflow(WF_THREE);
        WorkflowSchemeClient.WorkflowScheme data = this.client.deleteWorkflowMapping(scheme.getId(), WF_THREE, false);
        this.updateDraftInfo(expectedScheme, data, scheme.getId());
        Assert.assertThat((Object)expectedScheme.copyWithDefault(), this.equalsIgnoringLastModified(data));
        ParsedResponse<WorkflowSchemeClient.WorkflowScheme> response = this.client.deleteWorkflowMappingResponse(scheme.getId(), WF_FIVE, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        this.updateDraftInfo(expectedScheme.removeWorkflow(WF_FIVE), (WorkflowSchemeClient.WorkflowScheme)response.body, scheme.getId());
        Assert.assertThat((Object)expectedScheme.copyWithDefault(), this.equalsIgnoringLastModified((WorkflowSchemeClient.WorkflowScheme)response.body));
        response = this.client.deleteWorkflowMappingResponse(scheme.getId(), WF_FIVE, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        Assert.assertThat((Object)expectedScheme.copyWithDefault(), this.equalsIgnoringLastModified((WorkflowSchemeClient.WorkflowScheme)response.body));
        response = this.client.deleteWorkflowMappingResponse(2L, WF_THREE, true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertNull((Object)response.body);
        response = this.client.deleteWorkflowMappingResponse(scheme.getId(), WF_BAD, true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.anonymous()).deleteWorkflowMappingResponse(scheme.getId(), WF_TWO, false);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).deleteWorkflowMappingResponse(scheme.getId(), WF_TWO, false);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testUpdateWorkflowMapping() {
        WorkflowSchemeData scheme = new WorkflowSchemeData();
        scheme.setName("testUpdateWorkflowMapping").setDescription("testUpdateWorkflowMapping");
        scheme.setDefaultWorkflow(WF_ONE).setMapping(IssueType.BUG.name, WF_TWO).setMapping(IssueType.TASK.name, WF_TWO).setMapping(IssueType.NEW_FEATURE.name, WF_THREE);
        WorkflowSchemesControl schemesControl = this.backdoor.workflowSchemes();
        scheme = schemesControl.createScheme(scheme);
        SimpleWorkflowScheme expectedScheme = this.asSimpleScheme(scheme.getId());
        WorkflowSchemeClient.WorkflowMapping mapping = new WorkflowSchemeClient.WorkflowMapping(WF_TWO);
        mapping.setIssueTypes(Sets.newHashSet((Object[])new String[]{IssueType.TASK.id}));
        expectedScheme.removeMapping(IssueType.BUG);
        Assert.assertThat((Object)expectedScheme, this.equalsIgnoringLastModified(this.client.updateWorkflowMapping(scheme.getId(), mapping)));
        mapping = new WorkflowSchemeClient.WorkflowMapping(WF_BAD);
        mapping.setDefaultMapping(true);
        expectedScheme.setDefaultWorkflow(WF_TWO);
        Assert.assertThat((Object)expectedScheme, this.equalsIgnoringLastModified(this.client.updateWorkflowMapping(scheme.getId(), WF_TWO, mapping)));
        String pkey = "TUWM";
        this.backdoor.project().addProject("TUWM", "TUWM", "admin");
        this.backdoor.project().setWorkflowScheme("TUWM", scheme.getId());
        mapping.setWorkflow(WF_TWO);
        Assert.assertThat((Object)expectedScheme, this.equalsIgnoringLastModified(this.client.updateWorkflowMapping(scheme.getId(), mapping)));
        mapping = new WorkflowSchemeClient.WorkflowMapping(WF_FIVE);
        mapping.setDefaultMapping(false);
        mapping.setIssueTypes(Sets.newHashSet((Object[])new String[]{IssueType.BUG.id, IssueType.IMPROVMENT.id}));
        ParsedResponse<WorkflowSchemeClient.WorkflowScheme> response = this.client.updateWorkflowMappingResponse(scheme.getId(), mapping);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        mapping.setUpdateDraftIfNeeded(true);
        SimpleWorkflowScheme expectedDraft = expectedScheme.copyAsDraft();
        expectedDraft.setMapping(IssueType.BUG, WF_FIVE);
        expectedDraft.setMapping(IssueType.IMPROVMENT, WF_FIVE);
        WorkflowSchemeClient.WorkflowScheme actualDraft = this.client.updateWorkflowMapping(scheme.getId(), mapping);
        this.updateDraftInfo(expectedDraft, actualDraft, scheme.getId());
        Assert.assertEquals((Object)expectedDraft, (Object)this.asSimpleScheme(actualDraft));
        mapping = new WorkflowSchemeClient.WorkflowMapping(WF_BAD);
        mapping.setUpdateDraftIfNeeded(true);
        mapping.setIssueTypes(Sets.newHashSet());
        expectedDraft.removeWorkflow(WF_FIVE);
        actualDraft = this.client.updateWorkflowMapping(scheme.getId(), WF_FIVE, mapping);
        this.updateDraftInfo(expectedDraft, actualDraft, scheme.getId());
        Assert.assertEquals((Object)expectedDraft, (Object)this.asSimpleScheme(actualDraft));
        mapping = new WorkflowSchemeClient.WorkflowMapping(WF_FOUR);
        mapping.setDefaultMapping(true);
        mapping.setUpdateDraftIfNeeded(true);
        expectedDraft.setDefaultWorkflow(WF_FOUR);
        actualDraft = this.client.updateWorkflowMapping(scheme.getId(), mapping);
        this.updateDraftInfo(expectedDraft, actualDraft, scheme.getId());
        Assert.assertEquals((Object)expectedDraft, (Object)this.asSimpleScheme(actualDraft));
        mapping = new WorkflowSchemeClient.WorkflowMapping(WF_ONE);
        mapping.setDefaultMapping(true);
        mapping = new WorkflowSchemeClient.WorkflowMapping(WF_FOUR);
        mapping.setIssueTypes(Sets.newHashSet((Object[])new String[]{IssueType.BUG.id}));
        mapping.setUpdateDraftIfNeeded(true);
        expectedDraft.setMapping(IssueType.BUG, WF_FOUR);
        actualDraft = this.client.updateWorkflowMapping(scheme.getId(), mapping);
        this.updateDraftInfo(expectedDraft, actualDraft, scheme.getId());
        Assert.assertEquals((Object)expectedDraft, (Object)this.asSimpleScheme(actualDraft));
        mapping = new WorkflowSchemeClient.WorkflowMapping(WF_ONE);
        mapping.setDefaultMapping(true);
        response = this.client.updateWorkflowMappingResponse(2L, mapping);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertNull((Object)response.body);
        mapping = new WorkflowSchemeClient.WorkflowMapping(WF_BAD);
        mapping.setDefaultMapping(true);
        response = this.client.updateWorkflowMappingResponse(scheme.getId(), mapping);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        mapping = new WorkflowSchemeClient.WorkflowMapping(WF_FOUR);
        mapping.setIssueTypes(Sets.newHashSet((Object[])new String[]{IssueType.BAD.id}));
        mapping.setDefaultMapping(true);
        response = this.client.updateWorkflowMappingResponse(scheme.getId(), mapping);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.anonymous()).updateWorkflowMappingResponse(scheme.getId(), mapping);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).updateWorkflowMappingResponse(scheme.getId(), mapping);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testUpdateDraftWorkflowMapping() {
        this.client = this.client.asDraft();
        WorkflowSchemeData scheme = new WorkflowSchemeData();
        scheme.setName("testUpdateDraftWorkflowMapping").setDescription("testUpdateDraftWorkflowMapping");
        scheme.setDefaultWorkflow(WF_ONE).setMapping(IssueType.BUG.name, WF_TWO).setMapping(IssueType.TASK.name, WF_TWO).setMapping(IssueType.NEW_FEATURE.name, WF_THREE);
        WorkflowSchemesControl schemesControl = this.backdoor.workflowSchemes();
        scheme = schemesControl.createScheme(scheme);
        String pkey = "TUDWM";
        this.backdoor.project().addProject("TUDWM", "TUDWM", "admin");
        this.backdoor.project().setWorkflowScheme("TUDWM", scheme.getId());
        schemesControl.createDraft(scheme);
        WorkflowSchemeData draftScheme = new WorkflowSchemeData().setDefaultWorkflow(WF_FIVE).setMapping(IssueType.BUG.name, WF_THREE).setMapping(IssueType.TASK.name, WF_FOUR).setMapping(IssueType.NEW_FEATURE.name, WF_THREE);
        schemesControl.updateDraftScheme(scheme.getId().longValue(), draftScheme);
        SimpleWorkflowScheme expectedScheme = this.asSimpleScheme(scheme.getId());
        WorkflowSchemeClient.WorkflowMapping mapping = new WorkflowSchemeClient.WorkflowMapping(WF_THREE);
        mapping.setIssueTypes(Sets.newHashSet((Object[])new String[]{IssueType.TASK.id}));
        expectedScheme.removeMapping(IssueType.BUG).removeMapping(IssueType.NEW_FEATURE).setMapping(IssueType.TASK, WF_THREE);
        WorkflowSchemeClient.WorkflowScheme actualData = this.client.updateWorkflowMapping(scheme.getId(), mapping);
        this.updateDraftInfo(expectedScheme, actualData, scheme.getId());
        Assert.assertEquals((Object)expectedScheme, (Object)this.asSimpleScheme(actualData));
        mapping = new WorkflowSchemeClient.WorkflowMapping(WF_TWO);
        mapping.setDefaultMapping(true);
        expectedScheme.setDefaultWorkflow(WF_TWO);
        actualData = this.client.updateWorkflowMapping(scheme.getId(), mapping);
        this.updateDraftInfo(expectedScheme, actualData, scheme.getId());
        Assert.assertEquals((Object)expectedScheme, (Object)this.asSimpleScheme(actualData));
        mapping = new WorkflowSchemeClient.WorkflowMapping(WF_BAD);
        mapping.setDefaultMapping(false);
        mapping.setIssueTypes(Sets.newHashSet((Object[])new String[]{IssueType.IMPROVMENT.id, IssueType.NEW_FEATURE.id}));
        expectedScheme.setDefaultWorkflow(null).setMapping(IssueType.IMPROVMENT, WF_TWO).setMapping(IssueType.NEW_FEATURE, WF_TWO);
        actualData = this.client.updateWorkflowMapping(scheme.getId(), WF_TWO, mapping);
        this.updateDraftInfo(expectedScheme, actualData, scheme.getId());
        Assert.assertEquals((Object)expectedScheme.copyWithDefault(), (Object)this.asSimpleScheme(actualData));
        mapping = new WorkflowSchemeClient.WorkflowMapping(WF_THREE);
        mapping.setDefaultMapping(true);
        mapping.setIssueTypes(Sets.newHashSet((Object[])new String[]{IssueType.IMPROVMENT.id}));
        expectedScheme.setDefaultWorkflow(WF_THREE).removeMapping(IssueType.TASK).setMapping(IssueType.IMPROVMENT, WF_THREE);
        actualData = this.client.updateWorkflowMapping(scheme.getId(), mapping);
        this.updateDraftInfo(expectedScheme, actualData, scheme.getId());
        Assert.assertEquals((Object)expectedScheme.copyWithDefault(), (Object)this.asSimpleScheme(actualData));
        mapping = new WorkflowSchemeClient.WorkflowMapping(WF_FOUR);
        mapping.setIssueTypes(Sets.newHashSet((Object[])new String[]{IssueType.BUG.id}));
        mapping.setUpdateDraftIfNeeded(true);
        expectedScheme.setMapping(IssueType.BUG, WF_FOUR);
        actualData = this.client.updateWorkflowMapping(scheme.getId(), mapping);
        this.updateDraftInfo(expectedScheme, actualData, scheme.getId());
        Assert.assertEquals((Object)expectedScheme, (Object)this.asSimpleScheme(actualData));
        mapping = new WorkflowSchemeClient.WorkflowMapping(WF_ONE);
        mapping.setDefaultMapping(true);
        mapping = new WorkflowSchemeClient.WorkflowMapping(WF_ONE);
        mapping.setDefaultMapping(true);
        ParsedResponse<WorkflowSchemeClient.WorkflowScheme> response = this.client.updateWorkflowMappingResponse(2L, mapping);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertNull((Object)response.body);
        mapping = new WorkflowSchemeClient.WorkflowMapping(WF_BAD);
        mapping.setDefaultMapping(true);
        response = this.client.updateWorkflowMappingResponse(scheme.getId(), mapping);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        mapping = new WorkflowSchemeClient.WorkflowMapping(WF_FOUR);
        mapping.setIssueTypes(Sets.newHashSet((Object[])new String[]{IssueType.BAD.id}));
        mapping.setDefaultMapping(true);
        response = this.client.updateWorkflowMappingResponse(scheme.getId(), mapping);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.anonymous()).updateWorkflowMappingResponse(scheme.getId(), mapping);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).updateWorkflowMappingResponse(scheme.getId(), mapping);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testGetIssueTypeMapping() {
        WorkflowSchemeData scheme = new WorkflowSchemeData();
        scheme.setName("testGetIssueTypeMapping").setDescription("testGetIssueTypeMapping");
        scheme.setDefaultWorkflow(WF_ONE).setMapping(IssueType.BUG.name, WF_TWO).setMapping(IssueType.TASK.name, WF_TWO).setMapping(IssueType.NEW_FEATURE.name, WF_THREE);
        WorkflowSchemesControl schemesControl = this.backdoor.workflowSchemes();
        scheme = schemesControl.createScheme(scheme);
        SimpleWorkflowScheme expectedScheme = this.asSimpleScheme(scheme.getId());
        this.assertIssueTypeMapping(expectedScheme, scheme.getId(), false);
        this.assertIssueTypeMapping(expectedScheme, scheme.getId(), true);
        String pkey = "TGITM";
        this.backdoor.project().addProject("TGITM", "TGITM", "admin");
        this.backdoor.project().setWorkflowScheme("TGITM", scheme.getId());
        WorkflowSchemeData draft = schemesControl.createDraft(scheme);
        draft.setDefaultWorkflow(null).setMapping(IssueType.IMPROVMENT.id, WF_FIVE).setMapping(IssueType.NEW_FEATURE.id, WF_ONE).setMapping(IssueType.BUG.id, WF_ONE);
        schemesControl.updateDraftScheme(scheme.getId().longValue(), draft);
        this.assertIssueTypeMapping(expectedScheme, scheme.getId(), false);
        WorkflowSchemeClient.WorkflowScheme actualDraft = this.client.getWorkflowScheme(scheme.getId(), true);
        Assert.assertEquals((Object)"admin", (Object)actualDraft.getLastModifiedUser().name);
        Assert.assertNotNull((Object)actualDraft.getLastModified());
        SimpleWorkflowScheme expectedDraft = this.asSimpleScheme(scheme.getId());
        this.assertIssueTypeMapping(expectedDraft, scheme.getId(), true);
        schemesControl.discardDraftScheme(scheme.getId().longValue());
        this.assertIssueTypeMapping(expectedScheme, scheme.getId(), false);
        this.assertIssueTypeMapping(expectedScheme, scheme.getId(), true);
        ParsedResponse<WorkflowSchemeClient.IssueTypeMappingBean> response = this.client.getIssueTypeMappingResponse(2L, IssueType.BAD.getId(), true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertNull((Object)response.body);
        response = this.client.getIssueTypeMappingResponse(scheme.getId(), IssueType.BAD.getId(), true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.anonymous()).getIssueTypeMappingResponse(scheme.getId(), IssueType.BUG.getId(), false);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).getIssueTypeMappingResponse(scheme.getId(), IssueType.BUG.getId(), false);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testGetDraftIssueTypeMapping() {
        this.client = this.client.asDraft();
        WorkflowSchemeData scheme = new WorkflowSchemeData();
        scheme.setName("testGetDraftIssueTypeMapping").setDescription("testGetDraftIssueTypeMapping");
        scheme.setDefaultWorkflow(WF_ONE).setMapping(IssueType.BUG.name, WF_TWO).setMapping(IssueType.TASK.name, WF_TWO).setMapping(IssueType.NEW_FEATURE.name, WF_THREE);
        WorkflowSchemesControl schemesControl = this.backdoor.workflowSchemes();
        scheme = schemesControl.createScheme(scheme);
        String pkey = "TGDITM";
        this.backdoor.project().addProject("TGDITM", "TGDITM", "admin");
        this.backdoor.project().setWorkflowScheme("TGDITM", scheme.getId());
        WorkflowSchemeData draft = schemesControl.createDraft(scheme);
        draft.setDefaultWorkflow(null).setMapping(IssueType.IMPROVMENT.id, WF_FIVE).setMapping(IssueType.NEW_FEATURE.id, WF_ONE).setMapping(IssueType.BUG.id, WF_ONE);
        schemesControl.updateDraftScheme(scheme.getId().longValue(), draft);
        SimpleWorkflowScheme expectedScheme = this.asSimpleScheme(scheme.getId());
        this.assertIssueTypeMapping(expectedScheme, scheme.getId(), false);
        ParsedResponse<WorkflowSchemeClient.IssueTypeMappingBean> response = this.client.getIssueTypeMappingResponse(2L, IssueType.BAD.getId(), true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertNull((Object)response.body);
        response = this.client.getIssueTypeMappingResponse(scheme.getId(), IssueType.BAD.getId(), true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.anonymous()).getIssueTypeMappingResponse(scheme.getId(), IssueType.BUG.getId(), false);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).getIssueTypeMappingResponse(scheme.getId(), IssueType.BUG.getId(), false);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testDeleteIssueTypeMapping() {
        WorkflowSchemeData scheme = new WorkflowSchemeData();
        scheme.setName("testDeleteIssueTypeMapping").setDescription("testDeleteIssueTypeMapping");
        scheme.setDefaultWorkflow(WF_ONE).setMapping(IssueType.BUG.name, WF_TWO).setMapping(IssueType.TASK.name, WF_TWO).setMapping(IssueType.NEW_FEATURE.name, WF_THREE);
        WorkflowSchemesControl schemesControl = this.backdoor.workflowSchemes();
        scheme = schemesControl.createScheme(scheme);
        SimpleWorkflowScheme expectedScheme = this.asSimpleScheme(scheme.getId()).removeMapping(IssueType.BUG);
        Assert.assertEquals((Object)expectedScheme, (Object)this.asSimpleScheme(this.client.deleteIssueMapping(scheme.getId(), IssueType.BUG.id, false)));
        Assert.assertEquals((Object)expectedScheme, (Object)this.asSimpleScheme(this.client.deleteIssueMapping(scheme.getId(), IssueType.BUG.id, false)));
        String pkey = "TDITM";
        this.backdoor.project().addProject("TDITM", "TDITM", "admin");
        this.backdoor.project().setWorkflowScheme("TDITM", scheme.getId());
        ParsedResponse<WorkflowSchemeClient.WorkflowScheme> response = this.client.deleteIssueMappingResponse(scheme.getId(), IssueType.TASK.id, false);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        SimpleWorkflowScheme draftScheme = expectedScheme.copyAsDraft();
        response = this.client.deleteIssueMappingResponse(scheme.getId(), IssueType.TASK.id, true);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        this.updateDraftInfo(draftScheme, (WorkflowSchemeClient.WorkflowScheme)response.body, scheme.getId());
        Assert.assertEquals((Object)draftScheme.removeMapping(IssueType.TASK), (Object)this.asSimpleScheme((WorkflowSchemeClient.WorkflowScheme)response.body));
        response = this.client.deleteIssueMappingResponse(scheme.getId(), IssueType.IMPROVMENT.id, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        Assert.assertThat((Object)expectedScheme, this.equalsIgnoringLastModified((WorkflowSchemeClient.WorkflowScheme)response.body));
        response = this.client.deleteIssueMappingResponse(2L, IssueType.NEW_FEATURE.id, true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertNull((Object)response.body);
        response = this.client.deleteIssueMappingResponse(scheme.getId(), IssueType.BAD.id, true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.anonymous()).deleteIssueMappingResponse(scheme.getId(), IssueType.BUG.id, false);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).deleteIssueMappingResponse(scheme.getId(), IssueType.BUG.id, false);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testDeleteDraftIssueTypeMapping() {
        this.client = this.client.asDraft();
        WorkflowSchemeData scheme = new WorkflowSchemeData();
        scheme.setName("testDeleteDraftIssueTypeMapping").setDescription("testDeleteDraftIssueTypeMapping");
        scheme.setDefaultWorkflow(WF_ONE).setMapping(IssueType.BUG.name, WF_TWO).setMapping(IssueType.TASK.name, WF_TWO).setMapping(IssueType.NEW_FEATURE.name, WF_THREE);
        WorkflowSchemesControl schemesControl = this.backdoor.workflowSchemes();
        scheme = schemesControl.createScheme(scheme);
        ParsedResponse<WorkflowSchemeClient.WorkflowScheme> response = this.client.deleteIssueMappingResponse(scheme.getId(), IssueType.NEW_FEATURE.id, false);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertNull((Object)response.body);
        String pkey = "TDDITM";
        this.backdoor.project().addProject("TDDITM", "TDDITM", "admin");
        this.backdoor.project().setWorkflowScheme("TDDITM", scheme.getId());
        WorkflowSchemeData draft = schemesControl.createDraft(scheme);
        draft.setDefaultWorkflow(null).setMapping(IssueType.IMPROVMENT.id, WF_FIVE).setMapping(IssueType.NEW_FEATURE.id, WF_ONE).setMapping(IssueType.BUG.id, WF_ONE);
        schemesControl.updateDraftScheme(scheme.getId().longValue(), draft);
        SimpleWorkflowScheme expectedScheme = this.asSimpleScheme(scheme.getId());
        response = this.client.deleteIssueMappingResponse(scheme.getId(), IssueType.IMPROVMENT.id, false);
        expectedScheme.removeMapping(IssueType.IMPROVMENT);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        this.updateDraftInfo(expectedScheme, (WorkflowSchemeClient.WorkflowScheme)response.body, scheme.getId());
        Assert.assertEquals((Object)expectedScheme, (Object)this.asSimpleScheme((WorkflowSchemeClient.WorkflowScheme)response.body));
        response = this.client.deleteIssueMappingResponse(scheme.getId(), IssueType.IMPROVMENT.id, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((Object)expectedScheme, (Object)this.asSimpleScheme((WorkflowSchemeClient.WorkflowScheme)response.body));
        response = this.client.deleteIssueMappingResponse(2L, IssueType.NEW_FEATURE.id, true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertNull((Object)response.body);
        response = this.client.deleteIssueMappingResponse(scheme.getId(), IssueType.BAD.id, true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.anonymous()).deleteIssueMappingResponse(scheme.getId(), IssueType.BUG.id, false);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).deleteIssueMappingResponse(scheme.getId(), IssueType.BUG.id, false);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testUpdateIssueTypeMapping() {
        WorkflowSchemeData scheme = new WorkflowSchemeData();
        scheme.setName("testUpdateIssueTypeMapping").setDescription("testUpdateIssueTypeMapping");
        scheme.setDefaultWorkflow(WF_ONE).setMapping(IssueType.BUG.name, WF_TWO).setMapping(IssueType.TASK.name, WF_TWO).setMapping(IssueType.NEW_FEATURE.name, WF_THREE);
        WorkflowSchemesControl schemesControl = this.backdoor.workflowSchemes();
        scheme = schemesControl.createScheme(scheme);
        SimpleWorkflowScheme expectedScheme = this.asSimpleScheme(scheme.getId());
        WorkflowSchemeClient.IssueTypeMappingBean mapping = new WorkflowSchemeClient.IssueTypeMappingBean(IssueType.BUG.id, WF_ONE);
        expectedScheme.setMapping(IssueType.BUG, WF_ONE);
        Assert.assertThat((Object)expectedScheme, this.equalsIgnoringLastModified(this.client.updateIssueTypeMapping(scheme.getId(), mapping)));
        mapping = new WorkflowSchemeClient.IssueTypeMappingBean(IssueType.BAD.id, WF_THREE);
        expectedScheme.setMapping(IssueType.IMPROVMENT, WF_THREE);
        Assert.assertThat((Object)expectedScheme, this.equalsIgnoringLastModified(this.client.updateIssueTypeMapping(scheme.getId(), IssueType.IMPROVMENT.id, mapping)));
        String pkey = "TUITM";
        this.backdoor.project().addProject("TUITM", "TUITM", "admin");
        this.backdoor.project().setWorkflowScheme("TUITM", scheme.getId());
        mapping = new WorkflowSchemeClient.IssueTypeMappingBean(IssueType.IMPROVMENT.id, WF_THREE);
        Assert.assertThat((Object)expectedScheme, this.equalsIgnoringLastModified(this.client.updateIssueTypeMapping(scheme.getId(), mapping)));
        mapping = new WorkflowSchemeClient.IssueTypeMappingBean(IssueType.IMPROVMENT.id, WF_FOUR);
        ParsedResponse<WorkflowSchemeClient.WorkflowScheme> response = this.client.updateIssueTypeMappingResponse(scheme.getId(), mapping);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        mapping.setUpdateDraftIfNeeded(true);
        SimpleWorkflowScheme expectedDraft = expectedScheme.copyAsDraft();
        expectedDraft.setMapping(IssueType.IMPROVMENT, WF_FOUR);
        WorkflowSchemeClient.WorkflowScheme actualDraft = this.client.updateIssueTypeMapping(scheme.getId(), mapping);
        this.updateDraftInfo(expectedDraft, actualDraft, scheme.getId());
        Assert.assertEquals((Object)expectedDraft, (Object)this.asSimpleScheme(actualDraft));
        response = this.client.updateIssueTypeMappingResponse(2L, mapping);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertNull((Object)response.body);
        mapping = new WorkflowSchemeClient.IssueTypeMappingBean(IssueType.BAD.id, WF_FOUR);
        mapping.setUpdateDraftIfNeeded(true);
        response = this.client.updateIssueTypeMappingResponse(scheme.getId(), mapping);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        mapping = new WorkflowSchemeClient.IssueTypeMappingBean(IssueType.BUG.id, WF_BAD);
        mapping.setUpdateDraftIfNeeded(true);
        response = this.client.updateIssueTypeMappingResponse(scheme.getId(), mapping);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        mapping = new WorkflowSchemeClient.IssueTypeMappingBean(IssueType.IMPROVMENT.id, WF_THREE);
        mapping.setUpdateDraftIfNeeded(true);
        response = ((WorkflowSchemeClient)this.client.anonymous()).updateIssueTypeMappingResponse(scheme.getId(), mapping);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).updateIssueTypeMappingResponse(scheme.getId(), mapping);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testUpdateDraftIssueTypeMapping() {
        this.client = this.client.asDraft();
        WorkflowSchemeData scheme = new WorkflowSchemeData();
        scheme.setName("testUpdateDraftIssueTypeMapping").setDescription("testUpdateDraftIssueTypeMapping");
        scheme.setDefaultWorkflow(WF_ONE).setMapping(IssueType.BUG.name, WF_TWO).setMapping(IssueType.TASK.name, WF_TWO).setMapping(IssueType.NEW_FEATURE.name, WF_THREE);
        WorkflowSchemesControl schemesControl = this.backdoor.workflowSchemes();
        scheme = schemesControl.createScheme(scheme);
        WorkflowSchemeClient.IssueTypeMappingBean mapping = new WorkflowSchemeClient.IssueTypeMappingBean(IssueType.BUG.id, WF_THREE);
        ParsedResponse<WorkflowSchemeClient.WorkflowScheme> response = this.client.updateIssueTypeMappingResponse(scheme.getId(), mapping);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertNull((Object)response.body);
        String pkey = "TUDITM";
        this.backdoor.project().addProject("TUDITM", "TUDITM", "admin");
        this.backdoor.project().setWorkflowScheme("TUDITM", scheme.getId());
        WorkflowSchemeData draft = schemesControl.createDraft(scheme);
        draft.setDefaultWorkflow(WF_ONE).setMapping(IssueType.BUG.name, WF_TWO).setMapping(IssueType.TASK.name, WF_TWO).setMapping(IssueType.NEW_FEATURE.name, WF_THREE);
        schemesControl.updateDraftScheme(scheme.getId().longValue(), draft);
        SimpleWorkflowScheme expectedScheme = this.asSimpleScheme(scheme.getId());
        mapping = new WorkflowSchemeClient.IssueTypeMappingBean(IssueType.BUG.id, WF_ONE);
        expectedScheme.setMapping(IssueType.BUG, WF_ONE);
        WorkflowSchemeClient.WorkflowScheme actualScheme = this.client.updateIssueTypeMapping(scheme.getId(), mapping);
        this.updateDraftInfo(expectedScheme, actualScheme, scheme.getId());
        Assert.assertEquals((Object)expectedScheme, (Object)this.asSimpleScheme(actualScheme));
        mapping = new WorkflowSchemeClient.IssueTypeMappingBean(IssueType.BAD.id, WF_THREE);
        expectedScheme.setMapping(IssueType.IMPROVMENT, WF_THREE);
        actualScheme = this.client.updateIssueTypeMapping(scheme.getId(), IssueType.IMPROVMENT.id, mapping);
        this.updateDraftInfo(expectedScheme, actualScheme, scheme.getId());
        Assert.assertEquals((Object)expectedScheme, (Object)this.asSimpleScheme(actualScheme));
        mapping = new WorkflowSchemeClient.IssueTypeMappingBean(IssueType.IMPROVMENT.id, WF_THREE);
        Assert.assertEquals((Object)expectedScheme, (Object)this.asSimpleScheme(this.client.updateIssueTypeMapping(scheme.getId(), mapping)));
        response = this.client.updateIssueTypeMappingResponse(2L, mapping);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertNull((Object)response.body);
        mapping = new WorkflowSchemeClient.IssueTypeMappingBean(IssueType.BAD.id, WF_FOUR);
        mapping.setUpdateDraftIfNeeded(true);
        response = this.client.updateIssueTypeMappingResponse(scheme.getId(), mapping);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        mapping = new WorkflowSchemeClient.IssueTypeMappingBean(IssueType.BUG.id, WF_BAD);
        mapping.setUpdateDraftIfNeeded(true);
        response = this.client.updateIssueTypeMappingResponse(scheme.getId(), mapping);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        mapping = new WorkflowSchemeClient.IssueTypeMappingBean(IssueType.IMPROVMENT.id, WF_THREE);
        mapping.setUpdateDraftIfNeeded(true);
        response = ((WorkflowSchemeClient)this.client.anonymous()).updateIssueTypeMappingResponse(scheme.getId(), mapping);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).updateIssueTypeMappingResponse(scheme.getId(), mapping);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testDefaultResource() {
        WorkflowSchemeData scheme = new WorkflowSchemeData();
        scheme.setName("testDefaultResource").setDescription("testDefaultResource");
        scheme.setDefaultWorkflow(WF_ONE).setMapping(IssueType.BUG.name, WF_TWO).setMapping(IssueType.TASK.name, WF_TWO).setMapping(IssueType.NEW_FEATURE.name, WF_THREE);
        scheme = this.backdoor.workflowSchemes().createScheme(scheme);
        SimpleWorkflowScheme expectedScheme = this.asSimpleScheme(scheme.getId());
        expectedScheme.assertDefault(this.client.getDefault(scheme.getId(), false));
        expectedScheme.assertDefault(this.client.getDefault(scheme.getId(), true));
        expectedScheme.removeDefault();
        Assert.assertEquals((Object)expectedScheme.copyWithDefault(), (Object)this.asSimpleScheme(this.client.deleteDefault(scheme.getId(), false)));
        expectedScheme.assertDefault(this.client.getDefault(scheme.getId(), false));
        expectedScheme.assertDefault(this.client.getDefault(scheme.getId(), true));
        expectedScheme.setDefaultWorkflow(WF_FIVE);
        Assert.assertEquals((Object)expectedScheme.copyWithDefault(), (Object)this.asSimpleScheme(this.client.setDefault(scheme.getId(), WF_FIVE, false)));
        expectedScheme.assertDefault(this.client.getDefault(scheme.getId(), false));
        expectedScheme.assertDefault(this.client.getDefault(scheme.getId(), true));
        String pkey = "TDR";
        this.backdoor.project().addProject("TDR", "TDR", "admin");
        this.backdoor.project().setWorkflowScheme("TDR", scheme.getId());
        Assert.assertEquals((Object)expectedScheme.copyWithDefault(), (Object)this.asSimpleScheme(this.client.setDefault(scheme.getId(), WF_FIVE, false)));
        expectedScheme.assertDefault(this.client.getDefault(scheme.getId(), false));
        expectedScheme.assertDefault(this.client.getDefault(scheme.getId(), true));
        Object response = this.client.setDefaultResponse(scheme.getId(), WF_FOUR, false);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        expectedScheme.assertDefault(this.client.getDefault(scheme.getId(), false));
        expectedScheme.assertDefault(this.client.getDefault(scheme.getId(), true));
        WorkflowSchemeClient.WorkflowScheme actualScheme = this.client.setDefault(scheme.getId(), WF_FOUR, true);
        SimpleWorkflowScheme expectedDraft = expectedScheme.copyAsDraft().setDefaultWorkflow(WF_FOUR);
        this.updateDraftInfo(expectedDraft, actualScheme, scheme.getId());
        Assert.assertEquals((Object)expectedDraft.copyWithDefault(), (Object)this.asSimpleScheme(actualScheme));
        expectedDraft.assertDefault(this.client.getDefault(scheme.getId(), true));
        expectedScheme.assertDefault(this.client.getDefault(scheme.getId(), false));
        this.backdoor.workflowSchemes().discardDraftScheme(scheme.getId().longValue());
        response = this.client.deleteDefaultResponse(scheme.getId(), false);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        expectedScheme.assertDefault(this.client.getDefault(scheme.getId(), false));
        expectedScheme.assertDefault(this.client.getDefault(scheme.getId(), true));
        actualScheme = this.client.deleteDefault(scheme.getId(), true);
        this.updateDraftInfo(expectedDraft.removeDefault(), actualScheme, scheme.getId());
        Assert.assertEquals((Object)expectedDraft.copyWithDefault(), (Object)this.asSimpleScheme(actualScheme));
        expectedDraft.assertDefault(this.client.getDefault(scheme.getId(), true));
        expectedScheme.assertDefault(this.client.getDefault(scheme.getId(), false));
        this.backdoor.workflowSchemes().discardDraftScheme(scheme.getId().longValue());
        expectedScheme.assertDefault(this.client.getDefault(scheme.getId(), true));
        expectedScheme.assertDefault(this.client.getDefault(scheme.getId(), false));
        response = this.client.deleteDefaultResponse(-1L, true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = this.client.getDefaultResponse(-1L, true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = this.client.setDefaultResponse(-1L, WF_FIVE, true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = this.client.setDefaultResponse(scheme.getId(), WF_BAD, true);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.anonymous()).deleteDefaultResponse(scheme.getId(), true);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = this.client.getDefaultResponse(scheme.getId(), true);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = this.client.setDefaultResponse(scheme.getId(), WF_FIVE, true);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).getDefaultResponse(scheme.getId(), true);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
        response = this.client.getDefaultResponse(scheme.getId(), true);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
        response = this.client.setDefaultResponse(scheme.getId(), WF_FIVE, true);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testDefaultDraftResource() {
        this.client = this.client.asDraft();
        WorkflowSchemeData scheme = new WorkflowSchemeData();
        scheme.setName("testDefaulDrafttResource").setDescription("testDefaulDrafttResource");
        scheme = this.backdoor.workflowSchemes().createScheme(scheme);
        String pkey = "TDDR";
        this.backdoor.project().addProject("TDDR", "TDDR", "admin");
        this.backdoor.project().setWorkflowScheme("TDDR", scheme.getId());
        WorkflowSchemeData draftScheme = new WorkflowSchemeData();
        draftScheme.setDefaultWorkflow(WF_ONE).setMapping(IssueType.BUG.name, WF_TWO).setMapping(IssueType.TASK.name, WF_TWO).setMapping(IssueType.NEW_FEATURE.name, WF_THREE);
        this.backdoor.workflowSchemes().createDraft(scheme);
        this.backdoor.workflowSchemes().updateDraftScheme(scheme.getId().longValue(), draftScheme);
        SimpleWorkflowScheme expectedScheme = this.asSimpleScheme(scheme.getId());
        expectedScheme.assertDefault(this.client.getDefault(scheme.getId(), false));
        expectedScheme.removeDefault();
        WorkflowSchemeClient.WorkflowScheme actualScheme = this.client.deleteDefault(scheme.getId(), false);
        this.updateDraftInfo(expectedScheme, actualScheme, scheme.getId());
        Assert.assertEquals((Object)expectedScheme.copyWithDefault(), (Object)this.asSimpleScheme(actualScheme));
        expectedScheme.assertDefault(this.client.getDefault(scheme.getId(), false));
        expectedScheme.setDefaultWorkflow(WF_FIVE);
        actualScheme = this.client.setDefault(scheme.getId(), WF_FIVE, false);
        this.updateDraftInfo(expectedScheme, actualScheme, scheme.getId());
        Assert.assertEquals((Object)expectedScheme.copyWithDefault(), (Object)this.asSimpleScheme(actualScheme));
        expectedScheme.assertDefault(this.client.getDefault(scheme.getId(), false));
        Object response = this.client.deleteDefaultResponse(-1L, true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = this.client.getDefaultResponse(-1L, true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = this.client.setDefaultResponse(-1L, WF_FIVE, true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        response = this.client.setDefaultResponse(scheme.getId(), WF_BAD, true);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.anonymous()).deleteDefaultResponse(scheme.getId(), true);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = this.client.getDefaultResponse(scheme.getId(), true);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = this.client.setDefaultResponse(scheme.getId(), WF_FIVE, true);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.statusCode);
        response = ((WorkflowSchemeClient)this.client.loginAs("fred")).getDefaultResponse(scheme.getId(), true);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
        response = this.client.getDefaultResponse(scheme.getId(), true);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
        response = this.client.setDefaultResponse(scheme.getId(), WF_FIVE, true);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    private void assertGetWorkflowMapping(SimpleWorkflowScheme expectedScheme, Long schemeId, boolean draft) {
        for (String wf : WORKFLOWS) {
            Assert.assertEquals(expectedScheme.getMapping(wf), this.asWorkflowMap(this.client.getWorkflowMapping(schemeId, wf, draft)));
        }
    }

    private void assertIssueTypeMapping(SimpleWorkflowScheme expectedScheme, Long schemeId, boolean draft) {
        for (IssueType type : IssueType.ALL) {
            expectedScheme.assertIssueTypeMapping(this.client.getIssueTypeMapping(schemeId, type.id, draft));
        }
    }

    private void assertSchemeGone(Long id) {
        try {
            this.backdoor.workflowSchemes().getWorkflowScheme(id.longValue());
            Assert.fail((String)"The scheme should have been deleted.");
        }
        catch (WebApplicationException e) {
            Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)e.getResponse().getStatus());
        }
    }

    private void assertDraftDoesNotExist(Long id) {
        Assert.assertNull((String)"The draft scheme should not be there.", (Object)this.backdoor.workflowSchemes().getWorkflowSchemeForParentNullIfNotFound(id.longValue()));
        try {
            this.backdoor.workflowSchemes().getWorkflowScheme(id.longValue());
        }
        catch (WebApplicationException e) {
            Assert.fail((String)"Deleting the draft should not have deleted the parent.");
        }
    }

    @Before
    public void setUp() {
        this.client = new WorkflowSchemeClient(this.environmentData);
    }

    private Map<IssueType, String> asWorkflowMap(Iterable<WorkflowSchemeClient.WorkflowMapping> mappings) {
        HashMap map = Maps.newHashMap();
        for (WorkflowSchemeClient.WorkflowMapping mapping : mappings) {
            for (String issueType : mapping.getIssueTypes()) {
                if (map.put(IssueType.findById(issueType), mapping.getWorkflow()) == null) continue;
                throw new RuntimeException("Issue Type '" + issueType + "' mapped twice.");
            }
        }
        return map;
    }

    private Map<IssueType, String> asWorkflowMap(WorkflowSchemeClient.WorkflowMapping mapping) {
        HashMap map = Maps.newHashMap();
        for (String issueType : mapping.getIssueTypes()) {
            if (map.put(IssueType.findById(issueType), mapping.getWorkflow()) == null) continue;
            throw new RuntimeException("Issue Type '" + issueType + "' mapped twice.");
        }
        return map;
    }

    private SimpleWorkflowScheme asSimpleScheme(long id) {
        return this.asSimpleScheme(id, true);
    }

    private SimpleWorkflowScheme updateDraftInfo(SimpleWorkflowScheme scheme, WorkflowSchemeClient.WorkflowScheme data, long parentId) {
        Assert.assertNotNull((Object)data.getLastModified());
        Assert.assertNotNull((Object)data.getLastModifiedUser());
        scheme.setId(data.getId());
        scheme.setLastModified(data.getLastModified());
        scheme.setLastModifiedUser(data.getLastModifiedUser().name);
        scheme.setSelf(this.selfUri(parentId, true));
        return scheme;
    }

    private SimpleWorkflowScheme asSimpleScheme(long id, boolean lookForDraft) {
        WorkflowSchemeData scheme = this.backdoor.workflowSchemes().getWorkflowScheme(id);
        WorkflowSchemeData draftScheme = lookForDraft ? this.backdoor.workflowSchemes().getWorkflowSchemeForParentNullIfNotFound(id) : null;
        WorkflowSchemeData data = draftScheme == null ? scheme : draftScheme;
        SimpleWorkflowScheme bean = new SimpleWorkflowScheme();
        bean.setId(data.getId());
        bean.setName(data.getName());
        bean.setDescription(data.getDescription());
        bean.setDraft(data.isDraft());
        bean.setSelf(this.selfUri(scheme.getId(), data.isDraft()));
        bean.setDefaultWorkflow(data.getDefaultWorkflow() == null ? "jira" : data.getDefaultWorkflow());
        bean.setWorkflowMappings(TestWorkflowSchemeResource.convertMappingsByName(data.getMappings()));
        if (draftScheme != null) {
            bean.setLastModified(draftScheme.getLastModified());
            bean.setLastModifiedUser(draftScheme.getLastModifiedUser());
            bean.setOriginalWorkflowMappings(TestWorkflowSchemeResource.convertMappingsByName(scheme.getMappings()));
            bean.setOriginalDefaultWorkflow(scheme.getDefaultWorkflow());
        }
        return bean;
    }

    private SimpleWorkflowScheme asSimpleScheme(WorkflowSchemeClient.WorkflowScheme data) {
        SimpleWorkflowScheme bean = new SimpleWorkflowScheme();
        bean.setId(data.getId());
        bean.setName(data.getName());
        bean.setDescription(data.getDescription());
        bean.setDraft(data.isDraft());
        bean.setSelf(data.getSelf());
        bean.setDefaultWorkflow(data.getDefaultWorkflow());
        bean.setOriginalDefaultWorkflow(data.getOriginalDefaultWorkflow());
        bean.setLastModified(data.getLastModified());
        UserBean lastModifiedUser = data.getLastModifiedUser();
        if (lastModifiedUser != null) {
            bean.setLastModifiedUser(lastModifiedUser.name);
        }
        bean.setWorkflowMappings(TestWorkflowSchemeResource.convertMappingsById(data.getIssueTypeMappings()));
        bean.setOriginalWorkflowMappings(TestWorkflowSchemeResource.convertMappingsById(data.getOriginalIssueTypeMappings()));
        return bean;
    }

    private static Map<IssueType, String> convertMappingsByName(Map<String, String> dataMappings) {
        if (dataMappings == null) {
            return null;
        }
        HashMap mappings = Maps.newHashMap();
        for (Map.Entry<String, String> entry : dataMappings.entrySet()) {
            String issueType = entry.getKey();
            String workflow = entry.getValue();
            mappings.put(IssueType.findByName(issueType), workflow);
        }
        return mappings;
    }

    private static Map<IssueType, String> convertMappingsById(Map<String, String> dataMappings) {
        if (dataMappings == null) {
            return null;
        }
        HashMap mappings = Maps.newHashMap();
        for (Map.Entry<String, String> entry : dataMappings.entrySet()) {
            String issueType = entry.getKey();
            String workflow = entry.getValue();
            mappings.put(IssueType.findById(issueType), workflow);
        }
        return mappings;
    }

    private URI selfUri(Long id, boolean draft) {
        ArrayList paths = Lists.newArrayList((Object[])new String[]{this.environmentData.getBaseUrl().toString()});
        paths.add("rest");
        paths.add("api");
        paths.add("2");
        paths.add("workflowscheme");
        paths.add(id.toString());
        if (draft) {
            paths.add("draft");
        }
        return URI.create(Joiner.on((char)'/').join((Iterable)paths));
    }

    private static class IssueType {
        private static final IssueType BUG = new IssueType("1", "Bug");
        private static final IssueType IMPROVMENT = new IssueType("4", "Improvement");
        private static final IssueType NEW_FEATURE = new IssueType("2", "New Feature");
        private static final IssueType TASK = new IssueType("3", "Task");
        private static final List<IssueType> ALL = ImmutableList.of((Object)BUG, (Object)IMPROVMENT, (Object)NEW_FEATURE, (Object)TASK);
        private static final IssueType BAD = new IssueType("abc", "I Don't Actually Exist");
        private final String id;
        private final String name;

        private static IssueType findByName(final String name) {
            return (IssueType)Iterables.find(ALL, (Predicate)new Predicate<IssueType>(){

                public boolean apply(IssueType input) {
                    return input.name.equals(name);
                }
            });
        }

        private static IssueType findById(final String id) {
            return (IssueType)Iterables.find(ALL, (Predicate)new Predicate<IssueType>(){

                public boolean apply(IssueType input) {
                    return input.id.equals(id);
                }
            });
        }

        private IssueType(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IssueType issueType = (IssueType)o;
            return this.id.equals(issueType.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    private static class SimpleWorkflowScheme {
        private Long id;
        private String name;
        private String description;
        private String defaultWorkflow;
        private Map<IssueType, String> workflowMappings;
        private String originalDefaultWorkflow;
        private Map<IssueType, String> originalWorkflowMappings;
        private boolean draft;
        private String lastModifiedUser;
        private String lastModified;
        private URI self;

        public SimpleWorkflowScheme() {
        }

        public SimpleWorkflowScheme(SimpleWorkflowScheme other) {
            this.id = other.id;
            this.name = other.name;
            this.description = other.description;
            this.workflowMappings = SimpleWorkflowScheme.copyMap(other.workflowMappings);
            this.originalWorkflowMappings = SimpleWorkflowScheme.copyMap(other.originalWorkflowMappings);
            this.draft = other.draft;
            this.lastModified = other.lastModified;
            this.lastModifiedUser = other.lastModifiedUser;
            this.self = other.self;
            this.defaultWorkflow = other.defaultWorkflow;
            this.originalDefaultWorkflow = other.originalDefaultWorkflow;
        }

        private static <K, V> HashMap<K, V> copyMap(Map<K, V> other) {
            return other != null ? Maps.newHashMap(other) : null;
        }

        public SimpleWorkflowScheme copy() {
            return new SimpleWorkflowScheme(this);
        }

        public Long getId() {
            return this.id;
        }

        public SimpleWorkflowScheme setId(Long id) {
            this.id = id;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public SimpleWorkflowScheme setName(String name) {
            this.name = name;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDefaultWorkflow() {
            return this.defaultWorkflow;
        }

        public SimpleWorkflowScheme setDefaultWorkflow(String defaultWorkflow) {
            this.defaultWorkflow = defaultWorkflow;
            return this;
        }

        public Map<IssueType, String> getWorkflowMappings() {
            return this.workflowMappings;
        }

        public SimpleWorkflowScheme setWorkflowMappings(Map<IssueType, String> workflowMappings) {
            this.workflowMappings = workflowMappings;
            return this;
        }

        public Map<IssueType, String> getOriginalWorkflowMappings() {
            return this.originalWorkflowMappings;
        }

        public void setOriginalWorkflowMappings(Map<IssueType, String> originalWorkflowMappings) {
            this.originalWorkflowMappings = originalWorkflowMappings;
        }

        public boolean isDraft() {
            return this.draft;
        }

        public void setDraft(boolean draft) {
            this.draft = draft;
        }

        public String getLastModifiedUser() {
            return this.lastModifiedUser;
        }

        public void setLastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        public String getOriginalDefaultWorkflow() {
            return this.originalDefaultWorkflow;
        }

        public void setOriginalDefaultWorkflow(String originalDefaultWorkflow) {
            this.originalDefaultWorkflow = originalDefaultWorkflow;
        }

        public URI getSelf() {
            return this.self;
        }

        public SimpleWorkflowScheme setSelf(URI self) {
            this.self = self;
            return this;
        }

        public SimpleWorkflowScheme clearMappings() {
            this.workflowMappings = null;
            return this;
        }

        public SimpleWorkflowScheme setMapping(IssueType issueType, String workflow) {
            if (this.workflowMappings == null) {
                this.workflowMappings = Maps.newHashMap();
            }
            this.workflowMappings.put(issueType, workflow);
            return this;
        }

        public SimpleWorkflowScheme removeMapping(IssueType issueType) {
            if (this.workflowMappings != null) {
                this.workflowMappings.remove(issueType);
            }
            return this;
        }

        public SimpleWorkflowScheme setOriginalMapping(IssueType issueType, String workflow) {
            if (this.originalWorkflowMappings == null) {
                this.originalWorkflowMappings = Maps.newHashMap();
            }
            this.originalWorkflowMappings.put(issueType, workflow);
            return this;
        }

        public SimpleWorkflowScheme removeDefault() {
            this.defaultWorkflow = null;
            return this;
        }

        public SimpleWorkflowScheme copyAsDraft() {
            SimpleWorkflowScheme scheme = this.copy();
            scheme.setDraft(true);
            scheme.setOriginalWorkflowMappings(this.getWorkflowMappings() == null ? null : Maps.newHashMap(this.getWorkflowMappings()));
            scheme.setOriginalDefaultWorkflow(this.getDefaultWorkflow());
            return scheme;
        }

        public WorkflowSchemeClient.WorkflowScheme asRestBean() {
            WorkflowSchemeClient.WorkflowScheme scheme = new WorkflowSchemeClient.WorkflowScheme();
            scheme.setName(this.getName());
            scheme.setDescription(this.getDescription());
            scheme.setDefaultWorkflow(this.getDefaultWorkflow());
            scheme.setId(this.getId());
            if (this.workflowMappings != null) {
                HashMap issueTypes = Maps.newHashMap();
                for (Map.Entry<IssueType, String> entry : this.workflowMappings.entrySet()) {
                    IssueType type = entry.getKey();
                    String workflow = entry.getValue();
                    issueTypes.put(type.getId(), workflow);
                }
                scheme.setIssueTypeMappings(issueTypes);
            }
            return scheme;
        }

        public WorkflowSchemeData asBackdoorBean() {
            WorkflowSchemeData scheme = new WorkflowSchemeData();
            scheme.setName(this.getName());
            scheme.setDescription(this.getDescription());
            scheme.setDefaultWorkflow(this.getDefaultWorkflow());
            scheme.setId(this.getId());
            if (this.workflowMappings != null) {
                HashMap mappings = Maps.newHashMap();
                for (Map.Entry<IssueType, String> entry : this.workflowMappings.entrySet()) {
                    IssueType type = entry.getKey();
                    String workflow = entry.getValue();
                    mappings.put(type.getId(), workflow);
                }
                scheme.setMappings((Map)mappings);
            }
            return scheme;
        }

        public Map<IssueType, String> getMapping(final String workflowName) {
            return Maps.filterValues(this.workflowMappings, (Predicate)new Predicate<String>(){

                public boolean apply(@Nullable String input) {
                    return workflowName.equals(input);
                }
            });
        }

        public SimpleWorkflowScheme removeWorkflow(String workflowName) {
            Iterator<String> iterator = this.workflowMappings.values().iterator();
            while (iterator.hasNext()) {
                String actualName = iterator.next();
                if (!workflowName.equals(actualName)) continue;
                iterator.remove();
            }
            if (workflowName.equals(this.defaultWorkflow)) {
                this.defaultWorkflow = null;
            }
            return this;
        }

        public SimpleWorkflowScheme assertIssueTypeMapping(WorkflowSchemeClient.IssueTypeMappingBean bean) {
            IssueType type = IssueType.findById(bean.getIssueType());
            Assert.assertEquals((Object)this.workflowMappings.get(type), (Object)bean.getWorkflow());
            return this;
        }

        public SimpleWorkflowScheme assertDefault(WorkflowSchemeClient.DefaultBean bean) {
            String expected = this.defaultWorkflow == null ? "jira" : this.defaultWorkflow;
            Assert.assertEquals((Object)expected, (Object)bean.getWorkflow());
            return this;
        }

        public SimpleWorkflowScheme copyWithDefault() {
            SimpleWorkflowScheme copy = this.copy();
            if (copy.getDefaultWorkflow() == null) {
                copy.setDefaultWorkflow("jira");
            }
            if (this.draft && copy.getOriginalDefaultWorkflow() == null) {
                copy.setOriginalDefaultWorkflow("jira");
            }
            return copy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleWorkflowScheme that = (SimpleWorkflowScheme)o;
            if (this.draft != that.draft) {
                return false;
            }
            if (this.defaultWorkflow != null ? !this.defaultWorkflow.equals(that.defaultWorkflow) : that.defaultWorkflow != null) {
                return false;
            }
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
                return false;
            }
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            if (this.lastModified != null ? !this.lastModified.equals(that.lastModified) : that.lastModified != null) {
                return false;
            }
            if (this.lastModifiedUser != null ? !this.lastModifiedUser.equals(that.lastModifiedUser) : that.lastModifiedUser != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.originalDefaultWorkflow != null ? !this.originalDefaultWorkflow.equals(that.originalDefaultWorkflow) : that.originalDefaultWorkflow != null) {
                return false;
            }
            if (this.originalWorkflowMappings != null ? !this.originalWorkflowMappings.equals(that.originalWorkflowMappings) : that.originalWorkflowMappings != null) {
                return false;
            }
            if (this.self != null ? !this.self.equals(that.self) : that.self != null) {
                return false;
            }
            return !(this.workflowMappings != null ? !this.workflowMappings.equals(that.workflowMappings) : that.workflowMappings != null);
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.defaultWorkflow != null ? this.defaultWorkflow.hashCode() : 0);
            result = 31 * result + (this.workflowMappings != null ? this.workflowMappings.hashCode() : 0);
            result = 31 * result + (this.originalDefaultWorkflow != null ? this.originalDefaultWorkflow.hashCode() : 0);
            result = 31 * result + (this.originalWorkflowMappings != null ? this.originalWorkflowMappings.hashCode() : 0);
            result = 31 * result + (this.draft ? 1 : 0);
            result = 31 * result + (this.lastModifiedUser != null ? this.lastModifiedUser.hashCode() : 0);
            result = 31 * result + (this.lastModified != null ? this.lastModified.hashCode() : 0);
            result = 31 * result + (this.self != null ? this.self.hashCode() : 0);
            return result;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    private static class ReflectionEquals
    extends BaseMatcher<Object>
    implements Serializable {
        private final Object wanted;
        private final String[] excludeFields;

        public ReflectionEquals(Object wanted, String ... excludeFields) {
            this.wanted = wanted;
            this.excludeFields = excludeFields;
        }

        public boolean matches(Object actual) {
            return EqualsBuilder.reflectionEquals((Object)this.wanted, (Object)actual, (String[])this.excludeFields);
        }

        public void describeTo(Description description) {
            description.appendText("refEq(").appendValue(this.wanted).appendText(")");
        }
    }
}

