/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.api;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreBlankInstance
public class TestXAUSERNAMEHeader
extends BaseJiraRestTest {
    public static final String ADMIN = "admin";
    public static final String ANONYMOUS = "anonymous";
    private Client restApiClient;

    @Before
    public void setUp() throws Exception {
        this.restApiClient = new Client(this.environmentData);
    }

    @Test
    public void testGettingIssueWithLoggedInUser() {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("MKY", "Issue summary");
        Response response = ((Client)this.restApiClient.loginAs(ADMIN, ADMIN)).issue(issue.key);
        this.readEntity(response);
        Assert.assertThat((Object)response.getStringHeaders(), (Matcher)Matchers.hasKey((Object)"X-AUSERNAME"));
        Assert.assertThat((Object)response.getStringHeaders().getFirst((Object)"X-AUSERNAME"), (Matcher)Matchers.is((Object)ADMIN));
    }

    @Test
    public void testGettingIssueWithAnonymousUser() {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("MKY", "Issue summary");
        Response response = ((Client)this.restApiClient.anonymous()).issue(issue.key);
        this.readEntity(response);
        Assert.assertThat((Object)response.getStringHeaders(), (Matcher)Matchers.hasKey((Object)"X-AUSERNAME"));
        Assert.assertThat((Object)response.getStringHeaders().getFirst((Object)"X-AUSERNAME"), (Matcher)Matchers.is((Object)ANONYMOUS));
    }

    private void readEntity(Response response) {
        response.getEntity();
        response.close();
    }

    public static class Client
    extends RestApiClient<Client> {
        public Client(JIRAEnvironmentData environmentData) {
            super(environmentData);
        }

        public Response issue(String issueKey) {
            return (Response)this.createResource().path("issue").path(issueKey).request().get(Response.class);
        }
    }
}

