/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client;

import com.atlassian.jira.rest.v2.issue.project.ProjectInputBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;

public class CreateSharedProjectResourceClient
extends RestApiClient<CreateSharedProjectResourceClient> {
    public CreateSharedProjectResourceClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public long createSharedProject(long existingProjectId, String key, String name, String leadName) {
        ProjectInputBean bean = ProjectInputBean.builder().setKey(key).setName(name).setLeadName(leadName).build();
        return this.createSharedProject(existingProjectId, bean).getProjectId();
    }

    public ProjectCreationResult createSharedProject(long existingProjectId, ProjectInputBean projectInputBean) {
        return (ProjectCreationResult)this.projectTemplates().path(Long.toString(existingProjectId)).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)projectInputBean), (GenericType)new GenericType<ProjectCreationResult>(){});
    }

    private WebTarget projectTemplates() {
        return this.resourceRoot(this.getEnvironmentData().getBaseUrl().toExternalForm()).path("rest").path("project-templates").path("1.0").path("createshared");
    }

    public static class ProjectCreationResult {
        private String returnUrl;
        private long projectId;
        private String projectKey;
        private String projectName;

        ProjectCreationResult(String returnUrl, long projectId, String projectKey, String projectName) {
            this.returnUrl = returnUrl;
            this.projectId = projectId;
            this.projectKey = projectKey;
            this.projectName = projectName;
        }

        ProjectCreationResult() {
        }

        public String getReturnUrl() {
            return this.returnUrl;
        }

        public long getProjectId() {
            return this.projectId;
        }

        public String getProjectKey() {
            return this.projectKey;
        }

        public String getProjectName() {
            return this.projectName;
        }
    }
}

