/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client;

import com.atlassian.jira.rest.v2.issue.customfield.CustomFieldOptionsBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class CustomFieldsClient
extends RestApiClient<CustomFieldsClient> {
    public CustomFieldsClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public ParsedResponse<CustomFieldOptionsBean> getOptions(Long customFieldId, Collection<Long> projectIds, Collection<String> issueTypeIds) {
        return this.getOptions(customFieldId, projectIds, issueTypeIds, null, null);
    }

    public ParsedResponse<CustomFieldOptionsBean> getOptions(Long customFieldId, Collection<Long> projectIds, Collection<String> issueTypeIds, @Nullable String query, @Nullable Long maxResults) {
        return this.toResponse(() -> {
            WebTarget target = this.createResource().path("customFields").path(String.valueOf(customFieldId)).path("options");
            if (query != null) {
                target = target.queryParam("query", new Object[]{query});
            }
            if (maxResults != null) {
                target = target.queryParam("maxResults", new Object[]{String.valueOf(maxResults)});
            }
            for (Long projectId : projectIds) {
                target = target.queryParam("projectIds", new Object[]{String.valueOf(projectId)});
            }
            for (String issueTypeId : issueTypeIds) {
                target = target.queryParam("issueTypeIds", new Object[]{issueTypeId});
            }
            return (Response)target.request().get(Response.class);
        }, CustomFieldOptionsBean.class);
    }
}

