/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd;

import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.ipd.BaseInProductDiagnosticsTest;
import com.jayway.awaitility.Awaitility;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.METRICS})
public class TestIpdTool
extends BaseInProductDiagnosticsTest {
    private static final String BASIC_DB_CONN_JMX_BEAN_NAME = "com.atlassian.jira:name=BasicDataSource,connectionpool=connections";
    private static final String ITA_DB_CONN_EXEC_TIME_JMX_BEAN_NAME = "com.atlassian.jira:type=metrics,category00=db,category01=core,name=executionTime";

    @Test
    @RestoreBlankInstance
    public void testIPDFeatureFlagIsEnabledByDefault() {
        this.assertIPDFeatureState(true);
    }

    @Test
    @RestoreBlankInstance
    public void testIPDFeatureFlagIsRespected() {
        this.enableIPDFeature();
        this.assertIPDFeatureState(true);
        this.disableIPDFeature();
        this.assertIPDFeatureState(false);
    }

    @Test
    @RestoreBlankInstance
    public void testSampleMetricsEmittedToJMX() {
        this.backdoor.profiling().enableAppMonitoring();
        Map<String, Object> dbConnMinIdle = this.getJmxObject(BASIC_DB_CONN_JMX_BEAN_NAME, "MinIdle");
        Assertions.assertThat((Object)dbConnMinIdle.get("MinIdle")).isNotNull();
        Map<String, Object> dbConnExecTime = this.getJmxObjectWithStats(ITA_DB_CONN_EXEC_TIME_JMX_BEAN_NAME);
        Assertions.assertThat(dbConnExecTime).isNotNull();
    }

    @Test
    @RestoreBlankInstance
    public void testEmittedLastValueToJMXWhenJMXReEnabled() {
        this.enableIPDFeature();
        this.enableIpdWipFeature();
        String jmxObjectName = this.getMetricObjectName(this.getAnyValueMetricName());
        Awaitility.await().atMost(1L, TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).until(() -> this.isPresentAndNonNegativeValue(this.getJmxObjectWithValue(jmxObjectName)));
        this.backdoor.profiling().disableJmx();
        Assert.assertNull((String)"Value should not be present in JMX", this.getJmxObjectWithValue(jmxObjectName));
        this.backdoor.profiling().enableJmx();
        this.backdoor.profiling().enableIpdMonitoring();
        Awaitility.await().atMost(1L, TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).until(() -> this.isPresentAndNonNegativeValue(this.getJmxObjectWithValue(jmxObjectName)));
    }

    private boolean isPresentAndNonNegativeValue(Map<String, Object> jmxObject) {
        return jmxObject != null && jmxObject.get("Value") instanceof Double && BigDecimal.valueOf((Double)jmxObject.get("Value")).compareTo(BigDecimal.valueOf(-1.0)) != 0;
    }

    private String getAnyValueMetricName() {
        Optional<String> metricName = TestIpdTool.getLastValueMetrics().findAny();
        Assumptions.assumeThat(metricName).isPresent();
        return metricName.get();
    }
}

