/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.util.JsonMatchers;
import com.atlassian.jira.webtests.ztests.bundledplugins2.webhooks.WebHookTester;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.Matcher;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WEBHOOKS, Category.REFERENCE_PLUGIN})
public class TestApplicationPropertyWebHook
extends BaseJiraFuncTest {
    private static final List<WebHookPropertyTest> webHookPropertyTests = ImmutableList.of((Object)new WebHookPropertyTest("option_voting_changed", "jira.option.voting"), (Object)new WebHookPropertyTest("option_unassigned_issues_changed", "jira.option.allowunassigned"), (Object)new WebHookPropertyTest("option_subtasks_changed", "jira.option.allowsubtasks"), (Object)new WebHookPropertyTest("option_attachments_changed", "jira.option.allowattachments"), (Object)new WebHookPropertyTest("option_issuelinks_changed", "jira.option.issuelinking"), (Object)new WebHookPropertyTest("option_timetracking_changed", "jira.option.timetracking"));
    @Rule
    public WebHookTester webHooks = new WebHookTester();

    @Before
    public void setUpTest() {
        this.backdoor.restoreBlankInstance();
    }

    @Test
    public void testWebHookSentToPersistentListenerOnApplicationPropertyChange() throws JSONException {
        for (WebHookPropertyTest webHookPropertyTest : webHookPropertyTests) {
            this.raiseAndCheckEvent(webHookPropertyTest, this.webHooks.getWebHookResponseSupplier());
        }
    }

    @Test
    public void testWebHookSentToModuleDescriptorListenerOnApplicationPropertyChange() throws JSONException {
        for (WebHookPropertyTest webHookPropertyTest : webHookPropertyTests) {
            this.raiseAndCheckEvent(webHookPropertyTest, this.webHooks.receiveWebhook(webHookPropertyTest.webHookId));
        }
    }

    private void raiseAndCheckEvent(WebHookPropertyTest webHookPropertyTest, Supplier<String> listener) throws JSONException {
        this.webHooks.registerWebHook(webHookPropertyTest.getWebHookId());
        ExpectedValues expectedValues = this.changeProperty(webHookPropertyTest.getOptionKey());
        this.assertApplicationPropertyEventReceived(webHookPropertyTest.getWebHookId(), listener, expectedValues);
    }

    private void assertApplicationPropertyEventReceived(String webHookEvent, Supplier<String> receivedWebhook, ExpectedValues expectedValues) throws JSONException {
        JSONObject json = new JSONObject((String)receivedWebhook.get());
        Assert.assertThat((Object)json, (Matcher)JsonMatchers.hasField((String)"timestamp"));
        Assert.assertThat((Object)json, (Matcher)JsonMatchers.hasField((String)"webhookEvent").equalTo((Object)webHookEvent));
        Assert.assertThat((Object)json, (Matcher)JsonMatchers.hasField((String)"property.key").equalTo((Object)expectedValues.key));
        Assert.assertThat((Object)json, (Matcher)JsonMatchers.hasField((String)"property.value").equalTo((Object)expectedValues.value));
    }

    private ExpectedValues changeProperty(String property) {
        boolean option = this.backdoor.applicationProperties().getOption(property);
        this.backdoor.applicationProperties().setOption(property, !option);
        return new ExpectedValues(property, !option);
    }

    private static class WebHookPropertyTest {
        private final String webHookId;
        private final String optionKey;

        private WebHookPropertyTest(String webHookId, String optionKey) {
            this.webHookId = webHookId;
            this.optionKey = optionKey;
        }

        public String getWebHookId() {
            return this.webHookId;
        }

        public String getOptionKey() {
            return this.optionKey;
        }
    }

    private static class ExpectedValues {
        private final String key;
        private final String value;

        private ExpectedValues(String key, boolean value) {
            this.key = key;
            this.value = String.valueOf(value);
        }
    }
}

