/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.charts;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.CHARTING})
@LoginAs(user="admin")
public class TestCharting
extends BaseJiraFuncTest {
    public static final String MAIN_CONTENT_AREA = "#content";
    public static final String PAGE_HEADER = "#content header h1";
    public static final String REPORT_HEADER = ".reportHeading h3";
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testCreatedVsResolvedReport() {
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:createdvsresolved-report");
        this.tester.assertTextPresent("Report: Created vs Resolved Issues Report");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Please specify a project or filter");
        this.tester.setFormElement("daysprevious", "aaa");
        this.tester.submit("Next");
        this.tester.assertTextPresent("You must specify a whole number of days.");
        this.tester.setFormElement("projectOrFilterId", "project-10000");
        this.tester.setFormElement("daysprevious", "30");
        this.tester.submit("Next");
        CssLocator locator = new CssLocator(this.tester, MAIN_CONTENT_AREA);
        this.textAssertions.assertTextPresent(locator, "There are no matching issues to report on.");
        this.navigation.issue().createIssue("homosapien", "Bug", "My first bug");
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:createdvsresolved-report");
        this.tester.setFormElement("projectOrFilterId", "project-10000");
        this.tester.setFormElement("daysprevious", "30");
        this.tester.submit("Next");
        locator = new CssLocator(this.tester, MAIN_CONTENT_AREA);
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, PAGE_HEADER), "Created vs Resolved Issues Report");
        this.textAssertions.assertTextSequence(new CssLocator(this.tester, REPORT_HEADER), "homosapien", new String[0]);
        this.textAssertions.assertTextSequence(locator, "This chart shows the number of issues", "created", "vs the number of issues", "resolved", "in the last", "30", "days.");
        this.tester.assertTextPresent("Data Table");
        TableLocator tableLocator = new TableLocator(this.tester, "createdvsresolved-report-datatable");
        this.textAssertions.assertTextPresent(tableLocator, "Period");
        this.textAssertions.assertTextPresent(tableLocator, "Created");
        this.textAssertions.assertTextPresent(tableLocator, "Resolved");
    }

    @Test
    public void testResolutionTimeReport() {
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:resolutiontime-report");
        this.tester.assertTextPresent("Report: Resolution Time Report");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Please specify a project or filter");
        this.tester.setFormElement("daysprevious", "aaa");
        this.tester.submit("Next");
        this.tester.assertTextPresent("You must specify a whole number of days.");
        this.tester.setFormElement("projectOrFilterId", "project-10000");
        this.tester.setFormElement("daysprevious", "30");
        this.tester.submit("Next");
        WebPageLocator locator = new WebPageLocator(this.tester);
        this.textAssertions.assertTextPresent(locator, "There are no matching issues to report on.");
    }

    @Test
    public void testPieReport() {
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:pie-report");
        this.tester.assertTextPresent("Report: Pie Chart Report");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Please specify a project or filter");
        this.tester.setFormElement("projectOrFilterId", "project-10000");
        this.tester.selectOption("statistictype", "Issue Type");
        this.tester.submit("Next");
        CssLocator locator = new CssLocator(this.tester, MAIN_CONTENT_AREA);
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, PAGE_HEADER), "Pie Chart Report");
        this.textAssertions.assertTextSequence(locator, "Project:", "homosapien", "(Issue Type)");
        this.textAssertions.assertTextPresent(locator, "There are no matching issues to report on.");
        this.navigation.issue().createIssue("homosapien", "Bug", "My first bug");
        this.navigation.issue().createIssue("homosapien", "Improvement", "My first improvement");
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:pie-report");
        this.tester.assertTextPresent("Report: Pie Chart Report");
        this.tester.setFormElement("projectOrFilterId", "project-10000");
        this.tester.selectOption("statistictype", "Issue Type");
        this.tester.submit("Next");
        locator = new CssLocator(this.tester, MAIN_CONTENT_AREA);
        this.textAssertions.assertTextSequence(locator, "Pie Chart Report", new String[0]);
        this.textAssertions.assertTextSequence(locator, "Project:", "homosapien", "(Issue Type)");
        this.tester.assertTextPresent("Data Table");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "singlefieldpie-report-datatable", 0, 1), "Issues");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "singlefieldpie-report-datatable", 0, 2), "%");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "singlefieldpie-report-datatable", 1, 0), "Improvement");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "singlefieldpie-report-datatable", 1, 1), "1");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "singlefieldpie-report-datatable", 1, 2), "50%");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "singlefieldpie-report-datatable", 2, 0), "Bug");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "singlefieldpie-report-datatable", 2, 1), "1");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "singlefieldpie-report-datatable", 2, 2), "50%");
        this.tester.clickLinkWithText("Bug: 1 issues (50%)");
        this.tester.assertTextPresent("My first bug");
    }

    @Test
    public void testAverageAgeReport() {
        String name = "Average Age Report";
        this.assertReportValidation("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:averageage-report", "Average Age Report", "There are no matching issues to report on.");
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, PAGE_HEADER), "Average Age Report");
        this.textAssertions.assertTextSequence(new CssLocator(this.tester, REPORT_HEADER), "homosapien", new String[0]);
        this.tester.assertTextPresent("Data Table");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "averageage-report-datatable", 0, 0), "Period");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "averageage-report-datatable", 0, 1), "Issues Unresolved");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "averageage-report-datatable", 0, 2), "Total Age");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "averageage-report-datatable", 0, 3), "Avg. Age");
    }

    @Test
    public void testRecentlyCreatedReport() {
        String name = "Recently Created Issues Report";
        this.assertReportValidation("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:recentlycreated-report", "Recently Created Issues Report", null);
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, PAGE_HEADER), "Recently Created Issues Report");
        this.textAssertions.assertTextSequence(new CssLocator(this.tester, REPORT_HEADER), "homosapien", new String[0]);
        this.tester.assertTextPresent("Data Table");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "recentlycreated-report-datatable", 0, 0), "Period");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "recentlycreated-report-datatable", 0, 1), "Created Issues (Unresolved)");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "recentlycreated-report-datatable", 0, 2), "Created Issues (Resolved)");
    }

    @Test
    public void testTimeSinceReport() {
        String name = "Time Since Issues Report";
        this.assertReportValidation("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:timesince-report", "Time Since Issues Report", null);
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, PAGE_HEADER), "Time Since Issues Report");
        this.textAssertions.assertTextSequence(new CssLocator(this.tester, REPORT_HEADER), "homosapien", new String[0]);
        this.tester.assertTextPresent("Data Table");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "timesince-report-datatable", 0, 0), "Period");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "timesince-report-datatable", 0, 1), "Created");
    }

    private void assertReportValidation(String url, String reportName, String noIssuesMsg) {
        this.tester.gotoPage(url);
        this.tester.assertTextPresent("Report: " + reportName);
        this.tester.submit("Next");
        this.tester.assertTextPresent("Please specify a project or filter");
        this.tester.setFormElement("daysprevious", "aaa");
        this.tester.submit("Next");
        this.tester.assertTextPresent("You must specify a whole number of days.");
        this.tester.setFormElement("projectOrFilterId", "project-10000");
        this.tester.setFormElement("daysprevious", "30");
        this.tester.submit("Next");
        WebPageLocator locator = new WebPageLocator(this.tester);
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, PAGE_HEADER), reportName);
        this.textAssertions.assertTextSequence(new CssLocator(this.tester, REPORT_HEADER), "homosapien", new String[0]);
        if (noIssuesMsg != null) {
            this.textAssertions.assertTextPresent(locator, noIssuesMsg);
        }
        this.navigation.issue().createIssue("homosapien", "Bug", "My first bug");
        this.navigation.issue().createIssue("homosapien", "Improvement", "My first improvement");
        this.tester.gotoPage(url);
        this.tester.assertTextPresent("Report: " + reportName);
        this.tester.setFormElement("projectOrFilterId", "project-10000");
        this.tester.setFormElement("daysprevious", "30");
        this.tester.submit("Next");
    }
}

