/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.comment;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.COMMENTS})
@LoginAs(user="admin")
public class TestCommentDelete
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private WorkflowUtil workflowUtil;
    private String applicationTitle;

    @Before
    public void setUp() {
        this.administration.restoreData("TestCommentDelete.xml");
        this.applicationTitle = this.backdoor.applicationProperties().getString("jira.title");
    }

    @Test
    public void testDeleteOwnCommentWithOwnPermission() {
        this.navigation.logout();
        this.navigation.login("detkin", "detkin");
        this.navigation.issue().gotoIssue("TST-1");
        this.tester.clickLink("delete_comment_10020");
        this.tester.submit("Delete");
        this.tester.assertLinkNotPresent("delete_comment_10020");
    }

    @Test
    public void testDeleteCommentWithAllPermission() {
        this.navigation.issue().gotoIssue("TST-1");
        this.tester.clickLink("delete_comment_10020");
        this.tester.submit("Delete");
        this.tester.assertLinkNotPresent("delete_comment_10020");
    }

    @Test
    public void testDeleteOthersCommentWithOwnPermission() {
        this.navigation.logout();
        this.navigation.login("barney", "barney");
        this.navigation.issue().gotoIssue("TST-1");
        this.tester.assertLinkNotPresent("delete_comment_10020");
    }

    @Test
    public void testDeleteCommentLinkNotAvailableWithNonEditableWorkflowState() {
        this.navigation.issue().gotoIssue("TST-1");
        this.workflowUtil.clickAction("action_id_2");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.tester.assertLinkNotPresent("delete_comment_10020");
    }

    @Test
    public void testDeleteCommentReindexesIssue() {
        this.navigation.issueNavigator().createSearch("comment ~ \"Unique Comment\"");
        this.tester.assertTextPresent("TST-1");
        this.navigation.issue().gotoIssue("TST-1");
        this.tester.clickLink("delete_comment_10020");
        this.tester.submit("Delete");
        this.navigation.issueNavigator().createSearch("comment ~ \"Unique Comment\"");
        this.tester.assertTextNotPresent("TST-1");
        this.assertions.assertNodeByIdDoesNotExist("issuetable");
    }

    @Test
    public void testDeleteCommentWithNoPermissions() {
        this.backdoor.permissionSchemes().removeProjectRolePermission(0L, ProjectPermissions.DELETE_ALL_COMMENTS, 10002L);
        this.backdoor.permissionSchemes().removeProjectRolePermission(0L, ProjectPermissions.DELETE_OWN_COMMENTS, 10000L);
        this.tester.gotoPage("/secure/DeleteComment!default.jspa?id=10000&commentId=10020");
        this.tester.assertTitleEquals("Error - " + this.applicationTitle);
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, "#content .aui-message-error"), "You do not have the permission for this comment.");
    }

    @Test
    public void testDeleteCommentWithNonEditableWorkflowState() {
        this.navigation.issue().gotoIssue("TST-1");
        this.workflowUtil.clickAction("action_id_2");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.tester.gotoPage("/secure/DeleteComment!default.jspa?id=10000&commentId=10020");
        this.tester.assertTitleEquals("Error - " + this.applicationTitle);
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, "#content .aui-message-error"), "You do not have the permission for this comment.");
    }

    @Test
    public void testOneCanNotDeleteCommentThatOneCanNotSee() {
        this.navigation.issue().gotoIssue("TST-1");
        this.navigation.issue().addComment("TST-1", "This comment is visible by developers only!", "Developers");
        this.tester.assertTextPresent("This comment is visible by developers only!");
        this.administration.usersAndGroups().addUserToGroup("barney", "jira-administrators");
        this.navigation.logout();
        this.navigation.login("barney", "barney");
        this.navigation.issue().gotoIssue("TST-1");
        this.tester.assertTextNotPresent("This comment is visible by developers only!");
        this.tester.gotoPage("/secure/DeleteComment!default.jspa?id=10000&commentId=10030");
        this.tester.assertTitleEquals("Error - " + this.applicationTitle);
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, "#content .aui-message-error"), "You do not have the permission for this comment.");
        this.tester.gotoPage("/secure/DeleteComment!default.jspa?id=10000&commentId=100301");
        this.tester.assertTitleEquals("Error - " + this.applicationTitle);
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, "#content .aui-message-error"), "You do not have the permission for this comment.");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue("TST-1");
        this.tester.assertTextPresent("This comment is visible by developers only!");
    }

    @Test
    public void testOneCanNotEditCommentThatOneCanNotSee() {
        this.navigation.issue().gotoIssue("TST-1");
        this.navigation.issue().addComment("TST-1", "This comment is visible by developers only!", "Developers");
        this.tester.assertTextPresent("This comment is visible by developers only!");
        this.administration.usersAndGroups().addUserToGroup("barney", "jira-administrators");
        this.navigation.logout();
        this.navigation.login("barney", "barney");
        this.navigation.issue().gotoIssue("TST-1");
        this.tester.assertTextNotPresent("This comment is visible by developers only!");
        this.tester.gotoPage("/secure/EditComment!default.jspa?id=10000&commentId=10030");
        this.tester.assertTitleEquals("Error - " + this.applicationTitle);
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, "#content .aui-message-error"), "You do not have the permission for this comment.");
        this.tester.gotoPage("/secure/EditComment!default.jspa?id=10000&commentId=100301");
        this.tester.assertTitleEquals("Error - " + this.applicationTitle);
        this.textAssertions.assertTextPresent(new CssLocator(this.tester, "#content .aui-message-error"), "You do not have the permission for this comment.");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue("TST-1");
        this.tester.assertTextPresent("This comment is visible by developers only!");
    }
}

