/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.Map;
import net.sourceforge.jwebunit.WebTester;

public class ArrowControlledOrdering {
    private final WebTester tester;
    private final TextAssertions textAssertions;
    private final HtmlPage page;
    private final FuncTestLogger logger;
    private final Form form;

    public ArrowControlledOrdering(WebTester webTester, TextAssertions textAssertions, HtmlPage page, FuncTestLogger logger, Form form) {
        this.tester = webTester;
        this.textAssertions = textAssertions;
        this.page = page;
        this.logger = logger;
        this.form = form;
    }

    private void moveOptionsToPositions(String[] optionValue, String[] optionId, String itemType, Map<String, String> moveToPosition) {
        for (String currentPosition : moveToPosition.keySet()) {
            int newIntPos;
            String newPosition = moveToPosition.get(currentPosition);
            int currIntPos = Integer.parseInt(currentPosition);
            if (currIntPos < (newIntPos = Integer.parseInt(newPosition))) {
                this.textAssertions.assertTextSequence(this.page.asString(), "<b>" + optionValue[currIntPos] + "</b>", "<b>" + optionValue[newIntPos] + "</b>");
            } else if (currIntPos > newIntPos) {
                this.textAssertions.assertTextSequence(this.page.asString(), "<b>" + optionValue[newIntPos] + "</b>", "<b>" + optionValue[currIntPos] + "</b>");
            }
            this.logger.log((Object)("      Moving item at position " + currIntPos + " to position " + newPosition));
            this.tester.setFormElement("new" + itemType + "Position_" + optionId[currIntPos], newPosition);
        }
        this.form.clickButtonWithValue("Move");
        for (int i = 1; i < optionValue.length; ++i) {
            int k;
            if (moveToPosition.containsKey(String.valueOf(i))) continue;
            for (k = 1; k <= i && moveToPosition.containsValue(String.valueOf(k)); ++k) {
            }
            moveToPosition.put(String.valueOf(i), String.valueOf(k));
        }
        for (String currentOption : moveToPosition.keySet()) {
            String newCurrentPos = moveToPosition.get(currentOption);
            String newReplacedPos = moveToPosition.get(newCurrentPos);
            int currentOptionInt = Integer.parseInt(currentOption);
            int newCurrentPosInt = Integer.parseInt(newCurrentPos);
            int otherOptionInt = Integer.parseInt(newCurrentPos);
            int newReplacedPosInt = Integer.parseInt(newReplacedPos);
            if (newCurrentPosInt < newReplacedPosInt) {
                this.textAssertions.assertTextSequence(this.page.asString(), "<b>" + optionValue[currentOptionInt] + "</b>", "<b>" + optionValue[otherOptionInt] + "</b>");
                continue;
            }
            if (newCurrentPosInt <= newReplacedPosInt) continue;
            this.textAssertions.assertTextSequence(this.page.asString(), "<b>" + optionValue[otherOptionInt] + "</b>", "<b>" + optionValue[currentOptionInt] + "</b>");
        }
    }

    public void checkOrderingUsingArrows(String[] optionValue, String[] optionId) {
        int i;
        this.logger.log((Object)"Testing reordering using the option ordering arrows");
        this.logger.log((Object)"  checking moveToLast arrows");
        for (i = 1; i < optionValue.length; ++i) {
            this.tester.clickLink("moveToLast_" + optionId[i]);
            this.tester.assertLinkNotPresent("moveDown_" + optionId[i]);
            this.tester.assertLinkNotPresent("moveToLast_" + optionId[i]);
        }
        this.checkItemsAreInAscendingOrder(optionValue);
        this.logger.log((Object)"  checking moveToFirst arrows");
        for (i = optionValue.length - 1; i >= 1; --i) {
            this.tester.clickLink("moveToFirst_" + optionId[i]);
            this.tester.assertLinkNotPresent("moveUp_" + optionId[i]);
            this.tester.assertLinkNotPresent("moveToFirst_" + optionId[i]);
        }
        this.checkItemsAreInAscendingOrder(optionValue);
        this.logger.log((Object)"  checking moveDown arrows");
        for (i = 1; i < optionValue.length - 1; ++i) {
            this.tester.clickLink("moveDown_" + optionId[i]);
        }
        this.checkItemsAreInAscendingOrder(optionValue);
        this.logger.log((Object)"  checking moveUp arrows");
        for (i = optionValue.length - 1; i >= 2; --i) {
            this.tester.clickLink("moveUp_" + optionId[i]);
        }
        this.checkItemsAreInAscendingOrder(optionValue);
    }

    public String checkOrderingUsingMoveToPos(String[] optionValue, String[] optionId, String itemType) {
        this.logger.log((Object)"  Testing reordering using 'Move To Position' field inputs");
        this.logger.log((Object)"    Test moving one item");
        this.tester.clickLinkWithText("Sort options alphabetically");
        this.moveOptionsToPositions(optionValue, optionId, itemType, MapBuilder.newBuilder().add("1", "2").toHashMap());
        this.logger.log((Object)"    Test moving two items");
        this.tester.clickLinkWithText("Sort options alphabetically");
        this.moveOptionsToPositions(optionValue, optionId, itemType, MapBuilder.newBuilder().add("1", "3").add("2", "4").toHashMap());
        this.logger.log((Object)"    Test moving three items");
        this.tester.clickLinkWithText("Sort options alphabetically");
        this.moveOptionsToPositions(optionValue, optionId, itemType, MapBuilder.newBuilder().add("1", "3").add("2", "5").add("3", "4").toHashMap());
        return optionValue[1];
    }

    private void checkItemsAreInAscendingOrder(String[] optionValue) {
        for (int i = 1; i < optionValue.length - 1; ++i) {
            this.textAssertions.assertTextSequence(this.page.asString(), "<b>" + optionValue[i] + "</b>", "<b>" + optionValue[i + 1] + "</b>");
        }
    }
}

