/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.CUSTOM_FIELDS, Category.FIELDS})
@LoginAs(user="admin")
public class TestTranslateCustomField
extends BaseJiraFuncTest {
    public static final String NAME_EN = "MY TEXT FIELD";
    public static final String NAME_FR = "Mon champ de texte";
    private static final String DEFAULT_DESCRIPTION = "The default description of MY TEXT FIELD";
    private static final String CUSTOM_DESCRIPTION = "A customised description for Monkey";
    private static final String CUSTOM_DESCRIPTION_FR = "Une nouvelle description";
    private String UPDATE_BUTTON_FRENCH;
    private String ISSUE_TYPE_BUG_FR;
    private String ISSUE_TYPE_BUG_UK;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.UPDATE_BUTTON_FRENCH = this.backdoor.i18n().getText("common.words.update", "fr_FR");
        this.ISSUE_TYPE_BUG_FR = this.backdoor.i18n().getText("jira.translation.issuetype.bug.name", "fr_FR");
        this.ISSUE_TYPE_BUG_UK = this.backdoor.i18n().getText("jira.translation.issuetype.bug.name", "en_UK");
    }

    @Test
    public void testEditFieldConfigurations() throws Exception {
        this.administration.restoreData("TestTranslateCustomField.xml");
        this.backdoor.userProfile().changeUserLanguage("admin", "fr_FR");
        this.assertFieldDescription("homosapien", this.ISSUE_TYPE_BUG_FR, DEFAULT_DESCRIPTION, NAME_EN);
        this.assertFieldDescription("monkey", this.ISSUE_TYPE_BUG_FR, CUSTOM_DESCRIPTION, NAME_EN);
        this.navigation.gotoPage("/secure/admin/TranslateCustomField!default.jspa?id=10000");
        this.tester.setFormElement("description", CUSTOM_DESCRIPTION_FR);
        this.tester.submit(this.UPDATE_BUTTON_FRENCH);
        this.assertFieldDescription("homosapien", this.ISSUE_TYPE_BUG_FR, CUSTOM_DESCRIPTION_FR, NAME_EN);
        this.assertFieldDescription("monkey", this.ISSUE_TYPE_BUG_FR, CUSTOM_DESCRIPTION, NAME_EN);
        this.navigation.gotoPage("/secure/admin/TranslateCustomField!default.jspa?id=10000");
        this.tester.setFormElement("name", NAME_FR);
        this.tester.submit(this.UPDATE_BUTTON_FRENCH);
        this.assertFieldDescription("homosapien", this.ISSUE_TYPE_BUG_FR, CUSTOM_DESCRIPTION_FR, NAME_FR);
        this.assertFieldDescription("monkey", this.ISSUE_TYPE_BUG_FR, CUSTOM_DESCRIPTION, NAME_FR);
        this.backdoor.userProfile().changeUserLanguage("admin", "en_UK");
        this.assertFieldDescription("homosapien", this.ISSUE_TYPE_BUG_UK, DEFAULT_DESCRIPTION, NAME_EN);
        this.assertFieldDescription("monkey", this.ISSUE_TYPE_BUG_UK, CUSTOM_DESCRIPTION, NAME_EN);
        this.backdoor.userProfile().changeUserLanguage("admin", "de_DE");
        this.assertFieldDescription("homosapien", this.ISSUE_TYPE_BUG_UK, DEFAULT_DESCRIPTION, NAME_EN);
        this.assertFieldDescription("monkey", this.ISSUE_TYPE_BUG_UK, CUSTOM_DESCRIPTION, NAME_EN);
        this.backdoor.userProfile().changeUserLanguage("admin", "fr_FR");
        this.navigation.gotoPage("/secure/admin/TranslateCustomField!default.jspa?id=10000");
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("description", "");
        this.tester.submit(this.UPDATE_BUTTON_FRENCH);
        this.assertFieldDescription("homosapien", this.ISSUE_TYPE_BUG_FR, DEFAULT_DESCRIPTION, NAME_EN);
        this.assertFieldDescription("monkey", this.ISSUE_TYPE_BUG_FR, CUSTOM_DESCRIPTION, NAME_EN);
        this.backdoor.userProfile().changeUserLanguage("admin", "en_UK");
    }

    private void assertFieldDescription(String projectName, String issueType, String description, String name) {
        String key = this.navigation.issue().createIssue(projectName, issueType, "Summary");
        this.navigation.issue().viewIssue(key);
        this.tester.clickLink("edit-issue");
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), new String[]{name, description});
    }
}

