/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Dashboard;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.DashboardAssertions;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.List;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.DASHBOARDS})
@LoginAs(user="admin")
public class TestReorderDashboardPages
extends BaseJiraFuncTest {
    private static final SharedEntityInfo PAGE_FRED_PUBLIC = new SharedEntityInfo(10011L, "PublicFredDashboard", "This is a dashboard page that can be seen by everyone.", true, TestSharingPermissionUtils.createPublicPermissions());
    private static final SharedEntityInfo PAGE_EXISTS = new SharedEntityInfo(10012L, "Exists", null, true, TestSharingPermissionUtils.createPrivatePermissions());
    private static final SharedEntityInfo PAGE_ADMINNOTFAVOURITE = new SharedEntityInfo(10013L, "AdminNotFavourite", null, false, TestSharingPermissionUtils.createPublicPermissions());
    private static final SharedEntityInfo PAGE_ADMINFAVOURITE = new SharedEntityInfo(10014L, "AdminFavourite", null, true, TestSharingPermissionUtils.createPublicPermissions());
    private static final String ERROR_403_MESSAGE = "HTTPError403";
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;

    private static String generateDownId(long position) {
        return "pos_down_" + position;
    }

    private static String generateLastId(long position) {
        return "pos_last_" + position;
    }

    private static String generateFirstId(long position) {
        return "pos_first_" + position;
    }

    private static String generateUpId(long position) {
        return "pos_up_" + position;
    }

    private static Locator createUrlLocator(Node root, String urlId) {
        return new XPathLocator(root, "//a[@id='" + urlId + "']/@href");
    }

    @Before
    public void setUpTest() {
        this.administration.restoreData("BaseProfessionalPortalPage.xml");
    }

    @Test
    public void testReorderButtonsAreNotXsrfable() {
        this.tester.gotoPage("/secure/ConfigurePortalPages!moveToStart.jspa?pageId=" + PAGE_FRED_PUBLIC.getId());
        this.tester.assertTextPresent(ERROR_403_MESSAGE);
        this.tester.gotoPage("/secure/ConfigurePortalPages!moveToEnd.jspa?pageId=" + PAGE_FRED_PUBLIC.getId());
        this.tester.assertTextPresent(ERROR_403_MESSAGE);
        this.tester.gotoPage("/secure/ConfigurePortalPages!moveUp.jspa?pageId=" + PAGE_FRED_PUBLIC.getId());
        this.tester.assertTextPresent(ERROR_403_MESSAGE);
        this.tester.gotoPage("/secure/ConfigurePortalPages!moveDown.jspa?pageId=" + PAGE_FRED_PUBLIC.getId());
        this.tester.assertTextPresent(ERROR_403_MESSAGE);
    }

    @Test
    public void testMoveDown() {
        Dashboard dashboard = this.navigation.dashboard();
        dashboard.favouriteDashboard(PAGE_FRED_PUBLIC.getId());
        dashboard.navigateToFavourites();
        this.assertPages(EasyList.build((Object)PAGE_EXISTS, (Object)PAGE_ADMINFAVOURITE, (Object)PAGE_FRED_PUBLIC));
        this.tester.clickLink(TestReorderDashboardPages.generateDownId(0L));
        this.assertPages(EasyList.build((Object)PAGE_ADMINFAVOURITE, (Object)PAGE_EXISTS, (Object)PAGE_FRED_PUBLIC));
        this.tester.clickLink(TestReorderDashboardPages.generateDownId(1L));
        this.assertPages(EasyList.build((Object)PAGE_ADMINFAVOURITE, (Object)PAGE_FRED_PUBLIC, (Object)PAGE_EXISTS));
        this.tester.clickLink(TestReorderDashboardPages.generateDownId(0L));
        this.assertPages(EasyList.build((Object)PAGE_FRED_PUBLIC, (Object)PAGE_ADMINFAVOURITE, (Object)PAGE_EXISTS));
        this.tester.clickLink(TestReorderDashboardPages.generateDownId(0L));
        this.assertPages(EasyList.build((Object)PAGE_ADMINFAVOURITE, (Object)PAGE_FRED_PUBLIC, (Object)PAGE_EXISTS));
        dashboard.unFavouriteDashboard(PAGE_EXISTS.getId());
        dashboard.navigateToFavourites();
        this.assertPages(EasyList.build((Object)PAGE_ADMINFAVOURITE, (Object)PAGE_FRED_PUBLIC));
        this.tester.clickLink(TestReorderDashboardPages.generateDownId(0L));
        this.assertPages(EasyList.build((Object)PAGE_FRED_PUBLIC, (Object)PAGE_ADMINFAVOURITE));
        dashboard.unFavouriteDashboard(PAGE_FRED_PUBLIC.getId());
        dashboard.navigateToFavourites();
        this.assertPages(EasyList.build((Object)PAGE_ADMINFAVOURITE));
    }

    @Test
    public void testMoveDownFavouriteGap() {
        this._testMoveFavouriteGap(new MoveDownCommand());
    }

    @Test
    public void testMoveDownPermissionGap() {
        this._testMovePastPermissionGap(new MoveDownCommand());
    }

    @Test
    public void testMoveUp() {
        Dashboard dashboard = this.navigation.dashboard();
        dashboard.favouriteDashboard(PAGE_FRED_PUBLIC.getId());
        dashboard.navigateToFavourites();
        this.assertPages(EasyList.build((Object)PAGE_EXISTS, (Object)PAGE_ADMINFAVOURITE, (Object)PAGE_FRED_PUBLIC));
        this.tester.clickLink(TestReorderDashboardPages.generateUpId(2L));
        this.assertPages(EasyList.build((Object)PAGE_EXISTS, (Object)PAGE_FRED_PUBLIC, (Object)PAGE_ADMINFAVOURITE));
        this.tester.clickLink(TestReorderDashboardPages.generateUpId(1L));
        this.assertPages(EasyList.build((Object)PAGE_FRED_PUBLIC, (Object)PAGE_EXISTS, (Object)PAGE_ADMINFAVOURITE));
        this.tester.clickLink(TestReorderDashboardPages.generateUpId(1L));
        this.assertPages(EasyList.build((Object)PAGE_EXISTS, (Object)PAGE_FRED_PUBLIC, (Object)PAGE_ADMINFAVOURITE));
        dashboard.unFavouriteDashboard(PAGE_EXISTS.getId());
        dashboard.navigateToFavourites();
        this.assertPages(EasyList.build((Object)PAGE_FRED_PUBLIC, (Object)PAGE_ADMINFAVOURITE));
        this.tester.clickLink(TestReorderDashboardPages.generateUpId(1L));
        this.assertPages(EasyList.build((Object)PAGE_ADMINFAVOURITE, (Object)PAGE_FRED_PUBLIC));
        dashboard.unFavouriteDashboard(PAGE_FRED_PUBLIC.getId());
        dashboard.navigateToFavourites();
        this.assertPages(EasyList.build((Object)PAGE_ADMINFAVOURITE));
    }

    @Test
    public void testMoveUpFavouriteGap() {
        this._testMoveFavouriteGap(new MoveUpCommand());
    }

    @Test
    public void testMoveUpPermissionGap() {
        this._testMovePastPermissionGap(new MoveUpCommand());
    }

    @Test
    public void testMoveStart() {
        Dashboard dashboard = this.navigation.dashboard();
        dashboard.favouriteDashboard(PAGE_FRED_PUBLIC.getId());
        dashboard.navigateToFavourites();
        this.assertPages(EasyList.build((Object)PAGE_EXISTS, (Object)PAGE_ADMINFAVOURITE, (Object)PAGE_FRED_PUBLIC));
        this.tester.clickLink(TestReorderDashboardPages.generateFirstId(2L));
        this.assertPages(EasyList.build((Object)PAGE_FRED_PUBLIC, (Object)PAGE_EXISTS, (Object)PAGE_ADMINFAVOURITE));
        this.tester.clickLink(TestReorderDashboardPages.generateFirstId(1L));
        this.assertPages(EasyList.build((Object)PAGE_EXISTS, (Object)PAGE_FRED_PUBLIC, (Object)PAGE_ADMINFAVOURITE));
        this.tester.clickLink(TestReorderDashboardPages.generateFirstId(2L));
        this.assertPages(EasyList.build((Object)PAGE_ADMINFAVOURITE, (Object)PAGE_EXISTS, (Object)PAGE_FRED_PUBLIC));
        dashboard.unFavouriteDashboard(PAGE_EXISTS.getId());
        dashboard.navigateToFavourites();
        this.assertPages(EasyList.build((Object)PAGE_ADMINFAVOURITE, (Object)PAGE_FRED_PUBLIC));
        this.tester.clickLink(TestReorderDashboardPages.generateFirstId(1L));
        this.assertPages(EasyList.build((Object)PAGE_FRED_PUBLIC, (Object)PAGE_ADMINFAVOURITE));
        dashboard.unFavouriteDashboard(PAGE_FRED_PUBLIC.getId());
        dashboard.navigateToFavourites();
        this.assertPages(EasyList.build((Object)PAGE_ADMINFAVOURITE));
    }

    @Test
    public void testMoveStartPastFavouriteGap() {
        this._testMoveFavouriteGap(new FirstReorderCommand());
    }

    @Test
    public void testMoveStartPastPermissionGap() {
        this._testMovePastPermissionGap(new FirstReorderCommand());
    }

    @Test
    public void testMoveEnd() {
        Dashboard dashboard = this.navigation.dashboard();
        dashboard.favouriteDashboard(PAGE_FRED_PUBLIC.getId());
        dashboard.navigateToFavourites();
        this.assertPages(EasyList.build((Object)PAGE_EXISTS, (Object)PAGE_ADMINFAVOURITE, (Object)PAGE_FRED_PUBLIC));
        this.tester.clickLink(TestReorderDashboardPages.generateLastId(0L));
        this.assertPages(EasyList.build((Object)PAGE_ADMINFAVOURITE, (Object)PAGE_FRED_PUBLIC, (Object)PAGE_EXISTS));
        this.tester.clickLink(TestReorderDashboardPages.generateLastId(1L));
        this.assertPages(EasyList.build((Object)PAGE_ADMINFAVOURITE, (Object)PAGE_EXISTS, (Object)PAGE_FRED_PUBLIC));
        this.tester.clickLink(TestReorderDashboardPages.generateLastId(0L));
        this.assertPages(EasyList.build((Object)PAGE_EXISTS, (Object)PAGE_FRED_PUBLIC, (Object)PAGE_ADMINFAVOURITE));
        dashboard.unFavouriteDashboard(PAGE_EXISTS.getId());
        dashboard.navigateToFavourites();
        this.assertPages(EasyList.build((Object)PAGE_FRED_PUBLIC, (Object)PAGE_ADMINFAVOURITE));
        this.tester.clickLink(TestReorderDashboardPages.generateLastId(0L));
        this.assertPages(EasyList.build((Object)PAGE_ADMINFAVOURITE, (Object)PAGE_FRED_PUBLIC));
        dashboard.unFavouriteDashboard(PAGE_ADMINFAVOURITE.getId());
        dashboard.navigateToFavourites();
        this.assertPages(EasyList.build((Object)PAGE_FRED_PUBLIC));
    }

    @Test
    public void testMoveEndPastFavouriteGap() {
        this._testMoveFavouriteGap(new LastReorderCommand());
    }

    @Test
    public void testMoveEndPastPermissionGap() {
        this._testMovePastPermissionGap(new LastReorderCommand());
    }

    private void _testMoveFavouriteGap(ReorderCommand reorderCommand) {
        SharedEntityInfo newFavourite = new SharedEntityInfo(PAGE_ADMINNOTFAVOURITE);
        newFavourite.setFavourite(true);
        Dashboard dashboard = this.navigation.dashboard();
        dashboard.favouriteDashboard(newFavourite.getId());
        dashboard.navigateToFavourites();
        this.assertPages(EasyList.build((Object)PAGE_EXISTS, (Object)PAGE_ADMINFAVOURITE, (Object)newFavourite));
        this.tester.clickLink(TestReorderDashboardPages.generateUpId(2L));
        this.assertPages(EasyList.build((Object)PAGE_EXISTS, (Object)newFavourite, (Object)PAGE_ADMINFAVOURITE));
        dashboard.unFavouriteDashboard(newFavourite.getId());
        dashboard.navigateToFavourites();
        this.assertPages(EasyList.build((Object)PAGE_EXISTS, (Object)PAGE_ADMINFAVOURITE));
        reorderCommand.reorder(this.tester);
        this.assertPages(EasyList.build((Object)PAGE_ADMINFAVOURITE, (Object)PAGE_EXISTS));
    }

    private void _testMovePastPermissionGap(ReorderCommand reorderCommand) {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            Dashboard dashboard = this.navigation.dashboard();
            dashboard.favouriteDashboard(PAGE_FRED_PUBLIC.getId());
            dashboard.navigateToFavourites();
            this.assertPages(EasyList.build((Object)PAGE_EXISTS, (Object)PAGE_ADMINFAVOURITE, (Object)PAGE_FRED_PUBLIC));
            this.tester.clickLink(TestReorderDashboardPages.generateDownId(1L));
            this.assertPages(EasyList.build((Object)PAGE_EXISTS, (Object)PAGE_FRED_PUBLIC, (Object)PAGE_ADMINFAVOURITE));
            this.makePagePrivate(dashboard, PAGE_FRED_PUBLIC);
            dashboard.navigateToFavourites();
            this.assertPages(EasyList.build((Object)PAGE_EXISTS, (Object)PAGE_ADMINFAVOURITE));
            reorderCommand.reorder(this.tester);
            this.assertPages(EasyList.build((Object)PAGE_ADMINFAVOURITE, (Object)PAGE_EXISTS));
            this.makePagePublic(dashboard, PAGE_FRED_PUBLIC);
            dashboard.navigateToFavourites();
            this.assertPages(EasyList.build((Object)PAGE_ADMINFAVOURITE, (Object)PAGE_EXISTS, (Object)PAGE_FRED_PUBLIC));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
        }
    }

    private SharedEntityInfo makePagePrivate(Dashboard dashboard, SharedEntityInfo page) {
        this.navigation.logout();
        this.navigation.login("fred");
        SharedEntityInfo privatePage = new SharedEntityInfo(page);
        privatePage.setSharingPermissions(TestSharingPermissionUtils.createPrivatePermissions());
        dashboard.editPage(privatePage);
        this.navigation.logout();
        this.navigation.login("admin");
        return privatePage;
    }

    private SharedEntityInfo makePagePublic(Dashboard dashboard, SharedEntityInfo page) {
        this.navigation.logout();
        this.navigation.login("fred");
        SharedEntityInfo privatePage = new SharedEntityInfo(page);
        privatePage.setSharingPermissions(TestSharingPermissionUtils.createPublicPermissions());
        dashboard.editPage(privatePage);
        this.navigation.logout();
        this.navigation.login("admin");
        return privatePage;
    }

    private void assertPages(List pages) {
        DashboardAssertions dashboardAssertions = this.assertions.getDashboardAssertions();
        Locator dashboardLocator = this.createFavouriteLocator();
        dashboardAssertions.assertDashboardPages(pages, Dashboard.Table.FAVOURITE);
        this.assertReorderLinks(pages.size(), dashboardLocator);
    }

    private void assertReorderLinks(int number, Locator dashboardLocator) {
        XPathLocator rows = new XPathLocator(dashboardLocator.getNode(), "tbody/tr");
        Node[] trNodes = rows.getNodes();
        Assert.assertEquals((String)"Not enough rows in the table.", (long)number, (long)trNodes.length);
        for (int i = 0; i < trNodes.length; ++i) {
            Node currentRow = trNodes[i];
            Locator firstLocator = TestReorderDashboardPages.createUrlLocator(currentRow, TestReorderDashboardPages.generateFirstId(i));
            Locator upLocator = TestReorderDashboardPages.createUrlLocator(currentRow, TestReorderDashboardPages.generateUpId(i));
            Assert.assertNotNull((String)("Expecting start arrow on row " + i), (Object)firstLocator.getNode());
            Assert.assertTrue((String)("Expecting start arrow on row " + i), (boolean)firstLocator.getText().startsWith(this.page.addXsrfToken("ConfigurePortalPages!moveToStart.jspa?pageId=")));
            Assert.assertNotNull((String)("Expecting up arrow on row " + i), (Object)upLocator.getNode());
            Assert.assertTrue((String)("Expecting up arrow on row " + i), (boolean)upLocator.getText().startsWith(this.page.addXsrfToken("ConfigurePortalPages!moveUp.jspa?pageId=")));
            Locator lastLocator = TestReorderDashboardPages.createUrlLocator(currentRow, TestReorderDashboardPages.generateLastId(i));
            Locator downLocator = TestReorderDashboardPages.createUrlLocator(currentRow, TestReorderDashboardPages.generateDownId(i));
            Assert.assertNotNull((String)("Expecting end arrow on row " + i), (Object)lastLocator.getNode());
            Assert.assertTrue((String)("Expecting end arrow on row " + i), (boolean)lastLocator.getText().startsWith(this.page.addXsrfToken("ConfigurePortalPages!moveToEnd.jspa?pageId=")));
            Assert.assertNotNull((String)("Expecting down arrow on row " + i), (Object)downLocator.getNode());
            Assert.assertTrue((String)("Expecting down arrow on row " + i), (boolean)downLocator.getText().startsWith(this.page.addXsrfToken("ConfigurePortalPages!moveDown.jspa?pageId=")));
        }
    }

    private Locator createFavouriteLocator() {
        return new XPathLocator(this.tester, Dashboard.Table.FAVOURITE.toXPath());
    }

    private static class LastReorderCommand
    implements ReorderCommand {
        private LastReorderCommand() {
        }

        @Override
        public void reorder(WebTester tester) {
            tester.clickLink(TestReorderDashboardPages.generateLastId(0L));
        }
    }

    private static class FirstReorderCommand
    implements ReorderCommand {
        private FirstReorderCommand() {
        }

        @Override
        public void reorder(WebTester tester) {
            tester.clickLink(TestReorderDashboardPages.generateFirstId(1L));
        }
    }

    private static class MoveUpCommand
    implements ReorderCommand {
        private MoveUpCommand() {
        }

        @Override
        public void reorder(WebTester tester) {
            tester.clickLink(TestReorderDashboardPages.generateUpId(1L));
        }
    }

    private static class MoveDownCommand
    implements ReorderCommand {
        private MoveDownCommand() {
        }

        @Override
        public void reorder(WebTester tester) {
            tester.clickLink(TestReorderDashboardPages.generateDownId(0L));
        }
    }

    private static interface ReorderCommand {
        public void reorder(WebTester var1);
    }
}

