/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.management;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.parser.dashboard.DashboardItem;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
@LoginAs(user="admin")
@Restore(value="TestSharedDashboards.xml")
public class TestChangeSharedDashboardOwnerByAdmins
extends BaseJiraFuncTest {
    private static final String DEV1 = "developer";
    private static final String DEV2 = "anotherdev";
    private static final String USER = "Fred";
    @Inject
    private Administration administration;

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=811000)
    public void testAnAdminIsAbleToChangeOwnersOfDashboardsSharedWithAGroupHeDoesNotBelongTo() {
        ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10015L).name("Shared Dashboard with group jira-developers owned by developer").owner("Another Developer (anotherdev)").build());
        List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().changeDashboardOwner(10015L, DEV2).dashboards().list();
        Assert.assertThat(actualDashboardItems, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)actualDashboardItems.isEmpty(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.in(actualDashboardItems)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAnAdminIsAbleToChangeOwnerOfDashboardsSharedWithAGroupHeBelongsTo() {
        ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10014L).name("Shared Dashboard with Anyone owned by developer").owner("Fred Normal (fred)").build(), (Object)new DashboardItem.Builder().id(10018L).name("Shared Dashboard with group jira-users owned by fred").owner("Developer (developer)").build());
        List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().changeDashboardOwner(10014L, USER).changeDashboardOwner(10018L, DEV1).dashboards().list();
        Assert.assertThat(actualDashboardItems, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)actualDashboardItems.isEmpty(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.in(actualDashboardItems)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=811000)
    public void testAnAdminIsAbleToChangeOwnerOfDashboardsSharedWithARoleHeIsNotPartOf() {
        ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10016L).name("Shared Dashboard with role Developers on homosapiens owned by developer").owner("Another Developer (anotherdev)").build());
        List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().changeDashboardOwner(10016L, DEV2).dashboards().list();
        Assert.assertThat(actualDashboardItems, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)actualDashboardItems.isEmpty(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.in(actualDashboardItems)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAnAdminIsAbleToChangeOwnerOfDashboardsSharedWithARoleHeIsPartOf() {
        ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10019L).name("Shared Dashboard with role Users on homosapien owned by fred").owner("Developer (developer)").build(), (Object)new DashboardItem.Builder().id(10013L).name("Shared Dashboard with all roles on Monkey owned by developer").owner("Fred Normal (fred)").build());
        List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().changeDashboardOwner(10019L, DEV1).changeDashboardOwner(10013L, USER).dashboards().list();
        Assert.assertThat(actualDashboardItems, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)actualDashboardItems.isEmpty(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.in(actualDashboardItems)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAnAdminCannotChangeOwnerOfDashboardsWhenNewOwnerDoesNotHaveSharePermission() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10016L).name("Shared Dashboard with role Developers on homosapiens owned by developer").owner("Fred Normal (fred)").build());
            List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().changeDashboardOwner(10016L, USER).dashboards().list();
            Assert.assertThat(actualDashboardItems, (Matcher)Matchers.notNullValue());
            Assert.assertThat((Object)actualDashboardItems.isEmpty(), (Matcher)Matchers.is((Object)false));
            Assert.assertThat((Object)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.not((Predicate)Predicates.in(actualDashboardItems))), (Matcher)Matchers.is((Object)true));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    @Test
    public void testAnAdminCanChangeOwnerOfDashboardsWhenNewOwnerDoesNotHaveSharePermission() {
        try {
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10016L).name("Shared Dashboard with role Developers on homosapiens owned by developer").owner("Fred Normal (fred)").build());
            List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().changeDashboardOwner(10016L, USER).dashboards().list();
            Assert.assertThat(actualDashboardItems, (Matcher)Matchers.notNullValue());
            Assert.assertThat((Object)actualDashboardItems.isEmpty(), (Matcher)Matchers.is((Object)false));
            Assert.assertThat((Object)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.not((Predicate)Predicates.in(actualDashboardItems))), (Matcher)Matchers.is((Object)false));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=811000)
    public void testAnAdminIsAbleToChangeOwnerOfPrivateDashboards() {
        ImmutableList expectedDashboardItems = ImmutableList.of((Object)new DashboardItem.Builder().id(10012L).name("Private Dasboard owned by developer").owner("Fred Normal (fred)").build());
        List<DashboardItem> actualDashboardItems = this.administration.sharedDashboards().goTo().searchAll().changeDashboardOwner(10012L, USER).dashboards().list();
        Assert.assertThat(actualDashboardItems, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)actualDashboardItems.isEmpty(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Iterables.all((Iterable)expectedDashboardItems, (Predicate)Predicates.in(actualDashboardItems)), (Matcher)Matchers.is((Object)true));
    }
}

