/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports.security.xss;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.ws.rs.WebApplicationException;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@WebTest(value={Category.FUNC_TEST, Category.GADGETS, Category.REST})
@RestoreBlankInstance
@LoginAs(user="admin")
@RunWith(value=Parameterized.class)
public class TestCSRFPieChart
extends BaseJiraFuncTest {
    protected Long projectId;
    @Parameterized.Parameter(value=0)
    public int size;
    @Parameterized.Parameter(value=1)
    public Optional<Class<Throwable>> exception;
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({-2, Optional.of(WebApplicationException.class)}, {0, Optional.of(WebApplicationException.class)}, {1, Optional.empty()}, {10, Optional.empty()}, {1000, Optional.empty()});
    }

    @Before
    public void before() {
        this.projectId = this.backdoor.project().addProject("HAMBURG", "HAM", "admin");
    }

    @After
    public void after() {
        this.backdoor.project().deleteProject("HAM");
    }

    @Test
    public void generatedEmptyChartMatchesSize() throws IOException {
        TestPieChartClient testPieChartClient = new TestPieChartClient(this.environmentData);
        this.exception.ifPresent(x -> this.exceptionRule.expect(x));
        Map<String, Object> generatedImageData = testPieChartClient.generateImage("project-" + this.projectId, this.size, this.size);
        BufferedImage generatedImage = testPieChartClient.getImage((String)generatedImageData.get("location"));
        Assertions.assertEquals((int)generatedImage.getWidth(), (int)this.size);
        Assertions.assertEquals((int)generatedImage.getHeight(), (int)this.size);
    }

    @Test
    public void generatedContainingChartMatchesSize() throws IOException {
        this.backdoor.issues().createIssue("HAM", "summary", "admin");
        TestPieChartClient testPieChartClient = new TestPieChartClient(this.environmentData);
        this.exception.ifPresent(x -> this.exceptionRule.expect(x));
        Map<String, Object> generatedImageData = testPieChartClient.generateImage("project-" + this.projectId, this.size, this.size);
        BufferedImage generatedImage = testPieChartClient.getImage((String)generatedImageData.get("location"));
        Assertions.assertEquals((int)generatedImage.getWidth(), (int)this.size);
        Assertions.assertEquals((int)generatedImage.getHeight(), (int)this.size);
    }

    private static class TestPieChartClient
    extends RestApiClient<TestPieChartClient> {
        JIRAEnvironmentData environmentData;

        TestPieChartClient(JIRAEnvironmentData environmentData) {
            super(environmentData);
            this.environmentData = environmentData;
        }

        private BufferedImage getImage(String name) throws IOException {
            try (InputStream is = (InputStream)this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("charts").queryParam("filename", new Object[]{name}).request().get(InputStream.class);){
                BufferedImage bufferedImage = ImageIO.read(is);
                return bufferedImage;
            }
        }

        Map<String, Object> generateImage(String projectOrFilterId, Integer width, Integer height) {
            return (Map)this.createResourceGadget().path("piechart").path("generate").queryParam("projectOrFilterId", new Object[]{projectOrFilterId}).queryParam("width", new Object[]{width.toString()}).queryParam("height", new Object[]{height.toString()}).request().get(Map.class);
        }
    }
}

