/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraEmailTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.email.EmailKit;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.MailTest;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.webtests.LicenseKeys;
import java.util.Collection;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL, Category.ISSUES})
@LoginAs(user="admin")
public class TestArchiveRestoreNotifications
extends BaseJiraEmailTest {
    private static final FeatureFlag ISSUE_ARCHIVING_FEATURE_FLAG = FeatureFlag.featureFlag((String)"com.atlassian.jira.issues.archiving");
    private static final int MINIMAL_ARCHIVING_ENABLED_BUILD_NUMBER = 801000;

    @Before
    public void setUp() {
        Assume.assumeTrue((this.backdoor.serverInfo().get().getBuildNumber() >= 801000L ? 1 : 0) != 0);
    }

    @Test
    @Restore(value="TestBulkDeleteIssuesNotifications.xml")
    @MailTest
    public void testArchiveNotifications() throws InterruptedException {
        this.backdoor.license().set(LicenseKeys.COMMERCIAL_FOR_ARCHIVING);
        this.backdoor.darkFeatures().enableForSite(ISSUE_ARCHIVING_FEATURE_FLAG);
        this.navigation.userProfile().changeNotifyMyChanges(true);
        Assert.assertEquals((long)this.backdoor.issues().archiveIssue("HSP-2").getStatus(), (long)204L);
        Collection<MimeMessage> mails = this.mailHelper.flushMailQueueAndWait(1);
        Assert.assertEquals((long)1L, (long)mails.size());
        MatcherAssert.assertThat((Object)EmailKit.getBody((Part)mails.stream().findFirst().get()), (Matcher)StringContains.containsString((String)"archived"));
    }

    @Test
    @Restore(value="TestBulkDeleteIssuesNotifications.xml")
    @MailTest
    public void testRestoreNotifications() throws InterruptedException {
        this.backdoor.license().set(LicenseKeys.COMMERCIAL_FOR_ARCHIVING);
        this.backdoor.darkFeatures().enableForSite(ISSUE_ARCHIVING_FEATURE_FLAG);
        Assert.assertEquals((long)this.backdoor.issues().archiveIssue("HSP-2").getStatus(), (long)204L);
        this.navigation.userProfile().changeNotifyMyChanges(true);
        Assert.assertEquals((long)this.backdoor.issues().restoreIssue("HSP-2").getStatus(), (long)204L);
        Collection<MimeMessage> mails = this.mailHelper.flushMailQueueAndWait(1);
        Assert.assertEquals((long)1L, (long)mails.size());
        MatcherAssert.assertThat((Object)EmailKit.getBody((Part)mails.stream().findFirst().get()), (Matcher)StringContains.containsString((String)"restored"));
    }
}

