/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraEmailTest;
import com.atlassian.jira.functest.framework.BulkOperationProgress;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.MailTest;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.webtests.LicenseKeys;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.EMAIL, Category.ISSUES})
@LoginAs(user="admin")
@MailTest
public class TestBulkArchiveIssuesNotifications
extends BaseJiraEmailTest {
    private static final FeatureFlag ISSUE_ARCHIVING_FEATURE_FLAG = FeatureFlag.featureFlag((String)"com.atlassian.jira.issues.archiving");
    private static final int MINIMAL_ARCHIVING_ENABLED_BUILD_NUMBER = 801000;
    @Inject
    protected TextAssertions textAssertions;
    @Inject
    private BulkOperationProgress bulkOperationProgress;
    @Inject
    private LocatorFactory locator;

    @Before
    public void setUp() {
        Assume.assumeTrue((this.backdoor.serverInfo().get().getBuildNumber() >= 801000L ? 1 : 0) != 0);
    }

    @Test
    @Restore(value="TestBulkDeleteIssuesNotifications.xml")
    public void testBulkArchiveNoNoEmatifications() throws InterruptedException {
        this.backdoor.license().set(LicenseKeys.COMMERCIAL_FOR_ARCHIVING);
        this.backdoor.darkFeatures().enableForSite(ISSUE_ARCHIVING_FEATURE_FLAG);
        this.navigation.userProfile().changeNotifyMyChanges(true);
        this.bulkArchiveAllIssues(false, false);
        Collection<MimeMessage> mails = this.mailHelper.flushMailQueueAndWait(0);
        Assert.assertEquals((long)0L, (long)mails.size());
    }

    @Test
    @Restore(value="TestBulkDeleteIssuesNotifications.xml")
    public void testBulkArchiveNotifications() throws InterruptedException, MessagingException {
        this.backdoor.license().set(LicenseKeys.COMMERCIAL_FOR_ARCHIVING);
        this.backdoor.darkFeatures().enableForSite(ISSUE_ARCHIVING_FEATURE_FLAG);
        this.navigation.userProfile().changeNotifyMyChanges(true);
        this.bulkArchiveAllIssues(true, false);
        Collection<MimeMessage> mails = this.mailHelper.flushMailQueueAndWait(2);
        Assert.assertEquals((long)2L, (long)mails.size());
        this.assertRecipients(mails, "fred@example.com", "admin@example.com");
    }

    @Test
    @Restore(value="TestBulkDeleteIssuesNotificationsWithSubtasks.xml")
    public void testBulkArchiveSubtaskNoNotifications() throws InterruptedException {
        this.backdoor.license().set(LicenseKeys.COMMERCIAL_FOR_ARCHIVING);
        this.backdoor.darkFeatures().enableForSite(ISSUE_ARCHIVING_FEATURE_FLAG);
        this.navigation.userProfile().changeNotifyMyChanges(true);
        this.bulkArchiveAllIssues(false, true);
        Collection<MimeMessage> mails = this.mailHelper.flushMailQueueAndWait(0);
        Assert.assertEquals((long)0L, (long)mails.size());
    }

    @Test
    @Restore(value="TestBulkDeleteIssuesNotificationsWithSubtasks.xml")
    public void testBulkArchiveSubtaskNotifications() throws InterruptedException, MessagingException {
        this.backdoor.license().set(LicenseKeys.COMMERCIAL_FOR_ARCHIVING);
        this.backdoor.darkFeatures().enableForSite(ISSUE_ARCHIVING_FEATURE_FLAG);
        this.navigation.userProfile().changeNotifyMyChanges(true);
        this.bulkArchiveAllIssues(true, true);
        Collection<MimeMessage> mimeMessages = this.mailHelper.flushMailQueueAndWait(2);
        Assert.assertEquals((long)2L, (long)mimeMessages.size());
        this.assertRecipients(mimeMessages, "fred@example.com", "admin@example.com");
        ArrayList<String> subjects = new ArrayList<String>();
        List<MimeMessage> adminMessages = this.mailHelper.getMessagesForAddress(mimeMessages, "admin@example.com");
        for (MimeMessage adminMessage : adminMessages) {
            subjects.add(adminMessage.getSubject());
        }
        Assert.assertThat(subjects, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"[JIRATEST] (HSP-2) This is my bug"}));
        List<MimeMessage> fredMessages = this.mailHelper.getMessagesForAddress(mimeMessages, "fred@example.com");
        Assert.assertEquals((Object)fredMessages.get(0).getSubject(), (Object)"[JIRATEST] (HSP-3) This is fred's bug");
    }

    private void bulkArchiveAllIssues(boolean sendMail, boolean subtaskPresent) {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.tester.checkCheckbox("bulkedit_10002", "on");
        this.tester.checkCheckbox("bulkedit_10001", "on");
        this.tester.submit("Next");
        this.tester.setFormElement("operation", "bulk.archive.operation.name");
        this.tester.submit("Next");
        if (!sendMail) {
            this.tester.uncheckCheckbox("sendBulkNotification");
        }
        this.tester.submit("Next");
        if (!sendMail) {
            this.textAssertions.assertTextSequence(this.locator.page(), "Email notifications will", "NOT", "be sent for this update.");
        } else {
            this.tester.assertTextPresent("Email notifications will be sent for this update.");
        }
        if (subtaskPresent) {
            this.tester.assertTextPresent("Subtask1");
        } else {
            this.tester.assertTextNotPresent("Subtask1");
        }
        this.tester.submit("Confirm");
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.tester.assertElementNotPresent("issuetable");
    }

    private void assertRecipients(Collection<MimeMessage> mails, String ... expectedRecipients) {
        List recipients = mails.stream().flatMap(mail -> {
            try {
                return Arrays.stream(mail.getAllRecipients()).map(Address::toString);
            }
            catch (MessagingException e) {
                return Stream.empty();
            }
        }).collect(Collectors.toList());
        Assert.assertThat(recipients, (Matcher)Matchers.containsInAnyOrder((Object[])expectedRecipients));
    }
}

