/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.email.EmailKit;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.AbstractSubscriptionEmailTest;
import java.util.Arrays;
import java.util.Iterator;
import javax.inject.Inject;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.EMAIL})
@Restore(value="TestSubscription.xml")
@LoginAs(user="admin")
public class TestEmailSubscription
extends AbstractSubscriptionEmailTest {
    @Inject
    protected TextAssertions textAssertions;
    @Inject
    private Administration administration;

    @Before
    public void setUpMailServer() {
        this.configureAndStartSmtpServer();
    }

    @Before
    public void setUpNotificationTypes() {
        this.backdoor.userProfile().changeUserNotificationType("admin", "text");
        this.backdoor.userProfile().changeUserNotificationType("bob", "text");
    }

    @Test
    public void testGroupZeroResults() throws Exception {
        this.subscribeToFilterAndRun(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_ZERO_RESULTS, "jira-users");
        this.flushMailQueueAndWait(3);
        MimeMessage[] messages = this.mailService.getReceivedMessages();
        MimeMessage currentMessage = EmailKit.findMessageAddressedTo("admin@stuff.com.com", messages);
        Assert.assertNotNull((Object)currentMessage);
        this.assertTextMessageValid(currentMessage, AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_ZERO_RESULTS, "jiratest@atlassian.com", "admin@stuff.com.com", "admin");
        String body = EmailKit.getBody((Part)currentMessage);
        TestEmailSubscription.assertNotPartialLink(body);
        TestEmailSubscription.assertEditLinkText(body);
        currentMessage = EmailKit.findMessageAddressedTo("bob@stuff.com.com", messages);
        Assert.assertNotNull((Object)currentMessage);
        this.assertTextMessageValid(currentMessage, AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_ZERO_RESULTS, "jiratest@atlassian.com", "bob@stuff.com.com", "admin");
        body = EmailKit.getBody((Part)currentMessage);
        TestEmailSubscription.assertNotPartialLink(body);
        TestEmailSubscription.assertNotEditLink(body);
        currentMessage = EmailKit.findMessageAddressedTo("fred@example.com", messages);
        Assert.assertNotNull((Object)currentMessage);
        this.assertHtmlMessageValid(currentMessage, AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_ZERO_RESULTS, "jiratest@atlassian.com", "fred@example.com", "admin");
        body = EmailKit.getBody((Part)currentMessage);
        TestEmailSubscription.assertNotPartialLink(body);
        TestEmailSubscription.assertNotEditLink(body);
    }

    @Test
    public void testGroupCompleteResults() throws Exception {
        this.subscribeToFilterAndRun(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_FULL, "jira-users");
        this.flushMailQueueAndWait(3);
        MimeMessage[] messages = this.mailService.getReceivedMessages();
        MimeMessage currentMessage = EmailKit.findMessageAddressedTo("admin@stuff.com.com", messages);
        Assert.assertNotNull((Object)currentMessage);
        this.assertTextMessageValid(currentMessage, AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_FULL, "jiratest@atlassian.com", "admin@stuff.com.com", "admin");
        String body = EmailKit.getBody((Part)currentMessage);
        TestEmailSubscription.assertNotPartialLink(body);
        TestEmailSubscription.assertEditLinkText(body);
        currentMessage = EmailKit.findMessageAddressedTo("bob@stuff.com.com", messages);
        Assert.assertNotNull((Object)currentMessage);
        this.assertTextMessageValid(currentMessage, AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_FULL, "jiratest@atlassian.com", "bob@stuff.com.com", "admin");
        body = EmailKit.getBody((Part)currentMessage);
        TestEmailSubscription.assertNotPartialLink(body);
        TestEmailSubscription.assertNotEditLink(body);
        currentMessage = EmailKit.findMessageAddressedTo("fred@example.com", messages);
        Assert.assertNotNull((Object)currentMessage);
        this.assertHtmlMessageValid(currentMessage, AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_FULL, "jiratest@atlassian.com", "fred@example.com", "admin");
        body = EmailKit.getBody((Part)currentMessage);
        TestEmailSubscription.assertNotPartialLink(body);
        TestEmailSubscription.assertNotEditLink(body);
    }

    @Test
    public void testMessageShouldContainAttachedIssueTypeAndPriorityIcons() throws Exception {
        this.subscribeToFilterAndRun(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_FULL, "jira-users");
        int expectedMultiPartCount = 3;
        this.flushMailQueueAndWait(3);
        MimeMessage[] messages = this.mailService.getReceivedMessages();
        MimeMessage message = EmailKit.findMessageAddressedTo("fred@example.com", messages);
        MimeMultipart messageMultipart = (MimeMultipart)message.getContent();
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((long)3L, (long)messageMultipart.getCount());
        String body = EmailKit.getBody((Part)message);
        for (int i = 0; i < messageMultipart.getCount(); ++i) {
            BodyPart bodyPart = messageMultipart.getBodyPart(i);
            String[] contentTypeHeaders = bodyPart.getHeader("Content-Type");
            Assert.assertNotNull((String)String.format("Body part %d should have Content-Type header.", i), (Object)contentTypeHeaders);
            MatcherAssert.assertThat((String)String.format("Body part %d should have Content-Type header.", i), (Object)contentTypeHeaders, (Matcher)Matchers.not((Matcher)Matchers.emptyArray()));
            if (!Arrays.asList(contentTypeHeaders).contains("image/png")) continue;
            String[] contentIdHeaders = bodyPart.getHeader("Content-ID");
            Assert.assertNotNull((String)String.format("Png image body part %d should have Content-ID header.", i), (Object)contentIdHeaders);
            MatcherAssert.assertThat((String)String.format("Png image body part %d should have Content-ID header.", i), (Object)contentIdHeaders, (Matcher)Matchers.not((Matcher)Matchers.emptyArray()));
            MatcherAssert.assertThat((Object)body, (Matcher)Matchers.containsString((String)contentIdHeaders[0]));
        }
    }

    @Test
    public void testGroupPartialResults() throws Exception {
        this.subscribeToFilterAndRun(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_PARTIAL, "jira-users");
        this.flushMailQueueAndWait(3);
        MimeMessage[] messages = this.mailService.getReceivedMessages();
        MimeMessage currentMessage = EmailKit.findMessageAddressedTo("admin@stuff.com.com", messages);
        Assert.assertNotNull((Object)currentMessage);
        this.assertTextMessageValid(currentMessage, AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_PARTIAL, "jiratest@atlassian.com", "admin@stuff.com.com", "admin");
        String body = EmailKit.getBody((Part)currentMessage);
        body = TestEmailSubscription.assertPartialLinkText(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_PARTIAL, body);
        TestEmailSubscription.assertEditLinkText(body);
        currentMessage = EmailKit.findMessageAddressedTo("bob@stuff.com.com", messages);
        Assert.assertNotNull((Object)currentMessage);
        this.assertTextMessageValid(currentMessage, AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_PARTIAL, "jiratest@atlassian.com", "bob@stuff.com.com", "admin");
        body = EmailKit.getBody((Part)currentMessage);
        body = TestEmailSubscription.assertPartialLinkText(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_PARTIAL, body);
        TestEmailSubscription.assertNotEditLink(body);
        currentMessage = EmailKit.findMessageAddressedTo("fred@example.com", messages);
        Assert.assertNotNull((Object)currentMessage);
        this.assertHtmlMessageValid(currentMessage, AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_PARTIAL, "jiratest@atlassian.com", "fred@example.com", "admin");
        body = EmailKit.getBody((Part)currentMessage);
        body = TestEmailSubscription.assertPartialLinkHtml(AbstractSubscriptionEmailTest.FilterConfig.ADMIN_FILTER_PARTIAL, body);
        TestEmailSubscription.assertNotEditLink(body);
    }

    @Test
    public void testPersonalZeroResults() throws Exception {
        this.navigation.login("fred", "fred");
        this.subscribeToFilterAndRun(AbstractSubscriptionEmailTest.FilterConfig.FRED_FILTER_ZERO_RESULTS, null);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.flushMailQueueAndWait(1);
        MimeMessage[] messages = this.mailService.getReceivedMessages();
        Assert.assertNotNull((Object)messages[0]);
        this.assertHtmlMessageValid(messages[0], AbstractSubscriptionEmailTest.FilterConfig.FRED_FILTER_ZERO_RESULTS, "jiratest@atlassian.com", "fred@example.com", "fred");
        String body = EmailKit.getBody((Part)messages[0]);
        TestEmailSubscription.assertNotPartialLink(body);
        TestEmailSubscription.assertEditLinkHtml(body);
    }

    @Test
    public void testPersonalCompleteResults() throws Exception {
        this.navigation.login("fred", "fred");
        this.subscribeToFilterAndRun(AbstractSubscriptionEmailTest.FilterConfig.FRED_FILTER_FULL, null);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.flushMailQueueAndWait(1);
        MimeMessage[] messages = this.mailService.getReceivedMessages();
        Assert.assertNotNull((Object)messages[0]);
        this.assertHtmlMessageValid(messages[0], AbstractSubscriptionEmailTest.FilterConfig.FRED_FILTER_FULL, "jiratest@atlassian.com", "fred@example.com", "fred");
        String body = EmailKit.getBody((Part)messages[0]);
        TestEmailSubscription.assertNotPartialLink(body);
        TestEmailSubscription.assertEditLinkHtml(body);
    }

    @Test
    public void testPersonalPartialResults() throws Exception {
        this.navigation.login("fred", "fred");
        this.subscribeToFilterAndRun(AbstractSubscriptionEmailTest.FilterConfig.FRED_FILTER_PARTIAL, null);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.flushMailQueueAndWait(1);
        MimeMessage[] messages = this.mailService.getReceivedMessages();
        Assert.assertNotNull((Object)messages[0]);
        this.assertHtmlMessageValid(messages[0], AbstractSubscriptionEmailTest.FilterConfig.FRED_FILTER_PARTIAL, "jiratest@atlassian.com", "fred@example.com", "fred");
        String body = EmailKit.getBody((Part)messages[0]);
        body = TestEmailSubscription.assertPartialLinkHtml(AbstractSubscriptionEmailTest.FilterConfig.FRED_FILTER_PARTIAL, body);
        TestEmailSubscription.assertEditLinkHtml(body);
    }

    @Test
    public void testSubscriptionIsHtmlEncoded() throws Exception {
        this.administration.restoreData("Test_JRA_17595.xml");
        this.configureAndStartSmtpServer();
        AbstractSubscriptionEmailTest.FilterConfig ADMIN_FILTER_XSS = new AbstractSubscriptionEmailTest.FilterConfig("FilterTwo", "<b>Description</b>", "ProjectTwo", "TWO", 2, 2){

            @Override
            public Iterator<Integer> getIssueIterator() {
                return new AbstractSubscriptionEmailTest.CountingIterator(1, this.getReturnedIssues());
            }
        };
        this.subscribeToFilterAndRun(ADMIN_FILTER_XSS, "jira-users");
        this.flushMailQueueAndWait(4);
        MimeMessage[] messages = this.mailService.getReceivedMessages();
        MimeMessage currentMessage = EmailKit.findMessageAddressedTo("admin@stuff.com.com", messages);
        Assert.assertNotNull((Object)currentMessage);
        this.assertHtmlMessageValid(currentMessage, ADMIN_FILTER_XSS, "jiratest@atlassian.com", "admin@stuff.com.com", "admin");
        String body = EmailKit.getBody((Part)currentMessage);
        this.textAssertions.assertTextPresent(body, "&lt;b&gt;Description&lt;/b&gt;");
        this.textAssertions.assertTextPresent(body, "Administrator &lt;b&gt;bold&lt;/b&gt;");
        currentMessage = EmailKit.findMessageAddressedTo("xss@example.com", messages);
        Assert.assertNotNull((Object)currentMessage);
        body = EmailKit.getBody((Part)currentMessage);
        this.textAssertions.assertTextPresent(body, "&lt;b&gt;Description&lt;/b&gt;");
    }

    @Test
    public void testUserNameIsEncodedInHtml() throws InterruptedException, MessagingException {
        this.administration.restoreData("Test_JRA_17595.xml");
        this.configureAndStartSmtpServer();
        AbstractSubscriptionEmailTest.FilterConfig XSS_FILTER_XSS = new AbstractSubscriptionEmailTest.FilterConfig("XssFilter", "<b>Description</b>", "ProjectTwo", "TWO", 2, 2){

            @Override
            public Iterator<Integer> getIssueIterator() {
                return new AbstractSubscriptionEmailTest.CountingIterator(1, this.getReturnedIssues());
            }
        };
        this.navigation.login("<b>xss</b>", "<b>xss</b>");
        this.subscribeToFilterAndRun(XSS_FILTER_XSS, null);
        this.navigation.login("admin", "admin");
        this.flushMailQueueAndWait(1);
        MimeMessage[] messages = this.mailService.getReceivedMessages();
        MimeMessage currentMessage = EmailKit.findMessageAddressedTo("xss@example.com", messages);
        Assert.assertNotNull((Object)currentMessage);
        String body = EmailKit.getBody((Part)currentMessage);
        this.textAssertions.assertTextPresent(body, "&lt;b&gt;Description&lt;/b&gt;");
        this.textAssertions.assertTextSequence(body, new String[]{"Subscriber:", "&lt;b&gt;xss&lt;/b&gt;"});
    }
}

