/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraEmailTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.MailTest;
import java.util.List;
import javax.inject.Inject;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
@Restore(value="TestIssueNotificationsCurrentAssignee.xml")
@MailTest
public class TestIssueEmailSubject
extends BaseJiraEmailTest {
    @Inject
    protected Administration administration;

    @Before
    public void setUpTest() {
        this.navigation.login("admin");
        this.navigation.userProfile().changeNotifyMyChanges(true);
        this.administration.generalConfiguration().setAllowUnassignedIssues(true);
    }

    private MimeMessage assertEmailSubject(Runnable setup, String expectedSubjectHeading) throws Exception {
        setup.run();
        List<MimeMessage> messagesForAdmin = this.mailHelper.filterMessagesForRecipient(this.mailHelper.flushMailQueueAndWait(1), "admin@example.com");
        Assert.assertEquals((long)1L, (long)messagesForAdmin.size());
        MimeMessage message = messagesForAdmin.get(0);
        Assert.assertEquals((Object)message.getSubject(), (Object)expectedSubjectHeading);
        return message;
    }

    private void assertEmailSubject(Runnable setup, String expectedSubjectHeading, String expectedTitle) throws Exception {
        MimeMessage message = this.assertEmailSubject(setup, expectedSubjectHeading);
        this.assertEmailTitleEquals(message, expectedTitle);
    }

    @Test
    public void testCreateIssue() throws Exception {
        this.assertEmailSubject(new Runnable(){

            @Override
            public void run() {
                TestIssueEmailSubject.this.navigation.issue().createIssue("COW", null, "New issue");
            }
        }, "[JIRATEST] (COW-4) New issue", "New issue");
    }

    @Test
    public void testIssueUpdated() throws Exception {
        this.assertEmailSubject(new Runnable(){

            @Override
            public void run() {
                TestIssueEmailSubject.this.navigation.issue().setDescription("COW-2", "Updated text");
            }
        }, "[JIRATEST] (COW-2) This cow has a calf");
    }

    @Test
    public void testAssignIssue() throws Exception {
        this.assertEmailSubject(new Runnable(){

            @Override
            public void run() {
                TestIssueEmailSubject.this.navigation.issue().unassignIssue("COW-2", "this is a comment");
            }
        }, "[JIRATEST] (COW-2) This cow has a calf");
    }

    @Test
    public void testIssueResolved() throws Exception {
        this.assertEmailSubject(new Runnable(){

            @Override
            public void run() {
                TestIssueEmailSubject.this.navigation.issue().resolveIssue("COW-2", "Fixed", "Yay!");
            }
        }, "[JIRATEST] (COW-2) This cow has a calf");
    }

    @Test
    public void testIssueCommented() throws Exception {
        this.assertEmailSubject(new Runnable(){

            @Override
            public void run() {
                TestIssueEmailSubject.this.navigation.issue().addComment("COW-2", "jaisodf", null);
            }
        }, "[JIRATEST] (COW-2) This cow has a calf");
    }

    @Test
    public void testIssueDeleted() throws Exception {
        this.assertEmailSubject(new Runnable(){

            @Override
            public void run() {
                TestIssueEmailSubject.this.navigation.issue().deleteIssue("COW-3");
            }
        }, "[JIRATEST] (COW-3) A calf is a tasty little renet factory");
    }
}

