/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.UserProfileImpl;
import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.functest.framework.admin.NotificationSchemes;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import com.google.common.collect.ImmutableList;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL, Category.ISSUES})
@LoginAs(user="admin")
public class TestIssueNotifications
extends EmailBaseFuncTestCase {
    private static final String ADMIN_COMMENT = "This comment will be for admin";
    private static final String HENRY_COMMENT = "This comment will be for henry";
    private static final String GROUP_TYPE = "group";
    private static final String ROLE_TYPE = "role";
    private static final String ADMINISTRATORS_ROLE = "Administrators";
    private static final String USERS_ROLE = "Users";
    private static final String ADMINISTRATORS_GROUP = "jira-administrators";
    private static final String USERS_GROUP = "jira-users";
    private static final String ISSUE_KEY_1 = "COW-1";
    private static final String ISSUE_KEY_2 = "COW-2";
    private static final String ISSUE_KEY_3 = "COW-3";
    private static final String ISSUE_1_SUBJECT = "[JIRATEST] (COW-1) The cow is in the pasture";
    private static final String ISSUE_3_SUBJECT = "[JIRATEST] (COW-3) A calf is a tasty little renet factory";
    private static final String ISSUE_1_PATTERN = ".*COW.*>.*COW-1.*";
    private static final String ISSUE_2_PATTERN = ".*COW.*>.*COW-2.*";
    private static final String JIRA_NO_FROTHER_REPORTER_FIELD = "jira.no.frother.reporter.field";
    private static final String NO_FROTHER_ASSIGNEE_FIELD = "no.frother.assignee.field";
    private static final String COMMENTED_STRING = "commented";
    private static final String DELETED_STRING = "deleted";
    private static final String DELETE_COMMENT_LINK = "delete_comment_10000";
    private static final String EDIT_COMMENT_LINK = "edit_comment_10000";
    private static final String DELETE_BUTTON = "Delete";
    private static final String SAVE_BUTTON = "Save";
    private static final String UPDATE_BUTTON = "Update";
    private static final String ADD_BUTTON = "Add";
    private static final String FOOTER_COMMENT_LINK = "footer-comment-button";
    private static final String DELETE_ISSUE_LINK = "delete-issue";
    private static final String COMMENT_EDIT_FORM = "comment-edit";
    private static final String ADD_COMMENT_FORM = "comment-add";
    private static final String COMMENT_FORM_ELEMENT = "comment";
    private static final String REPORTER_FORM_ELEMENT = "reporter";
    private static final String HENRY_FORD_USERNAME = "henry.ford";
    private static final String HENRY_FORD_EMAIL = "Henry.Ford@example.com";
    private static final String ADMIN_EMAIL = "admin@example.com";
    private static final String HENRY_FORD_COMMENTED = ".*henry.ford\\s.*commented.*";
    private static final String HENRY_FORD_UPDATED = ".*henry.ford\\s.*updated.*";
    private static final String HENRY_FORD_DELETED = ".*henry.ford\\s.*deleted.*";
    private static final String ADMIN_UPDATED = ".*admin.+\\s.*updated.*";
    private static final String COMMENTED_PATTERN = ".*commented.*";
    private static final String DELETED_PATTERN = ".*deleted.*";
    private static final String SUBJECT_HEADER = "Subject";
    private static final String TO_HEADER = "To";
    private static final String RESTRICTED_TO = "Restricted to";
    private static final String THIS_IS_A_COMMENT = "this is a comment";
    private static final String DASHBOARD_URL = "/secure/Dashboard.jspa";
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private EnvironmentUtils environmentUtils;
    @Inject
    private WorkflowUtil workflowUtil;

    @After
    public void tearDown() {
        this.backdoor.instanceFeaturesControl().disable(JIRA_NO_FROTHER_REPORTER_FIELD);
        this.backdoor.instanceFeaturesControl().disable(NO_FROTHER_ASSIGNEE_FIELD);
        this.backdoor.darkFeatures().enableForSite(FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.FIXED_COMMENT_DELETION_NOTIFICATIONS.featureKey()));
    }

    @Override
    protected void configureAndStartSmtpServerWithNotify() {
        super.configureAndStartSmtpServerWithNotify();
        this.navigation.login(HENRY_FORD_USERNAME);
        this.navigation.userProfile().changeNotifyMyChanges(true);
        this.navigation.logout();
        this.navigation.login("admin");
    }

    @Test
    @Restore(value="TestIssueNotifications.xml")
    public void testDeleteUserBeforeCommentNotification() throws InterruptedException {
        this.backdoor.instanceFeaturesControl().enable(JIRA_NO_FROTHER_REPORTER_FIELD);
        this.configureAndStartSmtpServerWithNotify();
        this.performDeleteUserBeforeCommentNotification();
        this.verifyDeleteUserBeforeCommentEmails(HENRY_FORD_DELETED);
    }

    @Test
    @Restore(value="TestIssueNotifications.xml")
    public void testDeleteUserBeforeCommentNotificationWithFFOff() throws InterruptedException {
        this.backdoor.instanceFeaturesControl().enable(JIRA_NO_FROTHER_REPORTER_FIELD);
        this.backdoor.darkFeatures().disableForSite(FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.FIXED_COMMENT_DELETION_NOTIFICATIONS.featureKey()));
        this.configureAndStartSmtpServerWithNotify();
        this.performDeleteUserBeforeCommentNotification();
        this.verifyDeleteUserBeforeCommentEmails(HENRY_FORD_UPDATED);
    }

    private void performDeleteUserBeforeCommentNotification() {
        this.navigation.logout();
        this.navigation.login(HENRY_FORD_USERNAME);
        this.navigation.issue().viewIssue(ISSUE_KEY_2);
        this.tester.clickLink(FOOTER_COMMENT_LINK);
        this.tester.setFormElement(COMMENT_FORM_ELEMENT, "monkeys");
        this.tester.submit();
        this.tester.clickLink(DELETE_COMMENT_LINK);
        this.tester.submit(DELETE_BUTTON);
        this.navigation.logout();
        this.navigation.login("admin");
        this.navigation.issue().viewIssue(ISSUE_KEY_1);
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement(REPORTER_FORM_ELEMENT, "admin");
        this.tester.submit(UPDATE_BUTTON);
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.navigation.webSudoAuthenticateUsingLastPassword();
        this.tester.clickLink("deleteuser_link_henry.ford");
        this.tester.submit(DELETE_BUTTON);
        this.navigation.gotoAdminSection(Navigation.AdminSection.SERVICES);
    }

    private void verifyDeleteUserBeforeCommentEmails(String henryCommentDeletionMailPattern) throws InterruptedException {
        this.flushMailQueueAndWait(3);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)3L, (long)mimeMessages.length);
        this.assertEmailBodyContainsLine(mimeMessages[0], HENRY_FORD_COMMENTED);
        this.assertEmailBodyContainsLine(mimeMessages[0], ISSUE_2_PATTERN);
        this.assertEmailBodyContainsLine(mimeMessages[1], henryCommentDeletionMailPattern);
        this.assertEmailBodyContainsLine(mimeMessages[1], ISSUE_2_PATTERN);
        this.assertEmailBodyContainsLine(mimeMessages[2], ADMIN_UPDATED);
        this.assertEmailBodyContainsLine(mimeMessages[2], ISSUE_1_PATTERN);
    }

    @Test
    @Restore(value="TestIssueNotifications.xml")
    public void testDeleteIssueBeforeCommentNotification() throws InterruptedException, MessagingException, IOException {
        if (this.environmentUtils.isOnWindows()) {
            return;
        }
        this.configureAndStartSmtpServerWithNotify();
        this.navigation.logout();
        this.navigation.login(HENRY_FORD_USERNAME);
        this.navigation.issue().viewIssue(ISSUE_KEY_1);
        this.tester.clickLink(FOOTER_COMMENT_LINK);
        this.tester.setFormElement(COMMENT_FORM_ELEMENT, "monkeys");
        this.tester.submit();
        this.navigation.logout();
        this.navigation.login("admin");
        this.navigation.issue().viewIssue(ISSUE_KEY_1);
        this.tester.clickLink(DELETE_ISSUE_LINK);
        this.tester.submit(DELETE_BUTTON);
        this.navigation.gotoAdminSection(Navigation.AdminSection.SERVICES);
        this.navigation.webSudoAuthenticateUsingLastPassword();
        this.flushMailQueueAndWait(4);
        this.assertCommentAndDeleteMessages(this.getMessagesForRecipient(HENRY_FORD_EMAIL));
        this.assertCommentAndDeleteMessages(this.getMessagesForRecipient(ADMIN_EMAIL));
    }

    private void assertCommentAndDeleteMessages(List<MimeMessage> mimeMessages) throws IOException, MessagingException {
        Assert.assertEquals((String)"messages received", (long)2L, (long)mimeMessages.size());
        this.assertEmailBodyContains(mimeMessages.get(0), HENRY_FORD_USERNAME);
        this.assertEmailBodyContainsLine(mimeMessages.get(0), COMMENTED_PATTERN);
        this.assertEmailBodyContainsLine(mimeMessages.get(0), ISSUE_1_PATTERN);
        this.assertEmailBodyContains(mimeMessages.get(1), "admin");
        this.assertEmailBodyContainsLine(mimeMessages.get(1), DELETED_PATTERN);
        this.assertEmailBodyContainsLine(mimeMessages.get(1), ISSUE_1_PATTERN);
    }

    @Test
    @Restore(value="TestIssueNotifications.xml")
    public void testDeleteSubTaskNotification() throws InterruptedException, MessagingException, IOException {
        this.configureAndStartSmtpServerWithNotify();
        String issueId = ISSUE_KEY_3;
        this.navigation.issue().viewIssue(issueId);
        this.tester.clickLink(DELETE_ISSUE_LINK);
        this.tester.submit(DELETE_BUTTON);
        this.flushMailQueueAndWait(1);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)1L, (long)mimeMessages.length);
        MimeMessage message = mimeMessages[0];
        Assert.assertEquals((Object)ADMIN_EMAIL, (Object)message.getHeader(TO_HEADER)[0]);
        this.assertMailProperties(message, issueId, ISSUE_3_SUBJECT);
    }

    @Test
    @Restore(value="TestIssueNotifications.xml")
    public void testDeleteIssueNotification() throws InterruptedException, MessagingException, IOException {
        this.configureAndStartSmtpServerWithNotify();
        String issueId = ISSUE_KEY_1;
        this.navigation.issue().viewIssue(issueId);
        this.tester.clickLink(DELETE_ISSUE_LINK);
        this.tester.submit(DELETE_BUTTON);
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)2L, (long)mimeMessages.length);
        ImmutableList expectedList = ImmutableList.of((Object)ADMIN_EMAIL, (Object)HENRY_FORD_EMAIL);
        ImmutableList receivedList = ImmutableList.of((Object)mimeMessages[0].getHeader(TO_HEADER)[0], (Object)mimeMessages[1].getHeader(TO_HEADER)[0]);
        Assert.assertEquals(new HashSet(expectedList), new HashSet(receivedList));
        this.assertMailProperties(mimeMessages[0], issueId, ISSUE_1_SUBJECT);
        this.assertMailProperties(mimeMessages[1], issueId, ISSUE_1_SUBJECT);
    }

    @Test
    @Restore(value="TestIssueNotifications.xml")
    public void testDeleteCommentNotification() throws InterruptedException, MessagingException, IOException {
        String commentBody = "This comment will be deleted";
        UserProfileImpl userProfile = new UserProfileImpl(this.tester, this.getEnvironmentData(), this.navigation);
        this.configureAndStartSmtpServerWithNotify();
        userProfile.changeUserNotificationType(true);
        this.navigation.issue().viewIssue(ISSUE_KEY_1);
        this.tester.clickLink(FOOTER_COMMENT_LINK);
        this.tester.setFormElement(COMMENT_FORM_ELEMENT, "This comment will be deleted");
        this.tester.submit();
        this.tester.assertTextPresent("This comment will be deleted");
        this.tester.clickLink(DELETE_COMMENT_LINK);
        this.tester.submit(DELETE_BUTTON);
        this.tester.assertTextNotPresent("This comment will be deleted");
        this.flushMailQueueAndWait(4);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient(ADMIN_EMAIL);
        Assert.assertEquals((long)2L, (long)messagesForAdmin.size());
        List<MimeMessage> messagesForHenry = this.getMessagesForRecipient(HENRY_FORD_EMAIL);
        Assert.assertEquals((long)2L, (long)messagesForHenry.size());
        for (MimeMessage message : messagesForHenry) {
            String subject = message.getSubject();
            if (!subject.contains("Updated")) continue;
            this.assertEmailSubjectEquals(message, ISSUE_1_SUBJECT);
            this.assertEmailBodyContains(message, "Comment: was deleted");
            this.assertEmailBodyContains(message, "(was: This comment will be deleted)");
        }
    }

    @Test
    @Restore(value="TestIssueNotifications.xml")
    public void testDeleteRoleRestrictedCommentNotification() throws InterruptedException, MessagingException, IOException {
        UserProfileImpl userProfile = new UserProfileImpl(this.tester, this.getEnvironmentData(), this.navigation);
        this.configureAndStartSmtpServerWithNotify();
        userProfile.changeUserNotificationType(true);
        this.addAndDeleteTwoComments(ROLE_TYPE, ADMINISTRATORS_ROLE, USERS_ROLE);
        this.verifyRestrictedCommentDeletionEmails(ADMINISTRATORS_ROLE, USERS_ROLE);
    }

    @Test
    @Restore(value="TestIssueNotifications.xml")
    public void testDeleteGroupRestrictedCommentNotification() throws InterruptedException, MessagingException, IOException {
        UserProfileImpl userProfile = new UserProfileImpl(this.tester, this.getEnvironmentData(), this.navigation);
        this.administration.generalConfiguration().setCommentVisibility(GeneralConfiguration.CommentVisibility.GROUPS_PROJECT_ROLES);
        this.configureAndStartSmtpServerWithNotify();
        userProfile.changeUserNotificationType(true);
        this.addAndDeleteTwoComments(GROUP_TYPE, ADMINISTRATORS_GROUP, USERS_GROUP);
        this.verifyRestrictedCommentDeletionEmails(ADMINISTRATORS_GROUP, USERS_GROUP);
    }

    private void verifyRestrictedCommentDeletionEmails(String administratorsGroup, String usersGroup) throws InterruptedException, MessagingException, IOException {
        this.flushMailQueueAndWait(6);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient(ADMIN_EMAIL);
        Assert.assertEquals((long)4L, (long)messagesForAdmin.size());
        for (MimeMessage message : messagesForAdmin) {
            String body = GreenMailUtil.getBody((Part)message);
            this.assertEmailBodyContains(message, RESTRICTED_TO);
            if (body.contains(ADMIN_COMMENT)) {
                this.assertEmailBodyContains(message, administratorsGroup);
                continue;
            }
            if (body.contains(HENRY_COMMENT)) {
                this.assertEmailBodyContains(message, usersGroup);
                continue;
            }
            Assert.fail((String)("Admin received inappropriate email:\n " + body));
        }
        List<MimeMessage> messagesForHenry = this.getMessagesForRecipient(HENRY_FORD_EMAIL);
        Assert.assertEquals((long)2L, (long)messagesForHenry.size());
        for (MimeMessage message : messagesForHenry) {
            String body = GreenMailUtil.getBody((Part)message);
            this.assertEmailBodyContains(message, RESTRICTED_TO);
            if (body.contains(HENRY_COMMENT)) {
                this.assertEmailBodyContains(message, usersGroup);
                continue;
            }
            Assert.fail((String)("Henry received inappropriate email:\n " + body));
        }
    }

    @Test
    @Restore(value="TestIssueNotifications.xml")
    public void testDeleteCommentNotificationIsNotSentIfDisabled() throws InterruptedException, MessagingException, IOException {
        UserProfileImpl userProfile = new UserProfileImpl(this.tester, this.getEnvironmentData(), this.navigation);
        this.administration.generalConfiguration().setCommentVisibility(GeneralConfiguration.CommentVisibility.GROUPS_PROJECT_ROLES);
        this.configureAndStartSmtpServerWithNotify();
        userProfile.changeUserNotificationType(true);
        ((NotificationSchemes)this.administration.notificationSchemes().goTo()).editNotifications(10000).deleteEntryWithId(10050).deleteEntryWithId(10051).deleteEntryWithId(10052);
        this.addAndDeleteTwoComments(GROUP_TYPE, ADMINISTRATORS_GROUP, USERS_GROUP);
        this.flushMailQueueAndWait(3);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient(ADMIN_EMAIL);
        Assert.assertEquals((long)2L, (long)messagesForAdmin.size());
        for (MimeMessage message : messagesForAdmin) {
            this.assertEmailBodyDoesntContain(message, DELETED_STRING);
        }
        List<MimeMessage> messagesForHenry = this.getMessagesForRecipient(HENRY_FORD_EMAIL);
        Assert.assertEquals((long)1L, (long)messagesForHenry.size());
        for (MimeMessage message : messagesForHenry) {
            this.assertEmailBodyDoesntContain(message, DELETED_STRING);
        }
    }

    private void addAndDeleteTwoComments(String restrictionType, String firstCommentRestriction, String secondCommentRestriction) {
        String adminCommentId = ((Comment)this.administration.backdoor().issues().commentIssueWithVisibility((String)ISSUE_KEY_1, (String)ADMIN_COMMENT, (String)restrictionType, (String)firstCommentRestriction).body).id;
        String henryCommentId = ((Comment)this.administration.backdoor().issues().commentIssueWithVisibility((String)ISSUE_KEY_1, (String)HENRY_COMMENT, (String)restrictionType, (String)secondCommentRestriction).body).id;
        this.administration.backdoor().issues().deleteComment(ISSUE_KEY_1, adminCommentId);
        this.administration.backdoor().issues().deleteComment(ISSUE_KEY_1, henryCommentId);
    }

    @Test
    @Restore(value="TestIssueNotificationsAnonymous.xml")
    public void testEditCommentNotification() throws InterruptedException, MessagingException, IOException {
        String originalComment = "This text will be soon edited";
        String newCommentAdmin = "The administrator just edited this text";
        String newCommentAnon = "An anonymous user just edited this text";
        String emailSubject = ISSUE_1_SUBJECT;
        this.configureAndStartSmtpServerWithNotify();
        this.editIssue("This text will be soon edited", HENRY_FORD_USERNAME, ISSUE_KEY_1, FOOTER_COMMENT_LINK);
        this.editIssueInForm("admin", ISSUE_KEY_1, EDIT_COMMENT_LINK, COMMENT_EDIT_FORM, "The administrator just edited this text");
        this.editIssueInForm(null, ISSUE_KEY_1, EDIT_COMMENT_LINK, COMMENT_EDIT_FORM, "An anonymous user just edited this text");
        this.navigation.login("admin");
        this.flushMailQueueAndWait(6);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient(ADMIN_EMAIL);
        Assert.assertEquals((long)3L, (long)messagesForAdmin.size());
        for (MimeMessage message : messagesForAdmin) {
            String subject = message.getSubject();
            if (!subject.contains("Edited")) continue;
            this.assertEmailSubjectEquals(message, ISSUE_1_SUBJECT);
            String from = message.getFrom()[0].toString();
            if (from.contains("Administrator")) {
                this.assertEmailBodyContains(message, "Administrator edited comment on COW-1 at");
                this.assertEmailBodyContains(message, "The administrator just edited this text");
                this.assertEmailBodyContains(message, "This text will be soon edited");
                this.assertEmailBodyDoesntContain(message, "An anonymous user just edited this text");
                continue;
            }
            this.assertEmailBodyContains(message, "Anonymous edited comment on COW-1 at");
            this.assertEmailBodyContains(message, "An anonymous user just edited this text");
            this.assertEmailBodyContains(message, "The administrator just edited this text");
            this.assertEmailBodyDoesntContain(message, "This text will be soon edited");
        }
    }

    @Test
    @Restore(value="TestIssueNotificationsAnonymous.xml")
    public void testEditCommentWithNewlineSendsEmailWithCorrectNumberOfNewlines() throws InterruptedException, MessagingException, IOException {
        String substring;
        long brTagsCountBetweenFirstAndLastCommentLine;
        String originalComment = "And now, for something\n\ncompletely different";
        String newCommentAdmin = "And now, for something\r\n\r\ncompletely different - The Larch";
        this.configureAndStartSmtpServerWithNotify();
        this.editIssue("And now, for something\n\ncompletely different", HENRY_FORD_USERNAME, ISSUE_KEY_1, FOOTER_COMMENT_LINK);
        this.editIssueInForm("admin", ISSUE_KEY_1, EDIT_COMMENT_LINK, COMMENT_EDIT_FORM, "And now, for something\r\n\r\ncompletely different - The Larch");
        this.navigation.login("admin");
        this.flushMailQueueAndWait(4);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient(ADMIN_EMAIL);
        Assert.assertEquals((long)2L, (long)messagesForAdmin.size());
        Iterator<MimeMessage> iterator = messagesForAdmin.iterator();
        Assert.assertThat((String)"Comment created notification ok", (Object)GreenMailUtil.getBody((Part)((Part)iterator.next())), (Matcher)Matchers.containsString((String)"And now, for something"));
        String body = GreenMailUtil.getBody((Part)((Part)iterator.next()));
        int start = body.indexOf("something");
        int end = body.indexOf("Larch");
        if (start == -1 || end == -1 || start >= end) {
            this.logEmail(body);
            Assert.fail((String)"Incorrect notification email received, cannot find edited comment body.");
        }
        if ((brTagsCountBetweenFirstAndLastCommentLine = (long)StringUtils.countMatches((CharSequence)(substring = body.substring(start, end)), (CharSequence)"<br")) != 2L) {
            this.logEmail(body);
            Assert.fail((String)("There should be exactly 2 newlines in email notification, got " + brTagsCountBetweenFirstAndLastCommentLine + " instead"));
        }
    }

    private void logEmail(String body) {
        this.logger.log((Object)"Email body start");
        this.logger.log((Object)body);
        this.logger.log((Object)"Email body end");
    }

    private String addBRforNewline(String multiLineText) {
        return multiLineText.replaceAll("\n", "<br/>\n");
    }

    private void editIssueInForm(String userName, String issueKey, String linkId, String workingFormName, String newComment) {
        this.navigation.logout();
        if (userName != null) {
            this.navigation.login(userName);
        } else {
            this.tester.gotoPage(DASHBOARD_URL);
        }
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink(linkId);
        this.tester.setWorkingForm(workingFormName);
        this.tester.setFormElement(COMMENT_FORM_ELEMENT, newComment);
        this.tester.submit(SAVE_BUTTON);
        this.tester.assertTextPresent(this.addBRforNewline(newComment));
    }

    private void editIssue(String originalComment, String userName, String issueKey, String linkId) {
        this.navigation.logout();
        this.navigation.login(userName);
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink(linkId);
        this.tester.setFormElement(COMMENT_FORM_ELEMENT, originalComment);
        this.tester.submit();
        this.tester.assertTextPresent(this.addBRforNewline(originalComment));
    }

    @Test
    @Restore(value="TestIssueNotificationsNoName.xml")
    public void testAnonymousUser() throws InterruptedException, MessagingException, IOException {
        String originalComment = "a comment from henry";
        this.configureAndStartSmtpServerWithNotify();
        this.navigation.logout();
        this.tester.gotoPage(DASHBOARD_URL);
        this.navigation.issue().viewIssue(ISSUE_KEY_1);
        this.tester.clickLink(FOOTER_COMMENT_LINK);
        this.tester.setFormElement(COMMENT_FORM_ELEMENT, "a comment from henry");
        this.tester.submit();
        this.tester.assertTextPresent("a comment from henry");
        this.navigation.logout();
        this.navigation.login(HENRY_FORD_USERNAME);
        this.navigation.issue().viewIssue(ISSUE_KEY_1);
        this.tester.clickLink(FOOTER_COMMENT_LINK);
        this.tester.setFormElement(COMMENT_FORM_ELEMENT, "a comment from henry");
        this.tester.submit();
        this.tester.assertTextPresent("a comment from henry");
        this.navigation.login("admin");
        this.flushMailQueueAndWait(2);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient(ADMIN_EMAIL);
        Assert.assertEquals((long)2L, (long)messagesForAdmin.size());
        String emailBody = GreenMailUtil.getBody((Part)((Part)messagesForAdmin.get(0)));
        if (emailBody.contains("Anonymous")) {
            this.assertEmailBodyContains(messagesForAdmin.get(1), HENRY_FORD_USERNAME);
            this.assertEmailBodyContains(messagesForAdmin.get(1), COMMENTED_STRING);
            this.assertEmailBodyContains(messagesForAdmin.get(1), ISSUE_KEY_1);
        } else {
            this.assertEmailBodyContains(messagesForAdmin.get(0), HENRY_FORD_USERNAME);
            this.assertEmailBodyContains(messagesForAdmin.get(0), COMMENTED_STRING);
            this.assertEmailBodyContains(messagesForAdmin.get(0), ISSUE_KEY_1);
            this.assertEmailBodyContains(messagesForAdmin.get(1), "Anonymous");
            this.assertEmailBodyContains(messagesForAdmin.get(1), COMMENTED_STRING);
            this.assertEmailBodyContains(messagesForAdmin.get(1), ISSUE_KEY_1);
        }
    }

    @Test
    @Restore(value="TestIssueNotificationsNotCurrentAssignee.xml")
    public void testAssignIssueNotificationNoCurrentAssignee() throws Exception {
        this.configureAndStartSmtpServerWithNotify();
        this.backdoor.instanceFeaturesControl().enable(NO_FROTHER_ASSIGNEE_FIELD);
        this.navigation.issue().assignIssue(ISSUE_KEY_2, THIS_IS_A_COMMENT, HENRY_FORD_USERNAME);
        this.flushMailQueueAndWait(0);
        List<MimeMessage> messagesForHank = this.getMessagesForRecipient(HENRY_FORD_EMAIL);
        Assert.assertEquals((long)0L, (long)messagesForHank.size());
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient(ADMIN_EMAIL);
        Assert.assertEquals((long)0L, (long)messagesForAdmin.size());
    }

    @Test
    @Restore(value="TestIssueNotificationsCurrentAssignee.xml")
    public void testAssignIssueNotificationCurrentAndPreviousAssignee() throws Exception {
        this.configureAndStartSmtpServerWithNotify();
        this.backdoor.instanceFeaturesControl().enable(NO_FROTHER_ASSIGNEE_FIELD);
        this.navigation.issue().assignIssue(ISSUE_KEY_2, THIS_IS_A_COMMENT, HENRY_FORD_USERNAME);
        this.flushMailQueueAndWait(2);
        List<MimeMessage> messagesForHank = this.getMessagesForRecipient(HENRY_FORD_EMAIL);
        Assert.assertEquals((long)1L, (long)messagesForHank.size());
        MimeMessage message = messagesForHank.get(0);
        this.assertEmailBodyContains(message, "assigned");
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient(ADMIN_EMAIL);
        Assert.assertEquals((long)1L, (long)messagesForAdmin.size());
        message = messagesForAdmin.get(0);
        this.assertEmailBodyContains(message, "assigned");
    }

    @Test
    @Restore(value="TestIssueNotificationsCurrentAssignee.xml")
    public void testAssignIssueNotificationUnassigned() throws Exception {
        this.configureAndStartSmtpServerWithNotify();
        this.administration.generalConfiguration().setAllowUnassignedIssues(true);
        this.backdoor.instanceFeaturesControl().enable(NO_FROTHER_ASSIGNEE_FIELD);
        this.navigation.issue().unassignIssue(ISSUE_KEY_2, THIS_IS_A_COMMENT);
        this.flushMailQueueAndWait(1);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient(ADMIN_EMAIL);
        Assert.assertEquals((long)1L, (long)messagesForAdmin.size());
        MimeMessage message = messagesForAdmin.get(0);
        this.assertEmailBodyContains(message, "assigned");
    }

    @Test
    @Restore(value="TestIssueNotifications.xml")
    public void testResolutionDateInEmail() throws InterruptedException, MessagingException, IOException {
        this.configureAndStartSmtpServerWithNotify();
        this.tester.clickLink("view_profile");
        this.tester.clickLink("edit_prefs_lnk");
        this.tester.selectOption("userNotificationsMimeType", "HTML");
        this.tester.submit();
        this.navigation.issue().viewIssue(ISSUE_KEY_1);
        this.tester.clickLink(FOOTER_COMMENT_LINK);
        this.tester.setWorkingForm(ADD_COMMENT_FORM);
        this.tester.setFormElement(COMMENT_FORM_ELEMENT, "Test comment");
        this.tester.submit(ADD_BUTTON);
        this.workflowUtil.clickAction("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.flushMailQueueAndWait(2);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient(ADMIN_EMAIL);
        Assert.assertEquals((long)2L, (long)messagesForAdmin.size());
        MimeMessage message = messagesForAdmin.get(0);
        this.assertEmailBodyDoesntContain(message, "Resolved:");
        this.assertEmailBodyContains(message, COMMENTED_STRING);
        MimeMessage resolvedMessage = messagesForAdmin.get(1);
        this.assertEmailBodyContains(resolvedMessage, "Resolved");
    }

    @Test
    @Restore(value="TestIssueNotificationsAnonymous.xml")
    public void testMailOrdering() throws Exception {
        String originalComment = "This text will be soon edited";
        String newCommentAdmin = "The administrator just edited this text";
        String newCommentAnon = "An anonymous user just edited this text";
        this.configureAndStartSmtpServerWithNotify();
        this.editIssue("This text will be soon edited", HENRY_FORD_USERNAME, ISSUE_KEY_1, FOOTER_COMMENT_LINK);
        this.editIssueInForm("admin", ISSUE_KEY_1, EDIT_COMMENT_LINK, COMMENT_EDIT_FORM, "The administrator just edited this text");
        this.editIssueInForm(null, ISSUE_KEY_1, EDIT_COMMENT_LINK, COMMENT_EDIT_FORM, "An anonymous user just edited this text");
        this.navigation.login("admin");
        this.flushMailQueueAndWait(6);
        MimeMessage[] messages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)6L, (long)messages.length);
        Date firstDate = messages[0].getSentDate();
        boolean notInOrder = false;
        for (MimeMessage message : messages) {
            notInOrder = message.getSentDate().before(firstDate);
        }
        Assert.assertFalse((boolean)notInOrder);
    }

    @Test
    @Restore(value="TestIssueNotifications.xml")
    public void testEditIssueWithoutSendingNotification() throws Exception {
        this.configureAndStartSmtpServerWithNotify();
        this.updateSummary(ISSUE_KEY_1, "new-summary", false);
        this.flushMailQueue();
        Assert.assertThat((Object)this.mailService.waitForIncomingMessage(5000L, 1), (Matcher)CoreMatchers.is((Object)false));
    }

    private void updateSummary(String issueKey, String summary, boolean notifyUser) {
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().fields(new IssueFields().summary(summary));
        ParsedResponse response = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData()).updateResponse(issueKey, updateRequest, notifyUser);
        Assert.assertThat((String)("Update failed. " + response.toString()), (Object)response.statusCode, (Matcher)CoreMatchers.is((Object)204));
    }

    private void assertMailProperties(MimeMessage message, String issueId, String subject) throws MessagingException, IOException {
        Assert.assertEquals((Object)subject, (Object)message.getHeader(SUBJECT_HEADER)[0]);
        String expectedSender = this.backdoor.applicationProperties().getString("jira.email.fromheader.format").replace("${fullname}", "admin");
        Assert.assertEquals((Object)("\"" + expectedSender + "\" <jiratest@atlassian.com>"), (Object)message.getHeader("From")[0]);
        this.assertEmailBodyContains(message, "admin");
        this.assertEmailBodyContainsLine(message, DELETED_PATTERN);
        this.assertEmailBodyContainsLine(message, ".*" + issueId + ".*");
    }
}

