/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import com.google.common.collect.Lists;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.inject.Inject;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsArrayWithSize;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
@LoginAs(user="admin")
public class TestMailImageAttachments
extends EmailBaseFuncTestCase {
    private static final Pattern IMG_SRC_WITH_CID = Pattern.compile("<img.*?src=\"cid:(\\S+)\"");
    private static final String FORMAT_NAME = "javax_imageio_png_1.0";
    @Inject
    private Administration administration;

    private static IIOImage readFirstImage(InputStream inputStream) throws IOException {
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        ImageReader reader = ImageIO.getImageReaders(imageInputStream).next();
        reader.setInput(imageInputStream, true, false);
        return reader.readAll(0, reader.getDefaultReadParam());
    }

    @Test
    @Restore(value="TestIssueNotifications.xml")
    public void testEachImageAttachmentIsVisible() throws Exception {
        this.configureAndStartSmtpServerWithNotify();
        String issueId = "COW-1";
        this.navigation.issue().viewIssue("COW-1");
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)2L, (long)mimeMessages.length);
        for (MimeMessage mimeMessage : mimeMessages) {
            this.assertEachCidAttachmentIsUsedInMailMessage(mimeMessage);
        }
    }

    private void assertEachCidAttachmentIsUsedInMailMessage(MimeMessage mimeMessage) throws IOException, MessagingException {
        Object content = mimeMessage.getContent();
        Assert.assertThat((Object)content, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(Multipart.class)));
        Multipart multipart = (Multipart)content;
        Collection<String> contentIds = this.getContentIds(multipart);
        for (String contentId : contentIds) {
            this.assertEmailBodyContains(mimeMessage, contentId);
        }
    }

    private Collection<String> getContentIds(Multipart multipart) throws MessagingException, IOException {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < multipart.getCount(); ++i) {
            BodyPart bodyPart = multipart.getBodyPart(i);
            String[] headers = bodyPart.getHeader("Content-ID");
            if (headers == null) continue;
            Assert.assertThat((String)"There should be only one 'Content-ID' header in BodyPart", (Object)headers, (Matcher)IsArrayWithSize.arrayWithSize((int)1));
            String cidHeader = headers[0];
            String[] contentTypeHeaders = bodyPart.getHeader("Content-Type");
            Assert.assertThat((Object)contentTypeHeaders, (Matcher)IsArrayWithSize.arrayWithSize((int)1));
            String contentTypeHeader = contentTypeHeaders[0];
            Assert.assertThat((Object)contentTypeHeader, (Matcher)Matchers.equalTo((Object)"image/png"));
            this.assertContainsJiraMetaData(bodyPart);
            result.add(cidHeader.substring(1, cidHeader.length() - 1));
        }
        return result;
    }

    private void assertEachImageWithCidHasCorrespondingAttachment(MimeMessage message) throws MessagingException, IOException {
        Object content = message.getContent();
        Assert.assertThat((Object)content, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(Multipart.class)));
        Multipart multipart = (Multipart)content;
        Object[] cidsFromMessage = this.getCidsFromMessage(GreenMailUtil.getBody((Part)message));
        Collection<String> contentIds = this.getContentIds(multipart);
        Assert.assertThat(contentIds, (Matcher)Matchers.containsInAnyOrder((Object[])cidsFromMessage));
    }

    private String[] getCidsFromMessage(String messageBody) {
        java.util.regex.Matcher matcher = IMG_SRC_WITH_CID.matcher(messageBody);
        ArrayList result = Lists.newArrayList();
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result.toArray(new String[result.size()]);
    }

    private void assertContainsJiraMetaData(BodyPart bodyPart) throws MessagingException, IOException {
        IIOImage image = TestMailImageAttachments.readFirstImage(bodyPart.getInputStream());
        IIOMetadata metadata = image.getMetadata();
        Node root = metadata.getAsTree(FORMAT_NAME);
        Node textNode = this.findChildNode("tEXt", root);
        Node textEntry = this.findChildNode("tEXtEntry", textNode);
        NamedNodeMap attributes = textEntry.getAttributes();
        Node keyword = attributes.getNamedItem("keyword");
        Node value = attributes.getNamedItem("value");
        Assert.assertThat((Object)keyword.getNodeValue(), (Matcher)Matchers.equalTo((Object)"jira-system-image-type"));
        Assert.assertThat((Object)value.getNodeValue(), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)"avatar"), (Matcher)Matchers.equalTo((Object)"icon"), (Matcher)Matchers.equalTo((Object)"logo")));
    }

    private Node findChildNode(String nodeName, Node parent) {
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!nodeName.equals(node.getNodeName())) continue;
            return node;
        }
        Assert.fail((String)String.format("No node with name %s found in parent %s.", nodeName, parent.getNodeName()));
        return null;
    }
}

